/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.measure;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.helper.OperationResultHelper;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.draft.AbstractDeskMeasureService;
import kd.taxc.tcept.business.draft.IncomeAdjustDraftService;
import kd.taxc.tcept.business.draft.IncomeDraftService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.extpoint.IPreLandMeasureService;
import kd.taxc.tcept.business.extpoint.impl.DefaultPreLandMeasureImpl;
import kd.taxc.tcept.business.statistics.DeskServiceMediator;
import kd.taxc.tcept.common.enums.TaxStateEnum;
import kd.taxc.tcept.common.utils.CollectionTool;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class PreLandMeasureService
implements AbstractDeskMeasureService {
    private static final String ENTRY_GROUP_ = "entry_group_";
    private static final String SALE_TAX_INCOME_ = "sale_tax_income_";
    private static final String PRE_RATE_ = "pre_rate_";
    private static final String PRE_LANDTAX_AMOUNT_ = "pre_landtax_amount_";
    public static final String BASTAX_TAXPROJECT = "bastax_taxproject";
    public static final String TAXC_TCEPT_PRE_LAND_MEASURE_SERVICE = "TAXC_TCEPT_PRE_LAND_MEASURE_SERVICE";
    public static final String TCEPT_PRE_LAND_MEASURE = "tcept_pre_land_measure";
    private IncomeDraftService incomeDraftService = new IncomeDraftService();
    private Map<String, String> TAX_STATE_MAPPING = new HashMap(){
        {
            this.put("0", "normal_house");
            this.put("1", "un_house");
            this.put("2", "un_calc_state");
            this.put("3", "un_normal_house");
        }
    };
    private Map<String, String> TAX_STATE_MAPPING2 = new HashMap(){
        {
            this.put("01", "normal_house");
            this.put("02", "un_normal_house");
            this.put("03", "un_house");
            this.put("04", "un_calc_state");
        }
    };

    public static DynamicObject queryDraftByUniq(Long org, Long project, Long scheme, String version) {
        QFilter q1 = new QFilter("org", "=", (Object)org);
        QFilter q2 = new QFilter("project", "=", (Object)project);
        QFilter q3 = new QFilter("scheme", "=", (Object)scheme);
        QFilter q4 = new QFilter("version", "=", (Object)version);
        DynamicObject draft = QueryServiceHelper.queryOne((String)TCEPT_PRE_LAND_MEASURE, (String)"id", (QFilter[])new QFilter[]{q1, q2, q3, q4});
        if (draft != null) {
            return BusinessDataServiceHelper.loadSingle((Object)draft.get("id"), (String)TCEPT_PRE_LAND_MEASURE);
        }
        return null;
    }

    public static Map<Object, Map<String, BigDecimal>> getYjTzsCsTaxTypeGroup(Long orgid, Long projectId, Long schemeId, String version) {
        DynamicObject incomeAdjDraft = PreLandMeasureService.queryDraftByUniq(orgid, projectId, schemeId, version);
        if (incomeAdjDraft != null) {
            DynamicObjectCollection entryentity = incomeAdjDraft.getDynamicObjectCollection("entryentity");
            return CollectionTool.listGroupOnceGetSumToGroup((List<DynamicObject>)entryentity, "taxstate", "pre_landtax_amount_1", "pre_landtax_amount_2", "pre_landtax_amount_3", "pre_landtax_amount_4", "pre_landtax_amount_5", "pre_landtax_amount_6", "pre_landtax_amount_7", "pre_landtax_amount_8", "pre_landtax_amount_9", "pre_landtax_amount_10");
        }
        return new HashMap<Object, Map<String, BigDecimal>>();
    }

    public List<String> getEntityGroupList() {
        return IntStream.rangeClosed(1, 10).boxed().map(a -> ENTRY_GROUP_ + a).collect(Collectors.toList());
    }

    public List<String> getEntityList() {
        return IntStream.rangeClosed(1, 10).boxed().flatMap(a -> Lists.newArrayList((Object[])new String[]{SALE_TAX_INCOME_, PRE_RATE_, PRE_LANDTAX_AMOUNT_}).stream().map(b -> b + a)).collect(Collectors.toList());
    }

    public List<String> getVisibleEntityList(int maxClearPeriods) {
        return this.getEntityList().stream().filter(s -> {
            int i;
            String[] split = s.split("_");
            return Integer.parseInt(split[i = split.length - 1]) <= maxClearPeriods;
        }).collect(Collectors.toList());
    }

    public List<String> getVisibleEntityGroupList(int maxClearPeriods) {
        return this.getEntityGroupList().stream().filter(s -> Integer.parseInt(s.split("_")[2]) <= maxClearPeriods).collect(Collectors.toList());
    }

    public DynamicObject getProjectInfo(Long id) {
        return BusinessDataServiceHelper.loadSingle((Object)id, (String)BASTAX_TAXPROJECT);
    }

    public Map<String, BigDecimal> getIncomeDraftGoodValueMap(Long orgId, Long projectId, Long schemeId, String version) {
        DynamicObject incomeDraft = this.incomeDraftService.query(orgId, projectId, schemeId, version);
        if (incomeDraft == null || incomeDraft.getDynamicObjectCollection("entryentity").size() == 0) {
            return new HashMap<String, BigDecimal>(16);
        }
        Map<String, List<DynamicObject>> collect = incomeDraft.getDynamicObjectCollection("entryentity").stream().collect(Collectors.groupingBy(s -> s.getString("clearperiod") + s.getString("taxstate")));
        Map<String, BigDecimal> goodsvalue = collect.entrySet().stream().collect(Collectors.toMap(s -> (String)s.getKey(), s -> ((List)s.getValue()).stream().map(a -> a.getBigDecimal("goodsvalue")).reduce(BigDecimal.ZERO, BigDecimal::add)));
        return goodsvalue;
    }

    public Map<String, BigDecimal> getIncomeDraftAdjustTaxGoodValueMap(Long orgId, Long projectId, Long schemeId, String version) {
        DynamicObject incomeAdjustDraft = IncomeAdjustDraftService.query(orgId, projectId, schemeId, version);
        if (incomeAdjustDraft == null || incomeAdjustDraft.getDynamicObjectCollection("entryentity").size() == 0) {
            return new HashMap<String, BigDecimal>(16);
        }
        Map<String, List<DynamicObject>> collect = incomeAdjustDraft.getDynamicObjectCollection("entryentity").stream().collect(Collectors.groupingBy(s -> {
            String taxtype = this.TAX_STATE_MAPPING2.get(s.getString("taxtype"));
            return s.getString("clearterm") + taxtype;
        }));
        Map<String, BigDecimal> goodsvalue = collect.entrySet().stream().collect(Collectors.toMap(s -> (String)s.getKey(), s -> ((List)s.getValue()).stream().map(a -> a.getBigDecimal("taxgoodvalue")).reduce(BigDecimal.ZERO, BigDecimal::add)));
        return goodsvalue;
    }

    public BigDecimal getRate(Date startDate, Date endDate, String subName, String taxMethod) {
        QFilter q1 = new QFilter("general", "=", (Object)"1");
        QFilter q2 = new QFilter("startdate", "<=", (Object)startDate);
        QFilter q3 = new QFilter("enddate", "is null", null).or(new QFilter("enddate", ">=", (Object)endDate));
        QFilter q4 = new QFilter("entryentity.subname", "=", (Object)subName);
        QFilter q5 = new QFilter("entryentity.taxmethod", "=", (Object)taxMethod);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_tcvat_prerate", (String)"entryentity.prerate as prerate", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
        return CollectionUtils.isEmpty((Collection)query) ? BigDecimal.ZERO : new BigDecimal(((DynamicObject)query.get(0)).getString("prerate").replace("%", "")).divide(new BigDecimal("100"), 2, 4);
    }

    private Map<String, Object> newCountRow(int index, List<String> visibleFieldList, Integer stage, List<Map<String, Object>> calcData) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>(32);
        rowMap.put("seq", index);
        rowMap.put("stage", stage);
        rowMap.put("taxstate", "count");
        for (String field : visibleFieldList) {
            rowMap.put(field, this.getsum(calcData, field, stage));
        }
        return rowMap;
    }

    public BigDecimal getTaxIncome(Map<String, BigDecimal> incomeDraftGoodValueMap, Map<String, BigDecimal> incomeDraftAdjustTaxGoodValueMap, String taxState, String clearPeriod) {
        String key = clearPeriod + taxState;
        BigDecimal income = incomeDraftGoodValueMap.getOrDefault(key, BigDecimal.ZERO);
        BigDecimal incomeAdjust = incomeDraftAdjustTaxGoodValueMap.getOrDefault(key, BigDecimal.ZERO);
        return income.add(incomeAdjust);
    }

    private BigDecimal getsum(List<Map<String, Object>> calcData, String field, Integer stage) {
        if (field.startsWith(PRE_RATE_)) {
            return BigDecimal.ZERO;
        }
        BigDecimal sum = calcData.stream().filter(s -> stage.equals(s.get("stage"))).filter(s -> Lists.newArrayList((Object[])new String[]{TaxStateEnum.NORMAL_HOUSE.getCode(), TaxStateEnum.UN_NORMAL_HOUSE.getCode(), TaxStateEnum.UN_HOUSE.getCode()}).contains(s.get("taxstate"))).map(s -> (BigDecimal)s.get(field)).reduce(BigDecimal.ZERO, BigDecimal::add);
        return sum;
    }

    private Map<Integer, List<DynamicObject>> getStageProjectInfoMap(DynamicObject projectInfo, List<String> extendColumns) {
        DynamicObjectCollection tdzzsentryentity = projectInfo.getDynamicObjectCollection("tdzzsentryentity");
        tdzzsentryentity = tdzzsentryentity.stream().filter(s -> !"2".equals(s.getString("swyt"))).sorted(Comparator.comparing(s -> s.getDate("yxqq"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
        HashMap<Integer, List<DynamicObject>> map = new HashMap<Integer, List<DynamicObject>>(16);
        if (!CollectionUtils.isEmpty((Collection)tdzzsentryentity)) {
            Map<String, List<DynamicObject>> swytMap = tdzzsentryentity.stream().collect(Collectors.groupingBy(s -> {
                if (extendColumns.isEmpty()) {
                    return s.getString("swyt");
                }
                String collect = extendColumns.stream().map(c -> s.getString(c)).collect(Collectors.joining(""));
                return s.getString("swyt") + collect;
            }));
            swytMap.entrySet().stream().filter(s -> ((List)s.getValue()).size() > 2).forEach(entry -> {
                List value = (List)entry.getValue();
                entry.setValue(value.subList(value.size() - 2, value.size()));
            });
            for (int i = 0; i < 2; ++i) {
                List list = map.getOrDefault(i + 1, new ArrayList());
                for (List<DynamicObject> value : swytMap.values()) {
                    if (value.size() < i + 1) continue;
                    list.add(value.get(i));
                }
                map.put(i + 1, list);
            }
        }
        return map;
    }

    public OperationResult reCalc(Long pk) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)TCEPT_PRE_LAND_MEASURE);
        if (dynamicObject != null) {
            Long orgId = (Long)dynamicObject.get("org.id");
            Long projectId = (Long)dynamicObject.get("project.id");
            Long schemeId = (Long)dynamicObject.get("scheme.id");
            String version = dynamicObject.getString("version");
            String swqsytfl = dynamicObject.getString("swqsytfl");
            Integer maxClearPeriod = dynamicObject.getInt("maxclearperiod");
            String billStatus = dynamicObject.getString("billstatus");
            if (!"A".equals(billStatus)) {
                OperationResult reclac = OperationResultHelper.getFatalErrorOperateResult((String)"reclac", Collections.singletonList(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"PreLandMeasureService_2", (String)"taxc-tcept", (Object[])new Object[0])), (String)"", (int)1, new ArrayList());
                return reclac;
            }
            Map<String, BigDecimal> incomeDraftGoodValueMap = this.getIncomeDraftGoodValueMap(orgId, projectId, schemeId, version);
            Map<String, BigDecimal> incomeDraftAdjustTaxGoodValueMap = this.getIncomeDraftAdjustTaxGoodValueMap(orgId, projectId, schemeId, version);
            List<String> visibleFieldList = this.getVisibleEntityList(maxClearPeriod);
            DynamicObject projectInfo = this.getProjectInfo(projectId);
            List<String> extendPluginSaleStateFieldList = this.getExtendPluginSaleStateFieldList();
            BigDecimal zzszsl = projectInfo.get("syslzsl") != null ? projectInfo.getBigDecimal("syslzsl") : BigDecimal.ZERO;
            boolean isSimpleMethod = projectInfo.getBoolean("syjhjsff");
            String taxMethod = "0".equals(projectInfo.getString("zsfs")) ? "normal" : "simple";
            BigDecimal zzsjzl = this.getRate(new Date(), null, ResManager.loadKDString((String)"\u9500\u552e\u81ea\u884c\u5f00\u53d1\u623f\u5730\u4ea7", (String)"PreLandMeasureService_0", (String)"taxc-tcept", (Object[])new Object[0]), taxMethod);
            List<Map<String, Object>> resultListMap = this.calcData(swqsytfl, incomeDraftGoodValueMap, incomeDraftAdjustTaxGoodValueMap, visibleFieldList, projectInfo, zzszsl, isSimpleMethod, zzsjzl, extendPluginSaleStateFieldList);
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            entryentity.clear();
            for (int i = 0; i < resultListMap.size(); ++i) {
                Map<String, Object> map = resultListMap.get(i);
                DynamicObject row = entryentity.addNew();
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (entry.getKey().equals("seq")) continue;
                    row.set(entry.getKey(), entry.getValue());
                }
            }
            OperationResult save = OperationServiceHelper.executeOperate((String)"save", (String)this.getBillNumber(), (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (save.isSuccess()) {
                DeskServiceMediator.fireBillChange(this.getBillNumber(), pk);
            }
            return save;
        }
        return null;
    }

    public List<Map<String, Object>> calcData(String swqsytfl, Map<String, BigDecimal> incomeDraftGoodValueMap, Map<String, BigDecimal> incomeDraftAdjustTaxGoodValueMap, List<String> visibleFieldList, DynamicObject projectInfo, BigDecimal zzszsl, boolean isSimpleMethod, BigDecimal zzsjzl, List<String> extendColumns) {
        ArrayList<Map<String, Object>> calcData = new ArrayList<Map<String, Object>>();
        Map<Integer, List<DynamicObject>> projectInfoMap = this.getStageProjectInfoMap(projectInfo, extendColumns);
        int index = 0;
        for (Map.Entry<Integer, List<DynamicObject>> entry : projectInfoMap.entrySet()) {
            Integer stage = entry.getKey();
            List<DynamicObject> rows = entry.getValue();
            if (rows.isEmpty()) continue;
            for (DynamicObject row : rows) {
                String taxState = this.TAX_STATE_MAPPING.get(row.getString("swyt"));
                if ("0".equals(swqsytfl) && "un_normal_house".equals(taxState)) continue;
                HashMap<String, Object> rowMap = new HashMap<String, Object>(32);
                rowMap.put("seq", ++index);
                BigDecimal taxIncome = BigDecimal.ZERO;
                BigDecimal yzl = BigDecimal.ZERO;
                String clearPeriod = "0";
                rowMap.put("stage", stage);
                rowMap.put("taxstate", taxState);
                extendColumns.stream().forEach(s -> rowMap.put((String)s, row.getString(s)));
                for (String field : visibleFieldList) {
                    BigDecimal landtaxAmount;
                    if (field.startsWith(SALE_TAX_INCOME_)) {
                        String[] split = field.split("_");
                        clearPeriod = String.format("%02d", Integer.parseInt(split[split.length - 1]));
                        taxIncome = stage == 1 ? this.getTaxIncome(incomeDraftGoodValueMap, incomeDraftAdjustTaxGoodValueMap, taxState, clearPeriod) : BigDecimal.ZERO;
                        rowMap.put(field, taxIncome);
                    }
                    if (field.startsWith(PRE_RATE_)) {
                        yzl = row.getBigDecimal("yzl");
                        rowMap.put(field, row.get("yzl"));
                    }
                    if (!field.startsWith(PRE_LANDTAX_AMOUNT_)) continue;
                    if (isSimpleMethod) {
                        landtaxAmount = taxIncome.subtract(taxIncome.divide(BigDecimal.ONE.add(zzszsl), 4, 2).multiply(zzsjzl)).multiply(yzl).setScale(2, 4);
                        rowMap.put(field, landtaxAmount);
                        continue;
                    }
                    landtaxAmount = taxIncome.divide(BigDecimal.ONE.add(zzszsl), 4, 2).multiply(yzl).setScale(2, 4);
                    rowMap.put(field, landtaxAmount);
                }
                calcData.add(rowMap);
            }
            calcData.add(this.newCountRow(++index, visibleFieldList, stage, calcData));
        }
        return calcData;
    }

    public List<String> getExtendPluginSaleStateFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>();
        DefaultPreLandMeasureImpl defaultPreLandMeasure = new DefaultPreLandMeasureImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defaultPreLandMeasure, IPreLandMeasureService.class, (String)TAXC_TCEPT_PRE_LAND_MEASURE_SERVICE, null);
        List resultList = pluginProxy.callReplaceIfPresent(p -> p.getSaleStateColumns());
        if (resultList != null && resultList.size() > 0) {
            return (List)resultList.get(0);
        }
        return fieldList;
    }

    @Override
    public String getBillNumber() {
        return TCEPT_PRE_LAND_MEASURE;
    }

    @Override
    public Map<String, Object> copy(Long originalPk, Long org, Long project, Long scheme, String version, String newVersion) {
        DynamicObject single = BusinessDataServiceHelper.loadSingle((Object)originalPk, (String)TCEPT_PRE_LAND_MEASURE);
        DynamicObject newObj = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityBase)single);
        newObj.set("id", null);
        newObj.set("version", (Object)newVersion);
        String billno = DraftCommonUtils.getDraftNumber(newObj, single.getLong("org.id"));
        newObj.set("billno", (Object)billno);
        newObj.set("billstatus", (Object)"A");
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newObj});
        return ServiceResultUtils.returnResultHandler((Object)save[0]);
    }

    @Override
    public boolean isSupportRecalc() {
        return true;
    }

    @Override
    public Map<String, Object> recalc(Long billpk, Long org, Long project, Long scheme, String version) {
        OperationResult operationResult;
        boolean exists = QueryServiceHelper.exists((String)this.getBillNumber(), (Object)billpk);
        if (exists && (operationResult = this.reCalc(billpk)) != null) {
            return AbstractDeskMeasureService.getResultMapFormOpRe(null, operationResult);
        }
        return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-1", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u64cd\u4f5c\u3002", (String)"PreLandMeasureService_1", (String)"taxc-tcept", (Object[])new Object[0]), null);
    }
}

