/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.statistics;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.extplugin.PluginProxy;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.draft.CostAdjustDraftService;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.business.draft.IncomeAdjustDraftService;
import kd.taxc.tcept.business.draft.IncomeDraftService;
import kd.taxc.tcept.business.draft.QiTaAdjustDraftService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.measure.LandValueTaxLiquCalcService;
import kd.taxc.tcept.business.measure.PreLandMeasureService;

public class DeskMeasureServiceFactory {
    public static final String TCEPT_DESK_SERVICE_EXTPLUGIN = "TCEPT_DESK_SERVICE_EXTPLUGIN";
    private Map<String, IDeskMeasureService> serviceMap = new LinkedHashMap<String, IDeskMeasureService>();
    private static DeskMeasureServiceFactory factory = new DeskMeasureServiceFactory();

    public static DeskMeasureServiceFactory getFactory() {
        if (factory.getServiceMap().isEmpty()) {
            DeskMeasureServiceFactory.loadServices();
        }
        return factory;
    }

    private static void loadServices() {
        IDeskMeasureService[] defaultServices = DeskMeasureServiceFactory.getDefaultService();
        List<IDeskMeasureService> commonExtServices = DeskMeasureServiceFactory.getCommonExtServices();
        for (IDeskMeasureService defaultService : defaultServices) {
            if (!StringUtil.isNotEmpty((CharSequence)defaultService.getBillNumber())) continue;
            factory.getServiceMap().put(defaultService.getBillNumber(), defaultService);
        }
        for (IDeskMeasureService defaultService : commonExtServices) {
            if (!StringUtil.isNotEmpty((CharSequence)defaultService.getBillNumber())) continue;
            factory.getServiceMap().put(defaultService.getBillNumber(), defaultService);
        }
    }

    private static IDeskMeasureService[] getDefaultService() {
        return new IDeskMeasureService[]{new IncomeDraftService(), new QiTaAdjustDraftService(), new IncomeAdjustDraftService(), new CostAdjustDraftService(), new CostSplitDraftService(), new LandValueTaxLiquCalcService(), new PreLandMeasureService()};
    }

    private static List<IDeskMeasureService> getCommonExtServices() {
        PluginProxy pluginProxy = PluginProxy.create(IDeskMeasureService.class, (String)TCEPT_DESK_SERVICE_EXTPLUGIN);
        return pluginProxy.getPlugins();
    }

    public IDeskMeasureService getService(String bill) {
        if (!this.serviceMap.containsKey(bill)) {
            DeskMeasureServiceFactory.loadServices();
        }
        return this.serviceMap.get(bill);
    }

    private Map<String, IDeskMeasureService> getServiceMap() {
        return this.serviceMap;
    }
}

