/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.statistics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ServiceResultUtils;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.statistics.DeskMeasureServiceFactory;
import kd.taxc.tcept.common.exception.TceptBizException;

public class DeskService {
    private static final Log LOGGER = LogFactory.getLog(DeskService.class);
    public static final String TCEPT_PROJECT_DESK = "tcept_project_desk";
    public static final String TCEPT_DESK_BILL_RECORD = "tcept_desk_bill_record";
    private SchemaDataService schemaDataService = new SchemaDataService();
    private static final Map<String, String> FIELD_MAP = new HashMap(){
        {
            this.put("org", "org_field_key");
            this.put("project", "project_field_key");
            this.put("scheme", "scheme_field_key");
            this.put("version", "version_field_key");
            this.put("cbillno", "billno_field_key");
            this.put("billstate", "billstatus_field_key");
            this.put("billmodifier", "modifier_field_key");
            this.put("billmodifydate", "modifydate_field_key");
        }
    };

    public void respondBillChange(String billnumber, Long billid) {
        QFilter qFilter4;
        QFilter qFilter3;
        QFilter qFilter2;
        Map<String, String> infoSyncFieldMap;
        DynamicObject sourceBill;
        QFilter qFilter1;
        QFilter qFilter;
        DynamicObject query;
        LOGGER.info("DeskService-respondBillChange \u8bf7\u6c42\u53c2\u6570\uff1abillnumber:{},billid:{}", (Object)billnumber, (Object)billid);
        if (billnumber != null && (query = QueryServiceHelper.queryOne((String)TCEPT_DESK_BILL_RECORD, (String)"id,org,project,scheme,version,controlseq,billmetanumber", (QFilter[])new QFilter[]{qFilter = new QFilter("billmetanumber", "=", (Object)billnumber), qFilter1 = new QFilter("org", "=", (sourceBill = BusinessDataServiceHelper.loadSingle((Object)billid, (String)billnumber)).get((infoSyncFieldMap = this.getBillService(billnumber).getInfoSyncField()).get(FIELD_MAP.get("org")) + ".id")), qFilter2 = new QFilter("project", "=", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("project")) + ".id")), qFilter3 = new QFilter("scheme", "=", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("scheme")) + ".id")), qFilter4 = new QFilter("version", "=", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("version"))))})) != null) {
            DynamicObject[] load;
            Object org = query.get("org");
            Object project = query.get("project");
            Object scheme = query.get("scheme");
            Object version = query.get("version");
            int seq = query.getInt("controlseq");
            for (DynamicObject billrecord : load = this.getBillRecordByBizUniq(org, project, scheme, version)) {
                int controlseq = billrecord.getInt("controlseq");
                Long curentBillid = billrecord.getLong("billid");
                if (billnumber.equals(billrecord.get("billmetanumber"))) {
                    billrecord.set("billid", (Object)billid);
                    billrecord.set("cbillno", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("cbillno"))));
                    billrecord.set("billstate", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billstate"))));
                    billrecord.set("createstatus", (Object)"ybz");
                    billrecord.set("calcstatus", (Object)"wxjs");
                    billrecord.set("billmodifier", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billmodifier"))));
                    billrecord.set("billmodifydate", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billmodifydate"))));
                    continue;
                }
                if (controlseq <= seq || curentBillid == null || curentBillid == 0L) continue;
                billrecord.set("calcstatus", (Object)"xjs");
            }
            LOGGER.info("DeskService-respondBillChange \u5b8c\u6210\uff1abillnumber:{},billid:{}\uff0c\u6267\u884c\u4fdd\u5b58", (Object)billnumber, (Object)billid);
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    public void respondBillDelete(String billnumber, Long org, Long project, Long scheme, String version) {
        DynamicObject[] load;
        Optional<DynamicObject> first;
        LOGGER.info("DeskService-respondBillDelete \u8bf7\u6c42\u53c2\u6570\uff1abillnumber:{},org:{},project:{},scheme:{},version:{}", new Object[]{billnumber, org, project, scheme, version});
        if (billnumber != null && (first = Arrays.stream(load = this.getBillRecordByBizUniq(org, project, scheme, version)).filter(a -> billnumber.equals(a.getString("billmetanumber"))).findFirst()).isPresent()) {
            DynamicObject deletedBill = first.get();
            int seq = deletedBill.getInt("controlseq");
            for (DynamicObject billrecord : load) {
                int controlseq = billrecord.getInt("controlseq");
                if (billnumber.equals(billrecord.get("billmetanumber"))) {
                    billrecord.set("billid", null);
                    billrecord.set("cbillno", null);
                    billrecord.set("billstate", null);
                    billrecord.set("createstatus", (Object)"wbz");
                    billrecord.set("calcstatus", null);
                    billrecord.set("billmodifier", null);
                    billrecord.set("billmodifydate", null);
                } else if (controlseq > seq) {
                    // empty if block
                }
                LOGGER.info("DeskService-respondBillDelete \u5b8c\u6210\uff1abillnumber:{},org:{},project:{},scheme:{},version:{} \u6267\u884c\u4fdd\u5b58", new Object[]{billnumber, org, project, scheme, version});
                SaveServiceHelper.save((DynamicObject[])load);
            }
        }
    }

    public Map<String, Object> deleteMulti(Object[] schemeVerRecPk) {
        DynamicObject[] load;
        LOGGER.info("DeskService-deleteMulti\uff1aschemeVerRecPk:{}", (Object)JsonUtil.toJson((Object)schemeVerRecPk));
        for (DynamicObject billrecord : load = BusinessDataServiceHelper.load((Object[])schemeVerRecPk, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCEPT_DESK_BILL_RECORD))) {
            String billmetanumber = billrecord.getString("billmetanumber");
            long billid = billrecord.getLong("billid");
            if (billid == 0L) continue;
            IDeskMeasureService billService = this.getBillService(billmetanumber);
            Map<String, Object> delete = billService.delete(billid);
            if (Boolean.TRUE.equals(delete.getOrDefault("success", Boolean.FALSE))) {
                billrecord.set("billid", null);
                billrecord.set("cbillno", null);
                billrecord.set("billstate", null);
                billrecord.set("createstatus", (Object)"wbz");
                billrecord.set("calcstatus", null);
                billrecord.set("billmodifier", null);
                billrecord.set("billmodifydate", null);
                continue;
            }
            String message = (String)delete.getOrDefault("message", ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"DeskService_0", (String)"taxc-tcept", (Object[])new Object[0]));
            throw new KDBizException(message);
        }
        LOGGER.info("DeskService-deleteMulti \u5b8c\u6210\u5f00\u59cb\u4fdd\u5b58\uff1aschemeVerRecPk:{},savesize:{}", (Object)JsonUtil.toJson((Object)schemeVerRecPk), (Object)load.length);
        SaveServiceHelper.save((DynamicObject[])load);
        return ServiceResultUtils.returnResultHandler((Object)true);
    }

    public Map<String, Object> copySuite(Long projectRecPk) {
        LOGGER.info("DeskService-copySuite\uff1aprojectRecPk:{}", (Object)JsonUtil.toJson((Object)projectRecPk));
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Map<Boolean, List<Map>> result;
            Object[] schemeVerRecPk = this.getBillRecordIdByProjectRecordId(Collections.singletonList(projectRecPk));
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])schemeVerRecPk, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCEPT_DESK_BILL_RECORD));
            DynamicObject projectDesk = this.getProjectDesk(projectRecPk);
            String newversion = this.schemaDataService.createVersionAndSyncData(projectDesk.getDynamicObject("scheme").getLong("id"), projectDesk.getString("versionname"));
            Object recordorg = projectDesk.get("org.id");
            Object recordproject = projectDesk.get("project.id");
            Object recordscheme = projectDesk.get("scheme.id");
            DynamicObject[] newLoad = this.getBillRecordByBizUniq(recordorg, recordproject, recordscheme, newversion);
            Map<String, DynamicObject> newMap = Arrays.stream(newLoad).collect(Collectors.toMap(a -> a.getString("billmetanumber"), b -> b, (m, n) -> m));
            List controlseq = Arrays.stream(load).sorted(Comparator.comparing(s -> s.getInt("controlseq"))).collect(Collectors.toList());
            ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(16);
            for (DynamicObject billrecord : controlseq) {
                DynamicObject sourceBill;
                String billmetanumber = billrecord.getString("billmetanumber");
                IDeskMeasureService billService = this.getBillService(billmetanumber);
                Map<String, String> infoSyncFieldMap = billService.getInfoSyncField();
                Long org = billrecord.getLong("org.id");
                Long project = billrecord.getLong("project.id");
                Long scheme = billrecord.getLong("scheme.id");
                String version = billrecord.getString("version");
                Long billid = billrecord.getLong("billid");
                if (billid == null || billid == 0L) continue;
                Map<String, Object> copy = billService.copy(billid, org, project, scheme, version, newversion);
                results.add(copy);
                if (!Boolean.TRUE.equals(copy.getOrDefault("success", Boolean.FALSE)) || (sourceBill = (DynamicObject)copy.get("data")) == null || newMap.get(billmetanumber) == null) continue;
                DynamicObject newbillrecord = newMap.get(billmetanumber);
                newbillrecord.set("billid", sourceBill.get("id"));
                newbillrecord.set("cbillno", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("cbillno"))));
                newbillrecord.set("billstate", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billstate"))));
                newbillrecord.set("createstatus", (Object)"ybz");
                newbillrecord.set("calcstatus", (Object)"wxjs");
                newbillrecord.set("billmodifier", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billmodifier"))));
                newbillrecord.set("billmodifydate", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billmodifydate"))));
            }
            if (newLoad != null && newLoad.length > 0) {
                SaveServiceHelper.save((DynamicObject[])newMap.values().toArray(new DynamicObject[newMap.size()]));
            }
            if ((result = results.stream().collect(Collectors.groupingBy(s -> (Boolean)s.get("success")))).containsKey(Boolean.FALSE)) {
                String message = result.get(Boolean.FALSE).stream().map(s -> (String)s.get("message")).collect(Collectors.joining("=====>"));
                LOGGER.info(String.format("DeskService-copySuite info :projectRecPk:%s", projectRecPk), (Object)message);
                Map map = ServiceResultUtils.returnResultHandler((boolean)false, (String)"-1", (String)ResManager.loadKDString((String)"\u6570\u636e\u64cd\u4f5c\u5931\u8d25\u3002", (String)"DeskService_1", (String)"taxc-tcept", (Object[])new Object[0]), null);
                return map;
            }
            Map map = ServiceResultUtils.returnResultHandler((Object)true);
            return map;
        }
        catch (Exception e) {
            try {
                LOGGER.error(String.format("DeskService-copySuite error :projectRecPk:%s", projectRecPk), (Throwable)e);
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Map<String, Object> deleteSuite(List<Long> projectRecPk) {
        return ServiceResultUtils.returnResultHandler((Object)true);
    }

    public Map<String, Object> submitSuite(List<Long> projectRecPk) {
        return this.operatorSuite(projectRecPk, (id, billService) -> billService.submit((Long)id), "B");
    }

    public Map<String, Object> unsubmitSuite(List<Long> projectRecPk) {
        return this.operatorSuite(projectRecPk, (id, billService) -> billService.unsubmit((Long)id), "A");
    }

    public Map<String, Object> auditSuite(List<Long> projectRecPk) {
        return this.operatorSuite(projectRecPk, (id, billService) -> billService.audit((Long)id), "C");
    }

    public Map<String, Object> unauditSuite(List<Long> projectRecPk) {
        return this.operatorSuite(projectRecPk, (id, billService) -> billService.unaudit((Long)id), "A");
    }

    public Map<String, Object> operatorByTransaction(Long projectId, BiFunction<Long, IDeskMeasureService, Map<String, Object>> function, String billstatus) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            Object billmetanumber;
            Object[] ids = this.getBillRecordIdByProjectRecordId(Lists.newArrayList((Object[])new Long[]{projectId}));
            DynamicObject[] loads = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCEPT_DESK_BILL_RECORD));
            List orderData = Arrays.stream(loads).sorted(Comparator.comparing(s -> s.getInt("controlseq"))).collect(Collectors.toList());
            ArrayList<Map<String, Object>> collect = new ArrayList<Map<String, Object>>();
            for (DynamicObject billrecord : orderData) {
                if (billrecord.getLong("billid") == 0L) continue;
                billmetanumber = billrecord.getString("billmetanumber");
                IDeskMeasureService billService = this.getBillService((String)billmetanumber);
                long billid = billrecord.getLong("billid");
                Map<String, Object> result = function.apply(billid, billService);
                collect.add(result);
            }
            Map<Boolean, List<Map>> result = collect.stream().collect(Collectors.groupingBy(s -> (Boolean)s.get("success")));
            if (result.containsKey(Boolean.FALSE)) {
                String message = result.get(Boolean.FALSE).stream().map(s -> {
                    DynamicObject data = (DynamicObject)s.get("data");
                    if (data != null) {
                        String billno = data.getString("billno");
                        String name = data.getDynamicObjectType().getDisplayName().getLocaleValue();
                        String msg = (String)s.get("message");
                        return String.format("%s\uff1a\u3010%s\u3011%s", name, billno, msg);
                    }
                    return (String)s.get("message");
                }).collect(Collectors.joining("\n"));
                LOGGER.info(String.format("DeskService-operatorSuite info :projectRecPk:%s", projectId), (Object)message);
                h.markRollback();
                billmetanumber = ServiceResultUtils.returnResultHandler((boolean)false, (String)"-1", (String)message, null);
                return billmetanumber;
            }
            DynamicObject[] syncBillInfo = this.syncBillInfo(loads);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)projectId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)TCEPT_PROJECT_DESK));
            dynamicObject.set("billstatus", (Object)billstatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            SaveServiceHelper.save((DynamicObject[])syncBillInfo);
            Map map = ServiceResultUtils.returnResultHandler((Object)true);
            return map;
        }
        catch (Exception e) {
            try {
                LOGGER.error(String.format("DeskService-operatorSuite error :projectRecPk:%s", projectId), (Throwable)e);
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Map<String, Object> operatorSuite(List<Long> projectRecPk, BiFunction<Long, IDeskMeasureService, Map<String, Object>> function, String billstatus) {
        try {
            List collect = projectRecPk.stream().map(projectId -> this.operatorByTransaction((Long)projectId, function, billstatus)).collect(Collectors.toList());
            Map<Boolean, List<Map>> result = collect.stream().collect(Collectors.groupingBy(s -> (Boolean)s.get("success")));
            if (result.containsKey(Boolean.FALSE)) {
                String message = result.get(Boolean.FALSE).stream().map(s -> {
                    DynamicObject data = (DynamicObject)s.get("data");
                    if (data != null) {
                        String billno = data.getString("billno");
                        String name = data.getDynamicObjectType().getDisplayName().getLocaleValue();
                        String msg = (String)s.get("message");
                        return String.format("%s\uff1a\u3010%s\u3011%s", name, billno, msg);
                    }
                    return (String)s.get("message");
                }).collect(Collectors.joining("\n"));
                return ServiceResultUtils.returnResultHandler((boolean)false, (String)"-1", (String)message, null);
            }
            return ServiceResultUtils.returnResultHandler((Object)true);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return ServiceResultUtils.returnResultHandler((boolean)false, (String)"-1", (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeskService_3", (String)"taxc-tcept", (Object[])new Object[0]), null);
        }
    }

    private DynamicObject[] syncBillInfo(DynamicObject[] loads) {
        for (DynamicObject billrecord : loads) {
            if (billrecord.getLong("billid") == 0L) continue;
            String billmetanumber = billrecord.getString("billmetanumber");
            IDeskMeasureService billService = this.getBillService(billmetanumber);
            long billid = billrecord.getLong("billid");
            DynamicObject sourceBill = this.getSourceBill(billmetanumber, billid);
            if (sourceBill == null) continue;
            Map<String, String> infoSyncFieldMap = billService.getInfoSyncField();
            billrecord.set("billid", sourceBill.get("id"));
            billrecord.set("cbillno", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("cbillno"))));
            billrecord.set("billstate", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billstate"))));
            billrecord.set("createstatus", (Object)"ybz");
            billrecord.set("calcstatus", (Object)"wxjs");
            billrecord.set("billmodifier", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billmodifier"))));
            billrecord.set("billmodifydate", sourceBill.get(infoSyncFieldMap.get(FIELD_MAP.get("billmodifydate"))));
        }
        return loads;
    }

    private DynamicObject getSourceBill(String billmetanumber, long billid) {
        return BusinessDataServiceHelper.loadSingle((Object)billid, (String)billmetanumber);
    }

    public List<DynamicObject> getControlRange() {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"tpo_tcept_bizdef", (String)"entryentity.seq seq, entryentity.entrynumber number,entryentity.projectname name", (QFilter[])new QFilter("number", "=", (Object)"PROJ-tax-001").toArray(), (String)"entryentity.seq asc");
        return query.stream().filter(a -> StringUtil.isNotEmpty((CharSequence)a.getString("number"))).collect(Collectors.toList());
    }

    public IDeskMeasureService getBillService(String billmetanumber) {
        IDeskMeasureService service = DeskMeasureServiceFactory.getFactory().getService(billmetanumber);
        if (service == null) {
            throw new TceptBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u627e\u5230\u5bf9\u5e94\u7684\u670d\u52a1\u63d2\u4ef6\u3002", (String)"DeskService_2", (String)"taxc-tcept", (Object[])new Object[0]), billmetanumber));
        }
        return service;
    }

    private DynamicObject[] getBillRecordByBizUniq(Object org, Object project, Object scheme, Object version) {
        QFilter qFilter5 = new QFilter("org", "=", org);
        QFilter qFilter2 = new QFilter("project", "=", project);
        QFilter qFilter3 = new QFilter("scheme", "=", scheme);
        QFilter qFilter4 = new QFilter("version", "=", version);
        DynamicObjectCollection queryBillRecord = QueryServiceHelper.query((String)TCEPT_DESK_BILL_RECORD, (String)"id,version,org,project,scheme,billmetanumber", (QFilter[])new QFilter[]{qFilter5, qFilter2, qFilter3, qFilter4});
        Object[] ids = queryBillRecord.stream().map(a -> a.get("id")).toArray();
        return BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCEPT_DESK_BILL_RECORD));
    }

    private Object[] getBillRecordIdByProjectRecordId(List<Long> projectRecPk) {
        QFilter qFilter = new QFilter("id", "in", projectRecPk);
        DynamicObjectCollection query = QueryServiceHelper.query((String)TCEPT_PROJECT_DESK, (String)"billno,org,project,scheme", (QFilter[])qFilter.toArray());
        HashSet<Long> org = new HashSet<Long>();
        HashSet<Long> project = new HashSet<Long>();
        HashSet<Long> scheme = new HashSet<Long>();
        HashSet<String> version = new HashSet<String>();
        for (DynamicObject dynamicObject : query) {
            org.add(dynamicObject.getLong("org"));
            project.add(dynamicObject.getLong("project"));
            scheme.add(dynamicObject.getLong("scheme"));
            version.add(dynamicObject.getString("billno"));
        }
        QFilter qFilter1 = new QFilter("org", "in", org);
        QFilter qFilter2 = new QFilter("project", "in", project);
        QFilter qFilter3 = new QFilter("scheme", "in", scheme);
        QFilter qFilter4 = new QFilter("version", "in", version);
        DynamicObjectCollection queryBillRecord = QueryServiceHelper.query((String)TCEPT_DESK_BILL_RECORD, (String)"id,version,org,project,scheme", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
        return queryBillRecord.stream().map(a -> a.get("id")).toArray();
    }

    public DynamicObject getProjectDesk(Long pkId) {
        return BusinessDataServiceHelper.loadSingle((Object)pkId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCEPT_PROJECT_DESK));
    }

    public boolean existNeedCalc(String billNo) {
        return QueryServiceHelper.exists((String)TCEPT_DESK_BILL_RECORD, (QFilter[])new QFilter[]{new QFilter("version", "=", (Object)billNo), new QFilter("calcstatus", "!=", (Object)"wxjs")});
    }

    public boolean existNoEdit(String billNo) {
        return QueryServiceHelper.exists((String)TCEPT_DESK_BILL_RECORD, (QFilter[])new QFilter[]{new QFilter("version", "=", (Object)billNo), new QFilter("createstatus", "=", (Object)"wbz")});
    }

    public boolean existRefVersion(String versionCode) {
        QFilter q1 = new QFilter("billno", "=", (Object)versionCode);
        QFilter q2 = new QFilter("version", "=", (Object)versionCode);
        return QueryServiceHelper.exists((String)TCEPT_PROJECT_DESK, (QFilter[])new QFilter[]{q1}) || QueryServiceHelper.exists((String)TCEPT_DESK_BILL_RECORD, (QFilter[])new QFilter[]{q2});
    }

    public Map<String, Object> reCalcOne(Object primaryKeyValue, String formId, String operateName) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)TCEPT_DESK_BILL_RECORD);
        String billmetanumber = dynamicObject.getString("billmetanumber");
        IDeskMeasureService service = this.getBillService(billmetanumber);
        Long billid = dynamicObject.getLong("billid");
        long project = dynamicObject.getLong("project.id");
        long scheme = dynamicObject.getLong("scheme.id");
        long org = dynamicObject.getLong("org.id");
        String version = dynamicObject.getString("version");
        String cbillno = dynamicObject.getString("cbillno");
        if (billid == null || billid == 0L) {
            return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-1", ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u65e0\u9700\u64cd\u4f5c\u3002", (String)"DeskService_7", (String)"taxc-tcept", (Object[])new Object[0]), null);
        }
        if (service.isSupportRecalc()) {
            Map<String, Object> recalc = service.recalc(billid, org, project, scheme, version);
            String operateDescription = Boolean.TRUE.equals(recalc.getOrDefault("success", Boolean.FALSE)) ? String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u53f7%s\u201d\u91cd\u65b0\u53d6\u6570\u6210\u529f", (String)"DeskService_3", (String)"taxc-tcept", (Object[])new Object[0]), String.valueOf(cbillno)) : String.format(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u53f7%s\u201d\u91cd\u65b0\u53d6\u6570\u5931\u8d25", (String)"DeskService_4", (String)"taxc-tcept", (Object[])new Object[0]), String.valueOf(cbillno));
            OperatorDialogUtils.operateDialogByAppid((String)"tcept", (String)billmetanumber, (String)ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570", (String)"DeskService_5", (String)"taxc-tcept", (Object[])new Object[0]), (String)operateDescription);
            return recalc;
        }
        return IDeskMeasureService.createReturnResultObject(Boolean.FALSE, "-2", ResManager.loadKDString((String)"\u8be5\u5e95\u7a3f\u65e0\u6cd5\u91cd\u65b0\u53d6\u6570\uff0c\u8bf7\u8fdb\u5165\u5355\u636e\u8be6\u7ec6\u9875\u9762\u4fee\u6539\u6570\u636e\u3002", (String)"DeskService_6", (String)"taxc-tcept", (Object[])new Object[0]), null);
    }
}

