/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.business.statistics;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tcept.business.statistics.DeskService;

public class DeskServiceMediator {
    private static DeskService deskService = new DeskService();
    private static final Log LOGGER = LogFactory.getLog(DeskService.class);

    public static void fireBillChange(String billnumber, Long billid) {
        LOGGER.info("DeskServiceMediator-fireBillChange \u8bf7\u6c42\u53c2\u6570\uff1abillnumber:{},billid:{}", (Object)billnumber, (Object)billid);
        try (TXHandle h = TX.required();){
            try {
                deskService.respondBillChange(billnumber, billid);
            }
            catch (Exception e) {
                h.markRollback();
                LOGGER.error(String.format("DeskServiceMediator-fireBillChange error :billnumber:%s,billid:%s", billnumber, billid), (Throwable)e);
                throw e;
            }
        }
    }

    public static void fireBillDelete(String billnumber, Long org, Long project, Long scheme, String version) {
        LOGGER.info("DeskServiceMediator-fireBillDelete \u8bf7\u6c42\u53c2\u6570\uff1abillnumber:{},org:{},project:{},scheme:{},version:{}", new Object[]{billnumber, org, project, scheme, version});
        try (TXHandle h = TX.required();){
            try {
                deskService.respondBillDelete(billnumber, org, project, scheme, version);
            }
            catch (Exception e) {
                LOGGER.error(String.format("DeskServiceMediator-fireBillDelete error :billnumber:%s,org:%s,project:%s,scheme:%s,version:%s", billnumber, org, project, scheme, version), (Throwable)e);
                h.markRollback();
                throw e;
            }
        }
    }
}

