/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum ClearPeriodEnum {
    period_01("01", 1, new MultiLangEnumBridge("\u4e00\u671f", "ClearPeriodEnum_1", "taxc-tcept")),
    period_02("02", 2, new MultiLangEnumBridge("\u4e8c\u671f", "ClearPeriodEnum_2", "taxc-tcept")),
    period_03("03", 3, new MultiLangEnumBridge("\u4e09\u671f", "ClearPeriodEnum_3", "taxc-tcept")),
    period_04("04", 4, new MultiLangEnumBridge("\u56db\u671f", "ClearPeriodEnum_4", "taxc-tcept")),
    period_05("05", 5, new MultiLangEnumBridge("\u4e94\u671f", "ClearPeriodEnum_5", "taxc-tcept")),
    period_06("06", 6, new MultiLangEnumBridge("\u516d\u671f", "ClearPeriodEnum_6", "taxc-tcept")),
    period_07("07", 7, new MultiLangEnumBridge("\u4e03\u671f", "ClearPeriodEnum_7", "taxc-tcept")),
    period_08("08", 8, new MultiLangEnumBridge("\u516b\u671f", "ClearPeriodEnum_8", "taxc-tcept")),
    period_09("09", 9, new MultiLangEnumBridge("\u4e5d\u671f", "ClearPeriodEnum_9", "taxc-tcept")),
    period_10("10", 10, new MultiLangEnumBridge("\u5341\u671f", "ClearPeriodEnum_10", "taxc-tcept")),
    period_count("count", 99, new MultiLangEnumBridge("\u5168\u6848\u6210\u672c\uff08\u5408\u8ba1\uff09", "ClearPeriodEnum_11", "taxc-tcept"));

    private String code;
    private Integer order;
    private MultiLangEnumBridge name;

    public Integer getOrder() {
        return this.order;
    }

    private ClearPeriodEnum(String code, Integer order, MultiLangEnumBridge name) {
        this.code = code;
        this.name = name;
        this.order = order;
    }

    public String getCode() {
        return this.code;
    }

    public MultiLangEnumBridge getName() {
        return this.name;
    }

    public static List<ComboItem> getClearPeriods(int max) {
        return Arrays.stream(ClearPeriodEnum.values()).filter(s -> s.getOrder() <= max).map(s -> new ComboItem(new LocaleString(s.getName().loadKDString()), s.getCode())).collect(Collectors.toList());
    }

    public static Map<Integer, ClearPeriodEnum> getOrderMap() {
        Map<Integer, ClearPeriodEnum> collect = Arrays.stream(ClearPeriodEnum.values()).filter(a -> a.getOrder() != null).collect(Collectors.toMap(a -> a.getOrder(), b -> b, (m, n) -> m));
        return collect;
    }

    public static List<ComboItem> getClearPeriodsWithCount(int max) {
        List<ComboItem> clearPeriods = ClearPeriodEnum.getClearPeriods(max);
        if (max > 0) {
            clearPeriods.add(new ComboItem(new LocaleString(period_count.getName().loadKDString()), period_count.getCode()));
        }
        return clearPeriods;
    }

    public static String getName(String code) {
        return Arrays.stream(ClearPeriodEnum.values()).filter(s -> s.getCode().equals(code)).map(s -> s.getName().loadKDString()).findFirst().orElseGet(() -> "");
    }

    public static ClearPeriodEnum getByCode(String code) {
        Optional<ClearPeriodEnum> first = Arrays.stream(ClearPeriodEnum.values()).filter(s -> s.getCode().equals(code)).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    public static ClearPeriodEnum getByOrder(int order) {
        Optional<ClearPeriodEnum> first = Arrays.stream(ClearPeriodEnum.values()).filter(s -> s.getOrder().equals(order)).findFirst();
        return first.isPresent() ? first.get() : null;
    }
}

