/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.common.enums;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;

public enum TaxStateEnum {
    NORMAL_HOUSE("normal_house", "01", "ptzz", new MultiLangEnumBridge("\u666e\u901a\u4f4f\u5b85", "TaxStateEnum_0", "taxc-tcept")),
    UN_NORMAL_HOUSE("un_normal_house", "02", "fptzz", new MultiLangEnumBridge("\u975e\u666e\u901a\u4f4f\u5b85", "TaxStateEnum_1", "taxc-tcept")),
    UN_HOUSE("un_house", "03", "qtlx", new MultiLangEnumBridge("\u5176\u4ed6\u7c7b\u578b\u623f\u5730\u4ea7", "TaxStateEnum_2", "taxc-tcept")),
    UN_CALC_STATE("un_calc_state", "04", "fqsyt", new MultiLangEnumBridge("\u975e\u6e05\u7b97\u4e1a\u6001", "TaxStateEnum_3", "taxc-tcept")),
    COUNT("count", "99", "", new MultiLangEnumBridge("\u5c0f\u8ba1", "TaxStateEnum_4", "taxc-tcept"));

    private String code;
    private String qtCode;
    private String columnCode;
    private MultiLangEnumBridge name;

    private TaxStateEnum(String code, String qtCode, String ftCode, MultiLangEnumBridge name) {
        this.code = code;
        this.qtCode = qtCode;
        this.columnCode = ftCode;
        this.name = name;
    }

    public String getColumnCode() {
        return this.columnCode;
    }

    public String getQtCode() {
        return this.qtCode;
    }

    public String getCode() {
        return this.code;
    }

    public MultiLangEnumBridge getName() {
        return this.name;
    }

    public static List<ComboItem> getTwoMethod(boolean withCount) {
        ArrayList enums = withCount ? Lists.newArrayList((Object[])new TaxStateEnum[]{NORMAL_HOUSE, UN_HOUSE, UN_CALC_STATE, COUNT}) : Lists.newArrayList((Object[])new TaxStateEnum[]{NORMAL_HOUSE, UN_HOUSE, UN_CALC_STATE});
        return enums.stream().map(s -> new ComboItem(new LocaleString(s.getName().loadKDString()), s.getCode())).collect(Collectors.toList());
    }

    public static List<ComboItem> getThreeMethod(boolean withCount) {
        ArrayList enums = withCount ? Lists.newArrayList((Object[])new TaxStateEnum[]{NORMAL_HOUSE, UN_NORMAL_HOUSE, UN_HOUSE, UN_CALC_STATE, COUNT}) : Lists.newArrayList((Object[])new TaxStateEnum[]{NORMAL_HOUSE, UN_NORMAL_HOUSE, UN_HOUSE, UN_CALC_STATE});
        return enums.stream().map(s -> new ComboItem(new LocaleString(s.getName().loadKDString()), s.getCode())).collect(Collectors.toList());
    }

    public static List<ComboItem> getComboItem(String type) {
        return "0".equals(type) ? TaxStateEnum.getTwoMethod(false) : TaxStateEnum.getThreeMethod(false);
    }

    public static List<ComboItem> getComboItemWithCount(String type) {
        return "0".equals(type) ? TaxStateEnum.getTwoMethod(true) : TaxStateEnum.getThreeMethod(true);
    }

    public static String getName(String code) {
        return Arrays.stream(TaxStateEnum.values()).filter(s -> s.getCode().equals(code)).map(s -> s.getName().loadKDString()).findFirst().orElseGet(() -> "");
    }
}

