/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.common.utils;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;

public class CollectionTool {
    public static Map<Object, Map<String, BigDecimal>> listGroupOnceGetOneToGroup(List<DynamicObject> entryentity, String firstGroupKey, String ... keys) {
        Map<Object, List<DynamicObject>> firstGroup = entryentity.stream().collect(Collectors.groupingBy(a -> a.get(firstGroupKey)));
        HashMap<Object, Map<String, BigDecimal>> hashMap = new HashMap<Object, Map<String, BigDecimal>>();
        for (Map.Entry<Object, List<DynamicObject>> entry : firstGroup.entrySet()) {
            Object key = entry.getKey();
            DynamicObject value = entry.getValue().get(0);
            HashMap<String, BigDecimal> hashMap1 = new HashMap<String, BigDecimal>(8);
            for (String k : keys) {
                hashMap1.put(k, value.getBigDecimal(k));
            }
            hashMap.put(key, hashMap1);
        }
        return hashMap;
    }

    public static Map<Object, Map<String, BigDecimal>> listGroupOnceGetSumToGroup(List<DynamicObject> entryentity, String firstGroupKey, String ... keys) {
        Map<Object, List<DynamicObject>> firstGroup = entryentity.stream().collect(Collectors.groupingBy(a -> a.get(firstGroupKey)));
        HashMap<Object, Map<String, BigDecimal>> hashMap = new HashMap<Object, Map<String, BigDecimal>>();
        for (Map.Entry<Object, List<DynamicObject>> entry : firstGroup.entrySet()) {
            Object key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            HashMap<String, BigDecimal> hashMap1 = new HashMap<String, BigDecimal>();
            for (DynamicObject dynamicObject : value) {
                for (String k : keys) {
                    BigDecimal orDefault = hashMap1.getOrDefault(k, BigDecimal.ZERO);
                    hashMap1.put(k, orDefault.add(dynamicObject.getBigDecimal(k)));
                }
            }
            hashMap.put(key, hashMap1);
        }
        return hashMap;
    }

    public static Map<Object, Map<Object, BigDecimal>> listGroupTwiceSumReduceOneKey(List<DynamicObject> entryentity, String firstGroupKey, String secondGroupKey, String reduceKey) {
        Map<Object, List<DynamicObject>> firstGroup = entryentity.stream().collect(Collectors.groupingBy(a -> a.get(firstGroupKey)));
        HashMap<Object, Map<Object, BigDecimal>> hashMap = new HashMap<Object, Map<Object, BigDecimal>>();
        for (Map.Entry<Object, List<DynamicObject>> entry : firstGroup.entrySet()) {
            Object key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            Map<Object, BigDecimal> secondGroup = value.stream().collect(Collectors.groupingBy(a -> a.get(secondGroupKey), Collectors.mapping(b -> b.getBigDecimal(reduceKey), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            hashMap.put(key, secondGroup);
        }
        return hashMap;
    }

    public static Map<Object, Map<Object, Map<String, BigDecimal>>> listGroupTwiceSumReduceKeys(List<DynamicObject> entryentity, String firstGroupKey, String secondGroupKey, String ... keys) {
        HashMap<Object, Map<Object, Map<String, BigDecimal>>> firstLevelMap = new HashMap<Object, Map<Object, Map<String, BigDecimal>>>();
        for (DynamicObject object : entryentity) {
            Object firstGroupK = object.get(firstGroupKey);
            Object secondGroupK = object.get(secondGroupKey);
            Map secondLevelMap = firstLevelMap.getOrDefault(firstGroupK, new HashMap());
            Map threeLevelMap = secondLevelMap.getOrDefault(secondGroupK, new HashMap());
            for (String k : keys) {
                BigDecimal orDefault = threeLevelMap.getOrDefault(k, BigDecimal.ZERO);
                threeLevelMap.put(k, orDefault.add(object.getBigDecimal(k)));
            }
            secondLevelMap.put(secondGroupK, threeLevelMap);
            firstLevelMap.put(firstGroupK, secondLevelMap);
        }
        return firstLevelMap;
    }
}

