/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.baseconfig;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tcept.business.baseconfig.RuleConfigService;
import kd.taxc.tcept.common.enums.TaxStateEnum;

public class RuleConfigEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private RuleConfigService ruleConfigService = new RuleConfigService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isChangingMainOrg = (String)this.getModel().getContextVariable("isChangingMainOrg");
        if (!"true".equals(isChangingMainOrg)) {
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
            List istaxpayers = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(col.stream().map(s -> s.getLong("id")).collect(Collectors.toList())).getData();
            col = col.stream().filter(s -> istaxpayers.contains(s.getLong("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            Long org = RequestContext.get().getOrgId();
            Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
            if (orgid != null) {
                this.getModel().setValue("org", (Object)orgid);
            }
        }
        this.initEntryentityFetch();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.ADDNEW) {
            String ruletype = (String)this.getModel().getValue("ruletype");
            Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            Long projectId = ((DynamicObject)this.getModel().getValue("project")).getLong("id");
            boolean exists = this.ruleConfigService.isExists(orgId, projectId, "private");
            if ("private".equals(ruletype) && exists) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u623f\u5730\u4ea7\u9879\u76ee\u5df2\u7ecf\u5b58\u5728\u201c\u81ea\u7528\u89c4\u5219\u201d\uff0c\u4e0d\u5f97\u91cd\u590d\u65b0\u589e\u3002", (String)"RuleConfigEditPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("project".equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            long orgid = org.getLong("id");
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter q1 = new QFilter("taxorg", "=", (Object)orgid);
            QFilter q2 = new QFilter("status", "=", (Object)"C");
            QFilter q3 = new QFilter("group.number", "=", (Object)"001");
            QFilter q4 = new QFilter("enable", "=", (Object)"1");
            listShowParameter.getListFilterParameter().setFilter(q1);
            listShowParameter.getListFilterParameter().setFilter(q2);
            listShowParameter.getListFilterParameter().setFilter(q3);
            listShowParameter.getListFilterParameter().setFilter(q4);
            List qFilters = listShowParameter.getTreeFilterParameter().getQFilters();
            qFilters.add(new QFilter("number", "in", (Object)"001"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        String name = e.getProperty().getName();
        if ("org".equals(name)) {
            this.getModel().setValue("prject", null);
        }
        if ("project".equals(name) && newValue != null) {
            String method = ((DynamicObject)newValue).getString("swqsytfl");
            this.initTaxStateComboItems(method);
            this.initEntryentityMap(method);
        }
        if ("minarea".equals(name) || "maxarea".equals(name)) {
            this.checkRange(e, "minarea", "maxarea");
        }
        if ("mintotalprice".equals(name) || "maxtotalprice".equals(name)) {
            this.checkRange(e, "mintotalprice", "maxtotalprice");
        }
        if ("minprice".equals(name) || "maxprice".equals(name)) {
            this.checkRange(e, "minprice", "maxprice");
        }
        if ("minplotratio".equals(name) || "maxplotratio".equals(name)) {
            this.checkRange(e, "minplotratio", "maxplotratio");
        }
        if ("signingstart".equals(name) || "signingend".equals(name)) {
            this.checkRangeDate(e, "signingstart", "signingend");
        }
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }

    private void checkRange(PropertyChangedArgs e, String s1, String s2) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        BigDecimal value1 = (BigDecimal)this.getModel().getValue(s1, rowIndex);
        BigDecimal value2 = (BigDecimal)this.getModel().getValue(s2, rowIndex);
        if (value1 != null && value2 != null && value1.compareTo(value2) > 0 && value1.compareTo(BigDecimal.ZERO) > 0 && value2.compareTo(BigDecimal.ZERO) > 0) {
            this.rollbackPropertyChange(e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u503c\u4e0b\u9650\u4e0d\u80fd\u5927\u4e8e\u4e0a\u9650\u3002", (String)"RuleConfigEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
        }
    }

    private void checkRangeDate(PropertyChangedArgs e, String s1, String s2) {
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        Date value1 = (Date)this.getModel().getValue(s1, rowIndex);
        Date value2 = (Date)this.getModel().getValue(s2, rowIndex);
        if (value1 != null && value2 != null && value1.compareTo(value2) > 0) {
            this.rollbackPropertyChange(e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u671f\u8d77\u4e0d\u80fd\u5927\u4e8e\u6b62\u3002", (String)"RuleConfigEditPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
        }
    }

    private void initTaxStateComboItems(String type) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl("taxstate");
        comboEdit.setComboItems(TaxStateEnum.getComboItem(type));
    }

    private void initEntryentityMap(String method) {
        List<ComboItem> comboItem = TaxStateEnum.getComboItem(method);
        IDataModel model = this.getModel();
        int rows = "0".equals(method) ? 3 : 4;
        model.deleteEntryData("entryentitymap");
        model.batchCreateNewEntryRow("entryentitymap", rows);
        for (int i = 0; i < rows; ++i) {
            this.getModel().setValue("taxstate", (Object)comboItem.get(i).getValue(), i);
        }
    }

    private void initEntryentityFetch() {
        this.getModel().setValue("costitemname", (Object)ResManager.loadKDString((String)"\u571f\u5730\u6210\u672c", (String)"RuleConfigEditPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]), 0);
        this.getModel().setValue("costitemname", (Object)ResManager.loadKDString((String)"\u623f\u5730\u4ea7\u5f00\u53d1\u6210\u672c", (String)"RuleConfigEditPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]), 1);
        this.getModel().setValue("costitemname", (Object)ResManager.loadKDString((String)"\u623f\u5730\u4ea7\u5f00\u53d1\u8d39\u7528", (String)"RuleConfigEditPlugin_5", (String)"taxc-tcept", (Object[])new Object[0]), 2);
        this.getModel().setValue("fetchtype", (Object)"includingtax", 0);
        this.getModel().setValue("fetchtype", (Object)"excludingtax", 1);
        this.getModel().setValue("fetchtype", (Object)"excludingtax", 2);
    }
}

