/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.baseconfig;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.tree.TreeFilterParameter;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.statistics.DeskService;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;

public class SchemeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private DeskService deskService = new DeskService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl("project");
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit incomever = (BasedataEdit)this.getControl("incomever");
        incomever.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costver = (BasedataEdit)this.getControl("costver");
        costver.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isChangingMainOrg = (String)this.getModel().getContextVariable("isChangingMainOrg");
        if (!"true".equals(isChangingMainOrg)) {
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
            List istaxpayers = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(col.stream().map(s -> s.getLong("id")).collect(Collectors.toList())).getData();
            col = col.stream().filter(s -> istaxpayers.contains(s.getLong("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
            Long org = RequestContext.get().getOrgId();
            Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
            if (orgid != null) {
                this.getModel().setValue("org", (Object)orgid);
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().deleteEntryData("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid;
        int[] selectRows;
        String collect;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (source instanceof Save) {
            DynamicObjectCollection entity;
            if (!this.checkClearPeriod()) {
                args.setCancel(true);
            }
            if (status == OperationStatus.ADDNEW && CollectionUtils.isEmpty((Collection)(entity = this.getModel().getEntryEntity("entryentity")))) {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                String value = dataEntity.getString("number");
                this.getModel().batchCreateNewEntryRow("entryentity", 1);
                this.getModel().setValue("versioncode", (Object)String.format("%1$s-%2$s", value, "0001"), 0);
                this.getModel().setValue("versionname", (Object)"V1", 0);
                this.getView().updateView("entryentity");
            }
        }
        if (args.getSource() instanceof DeleteEntry && StringUtil.isNotEmpty((CharSequence)(collect = Arrays.stream(selectRows = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()).boxed().map(index -> this.getModel().getEntryRowEntity("entryentity", index.intValue())).filter(s -> this.deskService.existRefVersion(s.getString("versioncode"))).map(s -> s.getString("versioncode")).collect(Collectors.joining("\uff0c"))))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7248\u672c\u53f7:\u3010%s\u3011\u5df2\u7ecf\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"SchemeEditPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]), collect));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (args.getSource() instanceof NewEntry) {
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            int size = entity.size();
            List collect = entity.stream().sorted(Comparator.comparing(s -> s.getString("versioncode")).reversed()).collect(Collectors.toList());
            DynamicObject maxObj = (DynamicObject)collect.get(0);
            String versioncode = maxObj.getString("versioncode");
            String versionname = maxObj.getString("versionname");
            String value = (String)this.getModel().getValue("number");
            if (StringUtil.isBlank((CharSequence)versioncode) && StringUtil.isBlank((CharSequence)versionname)) {
                this.getModel().setValue("versioncode", (Object)String.format("%1$s-%2$s", value, "0001"), size - 1);
                this.getModel().setValue("versionname", (Object)"V1", size - 1);
            } else {
                String[] splits1 = maxObj.getString("versioncode").split("-");
                String[] splits2 = maxObj.getString("versionname").split("V");
                String newvercode = String.format("%04d", Integer.parseInt(splits1[splits1.length - 1]) + 1);
                Integer newvername = Integer.parseInt(splits2[1]) + 1;
                this.getModel().setValue("versioncode", (Object)String.format("%1$s-%2$s", value, newvercode), size - 1);
                this.getModel().setValue("versionname", (Object)String.format("%1$s%2$s", "V", newvername), size - 1);
            }
            this.getView().updateView("entryentity");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("sameclearofcost".equals(name) || "project".equals(name) || "clearperiod".equals(name)) {
            this.checkClearPeriod();
        }
    }

    public boolean checkClearPeriod() {
        String sameclearofcost = (String)this.getModel().getValue("sameclearofcost");
        String clearperiod = (String)this.getModel().getValue("clearperiod");
        DynamicObject project = (DynamicObject)this.getModel().getValue("project");
        if ("1".equals(sameclearofcost) && project != null && sameclearofcost != null && clearperiod != null) {
            String cbfq = project.getString("cbfq");
            ClearPeriodEnum byCode = ClearPeriodEnum.getByCode(clearperiod);
            if (cbfq != null && byCode != null && !Objects.equals(byCode.getOrder() + "", cbfq)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672c\u65b9\u6848\u7684\u201c\u6e05\u7b97\u5206\u671f\u201d\u548c\u201c\u623f\u5730\u4ea7\u9879\u76ee-\u6210\u672c\u5206\u671f\u201d\u4e0d\u4e00\u81f4\uff0c\u4e0d\u53ef\u9009\u62e9\u201c\u662f\u201d\u3002", (String)"SchemeEditPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
                this.getModel().setValue("sameclearofcost", null);
                return false;
            }
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("project".equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            long orgid = org.getLong("id");
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter q1 = new QFilter("taxorg", "=", (Object)orgid);
            QFilter q2 = new QFilter("status", "=", (Object)"C");
            QFilter q3 = new QFilter("group.number", "=", (Object)"001");
            QFilter q4 = new QFilter("enable", "=", (Object)"1");
            listShowParameter.getListFilterParameter().setFilter(q1);
            listShowParameter.getListFilterParameter().setFilter(q2);
            listShowParameter.getListFilterParameter().setFilter(q3);
            listShowParameter.getListFilterParameter().setFilter(q4);
            List qFilters = listShowParameter.getTreeFilterParameter().getQFilters();
            qFilters.add(new QFilter("number", "in", (Object)"001"));
        } else if ("incomever".equals(evt.getProperty().getName())) {
            evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6536\u5165\u6570\u636e\u6e90\u7248\u672c", (String)"SchemeEditPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("id", "=", (Object)1910236729319735296L));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
        } else if ("costver".equals(evt.getProperty().getName())) {
            evt.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6210\u672c\u6570\u636e\u6e90\u7248\u672c", (String)"SchemeEditPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            TreeFilterParameter treeFilterParameter = new TreeFilterParameter();
            treeFilterParameter.getQFilters().add(new QFilter("id", "=", (Object)1910236729319735296L));
            formShowParameter.setTreeFilterParameter(treeFilterParameter);
        }
    }
}

