/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.baseconfig.sharedplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.baseconfig.RuleConfigService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.common.utils.OrgControlUtil;
import org.apache.commons.collections.CollectionUtils;

public class SharingPlanPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(SharingPlanPlugin.class);
    private static final String systemType = "taxc-tcept";
    private static final String REFRESH = "refresh";
    private static final String SAVE = "save";
    private static final String INDEX = "index";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private RuleConfigService ruleConfigService = new RuleConfigService();
    private static final String ORG = "org";
    private static final String RULE = "rule";
    private static final String CREATEORG = "createorg";
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String ORGENTITY = "orgentity";
    private static final String PROJECTENTITY = "projectentity";
    private static final String OPT_PLANADD = "planadd";
    private static final String OPT_PLANDEL = "plandel";
    private static final String NEWROW = "newRow";
    private static final String OLDROW = "oldRow";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String CARDSWITCH = "cardSwitch";
    private static final String SEARCHAP = "searchap";
    private static final String PROJECT = "project";
    private static Map<String, String> MAP;
    private static final String[] fieldNames;
    private static final String TCEPT_PROJ_SHARPLAN = "tcept_proj_sharplan";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelcreate"});
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener((ItemClickListener)this);
        OrgEdit taxOrgEdit = (OrgEdit)this.getControl(ORG);
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit projectEdit = (BasedataEdit)this.getControl(PROJECT);
        projectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        OrgEdit taxCreateOrgEdit = (OrgEdit)this.getControl(CREATEORG);
        taxCreateOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl(RULE);
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        search.addClickListener((ClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
    }

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("init", "true");
        this.loadFormData();
        this.checkPermission();
    }

    public void afterBindData(EventObject e) {
        String delete = this.getPageCache().get("delete");
        String saveNumber = this.getPageCache().get("saveNomber");
        if (ObjectUtils.isEmpty((Object)delete)) {
            this.selectListRow(0);
        } else if ("true".equalsIgnoreCase(delete)) {
            String deleteAfterSelectRow = this.getPageCache().get("deleteAfterSelectRow");
            this.selectListRow(Integer.parseInt(deleteAfterSelectRow));
            this.getPageCache().put("delete", null);
        }
        if (!ObjectUtils.isEmpty((Object)saveNumber)) {
            this.getModel().updateCache();
            DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity(PLANENTITY);
            int size = entryEntitys.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject entryEntity = (DynamicObject)entryEntitys.get(i);
                if (!entryEntity.getString("carnumber").equalsIgnoreCase(saveNumber)) continue;
                this.selectListRow(i);
                this.getPageCache().put("saveNomber", null);
                break;
            }
        }
        this.setVisible();
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        if (StringUtil.equalsIgnoreCase((CharSequence)this.getPageCache().get("currentSearch"), (CharSequence)searchText)) {
            this.selectListRowAndPutCache();
        } else {
            this.generateCardIndexs(searchText);
            this.selectListRowAndPutCache();
        }
    }

    private void generateCardIndexs(String searchText) {
        this.getPageCache().put("currentSearch", searchText);
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashMap map = new HashMap();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet tempDataSet = dataSet.filter(nameQ.or(numberQ).toString());
        for (Row row : tempDataSet) {
            list.add(row.getInteger(INDEX));
        }
        tempDataSet.close();
        Collections.sort(list);
        Stream.iterate(0, i -> i + 1).limit(list.size()).forEach(i -> {
            Integer cfr_ignored_0 = (Integer)map.put(String.valueOf(i), list.get((int)i));
        });
        this.getPageCache().put("cardIndexs", SerializationUtils.toJsonString(map));
        if (!map.isEmpty()) {
            this.getPageCache().put("focusCardIndex", "-1");
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        this.generateCardIndexs(searchText);
        return this.filterDataSet(searchText);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        List oldRows = evt.getOldRows();
        if (newRows != null && newRows.size() > 0) {
            Integer newRowIndex = (Integer)newRows.get(0);
            Integer oldRowIndex = (Integer)oldRows.get(0);
            if (this.checkChangeData((Integer)evt.getOldRows().get(0)) && !newRowIndex.equals(oldRowIndex)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CARDSWITCH, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_1", (String)systemType, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_2", (String)systemType, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_3", (String)systemType, (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
                this.getPageCache().put(OLDROW, String.valueOf(oldRowIndex));
                return;
            }
            this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
            this.getPageCache().put(OLDROW, newRowIndex.equals(oldRowIndex) ? String.valueOf(this.getPageCache().get(OLDROW)) : String.valueOf(oldRowIndex));
            this.resetPlanName(newRowIndex);
            this.getPageCache().put(OLDROW, String.valueOf(newRowIndex));
            this.getView().setEnable(Boolean.valueOf(this.getModel().getEntryRowCount(RULEENTITY) < 1), new String[]{"ruleadd"});
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtil.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && this.checkChangeData(this.getSelectRows())) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_1", (String)systemType, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_2", (String)systemType, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_3", (String)systemType, (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)REFRESH)) {
            this.getView().invokeOperation(REFRESH);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (RULEENTITY.equals(e.getEntryProp().getName()) && this.getModel().getEntryRowCount(RULEENTITY) > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ruleadd"});
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        if (ORGENTITY.equals(e.getEntryProp().getName())) {
            DynamicObjectCollection projects;
            int[] indexs;
            IDataModel model = this.getModel();
            List orgids = Arrays.stream(e.getRowIndexs()).mapToObj(a -> (DynamicObject)model.getValue(ORG, a)).filter(a -> a != null).map(b -> b.getLong("id")).collect(Collectors.toList());
            if (orgids.size() > 0 && (indexs = (projects = this.getModel().getEntryEntity(PROJECTENTITY)).stream().filter(a -> a.getDynamicObject(PROJECT) != null && orgids.contains(a.getDynamicObject(PROJECT).getLong("taxorg.id"))).mapToInt(b -> b.getInt("seq") - 1).toArray()).length > 0) {
                this.getModel().deleteEntryRows(PROJECTENTITY, indexs);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (RULEENTITY.equals(e.getEntryProp().getName()) && this.getModel().getEntryRowCount(RULEENTITY) == 0) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"ruleadd"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)CREATEORG)) {
            List<Long> permOrgs = OrgControlUtil.getPermOrgs(this.getView());
            QFilter qFilter2 = new QFilter("id", "in", permOrgs);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter2);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)ORG)) {
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue(CREATEORG);
            if (createOrg == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"SharingPlanPlugin_11", (String)systemType, (Object[])new Object[0]));
                return;
            }
            Long createOrgID = createOrg.getLong("id");
            ArrayList<Long> list = new ArrayList<Long>();
            list.add(createOrgID);
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)OrgUtils.getLocalDefaultViewId(), list, (boolean)true);
            QFilter subOrgFilter = new QFilter("id", "in", (Object)subOrgIds);
            List<Long> permOrgs = OrgControlUtil.getPermOrgs(this.getView());
            if (!ObjectUtils.isEmpty(permOrgs)) {
                subOrgFilter = subOrgFilter.and(new QFilter("id", "in", permOrgs));
            }
            beforeF7SelectEvent.getCustomQFilters().add(subOrgFilter);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)RULE)) {
            QFilter inFilter = new QFilter("id", "in", this.queryRule(this.getOrgid()));
            DynamicObjectCollection rules = this.getModel().getEntryEntity(RULEENTITY);
            Set ids = rules.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject(RULE) != null).map(o -> o.getDynamicObject(RULE).get("id")).collect(Collectors.toSet());
            QFilter notInOrgFilter = new QFilter("id", "not in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(inFilter);
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("openType", (Object)"openbyf7");
            beforeF7SelectEvent.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u8303\u56f4", (String)"SharingPlanPlugin_13", (String)systemType, (Object[])new Object[0]));
        } else if (StringUtil.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)PROJECT)) {
            DynamicObjectCollection orgs = this.getModel().getEntryEntity(ORGENTITY);
            if (orgs.size() == 0) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5171\u4eab\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"SharingPlanPlugin_12", (String)systemType, (Object[])new Object[0]));
                return;
            }
            Set<Long> orgids = orgs.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject(ORG) != null).map(o -> o.getDynamicObject(ORG).getLong("id")).collect(Collectors.toSet());
            DynamicObjectCollection projects = this.getModel().getEntryEntity(PROJECTENTITY);
            Set ids = projects.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject(PROJECT) != null).map(o -> o.getDynamicObject(PROJECT).get("id")).collect(Collectors.toSet());
            DynamicObjectCollection rules = this.getModel().getEntryEntity(RULEENTITY);
            if (rules.size() == 0) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5171\u4eab\u89c4\u5219\u8303\u56f4\u3002", (String)"SharingPlanPlugin_14", (String)systemType, (Object[])new Object[0]));
                return;
            }
            DynamicObject rule = ((DynamicObject)rules.get(0)).getDynamicObject(RULE);
            if (rule == null) {
                beforeF7SelectEvent.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5171\u4eab\u89c4\u5219\u8303\u56f4\u4e2d\u7684\u89c4\u5219\u3002", (String)"SharingPlanPlugin_15", (String)systemType, (Object[])new Object[0]));
                return;
            }
            String sfwytfl = this.ruleConfigService.queryProjectSwytflByPk(rule.getLong("id"));
            Map<Long, String> idNameMap = this.ruleConfigService.existUsableRule(orgids, this.getCurPlanId());
            ids.addAll(idNameMap.keySet());
            QFilter inFilter = new QFilter("taxorg", "in", orgids);
            QFilter notInOrgFilter = new QFilter("id", "not in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(inFilter);
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("swqsytfl", "=", (Object)sfwytfl));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("focusNodeId", (Object)"1888314377338207232");
        }
    }

    private List<Object> queryRule(Long orgid) {
        return this.ruleConfigService.queryAllSharePks(orgid);
    }

    private Long getOrgid() {
        DynamicObject org = (DynamicObject)this.getModel().getValue(CREATEORG);
        return org == null ? null : Long.valueOf(org.getLong("id"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean valid;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof NewEntry && StringUtil.equalsIgnoreCase((CharSequence)((NewEntry)source).getOperateKey(), (CharSequence)OPT_PLANADD) && this.checkChangeData(this.getSelectRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u65b0\u589e\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingPlanPlugin_5", (String)systemType, (Object[])new Object[0]));
            args.setCancel(true);
        } else if (source instanceof DeleteEntry && StringUtil.equalsIgnoreCase((CharSequence)((DeleteEntry)source).getOperateKey(), (CharSequence)OPT_PLANDEL)) {
            DynamicObject row = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(this.getSelectRows());
            Long planId = row.getLong("id");
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)TCEPT_PROJ_SHARPLAN), (Object[])new Object[]{planId});
            int i = row.getInt(1) - 1;
            int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
            if (entryCount == 0 || row.getInt(1) + 1 > entryCount) {
                i = 0;
            }
            this.getPageCache().put("delete", "true");
            this.getPageCache().put("deleteAfterSelectRow", String.valueOf(i));
        } else if (source instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)((Donothing)source).getOperateKey(), (CharSequence)SAVE) && !(valid = this.checkBeforeSave())) {
            args.setCancel(true);
            return;
        }
    }

    private boolean checkBeforeSave() {
        DynamicObjectCollection rules = this.getModel().getEntryEntity(RULEENTITY);
        if (rules != null && rules.size() > 0) {
            Optional<DynamicObject> first = rules.stream().filter(a -> a.get(RULE) == null).findFirst();
            if (first.isPresent()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u8303\u56f4\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"SharingPlanPlugin_16", (String)systemType, (Object[])new Object[0]));
                return false;
            }
            if (rules.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5171\u4eab\u89c4\u5219\u8303\u56f4\u201d\u4e2d\u7684\u201c\u9879\u76ee\u89c4\u5219\u201d\u53ea\u80fd\u6709\u4e00\u6761\uff0c\u8bf7\u5220\u884c\u3002", (String)"SharingPlanPlugin_17", (String)systemType, (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection orgs = this.getModel().getEntryEntity(ORGENTITY);
            DynamicObjectCollection projects = this.getModel().getEntryEntity(PROJECTENTITY);
            if (orgs.size() == 0 || projects.size() == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u914d\u7f6e\u6709\u8bef\uff0c\u88ab\u5171\u4eab\u7684\u8303\u56f4\u201c\u7ec4\u7ec7\u201d\u6216\u201c\u623f\u5730\u4ea7\u9879\u76ee\u201d\u4e3a\u7a7a\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u88ab\u5171\u4eab\u7684\u201c\u7ec4\u7ec7\u201d\u548c\u201c\u623f\u5730\u4ea7\u9879\u76ee\u201d\u3002", (String)"SharingPlanPlugin_26", (String)systemType, (Object[])new Object[0]));
                return false;
            }
            first = orgs.stream().filter(a -> a.get(ORG) == null).findFirst();
            if (first.isPresent()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5171\u4eab\u7ec4\u7ec7\u8303\u56f4\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"SharingPlanPlugin_18", (String)systemType, (Object[])new Object[0]));
                return false;
            }
            first = projects.stream().filter(a -> a.get(PROJECT) == null).findFirst();
            if (first.isPresent()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5171\u4eab\u9879\u76ee\u8303\u56f4\u7684\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"SharingPlanPlugin_19", (String)systemType, (Object[])new Object[0]));
                return false;
            }
            List<Long> projectids = projects.stream().filter(a -> a.get(PROJECT) != null).map(a -> a.getDynamicObject(PROJECT)).map(a -> a.getLong("id")).collect(Collectors.toList());
            Map<Long, String> idNameMap = this.ruleConfigService.existUsableRuleByProject(projectids, this.getCurPlanId());
            if (idNameMap.size() > 0) {
                String projectName = (String)idNameMap.values().toArray()[0];
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u9879\u76ee\u5df2\u7ecf\u5b58\u5728\u9879\u76ee\u89c4\u5219\u914d\u7f6e\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u5206\u914d\u89c4\u5219\u3002", (String)"SharingPlanPlugin_20", (String)systemType, (Object[])new Object[0]), projectName));
                return false;
            }
            DynamicObject firstRule = (DynamicObject)rules.get(0);
            long project = firstRule.getLong("rule.project.id");
            String swqsytfl = TaxProjectDataService.queryProjectSwqsytflNoFit(project);
            List noFitProject = projects.stream().filter(a -> a.get(PROJECT) != null).filter(a -> !swqsytfl.equals(a.getString("project.swqsytfl"))).collect(Collectors.toList());
            if (noFitProject.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u88ab\u5171\u4eab\u89c4\u5219\u7684\u201c\u7a0e\u52a1\u6e05\u7b97\u4e1a\u6001\u5206\u7c7b\u201d\u65b9\u6cd5\u548c\u88ab\u5171\u4eab\u7684\u8303\u56f4\u201c\u7a0e\u52a1\u6e05\u7b97\u4e1a\u6001\u5206\u7c7b\u201d\u65b9\u6cd5\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u88ab\u5171\u4eab\u7684\u8303\u56f4\u3002", (String)"SharingPlanPlugin_25", (String)systemType, (Object[])new Object[0]));
                return false;
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u6570\u636e\u3002", (String)"SharingPlanPlugin_24", (String)systemType, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Long getDefaultOrg() {
        Long org = RequestContext.get().getOrgId();
        long currUserId = RequestContext.get().getCurrUserId();
        Long orgid = OrgCheckUtil.setDefaultOrg((Long)org, (Long)currUserId, (IFormView)this.getView());
        return orgid;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult result;
        super.afterDoOperation(afterDoOperationEventArgs);
        this.setVisible();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        int selectRow = this.getSelectRows();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANADD)) {
            this.selectListRow(selectRow);
            Long rootOrgId = this.getDefaultOrg();
            String number = this.getCodeRuleNumber(rootOrgId);
            this.getModel().setValue(MAP.get(NUMBER), (Object)number, selectRow);
            this.getModel().setValue(MAP.get(CREATEORG), (Object)rootOrgId, selectRow);
            this.getModel().setValue(NUMBER, (Object)number, selectRow);
            this.getModel().beginInit();
            this.getModel().setValue(CREATEORG, (Object)rootOrgId, selectRow);
            this.getModel().endInit();
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRow);
            this.getModel().createNewEntryRow(RULEENTITY);
            this.getModel().createNewEntryRow(ORGENTITY);
            this.getView().updateView(CREATEORG);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANDEL)) {
            this.getView().invokeOperation(REFRESH);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)SAVE) && (result = afterDoOperationEventArgs.getOperationResult()).isSuccess()) {
            this.getModel().setDataChanged(false);
            this.save();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof Label && "labelcreate".equals(((Label)source).getKey())) {
            Button button = (Button)this.getControl("button_addplan");
            button.click();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (MAP.containsKey(key)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            int selectRow = this.getSelectRows();
            if (selectRow >= 0) {
                if (newValue instanceof LocaleDynamicObjectCollection) {
                    this.getModel().setValue(MAP.get(key), (Object)this.getLangValue(newValue), selectRow);
                } else {
                    this.getModel().setValue(MAP.get(key), newValue, selectRow);
                }
            }
        }
        if (CREATEORG.equalsIgnoreCase(key)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            String newid = newValue == null ? "0" : newValue.getString("id");
            String oldid = oldValue == null ? "0" : oldValue.getString("id");
            this.getPageCache().put("user_change_name", key);
            this.getPageCache().put("user_change_" + key + "_old", oldid);
            this.getPageCache().put("user_change_" + key + "_new", newid);
            this.showConfirmTips("change_base_info", ResManager.loadKDString((String)"\u4fee\u6539\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u5c06\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u53ca\u5171\u4eab\u7ec4\u7ec7\uff0c\u60a8\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"SharingPlanPlugin_21", (String)systemType, (Object[])new Object[0]));
        }
    }

    private void showConfirmTips(String key, String msg) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SharingPlanPlugin_22", (String)systemType, (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"SharingPlanPlugin_23", (String)systemType, (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps, "");
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String fieldKey = event.getCallBackId();
        super.confirmCallBack(event);
        if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ITEM_CLOSE)) {
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                this.getView().close();
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)"change_base_info")) {
            String name = this.getPageCache().get("user_change_name");
            if (CREATEORG.equals(name)) {
                String oldv = this.getPageCache().get("user_change_" + name + "_old");
                String newv = this.getPageCache().get("user_change_" + name + "_new");
                IDataModel model = this.getModel();
                if (event.getResult() == MessageBoxResult.Yes) {
                    model.beginInit();
                    this.getModel().deleteEntryData(RULEENTITY);
                    this.getModel().deleteEntryData(ORGENTITY);
                    this.getModel().deleteEntryData(PROJECTENTITY);
                    model.endInit();
                    this.getView().setEnable(Boolean.TRUE, new String[]{"ruleadd"});
                } else if (event.getResult() == MessageBoxResult.Cancel) {
                    model.beginInit();
                    model.setValue(name, (Object)Long.parseLong(oldv));
                    int selectRow = this.getSelectRows();
                    if (selectRow >= 0) {
                        this.getModel().setValue(MAP.get(name), (Object)Long.parseLong(oldv), selectRow);
                    }
                    model.endInit();
                    this.getView().updateView(name);
                    this.getView().updateView(MAP.get(name), selectRow);
                }
            }
            this.getPageCache().remove("user_change_name");
            this.getPageCache().remove("user_change_" + name + "_old");
            this.getPageCache().remove("user_change_" + name + "_new");
            this.getView().updateView(RULEENTITY);
            this.getView().updateView(ORGENTITY);
            this.getView().updateView(PROJECTENTITY);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)CARDSWITCH)) {
            if (MessageBoxResult.Yes.equals((Object)event.getResult())) {
                DynamicObject oldObject;
                String oldRow = this.getPageCache().get(OLDROW);
                DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
                Map planCacheMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PLANENTITY), Map.class);
                Map map = (Map)planCacheMap.get((oldObject = (DynamicObject)collection.get(Integer.parseInt(oldRow))).getString("id"));
                if (null != map) {
                    List planList = (List)map.get(PLANENTITY);
                    List ruleList = (List)map.get(RULEENTITY);
                    List orgList = (List)map.get(ORGENTITY);
                    List projectList = (List)map.get(PROJECTENTITY);
                    oldObject.set(MAP.get(NUMBER), planList.get(0));
                    oldObject.set(MAP.get(NAME), planList.get(1));
                    this.getModel().setEntryCurrentRowIndex(PLANENTITY, Integer.parseInt(oldRow));
                    this.getModel().deleteEntryData(RULEENTITY);
                    ruleList.stream().forEach(o -> {
                        if (o != null) {
                            int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                            this.getModel().setValue(RULE, (Object)Long.valueOf(o), subRowIndex);
                        }
                    });
                    this.getModel().deleteEntryData(ORGENTITY);
                    orgList.stream().forEach(o -> {
                        if (o != null) {
                            int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                            this.getModel().setValue(ORG, (Object)Long.valueOf(o), subRowIndex);
                        }
                    });
                    this.getModel().deleteEntryData(PROJECTENTITY);
                    projectList.stream().forEach(o -> {
                        if (o != null) {
                            int subRowIndex = this.getModel().createNewEntryRow(PROJECTENTITY);
                            this.getModel().setValue(PROJECT, (Object)Long.valueOf(o), subRowIndex);
                        }
                    });
                    this.getView().updateView(PLANENTITY);
                } else {
                    this.getModel().deleteEntryRow(PLANENTITY, Integer.parseInt(oldRow));
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get(NEWROW)));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get(OLDROW)));
            }
        }
    }

    private List<String> filterDataSet(String searchText) {
        ArrayList<String> list = new ArrayList<String>();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet nameDataSet = dataSet.filter(nameQ.toString());
        DataSet numberDataSet = dataSet.filter(numberQ.toString());
        if (!nameDataSet.isEmpty()) {
            nameDataSet.forEach(o -> list.add(o.getString(NAME)));
        }
        if (!numberDataSet.isEmpty()) {
            numberDataSet.forEach(o -> list.add(o.getString(NUMBER)));
        }
        nameDataSet.close();
        numberDataSet.close();
        return list;
    }

    private DataSet buildDataSet() {
        DataType[] dataTypes = new DataType[]{DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.StringType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        int entryRowCount = this.getModel().getEntryRowCount(PLANENTITY);
        for (int i = 0; i < entryRowCount; ++i) {
            Object[] value = new Object[fieldNames.length];
            DynamicObject planEntry = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(i);
            value[0] = i;
            value[1] = planEntry.getString(MAP.get(NUMBER));
            value[2] = planEntry.getString(MAP.get(NAME));
            value[3] = planEntry.getDynamicObject(MAP.get(CREATEORG)) != null ? planEntry.getDynamicObject(MAP.get(CREATEORG)).getString(NAME) : "";
            coll.add(value);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet dataSet = Algo.create((String)TCEPT_PROJ_SHARPLAN).createDataSet(new Input[]{inputs});
        return dataSet;
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            this.getModel().setValue(NUMBER, planentities[0].get(MAP.get(NUMBER)));
            this.getModel().setValue(NAME, planentities[0].get(MAP.get(NAME)));
            this.getModel().beginInit();
            this.getModel().setValue(CREATEORG, planentities[0].get(MAP.get(CREATEORG)));
            this.getModel().endInit();
            if (planentities[0].getLong("id") == 0L) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{CREATEORG});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{CREATEORG});
            }
        } else {
            this.getModel().setValue(NUMBER, (Object)"");
            this.getModel().setValue(NAME, (Object)"");
        }
        this.getView().updateView(NUMBER);
        this.getView().updateView(NAME);
        this.getModel().beginInit();
        this.getView().updateView(CREATEORG);
        this.getModel().endInit();
    }

    private void loadFormData() {
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
        Set orgids = col.stream().map(a -> a.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] planRows = BusinessDataServiceHelper.load((String)TCEPT_PROJ_SHARPLAN, (String)"id,number,name,creator,createtime,ruleentity.rule,ruleentity.ruletype,ruleentity.id,orgentity.org,orgentity.id,projectentity.id,projectentity.project,createorg", (QFilter[])new QFilter[]{new QFilter(CREATEORG, "in", orgids)}, (String)"number asc");
        if (planRows.length > 0) {
            this.getModel().deleteEntryData(PLANENTITY);
            Arrays.stream(planRows).forEach(planRow -> {
                int rowIndex = this.getModel().createNewEntryRow(PLANENTITY);
                this.getModel().setValue("id", planRow.get("id"), rowIndex);
                this.getModel().setValue(MAP.get(NUMBER), planRow.get(NUMBER), rowIndex);
                this.getModel().setValue(MAP.get(NAME), planRow.get(NAME), rowIndex);
                this.getModel().setValue("creator", planRow.get("creator"), rowIndex);
                this.getModel().setValue("createtime", planRow.get("createtime"), rowIndex);
                this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), rowIndex);
                this.getModel().setValue("modifytime", (Object)new Date(), rowIndex);
                this.getModel().setValue(MAP.get(CREATEORG), (Object)planRow.getDynamicObject(CREATEORG), rowIndex);
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, rowIndex);
                DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
                ruleCol.stream().forEach(ruleRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                    this.getModel().setValue(RULE, ruleRow.get(RULE), subRowIndex);
                    this.getModel().setValue("ruletype", ruleRow.get("ruletype"), subRowIndex);
                    this.getModel().setValue("ruleentryid", ruleRow.get("id"), subRowIndex);
                });
                DynamicObjectCollection projectCol = planRow.getDynamicObjectCollection(PROJECTENTITY);
                projectCol.stream().forEach(projectRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(PROJECTENTITY);
                    this.getModel().setValue(PROJECT, projectRow.get(PROJECT), subRowIndex);
                    this.getModel().setValue("projectentryid", projectRow.get("id"), subRowIndex);
                });
                DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
                orgCol.stream().forEach(orgRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                    this.getModel().setValue(ORG, orgRow.get(ORG), subRowIndex);
                    this.getModel().setValue("orgentryid", orgRow.get("id"), subRowIndex);
                });
            });
            this.getView().updateView(RULEENTITY);
            this.getView().updateView(PROJECTENTITY);
            this.getView().updateView(ORGENTITY);
        }
        this.getPageCache().put(PLANENTITY, SerializationUtils.toJsonString(this.getPlanCacheMap(planRows)));
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    private Long getCurPlanId() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return null;
        }
        DynamicObject row = (DynamicObject)collection.get(this.getSelectRows());
        Long planId = row.getLong("id");
        return planId;
    }

    private void save() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return;
        }
        ArrayList<DynamicObject> forSaveObjArr = new ArrayList<DynamicObject>(10);
        DynamicObject row = (DynamicObject)collection.get(this.getSelectRows());
        Long planId = row.getLong("id");
        DynamicObject planObject = BusinessDataServiceHelper.newDynamicObject((String)TCEPT_PROJ_SHARPLAN);
        if (!ObjectUtils.isEmpty((Object)planId) && planId > 0L) {
            planObject = BusinessDataServiceHelper.loadSingle((Object)planId, (String)TCEPT_PROJ_SHARPLAN);
        } else {
            planObject.set("creator", row.get("creator"));
            planObject.set("createtime", row.get("createtime"));
        }
        planObject.set(NUMBER, row.get(MAP.get(NUMBER)));
        this.getPageCache().put("saveNomber", row.get(MAP.get(NUMBER)).toString());
        planObject.set(NAME, row.get(MAP.get(NAME)));
        planObject.set("modifier", row.get("modifier"));
        planObject.set("modifytime", row.get("modifytime"));
        planObject.set("status", (Object)"C");
        planObject.set("enable", (Object)1);
        planObject.set(CREATEORG, row.get(MAP.get(CREATEORG)));
        DynamicObjectCollection ruleCol = row.getDynamicObjectCollection(RULEENTITY);
        DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection(RULEENTITY);
        ruleCollection.clear();
        Stream.iterate(0, i -> i + 1).limit(ruleCol.size()).forEach(index -> {
            DynamicObject rule = (DynamicObject)ruleCol.get(index.intValue());
            if (rule.get(RULE) != null) {
                DynamicObject ruleRow = ruleCollection.addNew();
                ruleRow.set("seq", index);
                ruleRow.set("ruletype", (Object)"xm");
                ruleRow.set("id", rule.get("ruleentryid"));
                ruleRow.set(RULE, ((DynamicObject)rule.get(RULE)).get("id"));
            }
        });
        DynamicObjectCollection orgCol = row.getDynamicObjectCollection(ORGENTITY);
        DynamicObjectCollection orgCollection = planObject.getDynamicObjectCollection(ORGENTITY);
        orgCollection.clear();
        Stream.iterate(0, i -> i + 1).limit(orgCol.size()).forEach(index -> {
            DynamicObject org = (DynamicObject)orgCol.get(index.intValue());
            if (org.get(ORG) != null) {
                DynamicObject orgRow = orgCollection.addNew();
                orgRow.set("seq", index);
                orgRow.set("id", org.get("orgentryid"));
                orgRow.set(ORG, ((DynamicObject)org.get(ORG)).get("id"));
            }
        });
        DynamicObjectCollection prjCol = row.getDynamicObjectCollection(PROJECTENTITY);
        DynamicObjectCollection prjCollection = planObject.getDynamicObjectCollection(PROJECTENTITY);
        prjCollection.clear();
        Stream.iterate(0, i -> i + 1).limit(prjCol.size()).forEach(index -> {
            DynamicObject prj = (DynamicObject)prjCol.get(index.intValue());
            if (prj.get(PROJECT) != null) {
                DynamicObject prjRow = prjCollection.addNew();
                prjRow.set("seq", index);
                prjRow.set("id", prj.get("projectentryid"));
                prjRow.set(PROJECT, ((DynamicObject)prj.get(PROJECT)).get("id"));
            }
        });
        forSaveObjArr.add(planObject);
        OperationResult result = null;
        try (TXHandle h = TX.requiresNew();){
            try {
                result = OperationServiceHelper.executeOperate((String)SAVE, (String)TCEPT_PROJ_SHARPLAN, (DynamicObject[])forSaveObjArr.toArray(new DynamicObject[forSaveObjArr.size()]), (OperateOption)OperateOption.create());
            }
            catch (Throwable e1) {
                LOGGER.error(e1);
                h.markRollback();
                throw e1;
            }
        }
        if (result != null) {
            if (result.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"SharingPlanPlugin_8", (String)systemType, (Object[])new Object[0]), Integer.valueOf(3000));
                this.getView().invokeOperation(REFRESH);
            } else {
                List errors = result.getAllErrorInfo();
                List vas = result.getValidateResult().getValidateErrors();
                StringBuilder error = new StringBuilder(result.getMessage());
                for (OperateErrorInfo opError : errors) {
                    error.append(opError.getMessage());
                }
                for (ValidateResult va : vas) {
                    for (OperateErrorInfo operr : va.getAllErrorInfo()) {
                        error.append(operr.getMessage());
                    }
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s", (String)"SharingPlanPlugin_9", (String)systemType, (Object[])new Object[0]), error));
            }
        }
    }

    private void selectListRow(int rowIndex) {
        CardEntry planCardEntry = (CardEntry)this.getControl(PLANENTITY);
        int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        int nowRow = this.getSelectRows();
        planCardEntry.selectCard(Integer.valueOf(rowIndex));
        planCardEntry.selectRowsChanged(Collections.singletonList(rowIndex), Collections.singletonList(nowRow));
    }

    private int getSelectRows() {
        int rowIndex = 0;
        EntryGrid planEntry = (EntryGrid)this.getControl(PLANENTITY);
        int[] ids = planEntry.getSelectRows();
        if (!ObjectUtils.isEmpty((Object)ids)) {
            rowIndex = ids[0];
        }
        return rowIndex;
    }

    private String getLangValue(Object object) {
        String value = null;
        String lang = RequestContext.get().getLang().toString();
        if (object instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection valueCol = (LocaleDynamicObjectCollection)object;
            for (DynamicObject langObj : valueCol) {
                String localeid = langObj.getString("localeid");
                String version = langObj.getString(NAME);
                if (lang == null || !lang.equals(localeid)) continue;
                value = version;
                break;
            }
        }
        return value;
    }

    private String getCodeRuleNumber(Object createorg) {
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)TCEPT_PROJ_SHARPLAN);
        dataInfo.set(CREATEORG, createorg);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String number = codeRuleService.readNumber(TCEPT_PROJ_SHARPLAN, dataInfo, null);
        return number;
    }

    private boolean checkChangeData(int row) {
        DynamicObject planRow;
        boolean change = false;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return change;
        }
        Map planCacheMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PLANENTITY), Map.class);
        Map map = (Map)planCacheMap.get((planRow = (DynamicObject)collection.get(row)).getString("id"));
        if (null == map) {
            change = true;
        } else {
            List<String> planList = Arrays.asList(planRow.getString(MAP.get(NUMBER)), planRow.getString(MAP.get(NAME)), planRow.getString("carcreateorg.id"));
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            List planCacheList = (List)map.get(PLANENTITY);
            List ruleCacheList = (List)map.get(RULEENTITY);
            List orgCacheList = (List)map.get(ORGENTITY);
            if (!(CollectionUtils.isEqualCollection(planList, (Collection)planCacheList) && CollectionUtils.isEqualCollection(ruleList, (Collection)ruleCacheList) && CollectionUtils.isEqualCollection(orgList, (Collection)orgCacheList))) {
                change = true;
            }
        }
        return change;
    }

    private Map<String, Map<String, List<String>>> getPlanCacheMap(DynamicObject[] rows) {
        HashMap<String, Map<String, List<String>>> planCacheMap = new HashMap<String, Map<String, List<String>>>();
        Arrays.stream(rows).forEach(planRow -> {
            HashMap<String, List<String>> planEntityMap = new HashMap<String, List<String>>();
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            ArrayList projectList = new ArrayList();
            DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
            orgCol.stream().forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            DynamicObjectCollection projectCol = planRow.getDynamicObjectCollection(PROJECTENTITY);
            projectCol.stream().forEach(orgRow -> projectList.add(orgRow.getString("project.id")));
            planEntityMap.put(PLANENTITY, Arrays.asList(planRow.getString(NUMBER), planRow.getString(NAME), planRow.getString("createorg.id")));
            planEntityMap.put(RULEENTITY, ruleList);
            planEntityMap.put(ORGENTITY, orgList);
            planEntityMap.put(PROJECTENTITY, projectList);
            planCacheMap.put(planRow.getString("id"), planEntityMap);
        });
        return planCacheMap;
    }

    private void checkPermission() {
    }

    private void selectListRowAndPutCache() {
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("cardIndexs"), Map.class);
        if (!map.isEmpty()) {
            Integer focusCardIndex = Integer.valueOf(this.getPageCache().get("focusCardIndex"));
            if (map.size() - 1 > focusCardIndex) {
                String nextFocusCardIndex = String.valueOf(focusCardIndex + 1);
                this.selectListRow((Integer)map.get(nextFocusCardIndex));
                this.getPageCache().put("focusCardIndex", nextFocusCardIndex);
            } else if (map.size() - 1 == focusCardIndex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5230\u6700\u540e\u4e00\u884c\u3002", (String)"SharingPlanPlugin_10", (String)systemType, (Object[])new Object[0]));
            }
        }
    }

    static {
        fieldNames = new String[]{INDEX, NUMBER, NAME, CREATEORG};
        MAP = new HashMap<String, String>();
        MAP.put(NAME, "carname");
        MAP.put(NUMBER, "carnumber");
        MAP.put(CREATEORG, "carcreateorg");
    }
}

