/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.common.utils.OrgControlUtil;

public class AbstractDraftBillEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String SCHEME = "scheme";
    public static final String VERSION = "version";

    public void setVersionComboItemsList(DynamicObject object) {
        ComboEdit control = (ComboEdit)this.getControl(VERSION);
        control.setComboItems(this.getVersionComboItemsList(object));
    }

    public List<ComboItem> getVersionComboItemsList(DynamicObject object) {
        if (object != null) {
            return object.getDynamicObjectCollection("entryentity").stream().map(s -> new ComboItem(new LocaleString(s.getString("versionname")), s.getString("versioncode"))).collect(Collectors.toList());
        }
        return new ArrayList<ComboItem>();
    }

    public List<ComboItem> getVersionComboItemsList(Long schemePk) {
        if (schemePk != null) {
            DynamicObject dynamicObject = SchemaDataService.querySchemeSingle(schemePk);
            return dynamicObject.getDynamicObjectCollection("entryentity").stream().map(s -> new ComboItem(new LocaleString(s.getString("versionname")), s.getString("versioncode"))).collect(Collectors.toList());
        }
        return new ArrayList<ComboItem>();
    }

    public void itemClick(ItemClickEvent evt) {
        this.setBaseFieldEnable();
    }

    public void setBaseFieldEnable() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "houseproject", SCHEME, VERSION});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit houseproject = (BasedataEdit)this.getView().getControl("houseproject");
        houseproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getView().getControl(SCHEME);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public Long getOrgid() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        return org == null ? null : Long.valueOf(org.getLong("id"));
    }

    public Long getProjectId() {
        DynamicObject houseproject = (DynamicObject)this.getModel().getValue("houseproject");
        return houseproject == null ? null : Long.valueOf(houseproject.getLong("id"));
    }

    public String getVersion() {
        return (String)this.getModel().getValue(VERSION);
    }

    public Long getSchemeId() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        return scheme == null ? null : Long.valueOf(scheme.getLong("id"));
    }

    public int getClearPeriod() {
        Object clearperiod = this.getModel().getValue("clearperiod");
        return clearperiod == null ? 1 : (Integer)clearperiod;
    }

    public String getSwytfl() {
        Object swqsytfl = this.getModel().getValue("swqsytfl");
        return swqsytfl == null ? "1" : (String)swqsytfl;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("org".equals(name) || "houseproject".equals(name) || SCHEME.equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
            IDataModel model = this.getModel();
            model.beginInit();
            if ("org".equals(name)) {
                if (newValue == null) {
                    model.setValue("houseproject", null);
                    model.setValue(SCHEME, null);
                    model.setValue(VERSION, null);
                } else {
                    Long houseproject = TaxProjectDataService.queryFirstProjectByOrg(this.getOrgid());
                    Long scheme = SchemaDataService.queryLastScheme(this.getOrgid(), houseproject);
                    List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
                    String version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                    model.setValue("houseproject", (Object)houseproject);
                    model.setValue(SCHEME, (Object)scheme);
                    model.setValue(VERSION, (Object)version);
                }
            } else if ("houseproject".equals(name)) {
                if (newValue == null) {
                    model.setValue(SCHEME, null);
                    model.setValue(VERSION, null);
                } else {
                    Long scheme = SchemaDataService.queryLastScheme(this.getOrgid(), this.getProjectId());
                    List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
                    String version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                    model.setValue(SCHEME, (Object)scheme);
                    model.setValue(VERSION, (Object)version);
                }
                String swqsytfl = TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId());
                this.getModel().setValue("swqsytfl", (Object)swqsytfl);
            } else if (SCHEME.equals(name)) {
                if (newValue == null) {
                    model.setValue(VERSION, null);
                } else {
                    List<ComboItem> comboItems = this.getVersionComboItemsList(this.getSchemeId());
                    String version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                    model.setValue(VERSION, (Object)version);
                }
                int clearperiod = SchemaDataService.querySchemeClearperiod(this.getSchemeId());
                this.getModel().setValue("clearperiod", (Object)clearperiod);
            }
            model.endInit();
            this.setVersionComboItemsList(this.getSchemeId());
            this.getView().updateView("fs_baseinfo");
        }
    }

    public void setVersionComboItemsList(Long schemePk) {
        ComboEdit control = (ComboEdit)this.getControl(VERSION);
        control.setComboItems(this.getVersionComboItemsList(schemePk));
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.startsWith("houseproject")) {
            if (this.getOrgid() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AbstractDraftBillEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            QFilter qFilter3 = new QFilter("taxorg", "=", (Object)this.getOrgid());
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", (Object)"001"));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)"001"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("focusNodeId", (Object)"1888314377338207232");
        }
        if (name.startsWith(SCHEME)) {
            if (this.getOrgid() == null || this.getProjectId() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u548c\u623f\u5730\u4ea7\u9879\u76ee\u3002", (String)"AbstractDraftBillEditPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            QFilter qFilter2 = new QFilter("org", "=", (Object)this.getOrgid());
            QFilter qFilter3 = new QFilter("project", "=", (Object)this.getProjectId());
            beforeF7SelectEvent.getCustomQFilters().add(qFilter2);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
        }
        if (name.startsWith("org")) {
            List<Long> permOrgs = OrgControlUtil.getPermOrgs(this.getView());
            QFilter qFilter2 = new QFilter("id", "in", permOrgs);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter2);
        }
    }
}

