/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tcept.business.draft.CommonGetModelService;
import kd.taxc.tcept.business.draft.IncomeDraftService;

public class CommonBillFormPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
CommonGetModelService {
    public static final String ORG = "org";
    public static final String PROJECT = "project";
    public static final String SCHEME = "scheme";
    public static final String VERSION = "version";
    private IncomeDraftService incomeDraftService = new IncomeDraftService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit project = (BasedataEdit)this.getControl(PROJECT);
        project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getControl(SCHEME);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBaseFieldEnable();
    }

    public void itemClick(ItemClickEvent evt) {
        this.setBaseFieldEnable();
    }

    public void setBaseFieldEnable() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{ORG, PROJECT, SCHEME, VERSION});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue()) {
            this.getModel().setValue(ORG, (Object)Long.parseLong((String)customParams.get(ORG)));
            this.getModel().setValue(PROJECT, (Object)Long.parseLong((String)customParams.get(PROJECT)));
            this.getModel().setValue(SCHEME, (Object)Long.parseLong((String)customParams.get(SCHEME)));
            this.getModel().setValue(VERSION, customParams.get(VERSION));
            String clearperiod = this.getModelObjStringWithDefault(SCHEME, "clearperiod", "0");
            String swqsytfl = this.getModelObjString(PROJECT, "swqsytfl");
            this.getModel().setValue("maxclearperiod", (Object)Integer.parseInt(clearperiod));
            this.getModel().setValue("swqsytfl", (Object)swqsytfl);
        } else {
            String isChangingMainOrg = (String)this.getModel().getContextVariable("isChangingMainOrg");
            if (!"true".equals(isChangingMainOrg)) {
                DynamicObject defaultorg = (DynamicObject)this.getModel().getValue(ORG);
                Long org = defaultorg != null ? defaultorg.getLong("id") : RequestContext.get().getOrgId();
                DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
                List istaxpayers = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(col.stream().map(s -> s.getLong("id")).collect(Collectors.toList())).getData();
                col = col.stream().filter(s -> istaxpayers.contains(s.getLong("id"))).collect(Collectors.toCollection(DynamicObjectCollection::new));
                Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
                if (orgid != null) {
                    this.getModel().setValue(ORG, (Object)orgid);
                }
            }
            Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
            Long defaultProjectId = this.incomeDraftService.getDefaultProject(orgId);
            this.getModel().setValue(PROJECT, (Object)defaultProjectId);
            this.getModel().setValue(SCHEME, (Object)this.incomeDraftService.getDefaultScheme(orgId, defaultProjectId));
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
            List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
            this.getModel().setValue(VERSION, comboItems.isEmpty() ? null : comboItems.get(0).getValue());
            String clearperiod = this.getModelObjStringWithDefault(SCHEME, "clearperiod", "0");
            String swqsytfl = this.getModelObjString(PROJECT, "swqsytfl");
            this.getModel().setValue("maxclearperiod", (Object)Integer.parseInt(clearperiod));
            this.getModel().setValue("swqsytfl", (Object)swqsytfl);
        }
    }

    @Override
    public Long getModelObjLongId(String prop) {
        return Optional.ofNullable((DynamicObject)this.getModel().getValue(prop)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
    }

    @Override
    public String getModelObjString(String prop, String name) {
        return Optional.ofNullable((DynamicObject)this.getModel().getValue(prop)).map(s -> s.getString(name)).orElseGet(() -> "");
    }

    @Override
    public String getModelObjStringWithDefault(String prop, String name, String defaultVal) {
        return Optional.ofNullable((DynamicObject)this.getModel().getValue(prop)).map(s -> s.getString(name)).orElseGet(() -> defaultVal);
    }

    @Override
    public String getModelString(String prop) {
        return Optional.ofNullable((String)this.getModel().getValue(prop)).orElseGet(() -> "");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject org;
        if (PROJECT.equals(evt.getProperty().getName())) {
            org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"CommonBillFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                return;
            }
            long orgid = org.getLong("id");
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter q1 = new QFilter("taxorg", "=", (Object)orgid);
            QFilter q2 = new QFilter("status", "=", (Object)"C");
            QFilter q3 = new QFilter("group.number", "=", (Object)"001");
            QFilter q4 = new QFilter("enable", "=", (Object)"1");
            listShowParameter.getListFilterParameter().setFilter(q1);
            listShowParameter.getListFilterParameter().setFilter(q2);
            listShowParameter.getListFilterParameter().setFilter(q3);
            listShowParameter.getListFilterParameter().setFilter(q4);
            List qFilters = listShowParameter.getTreeFilterParameter().getQFilters();
            qFilters.add(new QFilter("number", "in", (Object)"001"));
        }
        if (SCHEME.equals(evt.getProperty().getName())) {
            org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"CommonBillFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
            if (project == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u623f\u5730\u4ea7\u9879\u76ee\u3002", (String)"CommonBillFormPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long orgid = org.getLong("id");
            long projectId = project.getLong("id");
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter q1 = new QFilter(ORG, "in", (Object)orgid);
            QFilter q2 = new QFilter(PROJECT, "in", (Object)projectId);
            listShowParameter.getListFilterParameter().setFilter(q1);
            listShowParameter.getListFilterParameter().setFilter(q2);
        }
    }

    public List<ComboItem> getVersionComboItemsList(DynamicObject object) {
        return Optional.ofNullable(object).map(s -> s.getDynamicObjectCollection("entryentity").stream().map(a -> new ComboItem(new LocaleString(a.getString("versionname")), a.getString("versioncode"))).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
    }

    public void setVersionComboItemsList(DynamicObject object) {
        ComboEdit control = (ComboEdit)this.getControl(VERSION);
        control.setComboItems(this.getVersionComboItemsList(object));
    }
}

