/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.tcept.business.basedata.CostReportDataService;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.business.draft.CostAdjustDraftService;
import kd.taxc.tcept.formplugin.draft.AbstractDraftBillEditPlugin;

public class CostAdjustDraftBillEditPlugin
extends AbstractDraftBillEditPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit base = (BasedataEdit)this.getView().getControl("costitem1");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!"true".equals(this.getModel().getContextVariable("isChangingMainOrg"))) {
            Long orgid = null;
            Long project = null;
            Long scheme = null;
            String version = null;
            if (customParams.get("org") != null && customParams.get("project") != null) {
                orgid = Long.parseLong((String)customParams.get("org"));
                project = Long.parseLong((String)customParams.get("project"));
                scheme = Long.parseLong((String)customParams.get("scheme"));
                version = (String)customParams.get("version");
            } else {
                DynamicObject defaultorg = (DynamicObject)this.getModel().getValue("org");
                Long org = defaultorg != null ? defaultorg.getLong("id") : RequestContext.get().getOrgId();
                DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
                orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
                if (orgid != null) {
                    Boolean approve = (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgid).getData();
                    if (!approve.booleanValue()) {
                        this.getModel().setValue("org", null);
                        return;
                    }
                    project = TaxProjectDataService.queryFirstProjectByOrg(orgid);
                    scheme = SchemaDataService.queryLastScheme(orgid, project);
                    List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
                    version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                } else {
                    return;
                }
            }
            this.getModel().setValue("org", (Object)orgid);
            this.getModel().setValue("houseproject", (Object)project);
            this.getModel().setValue("scheme", (Object)scheme);
            this.getModel().setValue("swqsytfl", (Object)TaxProjectDataService.queryProjectSwqsytfl(project));
            this.getModel().setValue("clearperiod", (Object)SchemaDataService.querySchemeClearperiod(scheme));
            this.getModel().setValue("version", (Object)version);
            if (project != null && project != 0L && scheme != null && scheme != 0L) {
                this.calc(orgid, project, scheme, this.getVersion(), new ArrayList<Map<String, Object>>());
            }
        } else {
            this.getModel().setValue("houseproject", null);
            this.getModel().setValue("scheme", null);
            this.getModel().setValue("version", null);
        }
        this.setVersionComboItemsList((DynamicObject)this.getModel().getValue("scheme"));
    }

    public void afterBindData(EventObject e) {
        this.setVersionComboItemsList((DynamicObject)this.getModel().getValue("scheme"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "houseproject", "scheme", "version"});
        }
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("scheme", null);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        entryentity.clear();
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ArrayList amoutAdj = Lists.newArrayList((Object[])new String[]{"sgtzzhsje1", "sgtzzbhsje1", "costitem1"});
        ArrayList baseField = Lists.newArrayList((Object[])new String[]{"org", "houseproject", "scheme", "billno", "version"});
        if (amoutAdj.contains(name) || baseField.contains(name)) {
            if (baseField.contains(name)) {
                this.getModel().deleteEntryData("entryentity");
                this.getModel().deleteEntryData("entryentity1");
                this.getModel().deleteEntryData("entryentity2");
                this.getView().updateView("entryentity");
                this.getView().updateView("entryentity1");
                this.getView().updateView("entryentity2");
            }
            if (this.getOrgid() != null && this.getProjectId() != null && this.getSchemeId() != null) {
                List<Map<String, Object>> cbsgtz = this.getCbsgTzEntryData();
                if (amoutAdj.contains(name)) {
                    List<Map<String, Object>> stxstz = this.getStxsTzEntryData();
                    List<Map<String, Object>> cbhjlist = CostAdjustDraftService.calcCbHj(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion(), stxstz, cbsgtz);
                    this.setCbhjEntryData(cbhjlist);
                    this.getView().updateView("entryentity2");
                }
                if (baseField.contains(name)) {
                    this.calc(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion(), cbsgtz);
                }
            }
        }
    }

    private void calc(Long orgid, Long projectId, Long schemeId, String version, List<Map<String, Object>> cbsgtz) {
        Map<String, List> result = CostAdjustDraftService.callBillAll(orgid, projectId, schemeId, version, cbsgtz);
        List stxstzlist = result.get("stxstz");
        List cbhjlist = result.get("cbhj");
        this.setValueInModel(stxstzlist, cbhjlist);
        this.getView().updateView("entryentity");
        this.getView().updateView("entryentity2");
    }

    private void setValueInModel(List<Map<String, Object>> stxstzlist, List<Map<String, Object>> cbhjlist) {
        this.setStxsTzEntryData(stxstzlist);
        this.setCbhjEntryData(cbhjlist);
    }

    private List<Map<String, Object>> getCbsgTzEntryData() {
        DynamicObjectCollection cbsgEntity = this.getModel().getEntryEntity("entryentity1");
        List<Map<String, Object>> cbsgTzEntryData = CostAdjustDraftService.getCbsgTzEntryData(cbsgEntity);
        return cbsgTzEntryData;
    }

    private List<Map<String, Object>> getStxsTzEntryData() {
        DynamicObjectCollection stxsEntry = this.getModel().getEntryEntity("entryentity");
        List<Map<String, Object>> stxsTzEntryData = CostAdjustDraftService.getStxsTzEntryData(stxsEntry);
        return stxsTzEntryData;
    }

    private void setStxsTzEntryData(List<Map<String, Object>> stxstz) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        if (stxstz.size() > 0) {
            model.batchCreateNewEntryRow("entryentity", stxstz.size());
            for (int i = 0; i < stxstz.size(); ++i) {
                Map<String, Object> map = stxstz.get(i);
                int finalI = i;
                CostAdjustDraftService.getCostAdjustDraftExtServices().forEach(a -> a.setStxsTzFieldDataToModel(model, map, finalI));
                model.setValue("costadtype", map.get("costadtype"), i);
                model.setValue("clearterm", map.get("clearterm"), i);
                model.setValue("costitem", map.get("costitem"), i);
                model.setValue("sgtzzhsje", map.get("sgtzzhsje"), i);
                model.setValue("sgtzzbhsje", map.get("sgtzzbhsje"), i);
            }
        }
        model.endInit();
    }

    private void setCbhjEntryData(List<Map<String, Object>> cbhj) {
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity2");
        if (cbhj.size() > 0) {
            model.batchCreateNewEntryRow("entryentity2", cbhj.size());
            for (int i = 0; i < cbhj.size(); ++i) {
                Map<String, Object> map = cbhj.get(i);
                model.setValue("costitemname", map.get("costitemname"), i);
                model.setValue("costitem2", map.get("costitem2"), i);
                model.setValue("tzqhsje", map.get("tzqhsje"), i);
                model.setValue("tzqbhsje", map.get("tzqbhsje"), i);
                model.setValue("sgtzzhsje3", map.get("sgtzzhsje3"), i);
                model.setValue("sgtzzbhsje4", map.get("sgtzzbhsje4"), i);
                model.setValue("tzhhsje", map.get("tzhhsje"), i);
                model.setValue("tzhbhsje", map.get("tzhbhsje"), i);
                if (0L != (Long)map.get("costitem2")) continue;
                model.setValue("befortaxamount", map.get("tzqhsje"));
                model.setValue("adjamount", map.get("sgtzzhsje3"));
                model.setValue("aftertaxamount", map.get("tzhhsje"));
            }
        }
        model.endInit();
    }

    private boolean checkCalcCondition() {
        boolean changedCostItem;
        if (this.getOrgid() == null || this.getProjectId() == null || this.getSchemeId() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u672c\u4fe1\u606f\u3002", (String)"CostAdjustDraftBillEditPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        if (!"A".equals(this.getModel().getValue("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u8fdb\u884c\u201c\u91cd\u65b0\u53d6\u6570\u201d\u3002", (String)"CostAdjustDraftBillEditPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection entryentity2 = this.getModel().getEntryEntity("entryentity2");
        Long id = (Long)this.getModel().getValue("id");
        boolean bl = changedCostItem = id != null && id != 0L ? CostAdjustDraftService.isChangedCostItem(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion(), entryentity2) : false;
        if (changedCostItem) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u62a5\u8868\u4e2d\u7684\u6210\u672c\u9879\u76ee\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u7f6e\u5e95\u7a3f\u3002", (String)"CostAdjustDraftBillEditPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "recalc".equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey()) && !this.checkCalcCondition()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("recalc".equals(operateKey)) {
            this.calc(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion(), this.getCbsgTzEntryData());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"CostAdjustDraftBillEditPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]));
        } else if ("reset".equals(operateKey)) {
            this.getModel().setValue("swqsytfl", (Object)TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId()));
            this.getModel().setValue("clearperiod", (Object)SchemaDataService.querySchemeClearperiod(this.getSchemeId()));
            this.getModel().deleteEntryData("entryentity1");
            this.calc(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion(), this.getCbsgTzEntryData());
            this.getView().updateView("entryentity1");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u6210\u529f\u3002", (String)"CostAdjustDraftBillEditPlugin_5", (String)"taxc-tcept", (Object[])new Object[0]));
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if ("costitem1".equals(name)) {
            Set<Object> ids = CostReportDataService.getLastLevelCostItemIdsByUniq(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
            Set<String> numbers = CostReportDataService.queryCostItemsUpLevelNumbers(ids);
            QFilter qFilter1 = new QFilter("id", "in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter1);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", numbers));
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("org", "=", (Object)this.getOrgid()));
            formShowParameter.setCustomParam("custom_filter", (Object)"1");
        }
    }
}

