/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.tcept.business.draft.CostAdjustDraftService;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class CostAdjustDraftListPlugin
extends AbstractListPlugin {
    private static final String RECALCS = "recalcs";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        ListSelectedRowCollection selectedRows;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (RECALCS.equals(operateKey) && (selectedRows = this.getSelectedRows()).size() > 0) {
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            OperationResult operationResult = CostAdjustDraftService.reCalc((Long)listSelectedRow.getPrimaryKeyValue());
            if (operationResult == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CostAdjustDraftListPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
            } else if (operationResult != null && operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"CostAdjustDraftListPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            DraftCommonUtils.logOperation(operationResult, formShowParameter.getBillFormId(), ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570", (String)"CostAdjustDraftListPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]), listSelectedRow.getBillNo());
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refreshData();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof EntityOperate) {
            EntityOperate operate = (EntityOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (("copy".equals(operateKey) || RECALCS.equals(operateKey)) && (selectedRows.size() > 1 || selectedRows.size() == 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5355\u636e\u3002", (String)"CostAdjustDraftListPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }
}

