/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcept.business.basedata.CostReportDataService;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.business.draft.IncomeDraftService;
import kd.taxc.tcept.formplugin.draft.AbstractDraftBillEditPlugin;

public class IncomeAdjustDraftBillEditPlugin
extends AbstractDraftBillEditPlugin
implements BeforeF7SelectListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit base = (BasedataEdit)this.getView().getControl("costitemtype");
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit selltype = (BasedataEdit)this.getView().getControl("selltype");
        selltype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit selltype1 = (BasedataEdit)this.getView().getControl("selltype1");
        selltype1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit selltype2 = (BasedataEdit)this.getView().getControl("selltype2");
        selltype2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!"true".equals(this.getModel().getContextVariable("isChangingMainOrg"))) {
            Long orgid = null;
            Long project = null;
            Long scheme = null;
            String version = null;
            if (customParams.get("org") != null && customParams.get("project") != null) {
                orgid = Long.parseLong((String)customParams.get("org"));
                project = Long.parseLong((String)customParams.get("project"));
                scheme = Long.parseLong((String)customParams.get("scheme"));
                version = (String)customParams.get("version");
            } else {
                DynamicObject defaultorg = (DynamicObject)this.getModel().getValue("org");
                Long org = defaultorg != null ? defaultorg.getLong("id") : RequestContext.get().getOrgId();
                DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
                orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
                if (orgid != null) {
                    Boolean approve = (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgid).getData();
                    if (!approve.booleanValue()) {
                        this.getModel().setValue("org", null);
                        return;
                    }
                    project = TaxProjectDataService.queryFirstProjectByOrg(orgid);
                    scheme = SchemaDataService.queryLastScheme(orgid, project);
                    List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
                    version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                } else {
                    return;
                }
            }
            this.getModel().setValue("org", (Object)orgid);
            this.getModel().setValue("houseproject", (Object)project);
            this.getModel().setValue("scheme", (Object)scheme);
            this.getModel().setValue("version", (Object)version);
            this.getModel().setValue("swqsytfl", (Object)TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId()));
            this.getModel().setValue("clearperiod", (Object)SchemaDataService.querySchemeClearperiod(this.getSchemeId()));
        } else {
            this.getModel().setValue("houseproject", null);
            this.getModel().setValue("scheme", null);
            this.getModel().setValue("version", null);
        }
        this.setVersionComboItemsList((DynamicObject)this.getModel().getValue("scheme"));
    }

    public void afterCopyData(EventObject e) {
        this.getModel().setValue("scheme", null);
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        for (Object dynamicObject : entryentity) {
            dynamicObject.set("clearterm", (Object)"01");
        }
        DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity1");
        for (DynamicObject dynamicObject : entryentity1) {
            dynamicObject.set("clearterm1", (Object)"01");
        }
        DynamicObjectCollection entryentity2 = this.getModel().getEntryEntity("entryentity2");
        for (DynamicObject dynamicObject : entryentity2) {
            dynamicObject.set("clearterm2", (Object)"01");
        }
    }

    public void afterBindData(EventObject e) {
        this.updateTaxTypeCombo();
        this.updateClearPeriodCombo();
        this.setVersionComboItemsList((DynamicObject)this.getModel().getValue("scheme"));
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "houseproject", "scheme", "version"});
        }
    }

    private void updateClearPeriodCombo() {
        int clearperiod = OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus() ? SchemaDataService.querySchemeClearperiod(this.getSchemeId()) : this.getClearPeriod();
        List<ComboItem> clearterms = SchemaDataService.getItemsByClearPeriod(clearperiod);
        if (EmptyCheckUtils.isNotEmpty(clearterms)) {
            ComboEdit mulComboEdit = (ComboEdit)this.getView().getControl("clearterm");
            mulComboEdit.setComboItems(clearterms);
            ComboEdit mulComboEdit1 = (ComboEdit)this.getView().getControl("clearterm1");
            mulComboEdit1.setComboItems(clearterms);
            ComboEdit mulComboEdit2 = (ComboEdit)this.getView().getControl("clearterm2");
            mulComboEdit2.setComboItems(clearterms);
        }
    }

    private void updateTaxTypeCombo() {
        String swqsytfl = OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus() ? TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId()) : this.getSwytfl();
        List<ComboItem> comboItemsBySwqsytfl = TaxProjectDataService.getComboItemsBySwqsytfl(swqsytfl);
        if (EmptyCheckUtils.isNotEmpty(comboItemsBySwqsytfl)) {
            ComboEdit taxtypeComboEdit = (ComboEdit)this.getView().getControl("taxtype");
            taxtypeComboEdit.setComboItems(comboItemsBySwqsytfl);
            ComboEdit taxtypeComboEdit1 = (ComboEdit)this.getView().getControl("taxtype1");
            taxtypeComboEdit1.setComboItems(comboItemsBySwqsytfl);
            ComboEdit taxtypeComboEdit2 = (ComboEdit)this.getView().getControl("taxtype2");
            taxtypeComboEdit2.setComboItems(comboItemsBySwqsytfl);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.startsWith("selltype")) {
            Set<Object> selltypeIds = IncomeDraftService.queryIncomeBookSelltypeIds(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
            QFilter qFilter3 = new QFilter("id", "in", selltypeIds);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
        }
        if (name.startsWith("costitemtype")) {
            Set<Object> ids = CostReportDataService.getLastLevelCostItemIdsByUniq(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
            QFilter qFilter1 = new QFilter("id", "in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter1);
            Set<String> numbers = CostReportDataService.queryCostItemsUpLevelNumbers(ids);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", numbers));
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("org", "=", (Object)this.getOrgid()));
            formShowParameter.setCustomParam("custom_filter", (Object)"1");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("org".equals(name) || "houseproject".equals(name) || "scheme".equals(name)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("entryentity1");
            this.getModel().deleteEntryData("entryentity2");
        } else if ("version".equals(name)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity1");
            this.getModel().beginInit();
            for (int i = 0; i < rowCount; ++i) {
                this.getModel().setValue("costitemtype", null, i);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity1");
        }
    }
}

