/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Button;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.common.enums.TaxStateEnum;

public class IncomeBookBatchEditPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String method = (String)customParams.get("method");
        String maxclearperiod = (String)customParams.get("maxclearperiod");
        ComboEdit taxstateComboEdit = (ComboEdit)this.getView().getControl("taxstate");
        taxstateComboEdit.setComboItems(TaxStateEnum.getComboItem(method));
        ComboEdit clearperiodComboEdit = (ComboEdit)this.getView().getControl("clearperiod");
        clearperiodComboEdit.setComboItems(ClearPeriodEnum.getClearPeriods(Integer.parseInt(maxclearperiod)));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("editfields".equals(name)) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if ("clearperiod".equals(newValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"clearperiod"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxstate"});
                this.getModel().setValue("taxstate", null);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"clearperiod"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"taxstate"});
                this.getModel().setValue("clearperiod", null);
            }
        }
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        Map customs = this.getView().getFormShowParameter().getCustomParams();
        if ("btnok".equals(source.getKey())) {
            String editfields = (String)this.getModel().getValue("editfields");
            String clearperiod = (String)this.getModel().getValue("clearperiod");
            String taxstate = (String)this.getModel().getValue("taxstate");
            if (StringUtil.isBlank((CharSequence)editfields)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6279\u91cf\u7f16\u8f91\u7684\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"IncomeBookBatchEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                return;
            }
            customs.put("editfields", editfields);
            customs.put("clearperiod", clearperiod);
            customs.put("taxstate", taxstate);
            this.getView().getParentView().setReturnData((Object)customs);
            this.getView().close();
        }
    }
}

