/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import com.alibaba.fastjson.JSONArray;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.baseconfig.RuleConfigService;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.draft.IncomeDraftService;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.common.enums.TaxStateEnum;
import kd.taxc.tcept.formplugin.draft.CommonBillFormPlugin;

public class IncomeBookEditPlugin
extends CommonBillFormPlugin
implements HyperLinkClickListener {
    public static final String TCEPT_BATCH_BOOK_EDIT = "tcept_batch_book_edit";
    public static final String PROJECT = "project";
    public static final String SCHEME = "scheme";
    public static final String VERSION = "version";
    public static final String TAXSTATE = "taxstate";
    public static final String CLEARPERIOD = "clearperiod";
    public static final String ORG = "org";
    public static final String RECORD_DATA = "record_data";
    private IncomeDraftService incomeDraftService = new IncomeDraftService();
    private RuleConfigService ruleConfigService = new RuleConfigService();
    private List<Map<String, String>> taxStateRecordDatas = new ArrayList<Map<String, String>>();
    private boolean isRecalcing = Boolean.FALSE;
    private boolean isBatchEdit = false;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadBizData();
    }

    @Override
    public void afterBindData(EventObject e) {
        ComboEdit comboEdit;
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        if (project != null) {
            String method = status == OperationStatus.ADDNEW ? project.getString("swqsytfl") : this.getModelString("swqsytfl");
            this.getPageCache().put("method", method);
            comboEdit = (ComboEdit)this.getView().getControl(TAXSTATE);
            comboEdit.setComboItems(TaxStateEnum.getComboItem(method));
        }
        if (scheme != null) {
            String maxclearperiod = status == OperationStatus.ADDNEW ? scheme.getString(CLEARPERIOD) : this.getModel().getValue("maxclearperiod").toString();
            this.getPageCache().put("maxclearperiod", maxclearperiod);
            comboEdit = (ComboEdit)this.getView().getControl(CLEARPERIOD);
            comboEdit.setComboItems(ClearPeriodEnum.getClearPeriods(Integer.parseInt(maxclearperiod)));
            this.setVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (VERSION.equals(name)) {
            this.loadBizData();
        } else if (PROJECT.equals(name)) {
            if (newValue != null) {
                String method = ((DynamicObject)newValue).getString("swqsytfl");
                this.getPageCache().put("method", method);
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(TAXSTATE);
                comboEdit.setComboItems(TaxStateEnum.getComboItem(method));
                Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue(ORG)).map(s -> s.getLong("id")).orElseGet(() -> 0L);
                Long projectId = ((DynamicObject)newValue).getLong("id");
                this.getModel().setValue(SCHEME, (Object)this.incomeDraftService.getDefaultScheme(orgId, projectId));
            } else {
                this.getModel().setValue(SCHEME, null);
            }
        } else if (SCHEME.equals(name)) {
            if (newValue != null) {
                String maxclearperiod = ((DynamicObject)newValue).getString(CLEARPERIOD);
                this.getPageCache().put("maxclearperiod", maxclearperiod);
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(CLEARPERIOD);
                comboEdit.setComboItems(ClearPeriodEnum.getClearPeriods(Integer.parseInt(maxclearperiod)));
                List<ComboItem> comboItems = this.getVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
                this.getModel().setValue(VERSION, comboItems.isEmpty() ? null : comboItems.get(0).getValue());
            } else {
                this.getModel().setValue(VERSION, null);
            }
            this.setVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
        } else if (TAXSTATE.equals(name) && !this.isRecalcing && newValue != null && !newValue.equals(oldValue)) {
            String pkid = this.getModel().getDataEntity().getString("id");
            String bizfield = ResManager.loadKDString((String)"\u7a0e\u52a1\u4e1a\u6001", (String)"IncomeBookEditPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]);
            String beforevalue = TaxStateEnum.getName((String)oldValue);
            String aftervalue = TaxStateEnum.getName((String)newValue);
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            if (rowEntity != null && status.name().equals("EDIT")) {
                this.taxStateRecordDatas.add(this.getMap(pkid, bizfield, rowEntity.getDynamicObject("roombasedata").getString("id"), beforevalue, aftervalue));
            }
            if (!this.isBatchEdit) {
                this.getView().getPageCache().putBigObject(RECORD_DATA, SerializationUtils.toJsonString(this.taxStateRecordDatas));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if ("batchedit".equals(key)) {
            DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
            DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
            if (project == null || scheme == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u623f\u5730\u4ea7\u9879\u76ee\u548c\u65b9\u6848\u3002", (String)"IncomeBookEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entity)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7f16\u8f91\u7684\u6570\u636e\u3002", (String)"IncomeBookEditPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            HashMap<String, Object> customeMap = new HashMap<String, Object>(16);
            customeMap.put("method", this.getPageCache().get("method"));
            customeMap.put("maxclearperiod", this.getPageCache().get("maxclearperiod"));
            customeMap.put("selectRows", selectRows);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCEPT_BATCH_BOOK_EDIT, (IFormView)this.getView(), customeMap, (IFormPlugin)this);
        }
        if ("save".equals(key)) {
            long taxstateCount;
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entity)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u660e\u7ec6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u201c\u623f\u95f4\u6536\u5165\u4fe1\u606f\u201d\u4e2d\u7ef4\u62a4\u623f\u95f4\u660e\u7ec6\u3002", (String)"IncomeBookEditPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long clearperiodCount = entity.stream().filter(s -> StringUtil.isBlank((CharSequence)s.getString(CLEARPERIOD))).count();
            String msg = this.getMsgTip(clearperiodCount, taxstateCount = entity.stream().filter(s -> StringUtil.isBlank((CharSequence)s.getString(TAXSTATE))).count());
            if (StringUtil.isNotBlank((CharSequence)msg)) {
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            this.getModel().setValue("sumsuite", (Object)entity.size());
            this.getModel().setValue("sumfloorarea", (Object)entity.stream().map(s -> s.getBigDecimal("floorarea")).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.getModel().setValue("sumgoodsvalue", (Object)entity.stream().map(s -> s.getBigDecimal("goodsvalue")).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.getModel().setValue("sumintaxamount", (Object)entity.stream().map(s -> s.getBigDecimal("intaxamount")).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.getModel().setValue("sumreturnedmoney", (Object)entity.stream().map(s -> s.getBigDecimal("returnedmoney")).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.getModel().setValue("maxclearperiod", (Object)Optional.ofNullable((DynamicObject)this.getModel().getValue(SCHEME)).map(s -> Integer.parseInt(s.getString(CLEARPERIOD))).orElseGet(() -> 0));
            this.getModel().setValue("swqsytfl", (Object)Optional.ofNullable((DynamicObject)this.getModel().getValue(PROJECT)).map(s -> s.getString("swqsytfl")).orElseGet(() -> "1"));
            String record_data = this.getView().getPageCache().getBigObject(RECORD_DATA);
            if (StringUtil.isNotBlank((CharSequence)record_data)) {
                List datas = (List)SerializationUtils.fromJsonString((String)record_data, List.class);
                DynamicObjectCollection records = new DynamicObjectCollection();
                for (Map data : datas) {
                    records.add((Object)this.recordValue(Long.parseLong((String)data.get("bizid")), (String)data.get("bizfield"), (String)data.get("bizrowtype"), (String)data.get("beforevalue"), (String)data.get("aftervalue")));
                }
                SaveServiceHelper.save((DynamicObject[])((DynamicObject[])records.toArray((Object[])new DynamicObject[0])));
                this.getView().getPageCache().removeBigObject(RECORD_DATA);
            }
        }
        if ("recalc".equals(key) && this.loadBizData()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u6210\u529f\u3002", (String)"IncomeBookEditPlugin_12", (String)"taxc-tcept", (Object[])new Object[0]));
        }
    }

    private String getMsgTip(long clearperiodCount, long taxstateCount) {
        StringBuilder builder = new StringBuilder();
        if (clearperiodCount > 0L) {
            builder.append(String.format(ResManager.loadKDString((String)"\u6709%s\u4e2a\u623f\u95f4\u672a\u5f55\u5165\u3010\u6e05\u7b97\u5206\u671f\u3011\u3002", (String)"IncomeBookEditPlugin_5", (String)"taxc-tcept", (Object[])new Object[0]), clearperiodCount));
            builder.append("\t\n");
        }
        if (taxstateCount > 0L) {
            builder.append(String.format(ResManager.loadKDString((String)"\u6709%s\u4e2a\u623f\u95f4\u672a\u5f55\u5165\u3010\u7a0e\u52a1\u4e1a\u6001\u3011\u3002", (String)"IncomeBookEditPlugin_6", (String)"taxc-tcept", (Object[])new Object[0]), taxstateCount));
            builder.append("\t\n");
        }
        return builder.toString();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("roombasedata".equals(fieldName)) {
            EntryGrid source = (EntryGrid)evt.getSource();
            int[] selectRows = source.getSelectRows();
            DynamicObject object = (DynamicObject)source.getModel().getEntryEntity("entryentity").get(selectRows[0]);
            String entryId = object.getDynamicObject("roombasedata").getString("id");
            long pkId = this.getModel().getDataEntity().getLong("id");
            QFilter filter = new QFilter("bizid", "=", (Object)pkId).and(new QFilter("bizrowtype", "=", (Object)entryId));
            HashMap<String, String> customParams = new HashMap<String, String>(16);
            customParams.put("adjustQFilter", filter.toSerializedString());
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)"tcept_adj_record_show", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Map returnData;
        if (TCEPT_BATCH_BOOK_EDIT.equals(event.getActionId()) && (returnData = (Map)this.getView().getReturnData()) != null) {
            String editfields = (String)returnData.get("editfields");
            String clearperiod = (String)returnData.get(CLEARPERIOD);
            String taxstate = (String)returnData.get(TAXSTATE);
            JSONArray selectRows = (JSONArray)returnData.get("selectRows");
            this.isBatchEdit = true;
            if (selectRows != null && selectRows.size() > 0) {
                selectRows.stream().forEach(s -> this.getModel().setValue(editfields, (Object)(CLEARPERIOD.equals(editfields) ? clearperiod : taxstate), ((Integer)s).intValue()));
            } else {
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                entity.stream().forEach(s -> this.getModel().setValue(editfields, (Object)(CLEARPERIOD.equals(editfields) ? clearperiod : taxstate), s.getInt("seq") - 1));
            }
            this.getView().getPageCache().putBigObject(RECORD_DATA, SerializationUtils.toJsonString(this.taxStateRecordDatas));
            this.isBatchEdit = false;
        }
    }

    public DynamicObject recordValue(Long bizid, String bizfield, String bizrowtype, String beforevalue, String aftervalue) {
        DynamicObject object = BusinessDataServiceHelper.newDynamicObject((String)"tcept_adj_record");
        object.set("biztable", (Object)"tcept_income_book");
        object.set("bizid", (Object)bizid);
        object.set("bizfield", (Object)bizfield);
        object.set("bizrowtype", (Object)bizrowtype);
        object.set("beforevalue", (Object)beforevalue);
        object.set("aftervalue", (Object)aftervalue);
        object.set("updateor", (Object)RequestContext.get().getUserId());
        object.set("updatetime", (Object)new Date());
        return object;
    }

    public Map<String, String> getMap(String bizid, String bizfield, String bizrowtype, String beforevalue, String aftervalue) {
        HashMap<String, String> data = new HashMap<String, String>(16);
        data.put("bizid", bizid);
        data.put("bizfield", bizfield);
        data.put("bizrowtype", bizrowtype);
        data.put("beforevalue", beforevalue);
        data.put("aftervalue", aftervalue);
        return data;
    }

    private boolean loadBizData() {
        this.isRecalcing = Boolean.TRUE;
        this.getModel().deleteEntryData("entryentity");
        this.getView().getPageCache().removeBigObject(RECORD_DATA);
        long orgId = this.getModelObjLongId(ORG);
        long projectId = this.getModelObjLongId(PROJECT);
        long schemeId = this.getModelObjLongId(SCHEME);
        String version = (String)this.getModel().getValue(VERSION);
        if (orgId == 0L || schemeId == 0L || projectId == 0L || version == null || version.length() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u672c\u4fe1\u606f\u3002", (String)"IncomeBookEditPlugin_13", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        DynamicObject ruleConfig = this.ruleConfigService.queryOneFitRuleByProject(orgId, projectId);
        Long incomeVer = SchemaDataService.queryVersionEntryIncomeVer(schemeId, version);
        List conditions = Optional.ofNullable(ruleConfig).map(s -> this.ruleConfigService.loadRuleConfig(ruleConfig)).orElseGet(() -> null);
        QFilter q1 = new QFilter("taxorg", "=", (Object)orgId);
        QFilter q2 = new QFilter("room.taxproject", "=", (Object)projectId);
        q1.and(VERSION, "=", (Object)incomeVer);
        DynamicObjectCollection roomRevenue = QueryServiceHelper.query((String)"tdm_room_revenue", (String)"room.id,room.name,fxsyt.id,jzmp,kszc,jzmj,scmj,zgrq,qyrq,hz,qybhsze,qyhsze,hk", (QFilter[])new QFilter[]{q1, q2});
        if (!CollectionUtils.isEmpty((Collection)roomRevenue)) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow("entryentity", roomRevenue.size());
            ArrayList<String> list1 = new ArrayList<String>();
            ArrayList<String> list2 = new ArrayList<String>();
            int index = 0;
            for (DynamicObject object : roomRevenue) {
                this.getModel().setValue(CLEARPERIOD, null, index);
                this.getModel().setValue("roombasedata", object.get("room.id"), index);
                this.getModel().setValue("salestate", object.get("fxsyt.id"), index);
                this.getModel().setValue("decorationtype", object.get("jzmp"), index);
                this.getModel().setValue("holdstate", object.get("kszc"), index);
                this.getModel().setValue("floorarea", object.get("jzmj"), index);
                this.getModel().setValue("actualarea", object.get("scmj"), index);
                this.getModel().setValue("finishdate", object.get("zgrq"), index);
                this.getModel().setValue("signingdate", object.get("qyrq"), index);
                this.getModel().setValue("goodsvalue", object.get("hz"), index);
                this.getModel().setValue("extaxamount", object.get("qybhsze"), index);
                this.getModel().setValue("intaxamount", object.get("qyhsze"), index);
                this.getModel().setValue("returnedmoney", object.get("hk"), index);
                if (conditions != null && !conditions.isEmpty()) {
                    BigDecimal price;
                    Date qyrq;
                    Long xsytId = (Long)object.get("fxsyt.id");
                    BigDecimal hz = object.getBigDecimal("hz");
                    BigDecimal jzmj = object.getBigDecimal("jzmj");
                    String kszc = object.getString("kszc");
                    List<String> taxstates = this.ruleConfigService.getSaleStateByRuleConfig(xsytId, kszc, qyrq = object.getDate("qyrq"), conditions, jzmj, hz, price = jzmj != null && jzmj.compareTo(BigDecimal.ZERO) > 0 ? hz.divide(jzmj, 2, 4) : BigDecimal.ZERO, BigDecimal.ZERO);
                    if (taxstates == null || taxstates.isEmpty()) {
                        list1.add(object.getString("room.name"));
                    } else if (taxstates.size() == 1) {
                        this.getModel().setValue(TAXSTATE, (Object)taxstates.get(0), index);
                    } else {
                        list2.add(object.getString("room.name"));
                    }
                }
                ++index;
            }
            StringBuilder tips = new StringBuilder();
            if (!list1.isEmpty()) {
                tips.append(((Object)list1).toString()).append(ResManager.loadKDString((String)"\u7a0e\u52a1\u4e1a\u6001\u5224\u65ad\u4e3a\u7a7a\uff1b", (String)"IncomeBookEditPlugin_7", (String)"taxc-tcept", (Object[])new Object[0])).append("\n");
            }
            if (conditions == null || conditions.isEmpty()) {
                tips.append(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u9879\u76ee\u89c4\u5219\u3002", (String)"IncomeBookEditPlugin_14", (String)"taxc-tcept", (Object[])new Object[0])).append("\n");
            }
            if (!list2.isEmpty()) {
                tips.append(((Object)list2).toString()).append(ResManager.loadKDString((String)"\u7a0e\u52a1\u4e1a\u6001\u5224\u65ad\u4e3a\u591a\u4e2a\u503c\uff0c\u7cfb\u7edf\u8d4b\u503c\u4e3a\u7a7a\uff1b", (String)"IncomeBookEditPlugin_8", (String)"taxc-tcept", (Object[])new Object[0])).append("\n");
            }
            if (StringUtil.isNotEmpty((CharSequence)tips.toString())) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u5173\u95ed", (String)"IncomeBookEditPlugin_11", (String)"taxc-tcept", (Object[])new Object[0]));
                tips.append(ResManager.loadKDString((String)"\u8bf7\u624b\u5de5\u7f16\u8f91\u7a0e\u52a1\u4e1a\u6001\u3002", (String)"IncomeBookEditPlugin_10", (String)"taxc-tcept", (Object[])new Object[0]));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u9519\u8bef\u63d0\u793a", (String)"IncomeBookEditPlugin_9", (String)"taxc-tcept", (Object[])new Object[0]), tips.toString(), MessageBoxOptions.Toast, ConfirmTypes.Default, null, btnNameMaps, null);
            }
            this.getModel().endInit();
        }
        this.isRecalcing = Boolean.FALSE;
        this.getView().updateView("entryentity");
        return true;
    }
}

