/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.business.draft.IncomeDraftService;
import kd.taxc.tcept.business.draft.QiTaAdjustDraftService;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.common.enums.TaxStateEnum;
import kd.taxc.tcept.formplugin.draft.CommonFormPlugin;

public class QiTaAdjustDraftFormPlugin
extends CommonFormPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    protected static final String NEXT_KEY = "next";
    protected static final String FORWARD_KEY = "forward";
    public static final String RESET = "reset";
    public static final String RECALC = "recalc";
    public static final String SAVE = "save";
    public static final String NUMBER = "number";
    public static final String ORG = "org";
    public static final String PROJECT = "project";
    public static final String SCHEME = "scheme";
    public static final String VERSION = "version";
    public static final String DJDJMETHOD = "djdjmethod";
    public static final String JJKCADJUST = "jjkcadjust";
    public static final String SWQSYTFL = "swqsytfl";
    public static final String MAXCLEARPERIOD = "maxclearperiod";
    public static final String DJDJ = "djdj";
    public static final String SJJJKC = "sjjjkc";
    public static final String JJKC = "jjkc";
    public static final String PAGE_CACHE_CURRENT_STEP = "pageCacheCurrentStep";
    public static final String TCEPT_QITA_DRAFT_BILL = "tcept_qita_draft_bill";
    public static final String ENTITY_1_FTFF = "entity1_ftff";
    public static final String ENTITY_2_FTFF = "entity2_ftff";
    public static final String ENTITY_1_DJDJSUM = "entity1_djdjsum";
    public static final String ENTITY_1_P_ = "entity1_p_";
    public static final String TAXSTATE = "taxstate";
    public static final String CLEARPERIOD = "clearperiod";
    public static final String JJKCTAXSTATE = "jjkctaxstate";
    public static final String JJKCCLEARPERIOD = "jjkcclearperiod";
    public static final String ENTRYENTITY_1 = "entryentity1";
    public static final String ENTRYENTITY_2 = "entryentity2";
    public static final String ENTRYENTITY_3 = "entryentity3";
    public static final String ENTRYENTITY_4 = "entryentity4";
    public static final String FLEXPANELAPSTEP_1 = "flexpanelapstep1";
    public static final String FLEXPANELAPSTEP_2 = "flexpanelapstep2";
    public static final String FLEXPANELAPSTEP_3 = "flexpanelapstep3";
    public static final String SPLIT_1 = "split1";
    public static final String SPLIT_2 = "split2";
    private List<String> menuList = Lists.newArrayList((Object[])new String[]{"djdj", "sjjjkc", "jjkc"});
    private IncomeDraftService incomeDraftService = new IncomeDraftService();
    private QiTaAdjustDraftService qiTaAdjDraftService = new QiTaAdjustDraftService();

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "toolbaraplist"});
        this.menuList.stream().forEach(s -> this.addClickListeners(new String[]{s}));
        Optional.ofNullable(this.getControl(ORG)).map(s -> (OrgEdit)s).ifPresent(s -> s.addBeforeF7SelectListener((BeforeF7SelectListener)this));
        Optional.ofNullable(this.getControl(PROJECT)).map(s -> (BasedataEdit)s).ifPresent(s -> s.addBeforeF7SelectListener((BeforeF7SelectListener)this));
        Optional.ofNullable(this.getControl(SCHEME)).map(s -> (BasedataEdit)s).ifPresent(s -> s.addBeforeF7SelectListener((BeforeF7SelectListener)this));
        Optional.ofNullable(this.getControl(ENTITY_1_FTFF)).map(s -> (BasedataEdit)s).ifPresent(s -> s.addBeforeF7SelectListener((BeforeF7SelectListener)this));
        Optional.ofNullable(this.getControl(ENTITY_2_FTFF)).map(s -> (BasedataEdit)s).ifPresent(s -> s.addBeforeF7SelectListener((BeforeF7SelectListener)this));
        Optional.ofNullable(this.getControl(ENTITY_2_FTFF)).map(s -> (BasedataEdit)s).ifPresent(s -> s.addAfterF7SelectListener((AfterF7SelectListener)this));
    }

    public void afterCreateNewData(EventObject e) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String step = null;
        String djdjmethod = null;
        String jjkcadjust = null;
        List<String> listBanners = null;
        DynamicObject object = null;
        int maxClearPeriods = 0;
        String swqsytfl = "1";
        if (customParams.containsKey("mainbillpk")) {
            object = this.getDraft(customParams);
            this.getModel().setValue(NUMBER, (Object)object.getString("billno"));
            this.getModel().setValue(ORG, (Object)object.getDynamicObject(ORG).getLong("id"));
            this.getModel().setValue(PROJECT, (Object)object.getDynamicObject(PROJECT).getLong("id"));
            this.getModel().setValue(SCHEME, (Object)object.getDynamicObject(SCHEME).getLong("id"));
            this.getModel().setValue(VERSION, (Object)object.getString(VERSION));
            this.getModel().setValue(DJDJMETHOD, (Object)object.getString(DJDJMETHOD));
            this.getModel().setValue(JJKCADJUST, (Object)object.getString(JJKCADJUST));
            djdjmethod = this.getModelString(DJDJMETHOD);
            jjkcadjust = this.getModelString(JJKCADJUST);
            listBanners = Arrays.stream(object.getString("menulist").split(",")).filter(s -> StringUtil.isNotEmpty((CharSequence)s)).collect(Collectors.toList());
            step = object.getString("focusstep");
            swqsytfl = object.getString(SWQSYTFL);
            maxClearPeriods = object.getInt(MAXCLEARPERIOD);
            this.calcOrList(false, step, object);
        } else if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue() && status.equals((Object)OperationStatus.ADDNEW)) {
            this.getModel().setValue(NUMBER, this.getNumber(Long.parseLong((String)customParams.get(ORG))));
            this.getModel().setValue(ORG, (Object)Long.parseLong((String)customParams.get(ORG)));
            this.getModel().setValue(PROJECT, (Object)Long.parseLong((String)customParams.get(PROJECT)));
            this.getModel().setValue(SCHEME, (Object)Long.parseLong((String)customParams.get(SCHEME)));
            this.getModel().setValue(VERSION, customParams.get(VERSION));
            djdjmethod = this.getModelString(DJDJMETHOD);
            jjkcadjust = this.getModelString(JJKCADJUST);
            listBanners = this.qiTaAdjDraftService.getListBanners(djdjmethod, jjkcadjust);
            step = listBanners.size() > 0 ? listBanners.get(0) : JJKC;
            String clearperiod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
            maxClearPeriods = Integer.parseInt(clearperiod);
            swqsytfl = this.getModelObjString(PROJECT, SWQSYTFL);
            this.calcOrList(true, step, null);
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((String)appId, (String)TCEPT_QITA_DRAFT_BILL, (String)"47156aff000000ac");
            List hasPermOrgList = OrgCheckUtil.hasPermOrgList((HasPermOrgResult)hasPermOrgs);
            List istaxpayers = (List)TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer((List)hasPermOrgList).getData();
            Long orgId = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (List)istaxpayers);
            this.getModel().setValue(NUMBER, this.getNumber(orgId));
            this.getModel().setValue(ORG, (Object)orgId);
            Long defaultProjectId = this.incomeDraftService.getDefaultProject(orgId);
            this.getModel().setValue(PROJECT, (Object)defaultProjectId);
            Long defaultSchemeId = this.incomeDraftService.getDefaultScheme(orgId, defaultProjectId);
            this.getModel().setValue(SCHEME, (Object)defaultSchemeId);
            List<ComboItem> comboItems = this.getVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
            String version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
            this.getModel().setValue(VERSION, (Object)version);
            djdjmethod = this.getModelString(DJDJMETHOD);
            jjkcadjust = this.getModelString(JJKCADJUST);
            listBanners = this.qiTaAdjDraftService.getListBanners(djdjmethod, jjkcadjust);
            step = listBanners.size() > 0 ? listBanners.get(0) : JJKC;
            String clearperiod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
            maxClearPeriods = Integer.parseInt(clearperiod);
            swqsytfl = this.getModelObjString(PROJECT, SWQSYTFL);
            this.calcOrList(true, step, null);
        }
        this.setVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
        this.setPageProperties(step, djdjmethod, jjkcadjust, listBanners);
        this.getPageCache().put(PAGE_CACHE_CURRENT_STEP, step);
        this.setComboItemsList(maxClearPeriods, swqsytfl);
        this.switchInnerPage(step);
    }

    public DynamicObject getDraft(Map<String, Object> customParams) {
        Long mainbillpk = (Long)customParams.get("mainbillpk");
        if (mainbillpk != null && mainbillpk != 0L) {
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)mainbillpk, (String)TCEPT_QITA_DRAFT_BILL);
            return object;
        }
        return null;
    }

    private Object getNumber(Long orgId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)TCEPT_QITA_DRAFT_BILL);
        String number = DeclareServiceHelper.generateSBBNo((String)TCEPT_QITA_DRAFT_BILL, (DynamicObject)dynamicObject, (String)String.valueOf(orgId));
        return number;
    }

    public void setPageProperties(String step, String djdjmethod, String jjkcadjust, List<String> listBanners) {
        this.setPageBannerVisible(djdjmethod, jjkcadjust);
        this.setPageButtonVisible(step, listBanners);
        QiTaAdjustDraftFormPlugin.setStepStyle(listBanners, this.getView(), step);
    }

    private boolean checkMustInput(BeforeItemClickEvent evt, List<String> fields) {
        DataEntityPropertyCollection properties = this.getModel().getDataEntityType().getProperties();
        String checkMsg = fields.stream().filter(s -> {
            Object value = this.getModel().getValue(s);
            return value == null;
        }).map(s -> ((IDataEntityProperty)properties.get(s)).getDisplayName().getLocaleValue()).collect(Collectors.joining("\uff0c"));
        if (StringUtil.isNotEmpty((CharSequence)checkMsg)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%s\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QiTaAdjustDraftFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]), checkMsg));
            evt.setCancel(true);
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && RECALC.equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey()) && !this.checkCalcCondition()) {
            args.setCancel(true);
        }
    }

    private boolean checkCalcCondition() {
        DynamicObject draft = this.getDraft(this.getView().getFormShowParameter().getCustomParams());
        if (draft != null && !"A".equals(draft.getString("billstatus"))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u8fdb\u884c\u201c\u91cd\u65b0\u53d6\u6570\u201d\u3002", (String)"QiTaAdjustDraftFormPlugin_9", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "recalc": {
                this.recalc();
            }
        }
    }

    private void recalc() {
        String jjkcadjust;
        String djdjmethod = this.getModelString(DJDJMETHOD);
        List<String> listBanners = this.qiTaAdjDraftService.getListBanners(djdjmethod, jjkcadjust = this.getModelString(JJKCADJUST));
        if (listBanners.contains(DJDJ)) {
            this.calcOrList(false, DJDJ, null);
        }
        if (listBanners.contains(JJKC)) {
            this.calcOrList(false, JJKC, null);
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"QiTaAdjustDraftFormPlugin_10", (String)"taxc-tcept", (Object[])new Object[0]));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Long orgId = this.getModelObjLongId(ORG);
        Long projectId = this.getModelObjLongId(PROJECT);
        Long schemeId = this.getModelObjLongId(SCHEME);
        String version = this.getModelString(VERSION);
        String djdjmethod = this.getModelString(DJDJMETHOD);
        String jjkcadjust = this.getModelString(JJKCADJUST);
        String clearperiod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
        String swqsytfl = this.getModelObjString(PROJECT, SWQSYTFL);
        int maxClearPeriod = Integer.parseInt(clearperiod);
        if (DJDJMETHOD.equals(name) || JJKCADJUST.equals(name)) {
            List<String> listBanners = this.qiTaAdjDraftService.getListBanners(djdjmethod, jjkcadjust);
            if (listBanners.size() > 0) {
                String currentStep = listBanners.get(0);
                this.setPageProperties(currentStep, djdjmethod, jjkcadjust, listBanners);
                this.getPageCache().put(PAGE_CACHE_CURRENT_STEP, currentStep);
                this.switchInnerPage(currentStep);
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD_KEY, NEXT_KEY});
            }
        }
        if (ORG.equals(name)) {
            Long defaultProjectId = this.incomeDraftService.getDefaultProject(orgId);
            this.getModel().setValue(PROJECT, (Object)defaultProjectId);
        }
        if (PROJECT.equals(name)) {
            Long defaultSchemeId = this.incomeDraftService.getDefaultScheme(orgId, projectId);
            this.getModel().setValue(SCHEME, (Object)defaultSchemeId);
        }
        if (SCHEME.equals(name)) {
            List<ComboItem> comboItems = this.getVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
            this.getModel().setValue(VERSION, comboItems.isEmpty() ? null : comboItems.get(0).getValue());
            this.setVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
        }
        if (ORG.equals(name) || PROJECT.equals(name) || SCHEME.equals(name) || VERSION.equals(name)) {
            int innerMaxClearPeriod = Integer.parseInt(this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0"));
            String innerSwqsytfl = this.getModelObjString(PROJECT, SWQSYTFL);
            this.setComboItemsList(innerMaxClearPeriod, innerSwqsytfl);
            List<String> listBanners = this.qiTaAdjDraftService.getListBanners(djdjmethod, jjkcadjust);
            String currentStep = listBanners.size() > 0 ? listBanners.get(0) : JJKC;
            this.getPageCache().put(PAGE_CACHE_CURRENT_STEP, currentStep);
            this.setPageProperties(currentStep, djdjmethod, jjkcadjust, listBanners);
            this.calcOrList(true, currentStep, null);
            this.switchInnerPage(currentStep);
        }
        if (ENTITY_1_FTFF.equals(name)) {
            BigDecimal newValue = (BigDecimal)this.getModel().getValue(ENTITY_1_DJDJSUM, rowIndex);
            this.setDisPlayList1(rowIndex, orgId, projectId, schemeId, version, newValue, maxClearPeriod);
        }
        if (ENTITY_2_FTFF.equals(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (!this.checkMatchPeriod(maxClearPeriod, newValue, orgId, projectId, schemeId, version)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u201c\u6210\u672c\u5206\u644a\u65b9\u6cd5\u201d\u672a\u7ef4\u62a4\u6240\u6709\u5206\u671f\u7684\u5206\u644a\u6bd4\u4f8b\uff0c\u8bf7\u66f4\u6362\u201c\u6210\u672c\u5206\u644a\u65b9\u6cd5\u201d\u3002", (String)"QiTaAdjustDraftFormPlugin_8", (String)"taxc-tcept", (Object[])new Object[0]));
                this.rollbackPropertyChange(e);
                return;
            }
            this.setDisPlayList2(orgId, projectId, schemeId, version, maxClearPeriod, swqsytfl);
        }
        if (ENTITY_1_DJDJSUM.equals(name)) {
            BigDecimal newValue = Optional.ofNullable((BigDecimal)e.getChangeSet()[0].getNewValue()).orElseGet(() -> BigDecimal.ZERO);
            this.setDisPlayList1(rowIndex, orgId, projectId, schemeId, version, newValue, maxClearPeriod);
        }
        if (name.contains(ENTITY_1_P_)) {
            this.setDisPlayList2(orgId, projectId, schemeId, version, maxClearPeriod, swqsytfl);
        }
    }

    private boolean checkMatchPeriod(int maxClearPeriod, DynamicObject method, Long orgId, Long projectId, Long schemeId, String version) {
        if (method == null) {
            return true;
        }
        DynamicObject object = CostSplitDraftService.getDraftDataByUniKey(orgId, projectId, schemeId, version);
        if (object == null) {
            return false;
        }
        DynamicObjectCollection entryentity1 = object.getDynamicObjectCollection(ENTRYENTITY_1);
        long count = entryentity1.stream().filter(s -> s.getDynamicObject("costsplitmethod1").getLong("id") == method.getLong("id")).map(s -> s.getString("clearterm1")).distinct().count();
        return (long)maxClearPeriod == count;
    }

    public void click(EventObject evt) {
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getItemKey();
        String step = this.getPageCache().get(PAGE_CACHE_CURRENT_STEP);
        String clearperiod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
        int maxClearPeriods = Integer.parseInt(clearperiod);
        ArrayList checkFields = Lists.newArrayList((Object[])new String[]{ORG, PROJECT, SCHEME, VERSION, DJDJMETHOD, JJKCADJUST});
        if (NEXT_KEY.equals(operationKey)) {
            if (!this.checkMustInput(evt, checkFields)) {
                return;
            }
            if (DJDJ.equals(step)) {
                DynamicObject ftff1 = (DynamicObject)this.getModel().getValue(ENTITY_1_FTFF, 0);
                DynamicObject ftff2 = (DynamicObject)this.getModel().getValue(ENTITY_2_FTFF, 0);
                if (ftff1 == null || ftff2 == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5206\u644a\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QiTaAdjustDraftFormPlugin_5", (String)"taxc-tcept", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<String> visibleEntity1List = this.qiTaAdjDraftService.getVisibleEntity1List(maxClearPeriods);
                BigDecimal sum = visibleEntity1List.stream().map(s -> (BigDecimal)this.getModel().getValue(s)).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal djdjsum = (BigDecimal)this.getModel().getValue(ENTITY_1_DJDJSUM, 0);
                if (djdjsum != null && sum.compareTo(djdjsum) != 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5730\u4ef7\u62b5\u51cf\u9500\u9879\u8c03\u6574\u4e2d\u660e\u7ec6\u6570\u548c\u5408\u8ba1\u6570\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QiTaAdjustDraftFormPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
            if (SJJJKC.equals(step)) {
                Map<String, List<DynamicObject>> collect;
                boolean anyMatch;
                DynamicObjectCollection entity3 = this.getModel().getEntryEntity(ENTRYENTITY_3);
                if (!CollectionUtils.isEmpty((Collection)entity3)) {
                    DynamicObject object = (DynamicObject)entity3.get(0);
                    HashMap map = new HashMap(16);
                    DataEntityPropertyCollection properties = object.getDataEntityType().getProperties();
                    entity3.stream().forEach(e -> properties.stream().forEach(p -> {
                        if (e.get(p.getName()) == null) {
                            List list = map.computeIfAbsent(e.getString("seq"), k -> new ArrayList());
                            list.add(p.getDisplayName().getLocaleValue());
                        }
                    }));
                    if (!map.isEmpty()) {
                        String msg = map.entrySet().stream().map(s -> String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c%2$s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QiTaAdjustDraftFormPlugin_6", (String)"taxc-tcept", (Object[])new Object[0]), s.getKey(), s.getValue())).collect(Collectors.joining("\n"));
                        this.getView().showErrorNotification(msg);
                        evt.setCancel(true);
                        return;
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)entity3) && (anyMatch = (collect = entity3.stream().collect(Collectors.groupingBy(s -> s.getString("items") + s.getString(CLEARPERIOD) + s.getString(TAXSTATE)))).entrySet().stream().anyMatch(s -> ((List)s.getValue()).size() > 1))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u624b\u5de5\u8c03\u6574\u4e8b\u9879\u201d\u4e2d\u5b58\u5728\u201c\u8c03\u6574\u4e8b\u9879\u201d\u3001\u201c\u6e05\u7b97\u5206\u671f\u201d\u548c\u201c\u7a0e\u52a1\u4e1a\u6001\u201d\u5747\u76f8\u540c\u7684\u591a\u6761\u6570\u636e\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u6570\u636e\u540e\u518d\u4fdd\u5b58\u3002", (String)"QiTaAdjustDraftFormPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
            }
        }
        if (SAVE.equals(operationKey)) {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (!this.checkMustInput(evt, checkFields)) {
                return;
            }
            if (status == OperationStatus.ADDNEW && this.qiTaAdjDraftService.isExists(this.getModelString(NUMBER), this.getModelObjLongId(ORG), this.getModelObjLongId(PROJECT), this.getModelObjLongId(SCHEME), this.getModelString(VERSION))) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7ec4\u7ec7\u3001\u623f\u5730\u4ea7\u9879\u76ee\u3001\u65b9\u6848\u53ca\u65b9\u6848\u7248\u672c\u53f7\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"QiTaAdjustDraftFormPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
                return;
            }
        }
        if ((RESET.equals(operationKey) || RECALC.equals(operationKey)) && !this.checkMustInput(evt, checkFields)) {
            evt.setCancel(true);
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        String currentStep = this.getPageCache().get(PAGE_CACHE_CURRENT_STEP);
        if (itemKey.equals(NEXT_KEY) || itemKey.equals(FORWARD_KEY)) {
            String djdjmethod = this.getModelString(DJDJMETHOD);
            String jjkcadjust = this.getModelString(JJKCADJUST);
            List<String> listBanners = this.qiTaAdjDraftService.getListBanners(djdjmethod, jjkcadjust);
            String toStep = itemKey.equals(NEXT_KEY) ? this.qiTaAdjDraftService.getNextPageStep(listBanners, currentStep) : this.qiTaAdjDraftService.getPreviousPageStep(listBanners, currentStep);
            this.getPageCache().put(PAGE_CACHE_CURRENT_STEP, toStep);
            if (itemKey.equals(NEXT_KEY) && JJKC.equals(toStep)) {
                this.calcOrList(false, toStep, null);
            }
            this.setPageProperties(toStep, djdjmethod, jjkcadjust, listBanners);
            this.switchInnerPage(toStep);
        }
        if (RESET.equals(itemKey)) {
            String clearperiod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
            int maxClearPeriods = Integer.parseInt(clearperiod);
            String swqsytfl = this.getModelObjString(PROJECT, SWQSYTFL);
            String djdjmethod = this.getModelString(DJDJMETHOD);
            String jjkcadjust = this.getModelString(JJKCADJUST);
            List<String> listBanners = this.qiTaAdjDraftService.getListBanners(djdjmethod, jjkcadjust);
            String step = listBanners.get(0);
            this.getPageCache().put(PAGE_CACHE_CURRENT_STEP, step);
            this.setPageProperties(step, djdjmethod, jjkcadjust, listBanners);
            this.calcOrList(true, step, null);
            this.switchInnerPage(step);
            this.setComboItemsList(maxClearPeriods, swqsytfl);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u6210\u529f\u3002", (String)"QiTaAdjustDraftFormPlugin_11", (String)"taxc-tcept", (Object[])new Object[0]));
        }
        if (SAVE.equals(itemKey)) {
            DynamicObjectCollection entity4;
            DynamicObjectCollection entity3;
            DynamicObjectCollection entity2;
            DynamicObjectCollection entity1;
            String number = this.getModelString(NUMBER);
            Long orgId = this.getModelObjLongId(ORG);
            Long projectId = this.getModelObjLongId(PROJECT);
            Long schemeId = this.getModelObjLongId(SCHEME);
            String version = this.getModelString(VERSION);
            String swqsytfl = this.getModelObjString(PROJECT, SWQSYTFL);
            String clearperiod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
            int maxClearPeriods = Integer.parseInt(clearperiod);
            String djdjmethod = this.getModelString(DJDJMETHOD);
            String jjkcadjust = this.getModelString(JJKCADJUST);
            String step = this.getPageCache().get(PAGE_CACHE_CURRENT_STEP);
            OperationResult operationResult = this.qiTaAdjDraftService.createOrUpdate(number, orgId, projectId, schemeId, version, swqsytfl, maxClearPeriods, step, djdjmethod, jjkcadjust, entity1 = this.getModel().getEntryEntity(ENTRYENTITY_1), entity2 = this.getModel().getEntryEntity(ENTRYENTITY_2), entity3 = this.getModel().getEntryEntity(ENTRYENTITY_3), entity4 = this.getModel().getEntryEntity(ENTRYENTITY_4));
            if (operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QiTaAdjustDraftFormPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]));
                this.getView().setEnable(Boolean.FALSE, new String[]{ORG, PROJECT, SCHEME, VERSION, DJDJMETHOD, JJKCADJUST});
            } else {
                this.getView().showErrorNotification(operationResult.getMessage());
            }
        }
    }

    private void calcOrList(boolean needclear, String step, DynamicObject existsObject) {
        Long orgId = this.getModelObjLongId(ORG);
        Long projectId = this.getModelObjLongId(PROJECT);
        Long schemeId = this.getModelObjLongId(SCHEME);
        String version = this.getModelString(VERSION);
        String clearperiod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
        int maxClearPeriods = Integer.parseInt(clearperiod);
        String swqsytfl = this.getModelObjString(PROJECT, SWQSYTFL);
        String deductbycost = this.getModelObjString(SCHEME, "deductbycost");
        DynamicObjectCollection entryentity3 = this.getModel().getEntryEntity(ENTRYENTITY_3);
        if (existsObject != null) {
            DynamicObjectCollection objects = existsObject.getDynamicObjectCollection(ENTRYENTITY_4);
            List calcListDatas = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)objects), List.class);
            this.initData(needclear, existsObject, calcListDatas, maxClearPeriods, swqsytfl);
        } else if (JJKC.equals(step)) {
            List<Map<String, Object>> list = this.qiTaAdjDraftService.calcData(orgId, projectId, schemeId, version, swqsytfl, deductbycost, entryentity3);
            this.initData(needclear, null, list, maxClearPeriods, swqsytfl);
        } else {
            this.initData(needclear, null, null, maxClearPeriods, swqsytfl);
        }
    }

    private void initData(boolean needclear, DynamicObject existsObject, List<Map<String, Object>> list, int maxClearPeriods, String swqsytfl) {
        this.setEntryFieldVisible(maxClearPeriods, swqsytfl);
        this.showDataToForm(needclear, existsObject, ENTRYENTITY_1);
        this.showDataToForm(needclear, existsObject, ENTRYENTITY_2);
        this.showDataToForm(needclear, existsObject, ENTRYENTITY_3);
        this.showListDataToForm(list, maxClearPeriods, swqsytfl);
    }

    private void setEntryFieldVisible(int maxClearPeriods, String swqsytfl) {
        this.qiTaAdjDraftService.getEntity1List().stream().forEach(s -> this.getView().setVisible(Boolean.valueOf(this.qiTaAdjDraftService.getVisibleEntity1List(maxClearPeriods).contains(s)), new String[]{s}));
        this.qiTaAdjDraftService.getEntity2GroupList().stream().forEach(s -> this.getView().setVisible(Boolean.valueOf(this.qiTaAdjDraftService.getVisibleEntity2GroupList(maxClearPeriods).contains(s)), new String[]{s}));
        this.qiTaAdjDraftService.getEntity2List().stream().forEach(s -> this.getView().setVisible(Boolean.valueOf(this.qiTaAdjDraftService.getVisibleEntity2List(maxClearPeriods, swqsytfl).contains(s)), new String[]{s}));
    }

    private void showListDataToForm(List<Map<String, Object>> list, int maxClearPeriods, String swqsytfl) {
        this.getModel().deleteEntryData(ENTRYENTITY_4);
        if (list != null && list.size() > 0) {
            for (Map<String, Object> map : list) {
                int index = this.getModel().createNewEntryRow(ENTRYENTITY_4);
                this.getModel().setValue(JJKCCLEARPERIOD, map.get(JJKCCLEARPERIOD), index);
                this.getModel().setValue(JJKCTAXSTATE, map.get(JJKCTAXSTATE), index);
                this.getModel().setValue("tdcb", map.get("tdcb"), index);
                this.getModel().setValue("fdcdevcb", map.get("fdcdevcb"), index);
                this.getModel().setValue("sgtzsxamount", map.get("sgtzsxamount"), index);
                this.getModel().setValue("tzhfdcdevfybase", map.get("tzhfdcdevfybase"), index);
                this.getModel().setValue("cwfy", map.get("cwfy"), index);
                this.getModel().setValue("qtfdcdevfy", map.get("qtfdcdevfy"), index);
                this.getModel().setValue("fdcdevfy", map.get("fdcdevfy"), index);
                this.getModel().setValue("tzhqtkcbase", map.get("tzhqtkcbase"), index);
                this.getModel().setValue("qtkcxm", map.get("qtkcxm"), index);
            }
        } else {
            List<ComboItem> taxStateItems = TaxStateEnum.getComboItem(swqsytfl);
            List<ComboItem> clearPeriodItems = ClearPeriodEnum.getClearPeriodsWithCount(maxClearPeriods);
            this.getModel().deleteEntryData(ENTRYENTITY_4);
            for (ComboItem clearPeriod : clearPeriodItems) {
                for (ComboItem taxState : taxStateItems) {
                    int index = this.getModel().createNewEntryRow(ENTRYENTITY_4);
                    String clearPeriodCode = clearPeriod.getValue();
                    String taxStateCode = taxState.getValue();
                    this.getModel().setValue(JJKCCLEARPERIOD, (Object)clearPeriodCode, index);
                    this.getModel().setValue(JJKCTAXSTATE, (Object)taxStateCode, index);
                }
            }
        }
        this.getView().updateView(ENTRYENTITY_4);
    }

    private void showDataToForm(boolean needclear, DynamicObject object, String entryentity) {
        if (needclear) {
            this.getModel().deleteEntryData(entryentity);
            this.getModel().insertEntryRow(entryentity, 0);
            return;
        }
        if (object == null) {
            return;
        }
        if (ENTRYENTITY_2.equals(entryentity)) {
            DynamicObjectCollection list = object.getDynamicObjectCollection(entryentity);
            this.getModel().deleteEntryData(entryentity);
            int index = this.getModel().createNewEntryRow(entryentity);
            for (DynamicObject oo : list) {
                this.getModel().setValue(ENTITY_2_FTFF, oo.get(ENTITY_2_FTFF), index);
                int period = Integer.parseInt(oo.getString("period"));
                this.getModel().setValue("entity2_ptzz_p_" + period, oo.get("ptzz"), index);
                this.getModel().setValue("entity2_fptzz_p_" + period, oo.get("fptzz"), index);
                this.getModel().setValue("entity2_qtlx_p_" + period, oo.get("qtlx"), index);
                this.getModel().setValue("entity2_fqsyt_p_" + period, oo.get("fqsyt"), index);
            }
            this.getView().updateView(entryentity);
        } else if (ENTRYENTITY_1.equals(entryentity) || ENTRYENTITY_3.equals(entryentity)) {
            DynamicObjectCollection list = object.getDynamicObjectCollection(entryentity);
            this.getModel().deleteEntryData(entryentity);
            for (DynamicObject dynamicObject : list) {
                int index = this.getModel().createNewEntryRow(entryentity);
                DynamicObject rowEntity = this.getModel().getEntryRowEntity(entryentity, index);
                DataEntityPropertyCollection properties = rowEntity.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    if (!dynamicObject.getDataEntityType().getProperties().containsKey((Object)property.getName())) continue;
                    try {
                        this.getModel().setValue(property.getName(), dynamicObject.get(property.getName()), index);
                    }
                    catch (Exception exception) {}
                }
            }
            this.getView().updateView(entryentity);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter q1;
        ListShowParameter listShowParameter;
        List<Object> ids;
        DynamicObject object;
        String version;
        Long schemeId;
        Long orgId;
        String name = evt.getProperty().getName();
        if (ORG.equals(name)) {
            // empty if block
        }
        if (PROJECT.equals(name)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org == null) {
                return;
            }
            long orgid = org.getLong("id");
            ListShowParameter listShowParameter2 = (ListShowParameter)evt.getFormShowParameter();
            QFilter q12 = new QFilter("taxorg", "=", (Object)orgid);
            QFilter q2 = new QFilter("status", "=", (Object)"C");
            QFilter q3 = new QFilter("group.number", "=", (Object)"001");
            QFilter q4 = new QFilter("enable", "=", (Object)"1");
            listShowParameter2.getListFilterParameter().setFilter(q12);
            listShowParameter2.getListFilterParameter().setFilter(q2);
            listShowParameter2.getListFilterParameter().setFilter(q3);
            listShowParameter2.getListFilterParameter().setFilter(q4);
            List qFilters = listShowParameter2.getTreeFilterParameter().getQFilters();
            qFilters.add(new QFilter(NUMBER, "in", (Object)"001"));
        }
        if (SCHEME.equals(name)) {
            Long orgid = this.getModelObjLongId(ORG);
            Long projectId = this.getModelObjLongId(PROJECT);
            ListShowParameter listShowParameter3 = (ListShowParameter)evt.getFormShowParameter();
            QFilter q13 = new QFilter(ORG, "in", (Object)orgid);
            QFilter q2 = new QFilter(PROJECT, "in", (Object)projectId);
            listShowParameter3.getListFilterParameter().setFilter(q13);
            listShowParameter3.getListFilterParameter().setFilter(q2);
        }
        if (ENTITY_1_FTFF.equals(name)) {
            orgId = this.getModelObjLongId(ORG);
            Long projectId = this.getModelObjLongId(PROJECT);
            schemeId = this.getModelObjLongId(SCHEME);
            version = this.getModelString(VERSION);
            object = CostSplitDraftService.getDraftDataByUniKey(orgId, projectId, schemeId, version);
            ids = new ArrayList();
            if (object != null) {
                ids = object.getDynamicObjectCollection("entryentity").stream().map(s -> s.getDynamicObject("costsplitmethod").getLong("id")).distinct().collect(Collectors.toList());
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            q1 = new QFilter("id", "in", ids);
            listShowParameter.getListFilterParameter().setFilter(q1);
            listShowParameter.getListFilterParameter().setFilter(q1);
        }
        if (ENTITY_2_FTFF.equals(name)) {
            orgId = this.getModelObjLongId(ORG);
            Long projectId = this.getModelObjLongId(PROJECT);
            schemeId = this.getModelObjLongId(SCHEME);
            version = this.getModelString(VERSION);
            object = CostSplitDraftService.getDraftDataByUniKey(orgId, projectId, schemeId, version);
            ids = new ArrayList();
            if (object != null) {
                ids = object.getDynamicObjectCollection(ENTRYENTITY_1).stream().map(s -> s.getDynamicObject("costsplitmethod1").getLong("id")).distinct().collect(Collectors.toList());
            }
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            q1 = new QFilter("id", "in", ids);
            listShowParameter.getListFilterParameter().setFilter(q1);
            listShowParameter.getListFilterParameter().setFilter(q1);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Object inputValue = afterF7SelectEvent.getInputValue();
    }

    public void setComboItemsList(int maxClearPeriods, String swqsytfl) {
        ComboEdit taxstateComboEdit = (ComboEdit)this.getView().getControl(TAXSTATE);
        taxstateComboEdit.setComboItems(TaxStateEnum.getComboItem(swqsytfl));
        ComboEdit clearperiodComboEdit = (ComboEdit)this.getView().getControl(CLEARPERIOD);
        clearperiodComboEdit.setComboItems(ClearPeriodEnum.getClearPeriods(maxClearPeriods));
    }

    public void setDisPlayList2(Long orgId, Long projectId, Long schemeId, String version, int maxClearPeriods, String swqsytfl) {
        DynamicObjectCollection entryentity2 = this.getModel().getEntryEntity(ENTRYENTITY_2);
        DynamicObject object = CostSplitDraftService.getDraftDataByUniKey(orgId, projectId, schemeId, version);
        if (object != null) {
            Map<String, BigDecimal> costSplitTaxRateMapping = this.qiTaAdjDraftService.getCostSplitTaxRateMapping(object.getDynamicObjectCollection(ENTRYENTITY_1));
            Map<String, BigDecimal> spiltPeriodMapping = this.getSpiltPeriodMapping();
            for (DynamicObject row : entryentity2) {
                List<String> visibleEntity2List = this.qiTaAdjDraftService.getVisibleEntity2List(maxClearPeriods, swqsytfl);
                long methodId = this.getModelObjLongId(ENTITY_2_FTFF);
                for (String field : visibleEntity2List) {
                    BigDecimal a = this.qiTaAdjDraftService.getfqjAmount(methodId, field, spiltPeriodMapping);
                    BigDecimal b = this.qiTaAdjDraftService.getfswytfpbl(methodId, field, costSplitTaxRateMapping);
                    row.set(field, (Object)a.multiply(b).setScale(2, 4));
                }
            }
            this.getView().updateView(ENTRYENTITY_2);
        }
    }

    public Map<String, BigDecimal> getSpiltPeriodMapping() {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>(16);
        DynamicObjectCollection entity = this.getModel().getEntryEntity(ENTRYENTITY_1);
        entity.stream().forEach(e -> e.getDataEntityType().getProperties().stream().forEach(p -> {
            String name = p.getName();
            if (name.startsWith(ENTITY_1_P_)) {
                String clearPeriod = String.format("%02d", Integer.parseInt(name.split("_")[2]));
                map.put(clearPeriod, e.getBigDecimal(p));
            }
        }));
        return map;
    }

    public void setDisPlayList1(int rowIndex, Long orgId, Long projectId, Long schemeId, String version, BigDecimal newValue, int maxClearPeriods) {
        List<Map<String, Object>> rowDatas = CostSplitDraftService.getCbxmFqjRowFtbl(orgId, projectId, schemeId, version);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY_1, rowIndex);
        List<String> entity1List = this.qiTaAdjDraftService.getVisibleEntity1List(maxClearPeriods);
        BigDecimal sum = BigDecimal.ZERO;
        String lastPeriod = entity1List.get(entity1List.size() - 1);
        for (String field : entity1List) {
            BigDecimal o = (BigDecimal)rowDatas.stream().filter(s -> rowEntity.getDynamicObject(ENTITY_1_FTFF) != null).filter(s -> ((Long)s.get("costsplitmethod")).longValue() == rowEntity.getDynamicObject(ENTITY_1_FTFF).getLong("id")).map(s -> s.get("splitrate" + field.split("_")[2])).findFirst().orElseGet(() -> BigDecimal.ZERO);
            BigDecimal amount = newValue.multiply(o).setScale(2, 4);
            if (field.equals(lastPeriod) && !rowDatas.isEmpty()) {
                this.getModel().setValue(field, (Object)newValue.subtract(sum), rowIndex);
            } else {
                this.getModel().setValue(field, (Object)amount, rowIndex);
            }
            sum = sum.add(amount);
        }
    }

    public void switchInnerPage(String step) {
        this.getView().setVisible(Boolean.valueOf(DJDJ.equals(step)), new String[]{"step1content"});
        this.getView().setVisible(Boolean.valueOf(SJJJKC.equals(step)), new String[]{"step2content"});
        this.getView().setVisible(Boolean.valueOf(JJKC.equals(step)), new String[]{"step3content"});
    }

    public List<ComboItem> getVersionComboItemsList(DynamicObject object) {
        return Optional.ofNullable(object).map(s -> s.getDynamicObjectCollection("entryentity").stream().map(a -> new ComboItem(new LocaleString(a.getString("versionname")), a.getString("versioncode"))).collect(Collectors.toList())).orElseGet(() -> new ArrayList());
    }

    public void setVersionComboItemsList(DynamicObject object) {
        ComboEdit control = (ComboEdit)this.getControl(VERSION);
        control.setComboItems(this.getVersionComboItemsList(object));
    }

    private static void setStepStyle(List<String> listBanners, IFormView view, String focusPage) {
        for (String step : listBanners) {
            HashMap<String, String> colorMap;
            if (step.equals(focusPage)) {
                colorMap = new HashMap<String, String>(16);
                if (JJKC.equals(focusPage) && listBanners.size() == 1) {
                    colorMap.put("fc", "#CCCCCC");
                    colorMap.put("fw", "normal");
                } else {
                    colorMap.put("fc", "themeColor");
                    colorMap.put("fw", "bold");
                }
                view.updateControlMetadata(step, colorMap);
                continue;
            }
            colorMap = new HashMap(16);
            colorMap.put("fc", "#CCCCCC");
            colorMap.put("fw", "normal");
            view.updateControlMetadata(step, colorMap);
        }
    }

    public void setPageBannerVisible(String djdjmethod, String jjkcadjust) {
        if (Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(djdjmethod) && "1".equals(jjkcadjust)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAPSTEP_1, FLEXPANELAPSTEP_2, FLEXPANELAPSTEP_3, SPLIT_1, SPLIT_2});
        } else if (Lists.newArrayList((Object[])new String[]{"3"}).contains(djdjmethod) && "0".equals(jjkcadjust)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAPSTEP_1, FLEXPANELAPSTEP_2, SPLIT_1, SPLIT_2});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAPSTEP_3});
        } else if (Lists.newArrayList((Object[])new String[]{"1", "2"}).contains(djdjmethod) && "0".equals(jjkcadjust)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAPSTEP_2, SPLIT_1});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAPSTEP_1, FLEXPANELAPSTEP_3, SPLIT_2});
        } else if (Lists.newArrayList((Object[])new String[]{"3"}).contains(djdjmethod) && "1".equals(jjkcadjust)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAPSTEP_1, SPLIT_1});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAPSTEP_2, FLEXPANELAPSTEP_3, SPLIT_2});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAPSTEP_1, FLEXPANELAPSTEP_2, FLEXPANELAPSTEP_3, SPLIT_1, SPLIT_2});
        }
    }

    private void setPageButtonVisible(String currentStep, List<String> listBanners) {
        DynamicObject draft = this.getDraft(this.getView().getFormShowParameter().getCustomParams());
        if (JJKC.equals(currentStep) && (draft == null || "A".equals(draft.getString("billstatus")))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SAVE, RESET, RECALC});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SAVE, RESET, RECALC});
        }
        if (listBanners.size() > 1) {
            String firstPage = listBanners.get(0);
            String lastPage = listBanners.get(listBanners.size() - 1);
            if (firstPage.equals(currentStep)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD_KEY});
                this.getView().setVisible(Boolean.TRUE, new String[]{NEXT_KEY});
            } else if (lastPage.equals(currentStep)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{NEXT_KEY});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD_KEY});
                this.getView().setVisible(Boolean.TRUE, new String[]{NEXT_KEY});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{NEXT_KEY});
        }
    }

    private void rollbackPropertyChange(PropertyChangedArgs args) {
        String name = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        Object oldValue = changeSet[0].getOldValue();
        this.getModel().setValue(name, oldValue, rowIndex);
    }
}

