/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import java.util.HashMap;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.EntityOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.tcept.business.draft.QiTaAdjustDraftService;
import kd.taxc.tcept.common.utils.DraftCommonUtils;
import kd.taxc.tcept.formplugin.draft.CommonDraftListPlugin;

public class QiTaAdjustDraftListPlugin
extends CommonDraftListPlugin {
    private static final String RECALCS = "recalcs";
    private QiTaAdjustDraftService qiTaAdjDraftService = new QiTaAdjustDraftService();

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List filterColumnList = args.getCommonFilterColumns();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        List hasPermOrgList = OrgCheckUtil.hasPermOrgList((HasPermOrgResult)hasPermOrgs);
        Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (List)hasPermOrgList);
        for (FilterColumn column : filterColumnList) {
            if (!"org.id".equals(column.getFieldName()) || orgid == null) continue;
            column.setDefaultValues(new Object[]{String.valueOf(orgid)});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof EntityOperate) {
            EntityOperate operate = (EntityOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (RECALCS.equals(operateKey) && (selectedRows.size() > 1 || selectedRows.size() == 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u64cd\u4f5c\u3002", (String)"QiTaAdjustDraftListPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String operateKey = eventArgs.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if ("tblnew".equals(operateKey)) {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("tcept_qita_adjust_draft");
            param.setCustomParams(new HashMap());
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        } else if (RECALCS.equals(operateKey) && primaryKeyValues.length > 0) {
            OperationResult operationResult = this.qiTaAdjDraftService.doRecalc((Long)primaryKeyValues[0]);
            if (operationResult == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"QiTaAdjustDraftListPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
            } else if (operationResult != null && operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"QiTaAdjustDraftListPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            DraftCommonUtils.logOperation(operationResult, formShowParameter.getBillFormId(), ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570", (String)"QiTaAdjustDraftListPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]), selectedRow.getBillNo());
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refreshData();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Long pkId = (Long)list.getFocusRowPkId();
        FormShowParameter param = new FormShowParameter();
        param.setFormId("tcept_qita_adjust_draft");
        HashMap<String, Long> customParams = new HashMap<String, Long>(16);
        customParams.put("mainbillpk", pkId);
        param.setCustomParams(customParams);
        param.setStatus(OperationStatus.EDIT);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("modifytime desc");
    }
}

