/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.draft.ManualAdjustDetailService;
import kd.taxc.tcept.common.dto.AdjustRecordDto;

public class SgTzDetailFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRYENTITY_CARD = "entryentitycard";
    private static final String BIZID = "bizid";
    private static final String SUBBIZID = "subbizid";
    private static final String BIZTABLE = "biztable";
    private static final String BIZFIELD = "bizfield";
    private static final String CONVERTKEY = "convertkey";
    private static final String ADJUST_MODEL = "adjust_model";
    private static final String ADJUST_CACHE = "adjust_cache";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object bizid = customParams.get(BIZID);
        Object subbizid = customParams.get(SUBBIZID);
        String biztable = (String)customParams.get(BIZTABLE);
        String bizfield = (String)customParams.get(BIZFIELD);
        String convertkey = (String)customParams.get(CONVERTKEY);
        String adjust_model = (String)customParams.get(ADJUST_MODEL);
        Object dynamicObjectCollection = new ArrayList();
        if ("cache".equals(adjust_model)) {
            String adjust_cache = (String)customParams.get(ADJUST_CACHE);
            List list = SerializationUtils.fromJsonStringToList((String)adjust_cache, AdjustRecordDto.class);
            list.sort(Comparator.comparing(AdjustRecordDto::getUpdatetime).reversed());
            dynamicObjectCollection = list.stream().map(a -> AdjustRecordDto.transformToDynObj(a, BusinessDataServiceHelper.newDynamicObject((String)ManualAdjustDetailService.ENTITY_KEY))).collect(Collectors.toList());
        } else {
            dynamicObjectCollection = ManualAdjustDetailService.queryDataByBiz(biztable, bizid, subbizid, bizfield, convertkey);
        }
        IDataModel model = this.getModel();
        int rowindex = 0;
        if (dynamicObjectCollection.size() > 0) {
            model.beginInit();
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
            String remark = dynamicObject.getString("remark");
            String originalvalue = dynamicObject.getString("originalvalue");
            String adjustvalue = dynamicObject.getString("adjustvalue");
            String totalvalue = dynamicObject.getString("totalvalue");
            model.setValue("cardadjustexplain", (Object)remark, 0);
            model.setValue("adjustamount", (Object)ManualAdjustDetailService.convertBigDecimal(adjustvalue), 0);
            model.setValue("sumamount", (Object)ManualAdjustDetailService.convertBigDecimal(originalvalue));
            model.setValue("adjustsumamount", (Object)ManualAdjustDetailService.convertBigDecimal(totalvalue));
            model.batchCreateNewEntryRow("entryentity", dynamicObjectCollection.size());
            Iterator iterator = dynamicObjectCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject row = (DynamicObject)iterator.next();
                model.setValue("adjusttype", (Object)"2", rowindex);
                model.setValue("title", (Object)"--", rowindex);
                model.setValue("preadjust", (Object)ManualAdjustDetailService.convertBigDecimal(row.getString("beforevalue")), rowindex);
                model.setValue("postadjust", (Object)ManualAdjustDetailService.convertBigDecimal(row.getString("aftervalue")), rowindex);
                model.setValue("adjustexplain", row.get("remark"), rowindex);
                model.setValue("creator", row.get("updateor"), rowindex);
                model.setValue("createtime", (Object)row.getDate("updatetime"), rowindex);
                ++rowindex;
            }
            model.endInit();
        } else {
            String originalvalue = (String)customParams.get("originalvalue");
            model.setValue("sumamount", (Object)ManualAdjustDetailService.convertBigDecimal(originalvalue));
            model.setValue("adjustsumamount", (Object)ManualAdjustDetailService.convertBigDecimal(originalvalue));
        }
        this.getView().updateView(ENTRYENTITY_CARD);
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        DynamicObjectCollection entryentitycard;
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.equals("btnok") && this.check(entryentitycard = this.getModel().getEntryEntity(ENTRYENTITY_CARD))) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            BigDecimal sumamount = (BigDecimal)this.getModel().getValue("sumamount");
            BigDecimal adjustsumamount = (BigDecimal)this.getModel().getValue("adjustsumamount");
            String adjust_model = (String)customParams.get(ADJUST_MODEL);
            if ("cache".equals(adjust_model)) {
                AdjustRecordDto adjustRecordDto = ManualAdjustDetailService.setDataInDto(new AdjustRecordDto(), customParams, entryentitycard, sumamount, adjustsumamount);
                if (adjustRecordDto != null) {
                    this.getView().returnDataToParent((Object)adjustRecordDto);
                }
            } else {
                ManualAdjustDetailService.saveForm(customParams, entryentitycard, sumamount, adjustsumamount);
                this.getView().returnDataToParent((Object)"true");
            }
            this.getView().close();
        }
    }

    private boolean check(DynamicObjectCollection entryentitycard) {
        boolean success = true;
        DynamicObject row = (DynamicObject)entryentitycard.get(0);
        String tzsm = row.getString("cardadjustexplain");
        BigDecimal adjustamount = row.getBigDecimal("adjustamount");
        String fc = "black";
        if (adjustamount.compareTo(BigDecimal.ZERO) != 0 && StringUtil.isEmpty((CharSequence)tzsm)) {
            success = false;
            fc = "red";
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>(8);
        HashMap<String, HashMap<String, String>> properties = new HashMap<String, HashMap<String, String>>(8);
        propertiesMap.put("fc", fc);
        properties.put("cardadjustexplain", propertiesMap);
        CardEntry cardEntry = (CardEntry)this.getView().getControl(ENTRYENTITY_CARD);
        cardEntry.setCustomProperties(ENTRYENTITY_CARD, 0, properties);
        if (!success) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8c03\u6574\u8bf4\u660e\u4e3a\u5fc5\u586b\u9879\uff0c\u8bf7\u5f55\u5165\u503c\u3002", (String)"SgTzDetailFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
        }
        return success;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        int rowIndex = changeData.getRowIndex();
        if ("adjustamount".equals(name)) {
            BigDecimal newValue = (BigDecimal)changeData.getNewValue();
            BigDecimal sumamount = (BigDecimal)this.getModel().getValue("sumamount");
            this.getModel().setValue("adjustsumamount", (Object)sumamount.add(newValue), rowIndex);
        }
    }
}

