/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft.costsplit;

import com.google.common.collect.Sets;
import java.util.EventObject;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.tcept.business.basedata.CostReportDataService;

public class AbstractCostSplitRateForm
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit costitem1;
        super.registerListener(e);
        BasedataEdit costitem = (BasedataEdit)this.getView().getControl("costitem");
        if (costitem != null) {
            costitem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((costitem1 = (BasedataEdit)this.getView().getControl("costitem1")) != null) {
            costitem1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public String getAnyPeriodKey() {
        return "null";
    }

    public int getMaxPeriod() {
        int defaultMax = 30;
        for (int i = 1; i <= defaultMax; ++i) {
            if (this.getControl(this.getAnyPeriodKey() + i) != null) continue;
            return i - 1;
        }
        return defaultMax;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.startsWith("costitem")) {
            DynamicObjectCollection costitems;
            Set fbasedataid_ids;
            DynamicObjectCollection entryentity;
            Set collect;
            Sets.SetView difference;
            String formId = this.getView().getFormShowParameter().getFormId();
            Long org = Long.parseLong(this.getOrgid());
            Long houseproject = Long.parseLong(this.getProjectId());
            Long schemeId = Long.parseLong(this.getSchemeId());
            String version = this.getVersion();
            Set<Object> costitemIds = CostReportDataService.getLastLevelCostItemIdsByUniq(org, houseproject, schemeId, version);
            QFilter qFilter3 = new QFilter("id", "in", costitemIds);
            if ("tcept_cost_split_peri_rat".equals(formId) && (difference = Sets.difference(collect = (entryentity = this.getModel().getEntryEntity("entryentity")).stream().map(a -> a.getDynamicObjectCollection("costitem")).flatMap(a -> a.stream()).map(a -> a.getLong("fbasedataid_id")).collect(Collectors.toSet()), fbasedataid_ids = (costitems = (DynamicObjectCollection)this.getModel().getValue("costitem", beforeF7SelectEvent.getRow())).stream().map(a -> a.getLong("fbasedataid_id")).collect(Collectors.toSet()))).size() > 0) {
                qFilter3.and("id", "not in", (Object)difference);
            }
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            Set<String> numbers = CostReportDataService.queryCostItemsUpLevelNumbers(costitemIds);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", numbers));
            formShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("org", "=", (Object)org));
            formShowParameter.setCustomParam("custom_filter", (Object)"1");
        }
    }

    public String getProjectId() {
        return (String)this.getView().getFormShowParameter().getCustomParam("project");
    }

    public String getOrgid() {
        String org = (String)this.getView().getFormShowParameter().getCustomParam("org");
        return org == null || "null".equalsIgnoreCase(org) ? "0" : org;
    }

    public String getSchemeId() {
        String scheme = (String)this.getView().getFormShowParameter().getCustomParam("scheme");
        return scheme == null || "null".equalsIgnoreCase(scheme) ? "0" : scheme;
    }

    public String getVersion() {
        String version = (String)this.getView().getFormShowParameter().getCustomParam("version");
        return version == null || "null".equalsIgnoreCase(version) ? "0" : version;
    }

    public boolean isViewStatus() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        return OperationStatus.VIEW.equals((Object)status);
    }

    public String getClearPeriod() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel model = parentView.getModel();
            return String.valueOf(model.getValue("clearperiod"));
        }
        return "1";
    }

    public String getSwqsytfl() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            IDataModel model = parentView.getModel();
            return String.valueOf(model.getValue("swqsytfl"));
        }
        return "1";
    }
}

