/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft.costsplit;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftStepsUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.basedata.CostReportDataService;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.business.draft.ManualAdjustDetailService;
import kd.taxc.tcept.common.dto.AdjustRecordDto;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.common.utils.DraftCommonUtils;
import kd.taxc.tcept.common.utils.OrgControlUtil;

public class CostSplitDraftFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String FORWARD = "forward";
    private static final String NEXT = "next";
    private static final String SAVE = "save";
    private static final String RECALC = "recalc";
    private static final String RESET = "reset";
    private static final String REFRESH = "refresh";
    protected static final String FOCUS_STEP = "focus_step";
    protected static final String CONTENT_TAB = "tabcontent";
    private static final String PAGEID_STEP = "pageid_step";
    private static final String MAX_STEP = "max_step";
    private static final String SCHEME = "scheme";
    private static final String MAINBILLPK = "mainbillpk";
    private static final String TEMPBILLPK = "tempbillpk";
    protected static String BAR_KEY = "toolbarap";
    protected static String TOOL_BAR_DECLARE = "toolbarapdeclare";
    public static final String VERSION = "version";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit houseproject = (BasedataEdit)this.getView().getControl("houseproject");
        houseproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scheme = (BasedataEdit)this.getView().getControl(SCHEME);
        scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object pk = customParams.get(MAINBILLPK);
        if (pk != null) {
            String mainbillpk = pk instanceof Long ? ((Long)pk).toString() : (String)pk;
            this.getPageCache().put(MAINBILLPK, mainbillpk);
            DynamicObject bill = CostSplitDraftService.getDraftDataByPk(mainbillpk);
            Long org = bill.getLong("org.id");
            Long houseproject = bill.getLong("houseproject.id");
            Long scheme = bill.getLong("scheme.id");
            String billno = bill.getString("billno");
            int clearperiod = bill.getInt("clearperiod");
            String swqsytfl = bill.getString("swqsytfl");
            this.getModel().setValue("clearperiod", (Object)clearperiod);
            this.getModel().setValue("swqsytfl", (Object)swqsytfl);
            this.getModel().setValue("org", (Object)org);
            this.getModel().setValue("houseproject", (Object)houseproject);
            this.getModel().setValue(SCHEME, (Object)scheme);
            this.getModel().setValue(VERSION, (Object)bill.getString(VERSION));
            this.getModel().setValue("draftnumber", (Object)billno);
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "houseproject", SCHEME, VERSION});
            this.cacheMaxStep("3");
            this.cacheAdjust(mainbillpk);
            this.loadStepPage("1");
        } else {
            String originalbilid = (String)customParams.get("originalbilid");
            if (originalbilid != null) {
                DynamicObject draftDataByPk = CostSplitDraftService.getDraftDataByPk(originalbilid);
                if (draftDataByPk != null) {
                    Long orgid = draftDataByPk.getLong("org.id");
                    Long houseproject = draftDataByPk.getLong("houseproject.id");
                    Long scheme = draftDataByPk.getLong("scheme.id");
                    this.getModel().setValue("org", (Object)orgid);
                    this.getModel().setValue("houseproject", (Object)houseproject);
                    this.getModel().setValue(SCHEME, (Object)scheme);
                    this.getModel().setValue("draftnumber", DraftCommonUtils.readDraftNumber(orgid, "tcept_cost_split_draft"));
                    this.getModel().setValue(VERSION, (Object)draftDataByPk.getString(VERSION));
                    if (houseproject != null && houseproject != 0L && scheme != null && scheme != 0L) {
                        int clearperiod = SchemaDataService.querySchemeClearperiod(scheme);
                        String swqsytfl = TaxProjectDataService.queryProjectSwqsytfl(houseproject);
                        this.getModel().setValue("clearperiod", (Object)clearperiod);
                        this.getModel().setValue("swqsytfl", (Object)swqsytfl);
                        long longId = DBUtils.getLongId((String)"t_tcept_cost_split_draft");
                        this.getPageCache().put(TEMPBILLPK, String.valueOf(longId));
                        this.loadStepPage("1");
                        this.loadStepPage("2");
                    }
                }
            } else {
                this.setButtonVisible("1");
                this.resetAdjustCache();
                Long orgid = null;
                Long houseproject = null;
                Long scheme = null;
                String version = null;
                if (customParams.get("org") != null && customParams.get("project") != null) {
                    orgid = Long.parseLong((String)customParams.get("org"));
                    houseproject = Long.parseLong((String)customParams.get("project"));
                    scheme = Long.parseLong((String)customParams.get(SCHEME));
                    version = (String)customParams.get(VERSION);
                } else {
                    DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
                    Long org = RequestContext.get().getOrgId();
                    orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
                    if (orgid != null) {
                        Boolean approve = (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgid).getData();
                        if (!approve.booleanValue()) {
                            this.getModel().setValue("org", null);
                            return;
                        }
                        houseproject = TaxProjectDataService.queryFirstProjectByOrg(orgid);
                        scheme = SchemaDataService.queryLastScheme(orgid, houseproject);
                        List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
                        version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                    } else {
                        return;
                    }
                }
                this.getModel().setValue("org", (Object)orgid);
                this.getModel().setValue("houseproject", (Object)houseproject);
                this.getModel().setValue(SCHEME, (Object)scheme);
                this.getModel().setValue(VERSION, (Object)version);
                this.getModel().setValue("draftnumber", DraftCommonUtils.readDraftNumber(orgid, "tcept_cost_split_draft"));
                long longId = DBUtils.getLongId((String)"t_tcept_cost_split_draft");
                this.getPageCache().put(TEMPBILLPK, String.valueOf(longId));
                if (houseproject != null && houseproject != 0L && scheme != null && scheme != 0L) {
                    int clearperiod = SchemaDataService.querySchemeClearperiod(scheme);
                    String swqsytfl = TaxProjectDataService.queryProjectSwqsytfl(houseproject);
                    this.getModel().setValue("clearperiod", (Object)clearperiod);
                    this.getModel().setValue("swqsytfl", (Object)swqsytfl);
                    this.loadStepPage("1");
                }
            }
        }
        this.setVersionComboItemsList(this.getSchemeId());
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "houseproject", SCHEME, VERSION});
        }
    }

    private void cacheAdjust(String mainbillpk) {
        DynamicObjectCollection adjustDetail = ManualAdjustDetailService.queryDataByBiz("tcept_cost_split_draft_entryentity2", Long.parseLong(mainbillpk));
        List adjustRecordDtos = adjustDetail.stream().map(a -> AdjustRecordDto.transformFromDynObj(a)).collect(Collectors.toList());
        String cache1 = SerializationUtils.toJsonString(adjustRecordDtos);
        this.getView().getPageCache().put("AdjustRecordDto", cache1);
    }

    public void setVersionComboItemsList(Long schemePk) {
        ComboEdit control = (ComboEdit)this.getControl(VERSION);
        control.setComboItems(this.getVersionComboItemsList(schemePk));
    }

    public List<ComboItem> getVersionComboItemsList(Long schemePk) {
        if (schemePk != null) {
            DynamicObject dynamicObject = SchemaDataService.querySchemeSingle(schemePk);
            return dynamicObject.getDynamicObjectCollection("entryentity").stream().map(s -> new ComboItem(new LocaleString(s.getString("versionname")), s.getString("versioncode"))).collect(Collectors.toList());
        }
        return new ArrayList<ComboItem>();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "next": 
            case "forward": {
                this.lastOrNextStep(itemKey);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && RECALC.equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey()) && !this.checkCalcCondition()) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                this.save();
                break;
            }
            case "recalc": {
                this.recalc();
                break;
            }
            case "reset": {
                int clearperiod = SchemaDataService.querySchemeClearperiod(this.getSchemeId());
                String swqsytfl = TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId());
                this.getModel().setValue("clearperiod", (Object)clearperiod);
                this.getModel().setValue("swqsytfl", (Object)swqsytfl);
                this.reset();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u6210\u529f\u3002", (String)"CostSplitDraftFormPlugin_14", (String)"taxc-tcept", (Object[])new Object[0]));
                break;
            }
            case "refresh": {
                String step = this.getPageCache().get(FOCUS_STEP);
                this.refreshSubPage(step);
            }
        }
    }

    private void recalc() {
        Long billId = this.getBillId();
        if (billId != null) {
            this.getView().getPageCache().put("recalcchange", "1");
            this.refreshSubPage("3");
            this.getView().getPageCache().remove("recalcchange");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"CostSplitDraftFormPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
        }
    }

    private void showConfirmTips(String key, String msg) {
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
    }

    private void reset() {
        this.removeStepPageCache();
        this.removeStep3AdjDetail();
        this.getPageCache().put(RESET, "1");
        this.loadStepPage("1");
    }

    private void refreshSubPage(String step) {
        IFormView subView;
        String stepPageId = this.getPageCache().get(PAGEID_STEP + step);
        if (stepPageId != null && (subView = this.getView().getView(stepPageId)) != null && step.equals("3")) {
            subView.invokeOperation(REFRESH);
            this.getView().sendFormAction(subView);
        }
    }

    private void save() {
        Long orgid = this.getOrgid();
        Long projectId = this.getProjectId();
        Long schemeId = this.getSchemeId();
        String version = this.getVersion();
        int clearperiod = this.getClearperiod();
        String swqsytfl = this.getSwqsytfl();
        Long pk = this.getBillId();
        if (pk != null) {
            String pageid1 = this.getPageCache().get("pageid_step1");
            IFormView step1View1 = this.getView().getView(pageid1);
            DynamicObjectCollection fqjBlEntry = step1View1.getModel().getEntryEntity("entryentity");
            String pageid2 = this.getPageCache().get("pageid_step2");
            IFormView step1View2 = this.getView().getView(pageid2);
            DynamicObjectCollection fswytBlEntry = step1View2.getModel().getEntryEntity("entryentity");
            String pageid3 = this.getPageCache().get("pageid_step3");
            IFormView step1View3 = this.getView().getView(pageid3);
            DynamicObjectCollection fqjftbEntry = step1View3.getModel().getEntryEntity("entryentity");
            DynamicObjectCollection fswytftbEntry = step1View3.getModel().getEntryEntity("entryentity1");
            List<AdjustRecordDto> adjustRecordDtos = this.getAdjustRecordDtos();
            boolean success = CostSplitDraftService.saveFormDataToDraft(clearperiod, swqsytfl, this.getBillNo(), pk, orgid, projectId, schemeId, version, fqjBlEntry, fswytBlEntry, fqjftbEntry, fswytftbEntry, adjustRecordDtos);
            this.convertTempidToDbid();
            if (success) {
                DynamicObject draftDataByPk = CostSplitDraftService.getDraftDataByPk(pk.toString());
                this.getModel().setValue("draftnumber", (Object)draftDataByPk.getString("billno"));
                this.getView().setEnable(Boolean.FALSE, new String[]{"org", "houseproject", SCHEME, VERSION});
            }
        }
    }

    private List<AdjustRecordDto> getAdjustRecordDtos() {
        String cache = this.getView().getPageCache().get("AdjustRecordDto");
        if (cache == null) {
            return new ArrayList<AdjustRecordDto>();
        }
        return SerializationUtils.fromJsonStringToList((String)cache, AdjustRecordDto.class);
    }

    private void convertTempidToDbid() {
        String tempbillpk = this.getPageCache().get(TEMPBILLPK);
        if (tempbillpk != null) {
            this.getPageCache().put(MAINBILLPK, tempbillpk);
            this.getPageCache().remove(TEMPBILLPK);
        }
    }

    private void lastOrNextStep(String itemKey) {
        String focusPage = this.getPageCache().get(FOCUS_STEP);
        if (focusPage == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u57fa\u672c\u4fe1\u606f", (String)"CostSplitDraftFormPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]));
            return;
        }
        if (NEXT.equals(itemKey)) {
            String newFocusPage = String.valueOf(Integer.parseInt(focusPage) + 1);
            if (!this.checkBeforeNextStep(newFocusPage)) {
                return;
            }
            this.loadStepPage(newFocusPage);
        } else {
            String newFocusPage = String.valueOf(Integer.parseInt(focusPage) - 1);
            this.loadStepPage(newFocusPage);
        }
    }

    private boolean checkBeforeNextStep(String newFocusPage) {
        Long id = this.getDbBillId();
        String billStatus = CostSplitDraftService.getBillStatus(id);
        if ((StringUtil.isEmpty((CharSequence)billStatus) || "A".equals(billStatus)) && "2".equals(newFocusPage)) {
            Set<Object> costitemIds = CostReportDataService.getLastLevelCostItemIdsByUniq(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
            String pageid_step1 = this.getPageCache().get("pageid_step1");
            IFormView step1View = this.getView().getView(pageid_step1);
            DynamicObjectCollection entryentity = step1View.getModel().getEntryEntity("entryentity");
            Set formSet = entryentity.stream().filter(a -> a.getDynamicObjectCollection("costitem") != null).map(a -> a.getDynamicObjectCollection("costitem")).flatMap(a -> a.stream()).map(a -> a.get("fbasedataid_id")).collect(Collectors.toSet());
            Sets.SetView difference = Sets.difference(costitemIds, formSet);
            if (difference.size() > 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u9879\u76ee\u4e2d\u5b58\u5728\u672a\u5206\u914d\u6210\u672c\u5206\u644a\u65b9\u6cd5\u7684\u6210\u672c\u9879\u76ee\uff0c\u8bf7\u5206\u914d\u5b8c\u6bd5\u518d\u8fdb\u884c\u4e0b\u4e00\u6b65\u3002", (String)"CostSplitDraftFormPlugin_5", (String)"taxc-tcept", (Object[])new Object[0]));
                return true;
            }
            Set mustinputset = entryentity.stream().filter(a -> a.getDynamicObjectCollection("costitem") == null || a.get("costsplitmethod") == null).collect(Collectors.toSet());
            if (mustinputset.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u9879\u76ee\u3001\u6210\u672c\u5206\u644a\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u5b8c\u518d\u8fdb\u884c\u4e0b\u4e00\u6b65\u3002", (String)"CostSplitDraftFormPlugin_6", (String)"taxc-tcept", (Object[])new Object[0]));
                return false;
            }
        } else if ((StringUtil.isEmpty((CharSequence)billStatus) || "A".equals(billStatus)) && "3".equals(newFocusPage)) {
            String pageid_step2 = this.getPageCache().get("pageid_step2");
            IFormView step1View = this.getView().getView(pageid_step2);
            int clearperiod = this.getClearperiod();
            Set<Object> costitemIds = CostReportDataService.getLastLevelCostItemIdsByUniq(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
            DynamicObjectCollection entryentity = step1View.getModel().getEntryEntity("entryentity");
            Map<String, List<DynamicObject>> cleartermMap = entryentity.stream().collect(Collectors.groupingBy(a -> a.getString("clearterm1")));
            Set mustinputset = entryentity.stream().filter(a -> a.getDynamicObjectCollection("costitem1") == null || a.get("costsplitmethod1") == null || a.get("clearterm1") == null).collect(Collectors.toSet());
            if (mustinputset.size() > 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u9879\u76ee\u3001\u6210\u672c\u5206\u644a\u65b9\u6cd5\u3001\u6e05\u7b97\u5206\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u5b8c\u518d\u8fdb\u884c\u4e0b\u4e00\u6b65\u3002", (String)"CostSplitDraftFormPlugin_7", (String)"taxc-tcept", (Object[])new Object[0]));
                return false;
            }
            if (this.checkNoAllocationItem(clearperiod, costitemIds, cleartermMap)) {
                if (!this.checkRepeat(cleartermMap)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean checkRepeat(Map<String, List<DynamicObject>> cleartermMap) {
        ArrayList<String> msgs = new ArrayList<String>();
        for (Map.Entry<String, List<DynamicObject>> entry : cleartermMap.entrySet()) {
            String period = entry.getKey();
            ClearPeriodEnum byCode = ClearPeriodEnum.getByCode(period);
            List<DynamicObject> value = entry.getValue();
            HashMap<String, String> uniqmap = new HashMap<String, String>();
            for (DynamicObject dynamicObject : value) {
                DynamicObjectCollection costitem1 = dynamicObject.getDynamicObjectCollection("costitem1");
                for (DynamicObject object : costitem1) {
                    String fbasedata_id = object.getString("fbasedataid_id");
                    if (uniqmap.containsKey(fbasedata_id)) {
                        String format = String.format(ResManager.loadKDString((String)"\u201c%1s\u201d\u6210\u672c\u9879\u76ee\u4e2d\u201c%2s\u201d\u91cd\u590d\u9009\u62e9\u6210\u672c\u5206\u644a\u65b9\u6cd5\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u9879\u540e\u518d\u8fdb\u884c\u4e0b\u4e00\u6b65\u3002\r\n", (String)"CostSplitDraftFormPlugin_13", (String)"taxc-tcept", (Object[])new Object[0]), byCode.getName().getDescription(), object.getString("fbasedataid.name"));
                        msgs.add(format);
                        continue;
                    }
                    uniqmap.put(fbasedata_id, dynamicObject.getString("costsplitmethod1"));
                }
            }
        }
        if (msgs.size() > 0) {
            StringBuilder stringBuilder1 = new StringBuilder();
            for (String msg : msgs) {
                stringBuilder1.append(msg);
            }
            if (msgs.size() > 1) {
                this.getView().showMessage("", stringBuilder1.toString(), MessageTypes.Default);
            } else {
                this.getView().showErrorNotification(stringBuilder1.toString());
            }
            return false;
        }
        return true;
    }

    private boolean checkNoAllocationItem(int clearperiod, Set<Object> costitemIds, Map<String, List<DynamicObject>> cleartermMap) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i <= clearperiod; ++i) {
            ClearPeriodEnum byOrder = ClearPeriodEnum.getByOrder(i);
            if (cleartermMap.containsKey(byOrder.getCode())) {
                List<DynamicObject> dynamicObjectList = cleartermMap.get(byOrder.getCode());
                Set formSet = dynamicObjectList.stream().filter(a -> a.getDynamicObjectCollection("costitem1") != null).map(a -> a.getDynamicObjectCollection("costitem1")).flatMap(a -> a.stream()).map(a -> a.get("fbasedataid_id")).collect(Collectors.toSet());
                Sets.SetView difference = Sets.difference(costitemIds, formSet);
                if (difference.size() <= 0) continue;
                stringBuilder.append(byOrder.getName().getDescription());
                stringBuilder.append("\u3001");
                continue;
            }
            stringBuilder.append(byOrder.getName().getDescription());
            stringBuilder.append("\u3001");
        }
        if (stringBuilder.length() > 0) {
            String substring = stringBuilder.substring(0, stringBuilder.length() - 1);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u672c\u9879\u76ee\u4e2d\u5b58\u5728\u672a\u5206\u914d\u6210\u672c\u5206\u644a\u65b9\u6cd5\u7684\u6210\u672c\u9879\u76ee\uff0c\u8bf7\u5206\u914d\u5b8c\u6bd5\u518d\u8fdb\u884c\u4e0b\u4e00\u6b65\u3002", (String)"CostSplitDraftFormPlugin_9", (String)"taxc-tcept", (Object[])new Object[0]), substring));
            return true;
        }
        return true;
    }

    private boolean checkCalcCondition() {
        if (this.getOrgid() == null || this.getProjectId() == null || this.getSchemeId() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u672c\u4fe1\u606f\u3002", (String)"CostSplitDraftFormPlugin_15", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        Long id = this.getDbBillId();
        if (id != null && id != 0L) {
            IFormView subView;
            if (!"A".equals(CostSplitDraftService.getBillStatus(id))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u8fdb\u884c\u201c\u91cd\u65b0\u53d6\u6570\u201d\u3002", (String)"CostSplitDraftFormPlugin_16", (String)"taxc-tcept", (Object[])new Object[0]));
                return false;
            }
            String stepPageId = this.getPageCache().get("pageid_step3");
            if (stepPageId != null && (subView = this.getView().getView(stepPageId)) != null) {
                DynamicObjectCollection entryentity = subView.getModel().getEntryEntity("entryentity");
                boolean changedCostItem = CostSplitDraftService.isChangedCostItem(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion(), entryentity, "");
                if (changedCostItem) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u62a5\u8868\u4e2d\u7684\u6210\u672c\u9879\u76ee\u5df2\u53d8\u66f4\uff0c\u8bf7\u91cd\u7f6e\u5e95\u7a3f\u3002", (String)"CostSplitDraftFormPlugin_17", (String)"taxc-tcept", (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private void loadStepPage(String step) {
        this.lightenForStatus(step, this.getStatus(step));
        String stepPageId = this.getPageCache().get(PAGEID_STEP + step);
        if (stepPageId == null) {
            String pageFormByStep = CostSplitDraftService.getPageFormByStep(step);
            FormShowParameter param = new FormShowParameter();
            param.setFormId(pageFormByStep);
            param.setStatus(this.isOnlyEdit() ? OperationStatus.EDIT : OperationStatus.VIEW);
            Map<String, Object> customParams = this.createCustomParams();
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.InContainer);
            param.getOpenStyle().setTargetKey(this.getTargetKey(step));
            String pageid = param.getPageId();
            this.getPageCache().put(PAGEID_STEP + step, pageid);
            this.getView().showForm(param);
        } else if (step.equals("3") && "1".equals(this.getPageCache().get("manualinfochange"))) {
            this.refreshSubPage(step);
            this.getPageCache().remove("manualinfochange");
        }
        this.getPageCache().put(FOCUS_STEP, step);
        this.cacheMaxStep(step);
    }

    private String getTargetKey(String focuspage) {
        return CONTENT_TAB + focuspage;
    }

    private void cacheMaxStep(String statusStep) {
        String max_step = this.getPageCache().get(MAX_STEP);
        if (max_step != null && Integer.parseInt(statusStep) > Integer.parseInt(max_step) || max_step == null) {
            this.getPageCache().put(MAX_STEP, statusStep);
        }
    }

    private String getStatus(String focusStep) {
        String max_step = this.getPageCache().get(MAX_STEP);
        String string = max_step = max_step == null ? "1" : max_step;
        if (Integer.parseInt(focusStep) > Integer.parseInt(max_step)) {
            return focusStep;
        }
        return max_step;
    }

    protected void lightenForStatus(String focuspage, String status) {
        DraftStepsUtils.resetSteps((int)3, (String)focuspage, (String)status, (IFormView)this.getView());
        this.setButtonVisible(focuspage);
    }

    protected void setButtonVisible(String focuspage) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"tabcontent1", "tabcontent2", "tabcontent3"});
        switch (focuspage) {
            case "1": {
                this.getView().setVisible(Boolean.FALSE, new String[]{FORWARD, SAVE, RECALC});
                this.getView().setVisible(Boolean.TRUE, new String[]{NEXT, "tabcontent1"});
                break;
            }
            case "2": {
                this.getView().setVisible(Boolean.FALSE, new String[]{SAVE, RECALC});
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD, NEXT, "tabcontent2"});
                break;
            }
            case "3": {
                this.getView().setVisible(Boolean.FALSE, new String[]{NEXT});
                this.getView().setVisible(Boolean.TRUE, new String[]{FORWARD, SAVE, RECALC, "tabcontent3"});
                this.getView().setVisible(Boolean.valueOf(this.isOnlyEdit()), new String[]{SAVE, RECALC});
            }
        }
    }

    private boolean isOnlyEdit() {
        return !"B".equals(CostSplitDraftService.getBillStatus(this.getDbBillId())) && !"C".equals(CostSplitDraftService.getBillStatus(this.getDbBillId()));
    }

    private Map<String, Object> createCustomParams() {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Long orgid = this.getOrgid();
        customParams.put("org", String.valueOf(orgid == null ? 0L : orgid));
        Long projectId = this.getProjectId();
        customParams.put("project", String.valueOf(projectId == null ? 0L : projectId));
        Long schemeId = this.getSchemeId();
        customParams.put(SCHEME, String.valueOf(schemeId == null ? 0L : schemeId));
        customParams.put(VERSION, this.getVersion());
        customParams.put(MAINBILLPK, this.getPageCache().get(MAINBILLPK));
        customParams.put(TEMPBILLPK, this.getPageCache().get(TEMPBILLPK));
        customParams.put(RESET, this.getPageCache().get(RESET));
        customParams.put("originalbilid", this.getView().getFormShowParameter().getCustomParam("originalbilid"));
        for (int i = 1; i <= 3; ++i) {
            String pageid_step = this.getPageCache().get(PAGEID_STEP + i);
            if (pageid_step == null) continue;
            customParams.put(PAGEID_STEP + i, pageid_step);
        }
        return customParams;
    }

    private String getBillNo() {
        return (String)this.getModel().getValue("draftnumber");
    }

    public Long getDbBillId() {
        String pk = this.getPageCache().get(MAINBILLPK);
        return pk != null ? Long.valueOf(Long.parseLong(pk)) : null;
    }

    public Long getBillId() {
        String mainbillpk = this.getPageCache().get(MAINBILLPK);
        String tempbillpk = this.getPageCache().get(TEMPBILLPK);
        String pk = null;
        if (mainbillpk != null && !"null".equals(mainbillpk)) {
            pk = mainbillpk;
        } else if (tempbillpk != null && !"null".equals(tempbillpk)) {
            pk = tempbillpk;
        }
        return pk != null ? Long.valueOf(Long.parseLong(pk)) : null;
    }

    public Long getOrgid() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        return org == null ? null : Long.valueOf(org.getLong("id"));
    }

    public Long getProjectId() {
        DynamicObject houseproject = (DynamicObject)this.getModel().getValue("houseproject");
        return houseproject == null ? null : Long.valueOf(houseproject.getLong("id"));
    }

    public Long getSchemeId() {
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        return scheme == null ? null : Long.valueOf(scheme.getLong("id"));
    }

    public String getVersion() {
        return (String)this.getModel().getValue(VERSION);
    }

    public int getClearperiod() {
        return (Integer)this.getModel().getValue("clearperiod");
    }

    public String getSwqsytfl() {
        return (String)this.getModel().getValue("swqsytfl");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("org".equals(name) || "houseproject".equals(name) || SCHEME.equals(name)) {
            ChangeData changeData = e.getChangeSet()[0];
            DynamicObject newValue = (DynamicObject)changeData.getNewValue();
            IDataModel model = this.getModel();
            model.beginInit();
            if ("org".equals(name)) {
                if (newValue == null) {
                    model.setValue("houseproject", null);
                    model.setValue(SCHEME, null);
                    model.setValue(VERSION, null);
                } else {
                    Long houseproject = TaxProjectDataService.queryFirstProjectByOrg(this.getOrgid());
                    Long scheme = SchemaDataService.queryLastScheme(this.getOrgid(), houseproject);
                    List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
                    String version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                    model.setValue("houseproject", (Object)houseproject);
                    model.setValue(SCHEME, (Object)scheme);
                    model.setValue(VERSION, (Object)version);
                }
                String swqsytfl = TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId());
                this.getModel().setValue("swqsytfl", (Object)swqsytfl);
                int clearperiod = SchemaDataService.querySchemeClearperiod(this.getSchemeId());
                this.getModel().setValue("clearperiod", (Object)clearperiod);
            } else if ("houseproject".equals(name)) {
                if (newValue == null) {
                    model.setValue(SCHEME, null);
                    model.setValue(VERSION, null);
                } else {
                    Long scheme = SchemaDataService.queryLastScheme(this.getOrgid(), this.getProjectId());
                    List<ComboItem> comboItems = this.getVersionComboItemsList(scheme);
                    String version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                    model.setValue(SCHEME, (Object)scheme);
                    model.setValue(VERSION, (Object)version);
                }
                String swqsytfl = TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId());
                this.getModel().setValue("swqsytfl", (Object)swqsytfl);
                int clearperiod = SchemaDataService.querySchemeClearperiod(this.getSchemeId());
                this.getModel().setValue("clearperiod", (Object)clearperiod);
            } else if (SCHEME.equals(name)) {
                if (newValue == null) {
                    model.setValue(VERSION, null);
                } else {
                    List<ComboItem> comboItems = this.getVersionComboItemsList(this.getSchemeId());
                    String version = comboItems.isEmpty() ? null : comboItems.get(0).getValue();
                    model.setValue(VERSION, (Object)version);
                }
                int clearperiod = SchemaDataService.querySchemeClearperiod(this.getSchemeId());
                this.getModel().setValue("clearperiod", (Object)clearperiod);
            }
            model.endInit();
            this.setVersionComboItemsList(this.getSchemeId());
            this.getView().updateView("flexpanelap9");
            if (this.getOrgid() == null || this.getOrgid() == 0L || this.getProjectId() == null || this.getProjectId() == 0L || this.getSchemeId() == null || this.getSchemeId() == 0L || this.getVersion() != null) {
                // empty if block
            }
            this.reset();
        }
        if (VERSION.equals(name)) {
            if (this.getOrgid() != null && this.getOrgid() != 0L && StringUtil.isEmpty((CharSequence)this.getBillNo())) {
                this.getModel().setValue("draftnumber", DraftCommonUtils.readDraftNumber(this.getOrgid(), "tcept_cost_split_draft"));
            }
            this.reset();
        }
    }

    private void removeStepPageCache() {
        for (int step = 1; step <= 3; ++step) {
            this.getPageCache().remove(PAGEID_STEP + step);
        }
        this.getPageCache().remove(FOCUS_STEP);
        this.getPageCache().remove(MAX_STEP);
    }

    public void pageRelease(EventObject e) {
        this.removeStep3AdjDetail();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.removeStep3AdjDetail();
    }

    private void removeStep3AdjDetail() {
        this.resetAdjustCache();
    }

    private void resetAdjustCache() {
        String jsonString = SerializationUtils.toJsonString(new ArrayList());
        this.getPageCache().put("AdjustRecordDto", jsonString);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (name.startsWith("houseproject")) {
            if (this.getOrgid() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"CostSplitDraftFormPlugin_11", (String)"taxc-tcept", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            QFilter qFilter3 = new QFilter("taxorg", "=", (Object)this.getOrgid());
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getTreeFilterParameter().getQFilters().add(new QFilter("number", "in", (Object)"001"));
            listShowParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)"001"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("focusNodeId", (Object)"1888314377338207232");
        }
        if (name.startsWith(SCHEME)) {
            if (this.getOrgid() == null || this.getProjectId() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u548c\u623f\u5730\u4ea7\u9879\u76ee\u3002", (String)"CostSplitDraftFormPlugin_12", (String)"taxc-tcept", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
            }
            QFilter qFilter2 = new QFilter("org", "=", (Object)this.getOrgid());
            QFilter qFilter3 = new QFilter("project", "=", (Object)this.getProjectId());
            beforeF7SelectEvent.getCustomQFilters().add(qFilter2);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter3);
        }
        if (name.startsWith("org")) {
            List<Long> permOrgs = OrgControlUtil.getPermOrgs(this.getView());
            QFilter qFilter2 = new QFilter("id", "in", permOrgs);
            beforeF7SelectEvent.getCustomQFilters().add(qFilter2);
        }
    }
}

