/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft.costsplit;

import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class CostSplitDraftListPlugin
extends AbstractListPlugin {
    private static final String RECALCS = "recalcs";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof EntityOperate) {
            EntityOperate operate = (EntityOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (("copynew".equals(operateKey) || RECALCS.equals(operateKey)) && (selectedRows.size() > 1 || selectedRows.size() == 0)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u64cd\u4f5c\u3002", (String)"CostSplitDraftListPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (RECALCS.equals(operateKey)) {
            ListSelectedRow selectedRow = selectedRows.get(0);
            OperationResult operationResult = CostSplitDraftService.reCalcOne(selectedRow.getPrimaryKeyValue(), false);
            if (operationResult == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"CostSplitDraftListPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
            } else if (operationResult != null && operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"CostSplitDraftListPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            DraftCommonUtils.logOperation(operationResult, formShowParameter.getBillFormId(), ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570", (String)"CostSplitDraftListPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]), selectedRow.getBillNo());
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refreshData();
        } else if ("createnew".equals(operateKey)) {
            HashMap customParams = new HashMap();
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcept_cost_split_page", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        } else if ("copynew".equals(operateKey) && selectedRows.size() == 1) {
            FormShowParameter param = new FormShowParameter();
            HashMap<String, String> customParams = new HashMap<String, String>();
            customParams.put("originalbilid", selectedRows.get(0).getPrimaryKeyValue().toString());
            param.setFormId("tcept_cost_split_page");
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("billno".equals(args.getFieldName())) {
            args.setCancel(true);
            BillListHyperLinkClickEvent billListHyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            FormShowParameter param = new FormShowParameter();
            HashMap<String, String> customParams = new HashMap<String, String>();
            Object primaryKeyValue = billListHyperLinkClickEvent.getCurrentRow().getPrimaryKeyValue();
            customParams.put("mainbillpk", primaryKeyValue.toString());
            String billstate = billListHyperLinkClickEvent.getCurrentRow().getBillStatus();
            OperationStatus operationStatus = "B".equals(billstate) || "C".equals(billstate) ? OperationStatus.VIEW : OperationStatus.EDIT;
            param.setFormId("tcept_cost_split_page");
            param.setCustomParams(customParams);
            param.setStatus(operationStatus);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(param);
        }
    }
}

