/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft.costsplit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.common.constant.CostSplitFieldMappingEnum;
import kd.taxc.tcept.formplugin.draft.costsplit.AbstractCostSplitRateForm;

public class CostSplitPeriodRateFormPlugin
extends AbstractCostSplitRateForm
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String scheme = (String)customParams.get("scheme");
        Object mainbillpk = customParams.get("mainbillpk");
        String originalbilid = (String)customParams.get("originalbilid");
        String reset = (String)customParams.get("reset");
        String version = (String)customParams.get("version");
        String billpk = null;
        if (mainbillpk != null && !"null".equals(mainbillpk)) {
            billpk = mainbillpk;
        } else if (originalbilid != null) {
            billpk = originalbilid;
        }
        if (billpk != null && !"1".equals(reset)) {
            DynamicObjectCollection dynamicObjectCollection = CostSplitDraftService.getDraftDataPeriodRateEntryByPk(billpk.toString());
            CostSplitDraftService.paddingDataDbToForm(this.getModel().getEntryEntity("entryentity"), dynamicObjectCollection, "rowid", "period", CostSplitFieldMappingEnum.getAllConvertColumnByForm("tcept_cost_split_peri_rat"), (m, n) -> {});
            this.getView().updateView("entryentity");
        }
        int maxPeriod = this.getMaxPeriod();
        for (int i = 1; i <= maxPeriod; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"basenum" + i, "splitrate" + i});
        }
        if (scheme != null && !"null".equals(scheme)) {
            int clearperiod = Integer.parseInt(this.getClearPeriod());
            for (int i = 1; i <= clearperiod; ++i) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"basenum" + i, "splitrate" + i});
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities;
        for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
            this.getModel().setValue("rowid", (Object)DBUtils.getLongId((String)"t_tcept_cbftdg_fqj"), rowDataEntity.getRowIndex());
        }
    }

    @Override
    public String getAnyPeriodKey() {
        return "basenum";
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.startsWith("basenum")) {
            int max;
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal basenumHj = BigDecimal.ZERO;
            for (int i = max = this.getMax(); i > 0; --i) {
                BigDecimal basenum = (BigDecimal)this.getModel().getValue("basenum" + i, rowIndex);
                basenumHj = basenumHj.add(basenum);
            }
            this.getModel().setValue("basenum0", (Object)basenumHj);
            BigDecimal splitrateHj = BigDecimal.ZERO;
            for (int i = max; i > 0; --i) {
                if (basenumHj.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal basenum = (BigDecimal)this.getModel().getValue("basenum" + i, rowIndex);
                    BigDecimal splitrate = basenum.divide(basenumHj, 4, 4);
                    if (i == 1) {
                        this.getModel().setValue("splitrate" + i, (Object)BigDecimal.ONE.subtract(splitrateHj));
                        continue;
                    }
                    this.getModel().setValue("splitrate" + i, (Object)splitrate);
                    splitrateHj = splitrateHj.add(splitrate);
                    continue;
                }
                this.getModel().setValue("splitrate" + i, (Object)BigDecimal.ZERO);
            }
        }
        if (null != this.getView().getParentView()) {
            this.getView().getParentView().getPageCache().put("manualinfochange", "1");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public int getMax() {
        String scheme = (String)this.getView().getFormShowParameter().getCustomParam("scheme");
        return SchemaDataService.querySchemeClearperiod(Long.parseLong(scheme));
    }
}

