/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft.costsplit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.business.draft.ManualAdjustDetailService;
import kd.taxc.tcept.common.constant.CostSplitFieldMappingEnum;
import kd.taxc.tcept.common.dto.AdjustRecordDto;
import kd.taxc.tcept.common.enums.ClearPeriodEnum;
import kd.taxc.tcept.formplugin.draft.costsplit.AbstractCostSplitRateForm;

public class CostSplitTableFormPlugin
extends AbstractCostSplitRateForm
implements BeforeF7SelectListener,
HyperLinkClickListener {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid reportlist = (EntryGrid)this.getView().getControl("entryentity");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addPackageDataListener(a -> this.packageData((PackageDataEvent)a));
    }

    public void afterCreateNewData(EventObject e) {
        this.loadPageData();
    }

    private void loadPageData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object mainbillpk = customParams.get("mainbillpk");
        String project = (String)customParams.get("project");
        String org = (String)customParams.get("org");
        String scheme = (String)customParams.get("scheme");
        DynamicObjectCollection entryentityFqj = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection entryentityFswyt = this.getModel().getEntryEntity("entryentity1");
        int clearperiod = Integer.parseInt(this.getClearPeriod());
        String swqsytfl = this.getSwqsytfl();
        if (mainbillpk != null && (this.isViewStatus() || !this.isNeedRecalc())) {
            Optional<DynamicObject> costitem1;
            DynamicObject draftDataByPk = CostSplitDraftService.getDraftDataByPk(mainbillpk.toString());
            DynamicObjectCollection dynamicObjectCollection2 = draftDataByPk.getDynamicObjectCollection("entryentity2");
            CostSplitDraftService.paddingDataDbToForm(entryentityFqj, dynamicObjectCollection2, "rowid2", "period2", CostSplitFieldMappingEnum.getAllConvertColumnByForm("tcept_cost_split_table_fqj"), (formObj, dbObj) -> {
                formObj.set("lastlevel", (Object)(3 == dbObj.getInt("costitem2.level") ? Boolean.TRUE.booleanValue() : dbObj.getBoolean("costitem2.isleaf")));
                formObj.set("costitemname", CostSplitDraftService.formatCostItemName(dbObj.getString("costitem2.name"), dbObj.getInt("costitem2.level")));
            });
            DynamicObjectCollection dynamicObjectCollection3 = draftDataByPk.getDynamicObjectCollection("entryentity3");
            CostSplitDraftService.paddingDataDbToForm(entryentityFswyt, dynamicObjectCollection3, "rowid3", "period3", CostSplitFieldMappingEnum.getAllConvertColumnByForm("tcept_cost_split_table_fswyt"), (formObj, dbObj) -> formObj.set("costitemname1", CostSplitDraftService.formatCostItemName(dbObj.getString("costitem3.name"), dbObj.getInt("costitem3.level"))));
            Optional<DynamicObject> costitem = entryentityFqj.stream().filter(a -> a.get("costitem") == null).findFirst();
            if (costitem.isPresent()) {
                costitem.get().set("costitemname", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostSplitTableFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
            }
            if ((costitem1 = entryentityFswyt.stream().filter(a -> a.get("costitem1") == null).findFirst()).isPresent()) {
                costitem1.get().set("costitemname1", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostSplitTableFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
            }
        } else {
            String pageid_step1 = (String)customParams.get("pageid_step1");
            String pageid_step2 = (String)customParams.get("pageid_step2");
            String version = (String)customParams.get("version");
            IFormView step1View = this.getParentView().getView(pageid_step1);
            DynamicObjectCollection entryentity = step1View.getModel().getEntryEntity("entryentity");
            Map<Long, Map<String, BigDecimal>> cbxmFqjFtblMap = CostSplitDraftService.getCbxmFqjFtbl(clearperiod, entryentity);
            IFormView step1View2 = this.getParentView().getView(pageid_step2);
            DynamicObjectCollection entryentity2 = step1View2.getModel().getEntryEntity("entryentity");
            Map<Long, Map<String, DynamicObject>> cbxmFswytFtbl = CostSplitDraftService.getCbxmFswytFtbl(entryentity2);
            List<AdjustRecordDto> adjustRecordDtos = this.getAdjustRecordDtos();
            List<Map<String, Object>> fqjTable = this.loadFqjTable(clearperiod, cbxmFqjFtblMap, Long.parseLong(org), Long.parseLong(project), Long.parseLong(scheme), version, adjustRecordDtos);
            this.loadFqnswytTable(clearperiod, cbxmFswytFtbl, fqjTable);
        }
        this.setFeildsVisible(clearperiod, swqsytfl);
        this.setCellHighLight();
        this.getView().updateView();
    }

    private boolean isNeedRecalc() {
        String s = this.getParentView().getPageCache().get("manualinfochange");
        String s1 = this.getParentView().getPageCache().get("recalcchange");
        String adjust_fire = this.getParentView().getPageCache().get("adjust_fire");
        return "1".equals(s) || "1".equals(s1) || "1".equals(adjust_fire);
    }

    private IFormView getParentView() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostSplitTableFormPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
        }
        return parentView;
    }

    private void setFeildsVisible(int clearperiod, String swqsytfl) {
        int i;
        int maxPeriod = this.getMaxPeriod();
        for (i = clearperiod + 1; i <= maxPeriod; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryfield1groupap" + i, "entryfieldgroupap" + i});
        }
        for (i = 1; i <= clearperiod; ++i) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entryfield1groupap" + i, "entryfieldgroupap" + i});
        }
        for (i = 1; i <= clearperiod; ++i) {
            this.getView().setVisible(Boolean.valueOf(!"0".equals(swqsytfl)), new String[]{"fptzztaxamount" + i, "fptzznotaxamount" + i});
        }
    }

    private void setCellHighLight() {
        List<AdjustRecordDto> objects;
        Long tzDetailBizId = this.getTzDetailBizId();
        if (tzDetailBizId != null && (objects = this.getAdjustRecordDtos()) != null) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            Map<String, Integer> rowindexMap = entryentity.stream().collect(Collectors.toMap(a -> a.getString("costitem.id"), b -> b.getInt("seq") - 1, (m, n) -> m));
            Map<String, List<AdjustRecordDto>> collect = objects.stream().collect(Collectors.groupingBy(a -> a.getSubbizid() + a.getBizfield() + a.getConvertkey()));
            for (Map.Entry<String, List<AdjustRecordDto>> entry : collect.entrySet()) {
                entry.getValue().sort(Comparator.comparing(a -> a.getUpdatetime()));
                AdjustRecordDto first = entry.getValue().get(0);
                String subbizid = first.getSubbizid().toString();
                if (!rowindexMap.containsKey(subbizid)) continue;
                String period = first.getConvertkey();
                String bizfield = first.getBizfield();
                String suffix = CostSplitDraftService.getSuffixByPeriod(period);
                MetadataUtil.setCellColor((Control)entryGrid, (int)rowindexMap.get(subbizid), (String)(bizfield + suffix), (String)"#DCFAE4");
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit fieldEdit = (FieldEdit)e.getSource();
        String key = fieldEdit.getKey();
        if (key.equals("costitemname") && ResManager.loadKDString((String)"\u5408\u8ba1", (String)"CostSplitTableFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]).equals(e.getFormatValue())) {
            ArrayList<String> list = this.getAllFieldControl();
            e.getNoLinkKey().addAll(list);
        } else if (!e.getRowData().getBoolean("lastlevel")) {
            ArrayList<String> list = this.getAllFieldControl();
            e.getNoLinkKey().addAll(list);
        }
    }

    private ArrayList<String> getAllFieldControl() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 1; i < 11; ++i) {
            list.add("taxamount" + i);
            list.add("notaxamount" + i);
        }
        return list;
    }

    @Override
    public String getAnyPeriodKey() {
        return "ptzztaxamount";
    }

    private void loadFqnswytTable(int clearperiod, Map<Long, Map<String, DynamicObject>> cbxmFswytFtbl, List<Map<String, Object>> fqjTable) {
        List<Map<String, Object>> fswytTable = CostSplitDraftService.calcCbftbFswyt(clearperiod, cbxmFswytFtbl, fqjTable);
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity1");
        if (fswytTable.size() > 0) {
            model.batchCreateNewEntryRow("entryentity1", fswytTable.size());
            model.beginInit();
            int rowIndex = 0;
            for (Map<String, Object> map : fswytTable) {
                model.setValue("costitem1", map.get("costitem1"), rowIndex);
                model.setValue("rowid1", map.get("rowid1"), rowIndex);
                model.setValue("costitemname1", map.get("costitemname1"), rowIndex);
                for (int i = 1; i <= clearperiod; ++i) {
                    model.setValue("ptzztaxamount" + i, map.get("ptzztaxamount" + i), rowIndex);
                    model.setValue("ptzznotaxamount" + i, map.get("ptzznotaxamount" + i), rowIndex);
                    model.setValue("fptzztaxamount" + i, map.get("fptzztaxamount" + i), rowIndex);
                    model.setValue("fptzznotaxamount" + i, map.get("fptzznotaxamount" + i), rowIndex);
                    model.setValue("qtlxfctaxamount" + i, map.get("qtlxfctaxamount" + i), rowIndex);
                    model.setValue("qtlxfcnotaxamount" + i, map.get("qtlxfcnotaxamount" + i), rowIndex);
                    model.setValue("fqsyttaxamount" + i, map.get("fqsyttaxamount" + i), rowIndex);
                    model.setValue("fqsytnotaxamount" + i, map.get("fqsytnotaxamount" + i), rowIndex);
                }
                ++rowIndex;
            }
            model.endInit();
        }
    }

    private List<Map<String, Object>> loadFqjTable(int clearperiod, Map<Long, Map<String, BigDecimal>> cbxmFqjFtblMap, Long org, Long project, Long scheme, String version, List<AdjustRecordDto> adjustRecordDtos) {
        Long bizid = this.getTzDetailBizId();
        List<Map<String, Object>> fqjTable = CostSplitDraftService.calcCbftbFqj(clearperiod, org, project, scheme, version, cbxmFqjFtblMap, false, bizid, adjustRecordDtos);
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData("entryentity");
        int rowIndex = 0;
        if (fqjTable.size() > 0) {
            model.batchCreateNewEntryRow("entryentity", fqjTable.size());
            for (Map<String, Object> map : fqjTable) {
                model.setValue("costitem", map.get("costitem"), rowIndex);
                model.setValue("rowid", map.get("rowid"), rowIndex);
                Object costitemname = map.get("costitemname");
                model.setValue("costitemname", costitemname, rowIndex);
                model.setValue("lastlevel", map.get("lastlevel"), rowIndex);
                for (int i = 0; i <= clearperiod; ++i) {
                    model.setValue("taxamount" + i, map.get("taxamount" + i), rowIndex);
                    model.setValue("notaxamount" + i, map.get("notaxamount" + i), rowIndex);
                }
                ++rowIndex;
            }
            model.endInit();
        }
        return fqjTable;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("tcept_adj_record_pop") && (returnData = closedCallBackEvent.getReturnData()) instanceof AdjustRecordDto) {
            String cache = this.putAddAdjust((AdjustRecordDto)returnData);
            this.getParentView().getPageCache().put("adjust_fire", "1");
            this.loadPageData();
        }
    }

    private String putAddAdjust(AdjustRecordDto returnData) {
        List<AdjustRecordDto> objects = this.getAdjustRecordDtos();
        ArrayList<AdjustRecordDto> adjustRecordDtoAarryaList = new ArrayList<AdjustRecordDto>();
        adjustRecordDtoAarryaList.add(returnData);
        adjustRecordDtoAarryaList.addAll(objects);
        adjustRecordDtoAarryaList.sort(Comparator.comparing(AdjustRecordDto::getUpdatetime).reversed());
        String cache1 = SerializationUtils.toJsonString(adjustRecordDtoAarryaList);
        this.getParentView().getPageCache().put("AdjustRecordDto", cache1);
        return cache1;
    }

    private List<AdjustRecordDto> getAdjustRecordDtos() {
        String cache = this.getParentView().getPageCache().get("AdjustRecordDto");
        if (cache == null) {
            return new ArrayList<AdjustRecordDto>();
        }
        return SerializationUtils.fromJsonStringToList((String)cache, AdjustRecordDto.class);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String fieldName = hyperLinkClickEvent.getFieldName();
        String suffix = null;
        String bizfield = "";
        if (fieldName.startsWith("notaxamount")) {
            suffix = fieldName.replace("notaxamount", "");
            bizfield = "notaxamount";
        } else if (fieldName.startsWith("taxamount")) {
            suffix = fieldName.replace("taxamount", "");
            bizfield = "taxamount";
        }
        if (suffix != null) {
            ClearPeriodEnum byOrder = ClearPeriodEnum.getByOrder(Integer.parseInt(suffix));
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            Object subbizid = rowEntity.get("costitem.id");
            Long bizid = this.getTzDetailBizId();
            String biztable = "tcept_cost_split_draft_entryentity2";
            String convertkey = byOrder.getCode();
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put("bizid", bizid);
            customParams.put("subbizid", subbizid);
            customParams.put("biztable", biztable);
            customParams.put("bizfield", bizfield);
            customParams.put("convertkey", convertkey);
            customParams.put(ManualAdjustDetailService.BIZSTATUS, ManualAdjustDetailService.BIZSTATUS_TEMP);
            customParams.put("originalvalue", ((BigDecimal)this.getModel().getValue(fieldName, rowIndex)).toPlainString());
            List<AdjustRecordDto> adjustRecordDtos = this.getAdjustRecordDtos();
            String finalBizfield = bizfield;
            List collect = adjustRecordDtos.stream().filter(a -> subbizid.equals(a.getSubbizid())).filter(a -> Objects.equals(convertkey, a.getConvertkey())).filter(a -> Objects.equals(finalBizfield, a.getBizfield())).collect(Collectors.toList());
            String cache1 = SerializationUtils.toJsonString(collect);
            customParams.put("adjust_cache", cache1);
            customParams.put("adjust_model", "cache");
            String billStatus = CostSplitDraftService.getBillStatus(bizid);
            OperationStatus status = OperationStatus.EDIT;
            if ("B".equals(billStatus) || "C".equals(billStatus)) {
                status = OperationStatus.VIEW;
            }
            PageShowCommon.showForm((OperationStatus)status, (ShowType)ShowType.Modal, (String)"tcept_adj_record_pop", (IFormView)this.getView(), customParams, (IFormPlugin)this);
        }
    }

    private Long getTzDetailBizId() {
        Object mainbillpk = this.getView().getFormShowParameter().getCustomParam("mainbillpk");
        Object tempbillpk = this.getView().getFormShowParameter().getCustomParam("tempbillpk");
        Long bizid = null;
        if (mainbillpk != null && !"null".equals(mainbillpk)) {
            bizid = Long.parseLong((String)mainbillpk);
        } else if (tempbillpk != null && !"null".equals(tempbillpk)) {
            bizid = Long.parseLong((String)tempbillpk);
        }
        return bizid;
    }
}

