/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.draft.costsplit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.draft.CostSplitDraftService;
import kd.taxc.tcept.common.constant.CostSplitFieldMappingEnum;
import kd.taxc.tcept.formplugin.draft.costsplit.AbstractCostSplitRateForm;

public class CostSplitTaxRateFormPlugin
extends AbstractCostSplitRateForm
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object mainbillpk = customParams.get("mainbillpk");
        String originalbilid = (String)customParams.get("originalbilid");
        String reset = (String)customParams.get("reset");
        String billpk = null;
        if (mainbillpk != null && !"null".equals(mainbillpk)) {
            billpk = mainbillpk;
        } else if (originalbilid != null) {
            billpk = originalbilid;
        }
        if (billpk != null && !"1".equals(reset)) {
            DynamicObjectCollection dynamicObjectCollection1 = CostSplitDraftService.getDraftDataByPk(billpk.toString()).getDynamicObjectCollection("entryentity1");
            CostSplitDraftService.paddingDataDbToForm(this.getModel().getEntryEntity("entryentity"), dynamicObjectCollection1, "id", "", CostSplitFieldMappingEnum.getAllConvertColumnByForm("tcept_cost_split_taxt_rat"), (m, n) -> {});
            this.getView().updateView("entryentity");
        }
        String swqsytfl = this.getSwqsytfl();
        this.getView().setVisible(Boolean.valueOf(!"0".equals(swqsytfl)), new String[]{"basenum2", "splitrate2"});
    }

    public void afterBindData(EventObject e) {
        this.updateClearPeriodCombo();
    }

    private void updateClearPeriodCombo() {
        int clearperiod = Integer.parseInt(this.getClearPeriod());
        List<ComboItem> clearterms = SchemaDataService.getItemsByClearPeriod(clearperiod);
        if (EmptyCheckUtils.isNotEmpty(clearterms)) {
            ComboEdit mulComboEdit1 = (ComboEdit)this.getView().getControl("clearterm1");
            mulComboEdit1.setComboItems(clearterms);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.startsWith("basenum")) {
            int max;
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            BigDecimal basenumHj = BigDecimal.ZERO;
            for (int i = max = this.getMax(); i > 0; --i) {
                BigDecimal basenum = (BigDecimal)this.getModel().getValue("basenum" + i, rowIndex);
                basenumHj = basenumHj.add(basenum);
            }
            this.getModel().setValue("basenum0", (Object)basenumHj);
            BigDecimal splitrateHj = BigDecimal.ZERO;
            for (int i = max; i > 0; --i) {
                if (basenumHj.compareTo(BigDecimal.ZERO) != 0) {
                    BigDecimal basenum = (BigDecimal)this.getModel().getValue("basenum" + i, rowIndex);
                    BigDecimal splitrate = basenum.divide(basenumHj, 4, 4);
                    if (i == 1) {
                        this.getModel().setValue("splitrate" + i, (Object)BigDecimal.ONE.subtract(splitrateHj));
                        continue;
                    }
                    this.getModel().setValue("splitrate" + i, (Object)splitrate);
                    splitrateHj = splitrateHj.add(splitrate);
                    continue;
                }
                this.getModel().setValue("splitrate" + i, (Object)BigDecimal.ZERO);
            }
        }
        if (null != this.getView().getParentView()) {
            this.getView().getParentView().getPageCache().put("manualinfochange", "1");
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    public int getMax() {
        return 4;
    }
}

