/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.measure;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.business.draft.ManualAdjustDetailService;
import kd.taxc.tcept.business.measure.LandValueTaxLiquCalcService;
import kd.taxc.tcept.common.dto.AdjustRecordDto;
import kd.taxc.tcept.common.enums.LandValueTaxTableEnum;
import kd.taxc.tcept.formplugin.draft.AbstractDraftBillEditPlugin;

public class LandValueTaxLiquCalcBillEditPlugin
extends AbstractDraftBillEditPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final ArrayList<String> AllFieldControls = new ArrayList(){
        {
            for (int i = 1; i < 11; ++i) {
                this.add("ptzz" + i);
                this.add("fptzz" + i);
                this.add("qtlxfc" + i);
                this.add("fqsyt" + i);
            }
        }
    };

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid reportlist = (EntryGrid)this.getView().getControl("entryentity");
        reportlist.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        EntryGrid entryentity = (EntryGrid)this.getControl("entryentity");
        entryentity.addPackageDataListener(a -> this.packageData((PackageDataEvent)a));
    }

    private void packageData(PackageDataEvent e) {
        FieldEdit fieldEdit = (FieldEdit)e.getSource();
        String key = fieldEdit.getKey();
        DynamicObject rowData = e.getRowData();
        int rowno = rowData.getInt("rowno");
        if (LandValueTaxTableEnum.item_12.getRowNo() != rowno) {
            e.getNoLinkKey().addAll(AllFieldControls);
        }
        if (rowno <= 20 && rowno >= 15 && key.startsWith("fqsyt")) {
            e.setFormatValue((Object)"\u2014\u2014");
        } else if (rowno <= 17 && rowno >= 15 && key.startsWith("hj")) {
            e.setFormatValue((Object)"\u2014\u2014");
        } else if (rowno <= 17 && rowno >= 15 && AllFieldControls.contains(key)) {
            Object formatValue = e.getFormatValue();
            DecimalFormat df = new DecimalFormat("#0.00");
            BigDecimal bigDecimal = new BigDecimal(formatValue.toString());
            String str = df.format(bigDecimal.multiply(BigDecimal.TEN).multiply(BigDecimal.TEN));
            e.setFormatValue((Object)(str + "%"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!"true".equals(this.getModel().getContextVariable("isChangingMainOrg"))) {
            Long orgid = null;
            Long project = null;
            Long scheme = null;
            String version = null;
            if (customParams.get("org") != null && customParams.get("project") != null) {
                orgid = Long.parseLong((String)customParams.get("org"));
                project = Long.parseLong((String)customParams.get("project"));
                scheme = Long.parseLong((String)customParams.get("scheme"));
                version = (String)customParams.get("version");
                this.getModel().setValue("org", (Object)orgid);
                this.getModel().setValue("houseproject", (Object)project);
                this.getModel().setValue("scheme", (Object)scheme);
                this.getModel().setValue("version", (Object)version);
                this.getModel().setValue("swqsytfl", (Object)TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId()));
                this.getModel().setValue("clearperiod", (Object)SchemaDataService.querySchemeClearperiod(this.getSchemeId()));
            } else {
                DynamicObject defaultorg = (DynamicObject)this.getModel().getValue("org");
                Long org = defaultorg != null ? defaultorg.getLong("id") : RequestContext.get().getOrgId();
                DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
                orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
                if (orgid != null) {
                    Boolean approve = (Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)orgid).getData();
                    if (!approve.booleanValue()) {
                        this.getModel().setValue("org", null);
                        return;
                    }
                } else {
                    return;
                }
                this.getModel().setValue("org", (Object)orgid);
                this.changeProjectByOrgid(orgid);
            }
            long longId = DBUtils.getLongId((String)"t_tcept_liquida_calc");
            this.getModel().setValue("id", (Object)longId);
            this.resetAdjustCache();
            this.calc(orgid, this.getProjectId(), this.getSchemeId(), this.getVersion());
        } else {
            this.getModel().setValue("houseproject", null);
            this.getModel().setValue("scheme", null);
            this.getModel().setValue("version", null);
            Long orgid = this.getOrgid();
            this.resetAdjustCache();
            this.changeProjectByOrgid(orgid);
            this.calc(orgid, this.getProjectId(), this.getSchemeId(), this.getVersion());
        }
        this.setVersionComboItemsList((DynamicObject)this.getModel().getValue("scheme"));
    }

    private void changeProjectByOrgid(Long orgid) {
        Long project = TaxProjectDataService.queryFirstProjectByOrg(orgid);
        this.getModel().setValue("houseproject", (Object)project);
        if (project != null) {
            this.changeSchemeByProject(orgid, project);
        }
        this.getModel().setValue("swqsytfl", (Object)TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId()));
        this.getModel().setValue("clearperiod", (Object)SchemaDataService.querySchemeClearperiod(this.getSchemeId()));
    }

    private List<AdjustRecordDto> getAdjustRecordDtos() {
        String cache = this.getPageCache().get("AdjustRecordDto");
        if (StringUtil.isEmpty((CharSequence)cache)) {
            cache = "[]";
        }
        return SerializationUtils.fromJsonStringToList((String)cache, AdjustRecordDto.class);
    }

    private void cacheAdjust(String mainbillpk) {
        String cache = this.getPageCache().get("AdjustRecordDto");
        if (StringUtil.isEmpty((CharSequence)cache)) {
            DynamicObjectCollection adjustDetail = ManualAdjustDetailService.queryDataByBiz("tcept_liquida_calc_entryentity", Long.parseLong(mainbillpk));
            List adjustRecordDtos = adjustDetail.stream().map(a -> AdjustRecordDto.transformFromDynObj(a)).collect(Collectors.toList());
            String cache1 = SerializationUtils.toJsonString(adjustRecordDtos);
            this.getPageCache().put("AdjustRecordDto", cache1);
        }
    }

    private void resetAdjustCache() {
        String jsonString = SerializationUtils.toJsonString(new ArrayList());
        this.getPageCache().put("AdjustRecordDto", jsonString);
    }

    private void changeSchemeByProject(Long orgid, Long project) {
        Long scheme = SchemaDataService.queryLastScheme(orgid, project);
        this.getModel().setValue("scheme", (Object)scheme);
        this.refreshVersion();
    }

    private void refreshVersion() {
        List<ComboItem> comboItems = this.getVersionComboItemsList((DynamicObject)this.getModel().getValue("scheme"));
        this.getModel().setValue("version", comboItems.isEmpty() ? null : comboItems.get(0).getValue());
    }

    public void afterBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.getOrDefault("fromDesk", Boolean.FALSE).booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", "houseproject", "scheme", "version"});
        }
        this.setVersionComboItemsList((DynamicObject)this.getModel().getValue("scheme"));
        this.setFieldsVisible(this.getClearPeriod(), this.getSwytfl());
        Object id = this.getModel().getValue("id");
        this.getPageCache().put("billpk", id == null ? "0" : id.toString());
        this.cacheAdjust(((Long)this.getModel().getValue("id")).toString());
        this.setCellHighLight();
    }

    public String getAnyPeriodKey() {
        return "ptzz";
    }

    public int getMaxPeriod() {
        int defaultMax = 30;
        for (int i = 1; i <= defaultMax; ++i) {
            if (this.getControl(this.getAnyPeriodKey() + i) != null) continue;
            return i - 1;
        }
        return defaultMax;
    }

    private void setFieldsVisible(int clearperiod, String swqsytfl) {
        int i;
        int maxPeriod = this.getMaxPeriod();
        for (i = clearperiod + 1; i <= maxPeriod; ++i) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryfieldgroupap" + i});
        }
        for (i = 1; i <= clearperiod; ++i) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entryfieldgroupap" + i});
        }
        for (i = 1; i <= clearperiod; ++i) {
            this.getView().setVisible(Boolean.valueOf(!"0".equals(swqsytfl)), new String[]{"fptzz" + i});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ArrayList baseField = Lists.newArrayList((Object[])new String[]{"org", "houseproject", "scheme", "billno", "version"});
        if ((this.isFitPrefix(name) || baseField.contains(name)) && baseField.contains(name)) {
            this.calc(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
        }
    }

    private boolean isFitPrefix(String name) {
        for (String s : LandValueTaxLiquCalcService.FIELD_PREFIX) {
            if (!name.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void calc(Long orgid, Long projectId, Long schemeId, String version) {
        if (!this.checkCalcCondition()) {
            this.getModel().deleteEntryData("entryentity");
            this.getView().updateView("entryentity");
            return;
        }
        List<AdjustRecordDto> adjustRecordDtos = this.getAdjustRecordDtos();
        List<Map<String, Object>> measureTable = LandValueTaxLiquCalcService.callMeasureTable(orgid, projectId, schemeId, version, this.getClearPeriod(), this.getSwytfl(), this.getId(), false, adjustRecordDtos);
        this.setValueInModel(measureTable);
        this.setCellHighLight();
        this.getView().updateView("fs_baseinfo");
        this.getView().updateView("entryentity");
    }

    private void setCellHighLight() {
        List<AdjustRecordDto> objects;
        Long tzDetailBizId = this.getId();
        if (tzDetailBizId != null && (objects = this.getAdjustRecordDtos()) != null) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            Map<String, Integer> rowindexMap = entryentity.stream().collect(Collectors.toMap(a -> a.get("rowno") + "", b -> b.getInt("seq") - 1, (m, n) -> m));
            Map<String, List<AdjustRecordDto>> collect = objects.stream().collect(Collectors.groupingBy(a -> a.getSubbizid() + a.getBizfield()));
            for (Map.Entry<String, List<AdjustRecordDto>> entry : collect.entrySet()) {
                entry.getValue().sort(Comparator.comparing(a -> a.getUpdatetime()));
                AdjustRecordDto first = entry.getValue().get(0);
                String subbizid = String.valueOf(first.getSubbizid());
                if (!rowindexMap.containsKey(subbizid)) continue;
                String bizfield = first.getBizfield();
                MetadataUtil.setCellColor((Control)entryGrid, (int)rowindexMap.get(subbizid), (String)bizfield, (String)"#DCFAE4");
            }
        }
    }

    private void setValueInModel(List<Map<String, Object>> measureTable) {
        this.setTableEntryData(measureTable);
    }

    private void setTableEntryData(List<Map<String, Object>> table) {
        IDataModel model = this.getModel();
        this.getModel().beginInit();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", table.size());
        for (int i = 0; i < table.size(); ++i) {
            Map<String, Object> map = table.get(i);
            Integer rowno = (Integer)map.get("rowno");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                model.setValue(entry.getKey(), entry.getValue(), i);
            }
        }
        Map<Object, Map> tableMap = table.stream().collect(Collectors.toMap(a -> a.get("rowno"), b -> b, (m, n) -> m));
        model.setValue("fjsrhj", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_01.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("kcxmjehj", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_04.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("tdcb", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_06.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("fdckfcb", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_08.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("fdckffy", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_09.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("sj", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_12.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("qtkcxm", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_13.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("zze", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_14.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("ynse", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_18.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("yjse", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_19.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.setValue("ybtse", (Object)((Map)tableMap.getOrDefault(LandValueTaxTableEnum.item_20.getRowNo(), new HashMap())).getOrDefault("hj", BigDecimal.ZERO));
        model.endInit();
    }

    private boolean checkCalcCondition() {
        return this.getOrgid() != null && this.getProjectId() != null && this.getSchemeId() != null && this.getVersion() != null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("reset".equals(operateKey)) {
            if (this.getOrgid() == null || this.getProjectId() == null || this.getSchemeId() == null || this.getVersion() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u672c\u4fe1\u606f\u3002", (String)"LandValueTaxLiquCalcBillEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else if ("recalc".equals(operateKey)) {
            if (this.getOrgid() == null || this.getProjectId() == null || this.getSchemeId() == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u672c\u4fe1\u606f\u3002", (String)"LandValueTaxLiquCalcBillEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!"A".equals(this.getModel().getValue("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u8fdb\u884c\u201c\u91cd\u65b0\u53d6\u6570\u201d\u3002", (String)"LandValueTaxLiquCalcBillEditPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("recalc".equals(operateKey)) {
            this.calc(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"LandValueTaxLiquCalcBillEditPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
        } else if ("reset".equals(operateKey)) {
            this.getModel().setValue("swqsytfl", (Object)TaxProjectDataService.queryProjectSwqsytfl(this.getProjectId()));
            this.getModel().setValue("clearperiod", (Object)SchemaDataService.querySchemeClearperiod(this.getSchemeId()));
            this.resetAdjustCache();
            this.calc(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u6210\u529f\u3002", (String)"LandValueTaxLiquCalcBillEditPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
        } else if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            List<AdjustRecordDto> adjustRecordDtos = this.getAdjustRecordDtos();
            ManualAdjustDetailService.saveDtoToPersistent(adjustRecordDtos, this.getId(), "tcept_liquida_calc_entryentity");
        }
    }

    public void pageRelease(EventObject e) {
        this.removeAdjDetail();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.removeAdjDetail();
    }

    private void removeAdjDetail() {
        Long billId = this.getId();
        if (billId != null) {
            ManualAdjustDetailService.deleteTemp(billId, "tcept_liquida_calc_entryentity");
        }
    }

    private Long getId() {
        String billpk = this.getPageCache().get("billpk");
        billpk = billpk == null ? "0" : billpk;
        return Long.parseLong(billpk);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName;
        int rowIndex = hyperLinkClickEvent.getRowIndex();
        String bizfield = fieldName = hyperLinkClickEvent.getFieldName();
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("entryentity", rowIndex);
        Long subbizid = Long.parseLong(rowEntity.getInt("rowno") + "");
        Long bizid = this.getId();
        String biztable = "tcept_liquida_calc_entryentity";
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("bizid", bizid);
        customParams.put("subbizid", subbizid);
        customParams.put("biztable", biztable);
        customParams.put("bizfield", bizfield);
        customParams.put(ManualAdjustDetailService.BIZSTATUS, ManualAdjustDetailService.BIZSTATUS_TEMP);
        customParams.put("originalvalue", ((BigDecimal)this.getModel().getValue(fieldName, rowIndex)).toPlainString());
        List<AdjustRecordDto> adjustRecordDtos = this.getAdjustRecordDtos();
        String finalBizfield = bizfield;
        List collect = adjustRecordDtos.stream().filter(a -> subbizid.equals(a.getSubbizid())).filter(a -> Objects.equals(finalBizfield, a.getBizfield())).collect(Collectors.toList());
        String cache1 = SerializationUtils.toJsonString(collect);
        customParams.put("adjust_cache", cache1);
        customParams.put("adjust_model", "cache");
        String billstatus = (String)this.getModel().getValue("billstatus");
        OperationStatus status = OperationStatus.EDIT;
        if ("B".equals(billstatus) || "C".equals(billstatus)) {
            status = OperationStatus.VIEW;
        }
        PageShowCommon.showForm((OperationStatus)status, (ShowType)ShowType.Modal, (String)"tcept_adj_record_pop", (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("tcept_adj_record_pop") && (returnData = closedCallBackEvent.getReturnData()) instanceof AdjustRecordDto) {
            String cache = this.putAddAdjust((AdjustRecordDto)returnData);
            this.calc(this.getOrgid(), this.getProjectId(), this.getSchemeId(), this.getVersion());
        }
    }

    private String putAddAdjust(AdjustRecordDto returnData) {
        List<AdjustRecordDto> objects = this.getAdjustRecordDtos();
        ArrayList<AdjustRecordDto> adjustRecordDtoAarryaList = new ArrayList<AdjustRecordDto>();
        adjustRecordDtoAarryaList.add(returnData);
        adjustRecordDtoAarryaList.addAll(objects);
        adjustRecordDtoAarryaList.sort(Comparator.comparing(AdjustRecordDto::getUpdatetime).reversed());
        String cache1 = SerializationUtils.toJsonString(adjustRecordDtoAarryaList);
        this.getPageCache().put("AdjustRecordDto", cache1);
        return cache1;
    }
}

