/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.measure;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.taxc.tcept.business.measure.LandValueTaxLiquCalcService;
import kd.taxc.tcept.common.utils.DraftCommonUtils;

public class LandValueTaxLiquCalcListPlugin
extends AbstractListPlugin {
    private static final String RECALCS = "recalcs";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (RECALCS.equals(operateKey) && ((selectedRows = this.getSelectedRows()).size() > 1 || selectedRows.size() == 0)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u64cd\u4f5c\u3002", (String)"LandValueTaxLiquCalcListPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        Object[] primaryKeyValues;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (RECALCS.equals(operateKey) && (primaryKeyValues = (selectedRows = this.getSelectedRows()).getPrimaryKeyValues()).length > 0) {
            OperationResult operationResult = LandValueTaxLiquCalcService.reCalc((Long)primaryKeyValues[0]);
            if (operationResult == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u7684\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"LandValueTaxLiquCalcListPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
            } else if (operationResult != null && operationResult.isSuccess()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"LandValueTaxLiquCalcListPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
            } else {
                this.getView().showOperationResult(operationResult);
            }
            ListSelectedRow selectedRow = selectedRows.get(0);
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            DraftCommonUtils.logOperation(operationResult, formShowParameter.getBillFormId(), ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570", (String)"LandValueTaxLiquCalcListPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]), selectedRow.getBillNo());
            BillList billlist = (BillList)this.getControl("billlistap");
            billlist.refreshData();
        }
    }
}

