/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.measure;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.draft.IncomeDraftService;
import kd.taxc.tcept.business.measure.PreLandMeasureService;
import kd.taxc.tcept.formplugin.draft.CommonBillFormPlugin;

public class PreLandMeasureEditPlugin
extends CommonBillFormPlugin {
    public static final String ORG = "org";
    public static final String PROJECT = "project";
    public static final String SCHEME = "scheme";
    public static final String VERSION = "version";
    public static final String TAXSTATE = "taxstate";
    public static final String CLEARPERIOD = "clearperiod";
    public static final String SALE_TAX_INCOME_ = "sale_tax_income_";
    public static final String PRE_LANDTAX_AMOUNT = "pre_landtax_amount_";
    public static final String PRE_RATE = "pre_rate_";
    private static final String RESET = "reset";
    private IncomeDraftService incomeDraftService = new IncomeDraftService();
    private PreLandMeasureService preLandMeasureService = new PreLandMeasureService();

    public void initialize() {
        super.initialize();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addPackageDataListener(this::packageData);
    }

    public void packageData(PackageDataEvent e) {
        FieldEdit columnDesc = (FieldEdit)e.getSource();
        String key = columnDesc.getKey();
        DynamicObject d = e.getRowData();
        String taxstate = d.getString(TAXSTATE);
        if (key.startsWith(PRE_RATE) && "count".equals(taxstate)) {
            e.setFormatValue((Object)"");
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String swqsytfl = this.getModelString("swqsytfl");
        int maxclearperiod = (Integer)this.getModel().getValue("maxclearperiod");
        this.loadBizData(swqsytfl, maxclearperiod);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject project = (DynamicObject)this.getModel().getValue(PROJECT);
        DynamicObject scheme = (DynamicObject)this.getModel().getValue(SCHEME);
        int maxClearPeriods = 0;
        if (scheme != null) {
            this.setVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
            String clearperiod = status == OperationStatus.ADDNEW ? scheme.getString(CLEARPERIOD) : this.getModel().getValue("maxclearperiod").toString();
            maxClearPeriods = Integer.parseInt(clearperiod);
        }
        int finalMaxClearPeriods = maxClearPeriods;
        this.setVisibleList(finalMaxClearPeriods);
        this.setLockRow();
        this.setSumRow();
        this.getView().setVisible(Boolean.valueOf(this.getModel().getEntryEntity("entryentity").stream().map(s -> s.getString("stage")).distinct().count() > 1L), new String[]{"stage"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Long orgId = this.getModelObjLongId(ORG);
        Long projectId = this.getModelObjLongId(PROJECT);
        if (ORG.equals(name)) {
            Long defaultProjectId = this.incomeDraftService.getDefaultProject(orgId);
            this.getModel().setValue(PROJECT, (Object)defaultProjectId);
        }
        if (PROJECT.equals(name)) {
            Long defaultSchemeId = this.incomeDraftService.getDefaultScheme(orgId, projectId);
            this.getModel().setValue(SCHEME, (Object)defaultSchemeId);
            this.getModel().setValue("swqsytfl", (Object)this.getModelObjString(PROJECT, "swqsytfl"));
        }
        if (SCHEME.equals(name)) {
            List<ComboItem> comboItems = this.getVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
            this.getModel().setValue(VERSION, comboItems.isEmpty() ? null : comboItems.get(0).getValue());
            this.setVersionComboItemsList((DynamicObject)this.getModel().getValue(SCHEME));
            this.calcData();
        }
        if (VERSION.equals(name)) {
            this.calcData();
        }
        if (name.startsWith(SALE_TAX_INCOME_)) {
            Long schemeId = this.getModelObjLongId(SCHEME);
            String version = this.getModelString(VERSION);
            ChangeData changeData = e.getChangeSet()[0];
            int rowIndex = changeData.getRowIndex();
            DynamicObject currentRow = this.getModel().getEntryRowEntity("entryentity", rowIndex);
            String currentStage = currentRow.getString("stage");
            String taxstate = currentRow.getString(TAXSTATE);
            int currentSeq = currentRow.getInt("seq");
            String[] split = name.split("_");
            String period = split[split.length - 1];
            BigDecimal taxIncome = Optional.ofNullable((BigDecimal)changeData.getNewValue()).orElseGet(() -> BigDecimal.ZERO);
            Map<String, BigDecimal> incomeDraftGoodValueMap = this.preLandMeasureService.getIncomeDraftGoodValueMap(orgId, projectId, schemeId, version);
            Map<String, BigDecimal> incomeDraftAdjustTaxGoodValueMap = this.preLandMeasureService.getIncomeDraftAdjustTaxGoodValueMap(orgId, projectId, schemeId, version);
            BigDecimal firstOneIncome = this.preLandMeasureService.getTaxIncome(incomeDraftGoodValueMap, incomeDraftAdjustTaxGoodValueMap, taxstate, String.format("%02d", Integer.parseInt(period)));
            Integer firstStageSeq = this.getModel().getEntryEntity("entryentity").stream().filter(s -> s.getInt("stage") == 1 && s.getString(TAXSTATE).equals(currentRow.getString(TAXSTATE))).map(s -> s.getInt("seq")).findFirst().orElseGet(() -> 1);
            if (currentSeq != firstStageSeq) {
                this.getModel().setValue(SALE_TAX_INCOME_ + period, (Object)firstOneIncome.subtract(taxIncome), firstStageSeq - 1);
            }
            BigDecimal yzl = (BigDecimal)this.getModel().getValue(PRE_RATE + period, rowIndex);
            DynamicObject projectInfo = BusinessDataServiceHelper.loadSingle((Object)this.getModelObjLongId(PROJECT), (String)"bastax_taxproject");
            if (projectInfo != null) {
                BigDecimal zzszsl = projectInfo.get("syslzsl") != null ? projectInfo.getBigDecimal("syslzsl") : BigDecimal.ZERO;
                boolean isSimpleMethod = projectInfo.getBoolean("syjhjsff");
                String taxMethod = "0".equals(projectInfo.getString("zsfs")) ? "normal" : "simple";
                BigDecimal zzsjzl = this.preLandMeasureService.getRate(new Date(), null, ResManager.loadKDString((String)"\u9500\u552e\u81ea\u884c\u5f00\u53d1\u623f\u5730\u4ea7", (String)"PreLandMeasureEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]), taxMethod);
                BigDecimal landtaxAmount = isSimpleMethod ? taxIncome.subtract(taxIncome.divide(BigDecimal.ONE.add(zzszsl), 4, 2).multiply(zzsjzl)).multiply(yzl).setScale(2, 4) : taxIncome.divide(BigDecimal.ONE.add(zzszsl), 4, 2).multiply(yzl).setScale(2, 4);
                this.getModel().setValue(PRE_LANDTAX_AMOUNT + period, (Object)landtaxAmount, rowIndex);
                DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
                DataEntityPropertyCollection properties = ((DynamicObject)entity.get(0)).getDynamicObjectType().getProperties();
                entity.stream().filter(s -> currentStage.equals(s.getString("stage")) && "count".equals(s.getString(TAXSTATE))).forEach(object -> {
                    for (IDataEntityProperty property : properties) {
                        String prop = property.getName();
                        if (!prop.startsWith(SALE_TAX_INCOME_) && !prop.startsWith(PRE_LANDTAX_AMOUNT)) continue;
                        object.set(prop, (Object)this.getCountSum(currentStage, entity, prop));
                    }
                });
                this.getView().updateView("entryentity");
                this.setLockRow();
                this.setSumRow();
            }
        }
    }

    public void calcData() {
        String clearPeriod = this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0");
        int maxclearperiod = Integer.parseInt(clearPeriod);
        this.setVisibleList(maxclearperiod);
        this.getModel().setValue("maxclearperiod", (Object)maxclearperiod);
        String swqsytfl = this.getModelString("swqsytfl");
        this.loadBizData(swqsytfl, maxclearperiod);
    }

    public BigDecimal getCountSum(String currentStage, DynamicObjectCollection entity, String prop) {
        return entity.stream().filter(a -> a.getString("stage").equals(currentStage)).filter(a -> !a.getString(TAXSTATE).equals("count")).map(a -> a.getBigDecimal(prop)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        this.getModel().setValue("sumprelandamount", (Object)this.getCountByTaxState("count"));
        this.getModel().setValue("sumptzz", (Object)this.getCountByTaxState("normal_house"));
        this.getModel().setValue("sumfptzz", (Object)this.getCountByTaxState("un_normal_house"));
        this.getModel().setValue("sumqtlxfdc", (Object)this.getCountByTaxState("un_house"));
        if ("save".equals(operateKey)) {
            DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entity)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f34\u571f\u589e\u503c\u7a0e\u6d4b\u7b97\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PreLandMeasureEditPlugin_6", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (!RESET.equals(operateKey) && "recalc".equals(operateKey)) {
            Long orgId = this.getModelObjLongId(ORG);
            Long projectId = this.getModelObjLongId(PROJECT);
            Long schemeId = this.getModelObjLongId(SCHEME);
            if (orgId == null || projectId == null || schemeId == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u672c\u4fe1\u606f\u3002", (String)"PreLandMeasureEditPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (!"A".equals(this.getModel().getValue("billstatus"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u8fdb\u884c\u201c\u91cd\u65b0\u53d6\u6570\u201d\u3002", (String)"PreLandMeasureEditPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("recalc".equals(operateKey)) {
            String swqsytfl = this.getModelString("swqsytfl");
            int maxclearperiod = (Integer)this.getModel().getValue("maxclearperiod");
            boolean b = this.loadBizData(swqsytfl, maxclearperiod);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"PreLandMeasureEditPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]));
        } else if (RESET.equals(operateKey)) {
            Long schemeId = this.getModelObjLongId(SCHEME);
            String swqsytfl = this.getModelObjString(PROJECT, "swqsytfl");
            int maxclearperiod = SchemaDataService.querySchemeClearperiod(schemeId);
            this.getModel().setValue("swqsytfl", (Object)swqsytfl);
            this.getModel().setValue("maxclearperiod", (Object)maxclearperiod);
            boolean b = this.loadBizData(swqsytfl, maxclearperiod);
            if (RESET.equals(operateKey) && b) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5e95\u7a3f\u6210\u529f\u3002", (String)"PreLandMeasureEditPlugin_5", (String)"taxc-tcept", (Object[])new Object[0]));
            }
        }
    }

    private boolean loadBizData(String swqsytfl, int maxclearperiod) {
        Long orgId = this.getModelObjLongId(ORG);
        Long projectId = this.getModelObjLongId(PROJECT);
        Long schemeId = this.getModelObjLongId(SCHEME);
        String version = this.getModelString(VERSION);
        Integer maxClearPeriod = Integer.parseInt(this.getModelObjStringWithDefault(SCHEME, CLEARPERIOD, "0"));
        this.getModel().deleteEntryData("entryentity");
        if (projectId == null || projectId == 0L) {
            return false;
        }
        Map<String, BigDecimal> incomeDraftGoodValueMap = this.preLandMeasureService.getIncomeDraftGoodValueMap(orgId, projectId, schemeId, version);
        Map<String, BigDecimal> incomeDraftAdjustTaxGoodValueMap = this.preLandMeasureService.getIncomeDraftAdjustTaxGoodValueMap(orgId, projectId, schemeId, version);
        List<String> visibleFieldList = this.preLandMeasureService.getVisibleEntityList(maxClearPeriod);
        DynamicObject projectInfo = this.preLandMeasureService.getProjectInfo(projectId);
        if (projectInfo == null) {
            return false;
        }
        List<String> extendPluginSaleStateFieldList = this.preLandMeasureService.getExtendPluginSaleStateFieldList();
        List<String> notExists = this.checkExtendFieldExists(this.getModel().getDataEntity(), extendPluginSaleStateFieldList);
        if (notExists.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u6269\u5c55\u7684\u5b57\u6bb5%s\uff0c\u5f53\u524d\u9875\u9762\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PreLandMeasureEditPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]);
            String params = notExists.stream().collect(Collectors.joining("\uff0c"));
            this.getView().showErrorNotification(String.format(msg, params));
            return false;
        }
        BigDecimal zzszsl = projectInfo.get("syslzsl") != null ? projectInfo.getBigDecimal("syslzsl") : BigDecimal.ZERO;
        boolean isSimpleMethod = projectInfo.getBoolean("syjhjsff");
        String taxMethod = "0".equals(projectInfo.getString("zsfs")) ? "normal" : "simple";
        BigDecimal zzsjzl = this.preLandMeasureService.getRate(new Date(), null, ResManager.loadKDString((String)"\u9500\u552e\u81ea\u884c\u5f00\u53d1\u623f\u5730\u4ea7", (String)"PreLandMeasureEditPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]), taxMethod);
        List<Map<String, Object>> list = this.preLandMeasureService.calcData(swqsytfl, incomeDraftGoodValueMap, incomeDraftAdjustTaxGoodValueMap, visibleFieldList, projectInfo, zzszsl, isSimpleMethod, zzsjzl, extendPluginSaleStateFieldList);
        this.getModel().beginInit();
        for (Map<String, Object> map : list) {
            int index = this.getModel().createNewEntryRow("entryentity");
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (entry.getKey().equals("seq")) continue;
                this.getModel().setValue(entry.getKey(), entry.getValue(), index);
            }
        }
        this.getModel().endInit();
        this.getView().setVisible(Boolean.valueOf(this.getModel().getEntryEntity("entryentity").stream().map(s -> s.getString("stage")).distinct().count() > 1L), new String[]{"stage"});
        this.getView().updateView("entryentity");
        this.setLockRow();
        this.setSumRow();
        return true;
    }

    private List<String> checkExtendFieldExists(DynamicObject dataEntity, List<String> extendPluginSaleStateFieldList) {
        DataEntityPropertyCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity").getDynamicObjectType().getProperties();
        if (extendPluginSaleStateFieldList.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> notExists = extendPluginSaleStateFieldList.stream().filter(s -> !entryentity.containsKey(s)).collect(Collectors.toList());
        return notExists;
    }

    private void setLockRow() {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)entity)) {
            return;
        }
        entity.stream().forEach(s -> {
            DataEntityPropertyCollection properties = s.getDynamicObjectType().getProperties();
            for (IDataEntityProperty property : properties) {
                String name = property.getName();
                int stage = s.getInt("stage");
                String taxstate = s.getString(TAXSTATE);
                int index = s.getInt("seq") - 1;
                this.getView().setEnable(Boolean.valueOf(stage > 1 && !"count".equals(taxstate) && name.startsWith(SALE_TAX_INCOME_)), index, new String[]{name});
            }
        });
    }

    public void setVisibleList(int finalMaxClearPeriods) {
        this.preLandMeasureService.getEntityGroupList().stream().forEach(s -> this.getView().setVisible(Boolean.valueOf(this.preLandMeasureService.getVisibleEntityGroupList(finalMaxClearPeriods).contains(s)), new String[]{s}));
        this.preLandMeasureService.getEntityList().stream().forEach(s -> this.getView().setVisible(Boolean.valueOf(this.preLandMeasureService.getVisibleEntityList(finalMaxClearPeriods).contains(s)), new String[]{s}));
    }

    public BigDecimal getCountByTaxState(String taxstate) {
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        return entity.stream().filter(s -> taxstate.equals(s.getString(TAXSTATE))).flatMap(s -> IntStream.rangeClosed(1, 10).boxed().map(a -> s.getBigDecimal(PRE_LANDTAX_AMOUNT + a))).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public void setSumRow() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        HashMap<String, String> floatButtomData = new HashMap<String, String>(16);
        List collect = this.getModel().getEntryEntity("entryentity").stream().filter(s -> s.getString(TAXSTATE).equals("count")).collect(Collectors.toList());
        int maxClearPeriods = (Integer)this.getModel().getValue("maxclearperiod");
        List<String> visibleEntityList = this.preLandMeasureService.getVisibleEntityList(maxClearPeriods);
        for (String s2 : visibleEntityList) {
            if (!s2.startsWith(SALE_TAX_INCOME_) && !s2.startsWith(PRE_LANDTAX_AMOUNT)) continue;
            BigDecimal sum = collect.stream().map(a -> a.getBigDecimal(s2)).reduce(BigDecimal.ZERO, BigDecimal::add);
            DecimalFormat df = new DecimalFormat("###,##0.00");
            floatButtomData.put(s2, df.format(sum));
        }
        entryGrid.setFloatButtomData(floatButtomData);
    }
}

