/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.formplugin.statistics;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;
import kd.taxc.tcept.business.basedata.TaxProjectDataService;
import kd.taxc.tcept.business.extpoint.IDeskMeasureService;
import kd.taxc.tcept.business.statistics.DeskService;

public class SchemeMeasureDeskFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
TabSelectListener,
HyperLinkClickListener {
    private static final String SCHE_ADD = "sche_add";
    private static final String SCHE_DELETE = "sche_delete";
    private static final String SCHE_EDIT = "sche_edit";
    public static final String PRO_COPY = "pro_copy";
    public static final String PRO_SUBMIT = "pro_submit";
    public static final String PRO_UNSUBMIT = "pro_unsubmit";
    public static final String PRO_AUDIT = "pro_audit";
    public static final String PRO_UNAUDIT = "pro_unaudit";
    private static final String RECALCS = "recalcs";
    private DeskService deskService = new DeskService();
    private static String TREE_AP = "treeviewap";
    private static String PRO_TREE_AP = "pro_treeviewap";
    private static final String CURRENT_NODE = "CURRENT_NODE";
    private static final String CURRENT_TEMP_NODE = "CURRENT_TEMP_NODE";
    private static final String SEARCH_TEXT = "searchtext";

    public void initialize() {
        TreeView tree = (TreeView)this.getView().getControl(TREE_AP);
        TreeView proTree = (TreeView)this.getView().getControl(PRO_TREE_AP);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        proTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        ((Tab)this.getControl("tabap")).addTabSelectListener((TabSelectListener)this);
    }

    public void registerListener(EventObject e) {
        Search sl = (Search)this.getControl("entitysearchap");
        Search proSearchap = (Search)this.getControl("pro_entitysearchap");
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        TreeView treeView = (TreeView)this.getControl(TREE_AP);
        TreeView proTreeView = (TreeView)this.getControl(PRO_TREE_AP);
        sl.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                String last_searched = this.getPageCache().get("last_searched");
                if (!event.getText().equals(last_searched)) {
                    this.getPageCache().put("last_searched", event.getText());
                    this.getPageCache().remove("first_searched_" + last_searched);
                    this.getPageCache().remove(TREE_AP + "_focus");
                }
                String cachekey = "first_searched_" + event.getText();
                if (!"true".equals(this.getPageCache().get(cachekey))) {
                    this.getPageCache().put(cachekey, "true");
                    SearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)treeView, (String)TREE_AP);
                } else {
                    String[] btns = new String[]{"searchbefore", "searchnext"};
                    SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)"searchnext", (TreeView)((TreeView)this.getControl(TREE_AP)), (String[])btns, (String)TREE_AP);
                }
            } else {
                this.getPageCache().put("_resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"SchemeMeasureDeskFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
            }
        });
        proSearchap.addEnterListener(event -> {
            if (event.getText() != null && !"".equals(event.getText())) {
                String last_searched = this.getPageCache().get("pro_last_searched");
                if (!event.getText().equals(last_searched)) {
                    this.getPageCache().put("pro_last_searched", event.getText());
                    this.getPageCache().remove("pro_first_searched_" + last_searched);
                    this.getPageCache().remove(PRO_TREE_AP + "_focus");
                }
                String cachekey = "pro_first_searched_" + event.getText();
                if (!"true".equals(this.getPageCache().get(cachekey))) {
                    this.getPageCache().put(cachekey, "true");
                    SearchUtil.searchMember((String)event.getText().toLowerCase().trim(), (boolean)false, (IFormView)view, (IPageCache)pageCache, (TreeView)proTreeView, (String)PRO_TREE_AP);
                } else {
                    String[] btns = new String[]{"searchbefore1", "searchnext1"};
                    SearchUtil.getLeftOrRight((IPageCache)this.getPageCache(), (IFormView)this.getView(), (String)"searchnext1", (TreeView)((TreeView)this.getControl(PRO_TREE_AP)), (String[])btns, (String)PRO_TREE_AP);
                }
            } else {
                this.getPageCache().put("_resultlist", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e", (String)"SchemeMeasureDeskFormPlugin_0", (String)"taxc-tcept", (Object[])new Object[0]));
            }
        });
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addItemClickListeners(new String[]{"pro_toolbarap"});
        BillList billlistap = (BillList)this.getView().getControl("billlistap");
        BillList proBilllistap = (BillList)this.getView().getControl("pro_billlistap");
        billlistap.addHyperClickListener((HyperLinkClickListener)this);
        proBilllistap.addHyperClickListener((HyperLinkClickListener)this);
        billlistap.addSetFilterListener(this::setFilter);
        proBilllistap.addSetFilterListener(this::setFilter);
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshSchemeData(TREE_AP);
        this.refreshSchemeData(PRO_TREE_AP);
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList = (BillList)e.getSource();
        String listKey = billList.getKey();
        List qFilters = e.getQFilters();
        if ("billlistap".equals(listKey)) {
            String current = this.getPageCache().get(CURRENT_NODE);
            TreeView treeView = (TreeView)this.getControl(TREE_AP);
            TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
            if ("version".equals(treeNode.getType())) {
                String longNumber = treeNode.getLongNumber();
                String[] split = longNumber.split("\\.");
                if (split.length > 3) {
                    String orgid = split[0];
                    String projectid = split[1];
                    String schemeid = split[2];
                    String version = split[3];
                    Long org = StringUtil.isNotEmpty((CharSequence)orgid) ? Long.parseLong(orgid) : 0L;
                    Long project = StringUtil.isNotEmpty((CharSequence)projectid) ? Long.parseLong(projectid) : 0L;
                    Long scheme = StringUtil.isNotEmpty((CharSequence)schemeid) ? Long.parseLong(schemeid) : 0L;
                    QFilter qFilter = new QFilter("org", "=", (Object)org);
                    QFilter qFilter1 = new QFilter("project", "=", (Object)project);
                    QFilter qFilter2 = new QFilter("scheme", "=", (Object)scheme);
                    QFilter qFilter3 = new QFilter("version", "=", (Object)version);
                    qFilters.add(qFilter);
                    qFilters.add(qFilter1);
                    qFilters.add(qFilter2);
                    qFilters.add(qFilter3);
                }
            } else {
                QFilter of = QFilter.of((String)"1 != 1", (Object[])new Object[0]);
                qFilters.add(of);
            }
            e.setOrderBy("controlseq asc");
        } else if ("pro_billlistap".equals(listKey)) {
            TreeView treeView = (TreeView)this.getControl(PRO_TREE_AP);
            Map focusNode = treeView.getTreeState().getFocusNode();
            QFilter qFilter = new QFilter("org", "=", (Object)Long.parseLong(focusNode.get("id").toString())).or(new QFilter("project", "=", (Object)Long.parseLong(focusNode.get("id").toString())));
            qFilters.add(qFilter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            this.refreshSchemeData(TREE_AP);
        }
        if ("pro_refresh".equals(itemKey)) {
            this.refreshSchemeData(PRO_TREE_AP);
        }
    }

    public void search(SearchEnterEvent evt) {
        this.refreshSchemeData(TREE_AP);
    }

    private void refreshSchemeData(String treeType) {
        TreeView treeView = (TreeView)this.getView().getControl(treeType);
        treeView.deleteAllNodes();
        IFormView view = this.getView();
        IPageCache cache = this.getPageCache();
        TreeNode treeNode = this.buildOrgTree(view, treeView, cache, treeType);
        if (treeNode != null) {
            this.checkNode(treeView, cache, treeNode.getId());
        }
    }

    public TreeNode buildOrgTree(IFormView view, TreeView treeView, IPageCache pageCache, String treeType) {
        List<TreeNode> nodeList = this.getTreeNodeList(treeType);
        if (!nodeList.isEmpty()) {
            TreeNode defaultNode = null;
            if (TREE_AP.equals(treeType)) {
                Optional<TreeNode> first = nodeList.stream().filter(a -> "version".equals(a.getType())).findFirst();
                defaultNode = first.isPresent() ? first.get() : null;
            } else if (PRO_TREE_AP.equals(treeType)) {
                Optional<TreeNode> first = nodeList.stream().filter(a -> "project".equals(a.getType())).findFirst();
                defaultNode = first.isPresent() ? first.get() : null;
            }
            TreeUtils.build((TreeView)treeView, nodeList, (IPageCache)pageCache, (boolean)false);
            return defaultNode;
        }
        return null;
    }

    private List<TreeNode> getTreeNodeList(String treeType) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>();
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)PermissionUtils.getAllPermOrgs((IFormView)this.getView()), (boolean)true);
        List<Long> orgids = col.stream().map(p -> p.getLong("id")).collect(Collectors.toList());
        List<Long> projectIds = TaxProjectDataService.queryProjectByOrg(orgids);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"tcept_scheme", (String)"id,name,org.id orgid,org.name orgname,project.id projectid,project.name projectname,entryentity.versioncode versioncode, entryentity.versionname versionname", (QFilter[])new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1").and(QFilter.isNotNull((String)"entryentity.versioncode")).and("org", "in", orgids).and("project", "in", projectIds).toArray(), (String)"entryentity.versioncode asc");
        HashSet<String> orgSet = new HashSet<String>();
        HashSet<String> projectSet = new HashSet<String>();
        HashSet<String> schemeSet = new HashSet<String>();
        for (DynamicObject dynamicObject : collection) {
            String id = dynamicObject.getString("id");
            String name = dynamicObject.getString("name");
            String orgid = dynamicObject.getString("orgid");
            String orgname = dynamicObject.getString("orgname");
            String projectid = dynamicObject.getString("projectid");
            String projectname = dynamicObject.getString("projectname");
            String versioncode = dynamicObject.getString("versioncode");
            String versionname = dynamicObject.getString("versionname");
            if (!orgSet.contains(orgid)) {
                orgSet.add(orgid);
                TreeNode orgNode = new TreeNode();
                orgNode.setParentid("0");
                orgNode.setId(orgid);
                orgNode.setText(orgname);
                orgNode.setType("org");
                nodeList.add(orgNode);
            }
            if (!projectSet.contains(projectid)) {
                projectSet.add(projectid);
                TreeNode projectNode = new TreeNode();
                projectNode.setParentid(orgid);
                projectNode.setId(projectid);
                projectNode.setText(projectname);
                projectNode.setType("project");
                nodeList.add(projectNode);
            }
            if (!TREE_AP.equals(treeType)) continue;
            if (!schemeSet.contains(id)) {
                schemeSet.add(id);
                TreeNode schemeNode = new TreeNode();
                schemeNode.setParentid(projectid);
                schemeNode.setId(id);
                schemeNode.setText(name);
                schemeNode.setType("scheme");
                nodeList.add(schemeNode);
            }
            TreeNode versionNode = new TreeNode();
            versionNode.setParentid(id);
            versionNode.setId(versioncode);
            versionNode.setText(versionname);
            versionNode.setType("version");
            nodeList.add(versionNode);
        }
        return nodeList;
    }

    private void checkNode(TreeView treeView, IPageCache cache, String id) {
        TreeUtils.checkNode((IPageCache)cache, (TreeView)treeView, (String)id);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        if (evt.getSource() instanceof TreeView) {
            String key = ((TreeView)evt.getSource()).getKey();
            if (TREE_AP.equals(key)) {
                String nodeId = evt.getNodeId().toString();
                IPageCache pageCache = this.getPageCache();
                pageCache.put(CURRENT_NODE, nodeId);
                this.refreshSchemeRecordList();
            } else if (PRO_TREE_AP.equals(key)) {
                String nodeId = evt.getNodeId().toString();
                IPageCache pageCache = this.getPageCache();
                TreeView treeView = (TreeView)this.getControl(TREE_AP);
                TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)pageCache, (TreeView)treeView, (String)nodeId);
                BillList proBilllistap = (BillList)this.getControl("pro_billlistap");
                QFilter filter = null;
                String type = treeNode.getType();
                if ("org".equals(type)) {
                    filter = new QFilter("org", "=", (Object)Long.parseLong(nodeId));
                }
                if ("project".equals(type)) {
                    filter = new QFilter("project", "=", (Object)Long.parseLong(nodeId));
                }
                proBilllistap.getFilterParameter().setFilter(filter);
                proBilllistap.clearSelection();
                proBilllistap.refresh();
            }
        }
    }

    private void loadList(String orgid, String projectid, String schemeid, String version) {
        BillList billList = (BillList)this.getControl("billlistap");
        Long org = StringUtil.isNotEmpty((CharSequence)orgid) ? Long.parseLong(orgid) : 0L;
        Long project = StringUtil.isNotEmpty((CharSequence)projectid) ? Long.parseLong(projectid) : 0L;
        Long scheme = StringUtil.isNotEmpty((CharSequence)schemeid) ? Long.parseLong(schemeid) : 0L;
        QFilter qFilter = new QFilter("org", "=", (Object)org);
        QFilter qFilter1 = new QFilter("project", "=", (Object)project);
        QFilter qFilter2 = new QFilter("scheme", "=", (Object)scheme);
        QFilter qFilter3 = new QFilter("version", "=", (Object)version);
        List qFilters = billList.getFilterParameter().getQFilters();
        qFilters.add(qFilter);
        qFilters.add(qFilter1);
        qFilters.add(qFilter2);
        qFilters.add(qFilter3);
        billList.clearSelection();
        billList.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            String operateKey;
            AbstractOperate operate = (AbstractOperate)args.getSource();
            switch (operateKey = operate.getOperateKey()) {
                case "sche_add": {
                    if (this.checkAddBillRecord()) break;
                    args.setCancel(true);
                    break;
                }
                case "sche_delete": {
                    if (this.checkDelBillRecord()) break;
                    args.setCancel(true);
                    break;
                }
                case "pro_copy": {
                    this.checkbeforeDoOperation(args, PRO_COPY);
                    break;
                }
                case "pro_submit": {
                    this.checkbeforeDoOperation(args, PRO_SUBMIT);
                    break;
                }
                case "pro_unsubmit": {
                    this.checkbeforeDoOperation(args, PRO_UNSUBMIT);
                    break;
                }
                case "pro_audit": {
                    this.checkbeforeDoOperation(args, PRO_AUDIT);
                    break;
                }
                case "pro_unaudit": {
                    this.checkbeforeDoOperation(args, PRO_UNAUDIT);
                    break;
                }
                case "recalcs": {
                    if (this.checkbeforeDoRecalcs()) break;
                    args.setCancel(true);
                }
            }
        }
    }

    private boolean checkbeforeDoRecalcs() {
        ListSelectedRowCollection selectedRows = this.getSchemeRecordListSelectedRows();
        if (selectedRows.size() == 0 || selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u5355\u636e\u3002", (String)"SchemeMeasureDeskFormPlugin_18", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void checkbeforeDoOperation(BeforeDoOperationEventArgs args, String type) {
        BillList proBilllist = (BillList)this.getControl("pro_billlistap");
        ListSelectedRowCollection selectedRows = proBilllist.getSelectedRows();
        if (selectedRows.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u6761\u6570\u636e\u3002", (String)"SchemeMeasureDeskFormPlugin_1", (String)"taxc-tcept", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (PRO_COPY.equals(type)) {
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u590d\u5236\u4e00\u6761\u65b9\u6848\u6570\u636e\u3002", (String)"SchemeMeasureDeskFormPlugin_2", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean existNeedCalc = this.deskService.existNeedCalc(selectedRows.get(0).getBillNo());
            if (existNeedCalc) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u590d\u5236\u5355\u636e\u7684\u201c\u8ba1\u7b97\u72b6\u6001\u201d\u4e3a\u65e0\u9700\u8ba1\u7b97\u7684\u65b9\u6848\u3002", (String)"SchemeMeasureDeskFormPlugin_3", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        if (PRO_SUBMIT.equals(type) || PRO_UNSUBMIT.equals(type) || PRO_AUDIT.equals(type) || PRO_UNAUDIT.equals(type)) {
            boolean anyMatch = selectedRows.stream().anyMatch(s -> this.deskService.existNoEdit(s.getBillNo()));
            if (anyMatch) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u7f16\u5236\u7684\u5e95\u7a3f\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SchemeMeasureDeskFormPlugin_4", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            BiPredicate<ListSelectedRowCollection, String> predicate = (rows, status) -> rows.stream().allMatch(s -> s.getBillStatus().equals(status));
            if (PRO_SUBMIT.equals(type) && !predicate.test(selectedRows, "A")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u80fd\u63d0\u4ea4\u3002", (String)"SchemeMeasureDeskFormPlugin_5", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (PRO_UNSUBMIT.equals(type) && !predicate.test(selectedRows, "B")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u63d0\u4ea4\u7684\u6570\u636e\u624d\u80fd\u64a4\u9500\u3002", (String)"SchemeMeasureDeskFormPlugin_6", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (PRO_AUDIT.equals(type) && !predicate.test(selectedRows, "B")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u63d0\u4ea4\u7684\u6570\u636e\u624d\u80fd\u5ba1\u6838\u3002", (String)"SchemeMeasureDeskFormPlugin_7", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (PRO_UNAUDIT.equals(type) && !predicate.test(selectedRows, "C")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"SchemeMeasureDeskFormPlugin_8", (String)"taxc-tcept", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private boolean checkAddBillRecord() {
        ListSelectedRowCollection selectedRows = this.getSchemeRecordListSelectedRows();
        if (selectedRows.size() != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u4e3a\u7a7a\u7684\u5355\u636e\u3002", (String)"SchemeMeasureDeskFormPlugin_9", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tcept_desk_bill_record");
        String cbillno = dynamicObject.getString("cbillno");
        if (StringUtil.isNotEmpty((CharSequence)cbillno)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5355\u636e\u7f16\u53f7\u201d\u4e3a\u7a7a\u7684\u884c\u6b21\u65b0\u589e\u3002", (String)"SchemeMeasureDeskFormPlugin_10", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkDelBillRecord() {
        ListSelectedRowCollection selectedRows = this.getSchemeRecordListSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u4e00\u6761\u5355\u636e\u3002", (String)"SchemeMeasureDeskFormPlugin_11", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tcept_desk_bill_record");
        String cbillno = dynamicObject.getString("cbillno");
        if (StringUtil.isEmpty((CharSequence)cbillno)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u4e00\u6761\u5355\u636e\u3002", (String)"SchemeMeasureDeskFormPlugin_11", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        QFilter qFilter = new QFilter("billstate", "=", (Object)"B");
        qFilter.or("billstate", "=", (Object)"C");
        QFilter qFilter1 = new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues());
        boolean exists = QueryServiceHelper.exists((String)"tcept_desk_bill_record", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (exists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u201c\u6682\u5b58\u201d\u7684\u5355\u636e\u3002", (String)"SchemeMeasureDeskFormPlugin_12", (String)"taxc-tcept", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "sche_add": {
                this.addBill();
                break;
            }
            case "sche_delete": {
                ListSelectedRowCollection selectedRows = this.getSchemeRecordListSelectedRows();
                this.showConfirmTips(SCHE_DELETE, String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"SchemeMeasureDeskFormPlugin_13", (String)"taxc-tcept", (Object[])new Object[0]), selectedRows.size()), "");
                break;
            }
            case "pro_copy": {
                this.getMapConsumer(PRO_COPY).accept(this.deskService.copySuite(this.getProjectIds().get(0)));
                break;
            }
            case "pro_submit": {
                this.getMapConsumer(PRO_SUBMIT).accept(this.deskService.submitSuite(this.getProjectIds()));
                break;
            }
            case "pro_unsubmit": {
                this.getMapConsumer(PRO_UNSUBMIT).accept(this.deskService.unsubmitSuite(this.getProjectIds()));
                break;
            }
            case "pro_audit": {
                this.getMapConsumer(PRO_AUDIT).accept(this.deskService.auditSuite(this.getProjectIds()));
                break;
            }
            case "pro_unaudit": {
                this.getMapConsumer(PRO_UNAUDIT).accept(this.deskService.unauditSuite(this.getProjectIds()));
                break;
            }
            case "recalcs": {
                ListSelectedRowCollection selectedRows1 = this.getSchemeRecordListSelectedRows();
                Object primaryKeyValue = selectedRows1.get(0).getPrimaryKeyValue();
                Map<String, Object> objectMap = this.deskService.reCalcOne(primaryKeyValue, this.getView().getFormShowParameter().getFormId(), RECALCS);
                if (Boolean.TRUE.equals(objectMap.getOrDefault("success", Boolean.FALSE))) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u6210\u529f\u3002", (String)"SchemeMeasureDeskFormPlugin_20", (String)"taxc-tcept", (Object[])new Object[0]));
                    this.refreshSchemeRecordList();
                    break;
                }
                if ("-2".equals(objectMap.get("code"))) {
                    this.getView().showTipNotification((String)objectMap.getOrDefault("message", ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u5931\u8d25\u3002", (String)"SchemeMeasureDeskFormPlugin_21", (String)"taxc-tcept", (Object[])new Object[0])));
                    break;
                }
                this.getView().showErrorNotification((String)objectMap.getOrDefault("message", ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u5931\u8d25\u3002", (String)"SchemeMeasureDeskFormPlugin_21", (String)"taxc-tcept", (Object[])new Object[0])));
            }
        }
    }

    public Consumer<Map<String, Object>> getMapConsumer(String type) {
        return map -> {
            if (((Boolean)map.get("success")).booleanValue()) {
                if (type.equals(PRO_COPY)) {
                    this.refreshSchemeData(PRO_TREE_AP);
                }
                this.refreshProBillList();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"SchemeMeasureDeskFormPlugin_14", (String)"taxc-tcept", (Object[])new Object[0]));
            } else {
                this.refreshProBillList();
                this.getView().showErrorNotification((String)map.get("message"));
            }
        };
    }

    private List<Long> getProjectIds() {
        BillList proBillList = (BillList)this.getControl("pro_billlistap");
        ListSelectedRowCollection listSelectedRows = proBillList.getSelectedRows();
        return listSelectedRows.stream().map(s -> (Long)s.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    private ListSelectedRowCollection getSchemeRecordListSelectedRows() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList.getSelectedRows();
    }

    private void addBill() {
        ListSelectedRowCollection selectedRows = this.getSchemeRecordListSelectedRows();
        FormShowParameter showParameterById = this.getShowParameterById(selectedRows.get(0).getPrimaryKeyValue(), SCHE_ADD, false);
        this.getView().showForm(showParameterById);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        ListSelectedRowCollection selectedRows;
        Map<String, Object> objectMap;
        if (SCHE_DELETE.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes && Boolean.TRUE.equals((objectMap = this.deskService.deleteMulti((selectedRows = this.getSchemeRecordListSelectedRows()).getPrimaryKeyValues())).getOrDefault("success", Boolean.FALSE))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"SchemeMeasureDeskFormPlugin_14", (String)"taxc-tcept", (Object[])new Object[0]));
            this.refreshSchemeRecordList();
        }
    }

    public void refreshProBillList() {
        BillList proBilllistap = (BillList)this.getControl("pro_billlistap");
        proBilllistap.clearSelection();
        proBilllistap.refresh();
    }

    private void showConfirmTips(String key, String msg, String customvalue) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SchemeMeasureDeskFormPlugin_16", (String)"taxc-tcept", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"SchemeMeasureDeskFormPlugin_17", (String)"taxc-tcept", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Delete, confirmCallBacks, btnNameMaps, customvalue);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals(SCHE_ADD) || closedCallBackEvent.getActionId().equals(SCHE_DELETE) || closedCallBackEvent.getActionId().equals(SCHE_EDIT)) {
            this.refreshSchemeRecordList();
        }
    }

    private void refreshSchemeRecordList() {
        String current = this.getPageCache().get(CURRENT_NODE);
        TreeView treeView = (TreeView)this.getControl(TREE_AP);
        TreeNode treeNode = TreeUtils.getTreeNode((IPageCache)this.getPageCache(), (TreeView)treeView, (String)current);
        BillList billList = (BillList)this.getControl("billlistap");
        if ("version".equals(treeNode.getType())) {
            String longNumber = treeNode.getLongNumber();
            String[] split = longNumber.split("\\.");
            if (split.length > 3) {
                String orgid = split[0];
                String projectid = split[1];
                String schemeid = split[2];
                String version = split[3];
                this.loadList(orgid, projectid, schemeid, version);
            }
        } else {
            billList.getFilterParameter().setFilter(QFilter.of((String)"1 != 1", (Object[])new Object[0]));
            billList.clearSelection();
            billList.refresh();
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        Tab source = (Tab)tabSelectEvent.getSource();
        String tabKey = source.getKey();
        String tabPageKey = tabSelectEvent.getTabKey();
        if (tabPageKey.equals("schemedesk")) {
            this.refreshSchemeData(TREE_AP);
        }
        if (tabPageKey.equals("projectdesk")) {
            this.refreshSchemeData(PRO_TREE_AP);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        String fieldName = args.getFieldName();
        if (StringUtil.isNotEmpty((CharSequence)fieldName)) {
            Object primaryKeyValue;
            ListSelectedRow currentSelectedRowInfo;
            BillList list;
            if ("cbillno".equals(fieldName)) {
                list = (BillList)args.getSource();
                currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
                primaryKeyValue = currentSelectedRowInfo.getPrimaryKeyValue();
                FormShowParameter showParameterById = this.getShowParameterById(primaryKeyValue, SCHE_EDIT, true);
                this.getView().showForm(showParameterById);
            }
            if ("billno".equals(fieldName)) {
                list = (BillList)args.getSource();
                currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
                primaryKeyValue = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
                DynamicObject projectDesk = this.deskService.getProjectDesk((Long)primaryKeyValue);
                long schemeId = projectDesk.getDynamicObject("scheme").getLong("id");
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setCustomParams(new HashMap());
                billShowParameter.setPkId((Object)schemeId);
                billShowParameter.setStatus(OperationStatus.VIEW);
                billShowParameter.setFormId("tcept_scheme");
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)billShowParameter);
            }
        }
    }

    public FormShowParameter getShowParameterById(Object primaryKeyValue, String closeActionID, boolean hyperLink) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"tcept_desk_bill_record");
        String billmetanumber = dynamicObject.getString("billmetanumber");
        IDeskMeasureService service = this.deskService.getBillService(billmetanumber);
        String formNumber = service.getFormNumber();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        Long billid = dynamicObject.getLong("billid");
        String billstate = dynamicObject.getString("billstate");
        if (billid != null && billid != 0L) {
            customParams.put("mainbillpk", billid);
        }
        OperationStatus operationStatus = hyperLink ? ("B".equals(billstate) || "C".equals(billstate) ? OperationStatus.VIEW : OperationStatus.EDIT) : OperationStatus.ADDNEW;
        customParams.put("org", dynamicObject.getString("org.id"));
        customParams.put("project", dynamicObject.getString("project.id"));
        customParams.put("scheme", dynamicObject.getString("scheme.id"));
        customParams.put("version", dynamicObject.getString("version"));
        customParams.put("fromDesk", Boolean.TRUE);
        if (Objects.equals(formNumber, billmetanumber)) {
            FormShowParameter formShowParameter = this.showBill(ShowType.MainNewTabPage, formNumber, billid, this.getView(), customParams, operationStatus);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeActionID);
            formShowParameter.setCloseCallBack(closeCallBack);
            return formShowParameter;
        }
        FormShowParameter formShowParameter = this.createShowParameter(operationStatus, ShowType.MainNewTabPage, null, formNumber, customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, closeActionID);
        formShowParameter.setCloseCallBack(closeCallBack);
        return formShowParameter;
    }

    public FormShowParameter showBill(ShowType showType, String formId, Long pkId, IFormView view, Map<String, Object> customParams, OperationStatus status) {
        BillShowParameter billShowParameter = new BillShowParameter();
        if (customParams == null) {
            billShowParameter.setCustomParams(new HashMap());
        } else {
            billShowParameter.setCustomParams(customParams);
        }
        if (pkId != null && pkId != 0L) {
            billShowParameter.setPkId((Object)pkId);
        }
        billShowParameter.setStatus(status);
        billShowParameter.setFormId(formId);
        billShowParameter.getOpenStyle().setShowType(showType);
        view.showForm((FormShowParameter)billShowParameter);
        return billShowParameter;
    }

    private FormShowParameter createShowParameter(OperationStatus operationStatus, ShowType showType, StyleCss styleCss, String formid, Map<String, Object> customParams) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(formid);
        if (customParams == null) {
            param.setCustomParams(new HashMap());
        } else {
            param.setCustomParams(customParams);
        }
        if (customParams != null && customParams.get("customCaption") != null) {
            param.setCaption((String)customParams.get("customCaption"));
        }
        param.getOpenStyle().setShowType(showType);
        if (showType == ShowType.Modal && styleCss != null) {
            param.getOpenStyle().setInlineStyleCss(styleCss);
        }
        param.setStatus(operationStatus);
        return param;
    }
}

