/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.opplugin.draft;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcept.business.basedata.SchemaDataService;
import kd.taxc.tcept.business.statistics.DeskServiceMediator;

public class CostAdjustDraftOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("houseproject");
        e.getFieldKeys().add("scheme");
        e.getFieldKeys().add("version");
        e.getFieldKeys().add("entryentity1");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if ("save".equals(this.getOperateKey())) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        QFilter qFilter4;
                        String saveValidOp0;
                        DynamicObjectCollection entryentity1 = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity1");
                        BigDecimal total = entryentity1.stream().filter(a -> "cfl".equals(a.getString("costadtype1"))).map(a -> a.getBigDecimal("sgtzzhsje1")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (total.compareTo(BigDecimal.ZERO) != 0) {
                            saveValidOp0 = String.format(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b\u4e2d\u7684\u3010\u624b\u5de5\u8c03\u6574\u503c-\u542b\u7a0e\u91d1\u989d\u3011\u5408\u8ba1\u503c=%1$s\uff0c\u8bf7\u8c03\u6574\u5408\u8ba1\u503c\u4e3a0", (String)"CostAdjustDraftOp_0", (String)"taxc-tcept", (Object[])new Object[0]), total.toPlainString());
                            this.addFatalErrorMessage(dataEntity, saveValidOp0);
                            return;
                        }
                        total = entryentity1.stream().filter(a -> "cfl".equals(a.getString("costadtype1"))).map(a -> a.getBigDecimal("sgtzzbhsje1")).reduce(BigDecimal.ZERO, BigDecimal::add);
                        if (total.compareTo(BigDecimal.ZERO) != 0) {
                            saveValidOp0 = String.format(ResManager.loadKDString((String)"\u91cd\u5206\u7c7b\u4e2d\u7684\u3010\u624b\u5de5\u8c03\u6574\u503c-\u4e0d\u542b\u7a0e\u91d1\u989d\u3011\u5408\u8ba1\u503c=%1$s\uff0c\u8bf7\u8c03\u6574\u5408\u8ba1\u503c\u4e3a0", (String)"CostAdjustDraftOp_1", (String)"taxc-tcept", (Object[])new Object[0]), total.toPlainString());
                            this.addFatalErrorMessage(dataEntity, saveValidOp0);
                            return;
                        }
                        DynamicObject data = dataEntity.getDataEntity();
                        Object org = data.get("org.id");
                        Object scheme = data.get("scheme.id");
                        Object houseproject = data.get("houseproject.id");
                        String version = data.getString("version");
                        QFilter qFilter = new QFilter("org", "=", org);
                        QFilter qFilter1 = new QFilter("scheme", "=", scheme);
                        QFilter qFilter2 = new QFilter("houseproject", "=", houseproject);
                        Object billPkId = dataEntity.getBillPkId();
                        QFilter qFilter3 = new QFilter("id", "!=", billPkId);
                        DynamicObject draft = QueryServiceHelper.queryOne((String)"tcept_cost_adj_draft", (String)"version,houseproject.name as project, scheme.name as scheme", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4 = new QFilter("version", "=", (Object)version)});
                        if (draft == null) continue;
                        String projectname = draft.getString("project");
                        String versionName = SchemaDataService.queryVersionName((Long)scheme, version);
                        versionName = versionName == null ? version : versionName;
                        String saveValidOp02 = String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u4e2d\u5df2\u5b58\u5728\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CostAdjustDraftOp_2", (String)"taxc-tcept", (Object[])new Object[0]), versionName, projectname);
                        this.addFatalErrorMessage(dataEntity, saveValidOp02);
                        return;
                    }
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block3: {
            block2: {
                if (!"save".equals(e.getOperationKey())) break block2;
                for (DynamicObject dataEntity : e.getDataEntities()) {
                    long id = dataEntity.getLong("id");
                    DeskServiceMediator.fireBillChange("tcept_cost_adj_draft", id);
                }
                break block3;
            }
            if (!"delete".equals(e.getOperationKey())) break block3;
            for (DynamicObject dataEntity : e.getDataEntities()) {
                long org = dataEntity.getLong("org.id");
                long project = dataEntity.getLong("houseproject.id");
                long scheme = dataEntity.getLong("scheme.id");
                String version = dataEntity.getString("version");
                DeskServiceMediator.fireBillDelete("tcept_cost_adj_draft", org, project, scheme, version);
            }
        }
    }
}

