/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcept.opplugin.draft;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.taxc.tcept.business.draft.ManualAdjustDetailService;
import kd.taxc.tcept.business.statistics.DeskServiceMediator;

public class CostSplitDraftOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("houseproject");
        e.getFieldKeys().add("scheme");
        e.getFieldKeys().add("version");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if ("delete".equals(operationKey)) {
            DynamicObject[] dataEntities = e.getDataEntities();
            List<Object> id = Arrays.stream(dataEntities).map(a -> a.get("id")).collect(Collectors.toList());
            ManualAdjustDetailService.deleteDataByBizids("tcept_cost_split_draft_entryentity2", id);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        block3: {
            block2: {
                if (!"save".equals(e.getOperationKey())) break block2;
                for (DynamicObject dataEntity : e.getDataEntities()) {
                    long id = dataEntity.getLong("id");
                    DeskServiceMediator.fireBillChange("tcept_cost_split_draft", id);
                }
                break block3;
            }
            if (!"delete".equals(e.getOperationKey())) break block3;
            for (DynamicObject dataEntity : e.getDataEntities()) {
                long org = dataEntity.getLong("org.id");
                long project = dataEntity.getLong("houseproject.id");
                long scheme = dataEntity.getLong("scheme.id");
                String version = dataEntity.getString("version");
                DeskServiceMediator.fireBillDelete("tcept_cost_split_draft", org, project, scheme, version);
            }
        }
    }
}

