/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.mservice.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class ScqyMdtsDraftUpdateService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ScqyMdtsDraftUpdateService.class);
    private static final String MAIN_QUERY_SQL = "select fid,fexportbasedata,fdlckhwzmmh from t_tcetr_manufacture_draft where (fdatasource is null or fdatasource=' ') ";
    private static final String MAIN_UPDATE_SQL = "update t_tcetr_manufacture_draft set fdatasource = 'sdxz' where fid in (%s)";
    private static final String EXPORT_QUERY_SQL = "select fid,fentryid from t_tcetr_manufacture_entry where fid in (%s)";
    private static final String EXPORT_UPDATE_SQL = "update t_tcetr_manufacture_entry set fexportbase = ?, fdlckhwzmmh1= ? where fentryid = ?";

    protected Log getLogger() {
        return LOGGER;
    }

    protected IUpgradeService getService() {
        return this;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = true;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        try (TXHandle h = TX.requiresNew();){
            try {
                List entrys = DBUtils.query((String)MAIN_QUERY_SQL);
                if (EmptyCheckUtils.isNotEmpty((Object)entrys)) {
                    HashSet<String> fids = new HashSet<String>();
                    HashMap mainMap = new HashMap();
                    for (Map entry : entrys) {
                        Object fid = entry.get("FID");
                        fids.add(fid.toString());
                        mainMap.put(fid, entry);
                    }
                    if (fids.size() > 0) {
                        String fidstr = String.join((CharSequence)",", fids);
                        String exportQuerySql = String.format(EXPORT_QUERY_SQL, fidstr);
                        List exports = DBUtils.query((String)exportQuerySql);
                        ArrayList<Object[]> paramList = new ArrayList<Object[]>(10);
                        for (Map export : exports) {
                            Object fid = export.get("FID");
                            Map main = (Map)mainMap.get(fid);
                            Object fexportbasedata = main.get("FEXPORTBASEDATA");
                            Object fdlckhwzmmh = main.get("FDLCKHWZMMH");
                            Object fentryid = export.get("FENTRYID");
                            paramList.add(new Object[]{fexportbasedata, fdlckhwzmmh, fentryid});
                        }
                        if (EmptyCheckUtils.isNotEmpty(paramList)) {
                            DBUtils.executeBatch((String)"taxc", (String)EXPORT_UPDATE_SQL, paramList);
                        }
                        String mainUpdate = String.format(MAIN_UPDATE_SQL, fidstr);
                        DBUtils.execute((String)mainUpdate);
                    }
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }
}

