/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.mservice.upgradeservice;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class TcetrWmqyDeclareDetailUpdateService
extends AbstractUpgradeFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(TcetrWmqyDeclareDetailUpdateService.class);
    private static final String HIS_IN_QUERY_SQL = "SELECT fid,frowno,fbillno,ftaxtype,fvoucherno,fvouchertype,fnsrsbh,finvoicedate,fgoodsnoid,fgoodsname,funitid,famount,fjsje,ftaxrate,frebaterate,frebateamount,fremark,fsbbid,fewblxh,fzzsunit FROM t_tcetr_drawback_in_det where fsbbid not in (select fsbbid from t_tcetr_wmqy_in_detail)";
    private static final String HIS_OUT_QUERY_SQL = "SELECT fid,frowno,fbillno,finvoiceno,fcustomsno,fcertificateno,fexportdate,fgoodsnoid,fgoodsname,funitid,fexportamount,ffobusd,fdeclaregoodsid,fbusinesstypeid,fremark,fsbbid,fewblxh FROM t_tcetr_drawback_out_det WHERE fsbbid not in (select fsbbid from t_tcetr_wmqy_out_detail)";
    private static final String IN_INSERT_SQL = "INSERT INTO t_tcetr_wmqy_in_detail (fid,fentryid,fseq,frowno,fbillno,fvoucherno,fvouchertype,fnsrsbh,finvoicedate,fgoodsnoid,fgoodsname,funitid,famount,fjsje,ftaxrate,frebaterate,frebateamount,fremark,fsbbid,ftaxtype,fewblxh,fzzsunit) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String OUT_INSERT_SQL = "INSERT INTO t_tcetr_wmqy_out_detail (fid,fentryid,fseq,frowno,fbillno,finvoiceno,fcustomsno,fcertificateno,fexportdate,fgoodsnoid,fgoodsname,funitid,fexportamount,ffobusd,fdeclaregoodsid,fbusinesstypeid,fremark,fsbbid,fewblxh) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    protected Log getLogger() {
        return LOGGER;
    }

    protected IUpgradeService getService() {
        return this;
    }

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String log = SUCCESS_INFO;
        String info = SUCCESS_INFO;
        this.addLog(INFO, "DATA UPGRADE START");
        long l = System.currentTimeMillis();
        try {
            this.update();
        }
        catch (Throwable t) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(t);
            LOGGER.error(ERROR_INFO, t);
        }
        this.addLog(INFO, String.format("DATA UPGRADE END,USE TIME(MS)\uff1a%S", System.currentTimeMillis() - l));
        this.logs.append(log);
        this.logs.append('\n');
        result.setLog(this.logs.toString());
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        DataSet hisInRows = DBUtils.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)HIS_IN_QUERY_SQL, null);
        ArrayList<Object[]> inInsertParamList = new ArrayList<Object[]>(1000);
        if (!hisInRows.isEmpty()) {
            while (hisInRows.hasNext()) {
                Row row = hisInRows.next();
                inInsertParamList.add(new Object[]{row.getLong("fsbbid"), row.get("fid"), row.getInteger("frowno"), row.get("frowno"), row.get("fbillno"), row.get("fvoucherno"), row.get("fvouchertype"), row.get("fnsrsbh"), row.get("finvoicedate"), row.get("fgoodsnoid"), row.get("fgoodsname"), row.get("funitid"), row.get("famount"), row.get("fjsje"), row.get("ftaxrate"), row.get("frebaterate"), row.get("frebateamount"), row.get("fremark"), row.get("fsbbid"), row.get("ftaxtype"), row.get("fewblxh"), row.get("fzzsunit")});
            }
        }
        hisInRows.close();
        DataSet hisOutRows = DBUtils.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)HIS_OUT_QUERY_SQL, null);
        ArrayList<Object[]> outInsertParamList = new ArrayList<Object[]>(1000);
        if (!hisOutRows.isEmpty()) {
            while (hisOutRows.hasNext()) {
                Row row = hisOutRows.next();
                outInsertParamList.add(new Object[]{row.getLong("fsbbid"), row.get("fid"), row.getInteger("frowno"), row.get("frowno"), row.get("fbillno"), row.get("finvoiceno"), row.get("fcustomsno"), row.get("fcertificateno"), row.get("fexportdate"), row.get("fgoodsnoid"), row.get("fgoodsname"), row.get("funitid"), row.get("fexportamount"), row.get("ffobusd"), row.get("fdeclaregoodsid"), row.get("fbusinesstypeid"), row.get("fremark"), row.get("fsbbid"), row.get("fewblxh")});
            }
        }
        hisOutRows.close();
        try (TXHandle h = TX.requiresNew();){
            try {
                if (!inInsertParamList.isEmpty()) {
                    DBUtils.executeBatch((String)IN_INSERT_SQL, inInsertParamList);
                }
                if (!outInsertParamList.isEmpty()) {
                    DBUtils.executeBatch((String)OUT_INSERT_SQL, outInsertParamList);
                }
            }
            catch (Throwable t) {
                h.markRollback();
                throw t;
            }
        }
    }
}

