/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.business.draft;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcetr.business.draft.PatchNumberService;
import kd.taxc.tcetr.business.draft.task.CktsDraftAutoCalcTask;

public class CktsDraftService {
    public static final Log logger = LogFactory.getLog(CktsDraftService.class);
    private static final String entity = "tcetr_ckts_dgdj";
    private static final String MANUTACTUREENTITY = "tcetr_manufacturer_draft";
    private static final String TDM_EXPORT_DECLARATION = "tdm_export_declaration";
    private static final String SIM_VATINVOICE = "sim_vatinvoice";
    private static final String OUTENTRYENTITY = "outentryentity";
    private static final String INVOICEENTRYENTITY = "invoiceentryentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String DEALRATE = "dealrate";
    private static final String DOLLARRATE = "dollarrate";
    private static final String USD = "USD";
    private static final String TRADECURRENCY = "tradecurrency";
    private static final String EXPORTSELLAMOUNT = "exportsellamount";
    private static final String FOBPRICE = "fobprice";
    private static final String TRADEAMOUNT = "tradeamount";
    private static final String ZZSGLH = "zzsglh";
    private static final String INVOICEGLH = "invoiceglh";
    private static PatchNumberService patchNumberService = new PatchNumberService();

    public static DynamicObjectCollection query(Long orgId, Date month, String batchno) {
        String selectFields = "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,ktse,ckfph,ckhwbgdh,dlckhwzmmh,ckrq,ckspdm,jldw,cksl,mylaj,curreny,sbspdm,tmsywlx,jhslhj,ckspmcs,glh,sbny,sbpc,remaks,declarestatus,sbbbillno,datatype,sbbid,exportbasedata,ytzzsse,datasource,creator_id,modifier_id,auditor_id,org_id,ckspdm_id,jldw_id,curreny_id,sbspdm_id,tmsywlx_id,exportbasedata_id";
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("sbny", "=", (Object)month);
        QFilter q3 = new QFilter("sbpc", "=", (Object)batchno);
        return QueryServiceHelper.query((String)entity, (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3});
    }

    public static String querySbpc(Long orgId, Date month) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("sbny", "=", (Object)month);
        DynamicObjectCollection query = QueryServiceHelper.query((String)entity, (String)"id,sbpc", (QFilter[])new QFilter[]{q1, q2}, (String)"sbpc desc");
        return CollectionUtils.isEmpty((Collection)query) ? null : ((DynamicObject)query.get(0)).getString("sbpc");
    }

    public static DynamicObjectCollection queryManufacture(String declarenumber) {
        QFilter q1 = new QFilter("sbbbillno", "=", (Object)declarenumber);
        return QueryServiceHelper.query((String)MANUTACTUREENTITY, (String)"id", (QFilter[])new QFilter[]{q1});
    }

    public static DynamicObjectCollection draftFilter(Long orgId, Date month, String batchno, Predicate<DynamicObject> predicate) {
        DynamicObjectCollection query = CktsDraftService.query(orgId, month, batchno);
        if (query == null || query.size() == 0) {
            return new DynamicObjectCollection();
        }
        return query.stream().filter(s -> predicate.test((DynamicObject)s)).collect(Collectors.toCollection(DynamicObjectCollection::new));
    }

    public DynamicObject queryOneByBillno(String billno) {
        return QueryServiceHelper.queryOne((String)entity, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billno)});
    }

    public Map<Long, DynamicObject> getInvoiceMap(Collection collection) {
        DynamicObjectCollection invoiceList = this.getInvoiceList(collection);
        HashMap<Long, DynamicObject> rs = new HashMap<Long, DynamicObject>();
        for (DynamicObject dyo : invoiceList) {
            rs.put(dyo.getLong("sinvoicedetailid"), dyo);
        }
        return rs;
    }

    public DynamicObjectCollection getInvoiceList(Collection collection) {
        String selectProps = "invoiceno,issuetime,buyername,salertaxno,salername,items.id as sinvoicedetailid,items.goodsname as goodsname,items.goodscode as goodscode,items.specification as specification,items.unit as unit,items.num as num,items.unitprice as unitprice,items.amount as amount,items.taxrate as taxrate";
        DynamicObjectCollection vatinvoice = QueryServiceHelper.query((String)SIM_VATINVOICE, (String)selectProps, (QFilter[])new QFilter[]{new QFilter("items.id", "in", (Object)collection)});
        return vatinvoice;
    }

    public DynamicObject getExportDeclaration(Long pk) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)pk, (String)TDM_EXPORT_DECLARATION);
        return object;
    }

    public DynamicObject[] getExportDeclaration(List<Long> pk) {
        DynamicObject[] object = BusinessDataServiceHelper.load((Object[])pk.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TDM_EXPORT_DECLARATION));
        return object;
    }

    public List<Long> getInvoiceTypeId(String ... number) {
        List<Long> result = new ArrayList<Long>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bd_invoicetype", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)number)});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            result = Arrays.stream(dynamicObjects).map(s -> s.getLong("id")).collect(Collectors.toList());
        }
        return result;
    }

    public String getHxdw(Object writeofftypeid) {
        DynamicObject wfmapping = QueryServiceHelper.queryOne((String)"msmod_writeofftype", (String)"writeoffbillentry.wfmapping as wfmapping", (QFilter[])new QFilter[]{new QFilter("id", "=", writeofftypeid), new QFilter("writeoffbillentry.writeoffbilltype", "=", (Object)TDM_EXPORT_DECLARATION)});
        DynamicObject sbs = QueryServiceHelper.queryOne((String)"sbs_billfieldmapping", (String)"colsmap.sourcebillcol as sourcebillcol", (QFilter[])new QFilter[]{new QFilter("id", "=", wfmapping.get("wfmapping")), new QFilter("colsmap.targetobjcol", "=", (Object)"entry.unit")});
        String sourcebillcol = sbs.getString("sourcebillcol");
        if (StringUtils.isNotBlank((CharSequence)sourcebillcol)) {
            sourcebillcol = sourcebillcol.replace("entryentity.", "");
        }
        return sourcebillcol;
    }

    public DynamicObject initWfData(CktsDraftAutoCalcTask task, List<Object> successPkIds, DynamicObject mainData) {
        if (successPkIds != null && !successPkIds.isEmpty()) {
            DynamicObject[] wfRecords = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcetr_updownwfrecord"));
            HashMap<String, String> hxdwMap = new HashMap<String, String>();
            HashMap<Object, String> wfTypeIdHxdwMap = new HashMap<Object, String>();
            HashMap<String, List<DynamicObject>> exportGroup = new HashMap<String, List<DynamicObject>>();
            HashMap<String, List<DynamicObject>> invoiceGroup = new HashMap<String, List<DynamicObject>>();
            HashMap<String, List<DynamicObject>> specialGroup = new HashMap<String, List<DynamicObject>>();
            for (DynamicObject dynamicObject : wfRecords) {
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
                DynamicObject export = entry.stream().filter(o -> TDM_EXPORT_DECLARATION.equals(o.getString("billtype.number"))).findFirst().orElse(null);
                if (export == null) continue;
                String unique = export.getString("billno") + "_" + export.getString("invoicecode");
                Object writeofftypeid = dynamicObject.get("writeofftypeid.id");
                String hxdw = (String)wfTypeIdHxdwMap.get(writeofftypeid);
                if (StringUtils.isBlank((CharSequence)hxdw)) {
                    hxdw = this.getHxdw(writeofftypeid);
                }
                wfTypeIdHxdwMap.put(writeofftypeid, hxdw);
                hxdwMap.put(unique, hxdw);
                for (DynamicObject obj : entry) {
                    List list;
                    if (TDM_EXPORT_DECLARATION.equals(obj.getString("billtype.number"))) {
                        list = exportGroup.computeIfAbsent(unique, o -> new ArrayList());
                        list.add(obj);
                        continue;
                    }
                    if (SIM_VATINVOICE.equals(obj.getString("billtype.number"))) {
                        list = invoiceGroup.computeIfAbsent(unique, o -> new ArrayList());
                        list.add(obj);
                        continue;
                    }
                    if (!"rim_inv_special".equals(obj.getString("billtype.number")) && !"rim_inv_electric".equals(obj.getString("billtype.number"))) continue;
                    list = specialGroup.computeIfAbsent(unique, o -> new ArrayList());
                    list.add(obj);
                }
            }
            HashMap<String, DynamicObject> glhMap = new HashMap<String, DynamicObject>();
            this.setOutEntryEntity(mainData, exportGroup, hxdwMap, glhMap);
            task.feedbackProgress(30, null);
            this.setInvoiceEntity(mainData, invoiceGroup, glhMap);
            task.feedbackProgress(60, null);
            this.setZzsInvoiceEntry(mainData, specialGroup, glhMap);
        }
        return mainData;
    }

    private void setOutEntryEntity(DynamicObject mainData, Map<String, List<DynamicObject>> exportGroup, Map<String, String> hxdwMap, Map<String, DynamicObject> glhMap) {
        if (exportGroup != null && !exportGroup.isEmpty()) {
            ArrayList<Long> billIds = new ArrayList<Long>();
            HashMap exportIdMap = new HashMap(exportGroup.size());
            for (Map.Entry<String, List<DynamicObject>> entry : exportGroup.entrySet()) {
                List<DynamicObject> list = entry.getValue();
                Set billentryid = list.stream().map(o -> o.getLong("billid")).collect(Collectors.toSet());
                exportIdMap.put(entry.getKey(), billentryid);
                billIds.addAll(billentryid);
            }
            DynamicObjectCollection outRows = mainData.getDynamicObjectCollection(OUTENTRYENTITY);
            outRows.clear();
            DynamicObject[] exportDeclarations = this.getExportDeclaration(billIds);
            Map<Long, DynamicObject> exportDeclarationMap = Arrays.stream(exportDeclarations).collect(Collectors.toMap(d -> d.getLong("id"), d -> d));
            int index = 0;
            for (Map.Entry<String, List<DynamicObject>> gEntry : exportGroup.entrySet()) {
                List<DynamicObject> value = gEntry.getValue();
                String unique = gEntry.getKey();
                Set exportIds = (Set)exportIdMap.get(unique);
                if (CollectionUtils.isEmpty((Collection)exportIds)) continue;
                for (Long billid : exportIds) {
                    DynamicObject exportDeclaration = exportDeclarationMap.get(billid);
                    if (exportDeclaration == null) continue;
                    DynamicObjectCollection entryentity = exportDeclaration.getDynamicObjectCollection(ENTRYENTITY);
                    for (DynamicObject entry : entryentity) {
                        BigDecimal exportQty;
                        BigDecimal firstunitqty;
                        BigDecimal billqty;
                        String[] s = unique.split("_");
                        if (!s[1].equals(entry.getString("itemno"))) continue;
                        Map<Integer, String> associationCode = this.getOneGoodsGlh(mainData, index);
                        DynamicObject out = outRows.addNew();
                        String hxdw = hxdwMap.get(unique);
                        out.set("hxdw", (Object)hxdw);
                        this.setOutGoodsInfo(exportDeclaration, out, index, entry, associationCode, value);
                        glhMap.putIfAbsent(unique, out);
                        BigDecimal qty = out.getBigDecimal("qty");
                        if ("tradeunit".equals(hxdw)) {
                            billqty = entry.getBigDecimal("tradeqty");
                            firstunitqty = entry.getBigDecimal("firstunitqty");
                            exportQty = BigDecimal.ZERO;
                            if (BigDecimal.ZERO.compareTo(billqty) != 0) {
                                exportQty = qty.divide(billqty, 10, RoundingMode.HALF_UP).multiply(firstunitqty);
                                exportQty = this.getUnitQty(exportQty, out.getDynamicObject("unit1"));
                            }
                            out.set("exportqty", (Object)exportQty);
                        } else if ("secondunit".equals(hxdw)) {
                            billqty = entry.getBigDecimal("secondunitqty");
                            firstunitqty = entry.getBigDecimal("firstunitqty");
                            exportQty = BigDecimal.ZERO;
                            if (BigDecimal.ZERO.compareTo(billqty) != 0) {
                                exportQty = qty.divide(billqty, 10, RoundingMode.HALF_UP).multiply(firstunitqty);
                                exportQty = this.getUnitQty(exportQty, out.getDynamicObject("unit1"));
                            }
                            out.set("exportqty", (Object)exportQty);
                        }
                        out.set("tradeqty", (Object)this.getTradeQty(hxdw, qty, entry));
                        ++index;
                    }
                }
            }
        }
    }

    private void setInvoiceEntity(DynamicObject mainData, Map<String, List<DynamicObject>> invoiceGroup, Map<String, DynamicObject> glhMap) {
        if (invoiceGroup != null && !invoiceGroup.isEmpty()) {
            ArrayList billIds = new ArrayList();
            for (List<DynamicObject> list : invoiceGroup.values()) {
                Set billentryid = list.stream().map(o -> o.getLong("billentryid")).collect(Collectors.toSet());
                billIds.addAll(billentryid);
            }
            DynamicObjectCollection entryentity = mainData.getDynamicObjectCollection(INVOICEENTRYENTITY);
            entryentity.clear();
            String selectFields = "id,items.id as invoiceid,invoiceno,invoicecode,buyername,salertaxno,salername,issuetime as invoicedate,remark,items.goodsname as goodsname,items.unit as unit,items.num as num,items.unitprice as unitprice,items.taxrate as taxrate,items.amount as amount,items.specification as specification";
            DynamicObjectCollection resultList = QueryServiceHelper.query((String)SIM_VATINVOICE, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("items.id", "in", billIds)});
            Map<Long, DynamicObject> invoiceMap = resultList.stream().collect(Collectors.toMap(d -> d.getLong("invoiceid"), d -> d));
            for (Map.Entry<String, List<DynamicObject>> gEntry : invoiceGroup.entrySet()) {
                String unique = gEntry.getKey();
                List<DynamicObject> wfRecords = gEntry.getValue();
                Map<Long, List<DynamicObject>> map = wfRecords.stream().collect(Collectors.groupingBy(o -> o.getLong("billentryid")));
                for (Map.Entry<Long, List<DynamicObject>> wfRecord : map.entrySet()) {
                    long billid = wfRecord.getKey();
                    DynamicObject vatinvoice = invoiceMap.get(billid);
                    if (vatinvoice == null) continue;
                    DynamicObject invoice = entryentity.addNew();
                    this.setOutInvoiceModelValue(invoice, vatinvoice, wfRecord.getValue());
                    DynamicObject outEntry = glhMap.get(unique);
                    if (outEntry == null) continue;
                    invoice.set(INVOICEGLH, outEntry.get("goodsglh"));
                }
            }
        }
    }

    private void setZzsInvoiceEntry(DynamicObject mainData, Map<String, List<DynamicObject>> specialGroup, Map<String, DynamicObject> glhMap) {
        if (specialGroup != null && !specialGroup.isEmpty()) {
            ArrayList billIds = new ArrayList();
            for (List<DynamicObject> list : specialGroup.values()) {
                Set billentryid = list.stream().map(o -> o.getLong("billentryid")).collect(Collectors.toSet());
                billIds.addAll(billentryid);
            }
            DynamicObjectCollection entryentity = mainData.getDynamicObjectCollection(ENTRYENTITY);
            entryentity.clear();
            String selectFields = "id,items.id as invoiceid,invoice_no as invoiceno,effective_tax_amount,buyer_name as buyername,saler_tax_no as salertaxno,saler_name as salername,invoice_date as issuetime,remark,items.goods_name as goodsname,items.unit as unit,items.num as num,items.unit_price as unitprice,items.tax_rate as taxrate,items.detail_amount as amount,items.spec_model as specification";
            DynamicObjectCollection resultList = QueryServiceHelper.query((String)"rim_inv_special", (String)(selectFields + ", invoice_code as invoicecode"), (QFilter[])new QFilter[]{new QFilter("items.id", "in", billIds)});
            DynamicObjectCollection query2 = QueryServiceHelper.query((String)"rim_inv_electric", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("items.id", "in", billIds)});
            resultList.addAll((Collection)query2);
            Map<Long, DynamicObject> invoiceMap = resultList.stream().collect(Collectors.toMap(d -> d.getLong("invoiceid"), d -> d));
            for (Map.Entry<String, List<DynamicObject>> gEntry : specialGroup.entrySet()) {
                String unique = gEntry.getKey();
                DynamicObject maxIdx = null;
                BigDecimal maxJhsl = BigDecimal.ZERO;
                BigDecimal diff = null;
                List<DynamicObject> wfRecords = gEntry.getValue();
                Map<Long, List<DynamicObject>> map = wfRecords.stream().collect(Collectors.groupingBy(o -> o.getLong("billentryid")));
                for (Map.Entry<Long, List<DynamicObject>> wfRecord : map.entrySet()) {
                    long billno = wfRecord.getKey();
                    DynamicObject vatinvoice = invoiceMap.get(billno);
                    if (vatinvoice == null) continue;
                    DynamicObject zzsInv = entryentity.addNew();
                    this.setZzsInvoiceModelValue(zzsInv, vatinvoice, wfRecord.getValue());
                    DynamicObject outEntry = glhMap.get(unique);
                    if (outEntry == null) continue;
                    String goodsglh = outEntry.getString("goodsglh");
                    zzsInv.set(ZZSGLH, (Object)goodsglh);
                    BigDecimal exportqty = outEntry.getBigDecimal("exportqty");
                    if (diff == null) {
                        diff = exportqty;
                    }
                    BigDecimal invoiceqty = zzsInv.getBigDecimal("invoiceqty");
                    BigDecimal qty = wfRecords.stream().map(wf -> wf.getBigDecimal("qty")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    BigDecimal jhsl = BigDecimal.ZERO;
                    this.zzsGlhChangeCalc(zzsInv, outEntry);
                    if (BigDecimal.ZERO.compareTo(qty) != 0) {
                        jhsl = invoiceqty.divide(qty, 10, RoundingMode.HALF_UP).multiply(exportqty);
                        jhsl = this.getUnitQty(jhsl, zzsInv.getDynamicObject("jhjldw"));
                    }
                    diff = diff.subtract(jhsl);
                    if (maxJhsl.compareTo(jhsl) < 0) {
                        maxJhsl = jhsl;
                        maxIdx = zzsInv;
                    }
                    zzsInv.set("jhsl", (Object)jhsl);
                }
                if (maxIdx == null || diff == null) continue;
                maxIdx.set("jhsl", (Object)maxJhsl.add(diff));
            }
            this.updateYtzzsse(mainData);
        }
    }

    private void setOutGoodsInfo(DynamicObject exportDeclaration, DynamicObject outEntryData, int index, DynamicObject object, Map<Integer, String> associationCode, List<DynamicObject> wfRecord) {
        String itemno = object.getString("itemno");
        outEntryData.set(FOBPRICE, object.get("mylaj"));
        outEntryData.set("tradeqty", object.get("tradeqty"));
        if (wfRecord != null && !wfRecord.isEmpty()) {
            itemno = wfRecord.get(0).getString("invoicecode");
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal ftje = BigDecimal.ZERO;
            for (DynamicObject obj : wfRecord) {
                qty = qty.add(obj.getBigDecimal("qty"));
                ftje = ftje.add(obj.getBigDecimal("ftje"));
            }
            outEntryData.set("qty", (Object)qty);
            outEntryData.set(FOBPRICE, (Object)ftje);
            outEntryData.set("exportqty", (Object)qty);
            outEntryData.set("tradeqty", (Object)qty);
        }
        outEntryData.set("goodsid", (Object)object.getLong("id"));
        outEntryData.set("goodsitemno", (Object)itemno);
        outEntryData.set("hscode", object.get("hscode"));
        outEntryData.set("tradeunit", object.get("tradeunit"));
        outEntryData.set("tradeprice", object.get("tradeprice"));
        outEntryData.set(TRADECURRENCY, object.get(TRADECURRENCY));
        outEntryData.set(TRADEAMOUNT, object.get(TRADEAMOUNT));
        outEntryData.set("dcountry", object.get("dcountry"));
        outEntryData.set(DOLLARRATE, (Object)this.getDollarrate(outEntryData));
        BigDecimal exportsellamount = outEntryData.getBigDecimal(TRADEAMOUNT).multiply(outEntryData.getBigDecimal(DEALRATE));
        outEntryData.set(EXPORTSELLAMOUNT, (Object)exportsellamount);
        outEntryData.set("goodsglh", (Object)associationCode.get(index));
        outEntryData.set("exportbasedata1", (Object)exportDeclaration);
        String exportdata = exportDeclaration.getString("billno");
        outEntryData.set("goodsecdnum", (Object)(exportdata + "0" + itemno));
        outEntryData.set("ckrq1", (Object)exportDeclaration.getDate("exportdate"));
        outEntryData.set("unit1", object.get("firstunit"));
    }

    private void setOutInvoiceModelValue(DynamicObject model, DynamicObject object, List<DynamicObject> wfRecords) {
        String taxrateStr = object.getString("taxrate");
        if (wfRecords != null && !wfRecords.isEmpty()) {
            DynamicObject wfRecord = wfRecords.get(0);
            taxrateStr = this.getTaxRateStr(object.get("taxrate"));
            model.set("sissuetime", (Object)wfRecord.getDate("billdate"));
            model.set("sbuyername", (Object)wfRecord.getString("trade"));
            model.set("goodsname", (Object)wfRecord.getString("goodsname"));
        } else {
            model.set("sissuetime", (Object)object.getDate("issuetime"));
            model.set("sbuyername", (Object)object.getString("buyername"));
            model.set("goodsname", (Object)object.getString("goodsname"));
        }
        model.set("sinvoiceno", (Object)object.getString("invoiceno"));
        model.set("sinvoicedetailid", (Object)object.getLong("invoiceid"));
        model.set("specification", (Object)object.getString("specification"));
        model.set("unit", (Object)object.getString("unit"));
        model.set("num", (Object)object.getBigDecimal("num"));
        model.set("unitprice", (Object)object.getBigDecimal("unitprice"));
        model.set("amount", (Object)object.getBigDecimal("amount"));
        model.set("invoicetaxrate", (Object)taxrateStr);
    }

    private void setZzsInvoiceModelValue(DynamicObject zzsInv, DynamicObject object, List<DynamicObject> wfRecords) {
        String taxrateStr = object.getString("taxrate");
        if (wfRecords != null && !wfRecords.isEmpty()) {
            taxrateStr = this.getTaxRateStr(object.get("taxrate"));
            zzsInv.set("invoiceqty", (Object)wfRecords.stream().map(o -> o.getBigDecimal("qty")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            zzsInv.set("jsje", (Object)wfRecords.stream().map(o -> o.getBigDecimal("ftje")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
        } else {
            zzsInv.set("jhsl", (Object)object.getBigDecimal("num"));
            zzsInv.set("jsje", (Object)object.getBigDecimal("amount"));
        }
        zzsInv.set("pzzl", ((ComboProp)zzsInv.getDynamicObjectType().getProperty("pzzl")).getDefValue());
        String jhpzh = object.getDynamicObjectType().getProperties().containsKey((Object)"invoicecode") ? object.getString("invoicecode") + object.getString("invoiceno") : object.getString("invoiceno");
        zzsInv.set("jhpzh", (Object)jhpzh);
        zzsInv.set("sinvoicedetailid2", (Object)object.getLong("invoiceid"));
        zzsInv.set("ghfnsrsbh", (Object)object.getString("salertaxno"));
        zzsInv.set("ghfmc", (Object)object.getString("salername"));
        zzsInv.set("kprq", (Object)object.getDate("issuetime"));
        zzsInv.set("spmc", (Object)object.getString("goodsname"));
        zzsInv.set("invoiceunit", (Object)object.getString("unit"));
        zzsInv.set("zzsunit", (Object)object.getString("unit"));
        zzsInv.set("zzstaxrate", (Object)taxrateStr);
    }

    private void zzsGlhChangeCalc(DynamicObject entry, DynamicObject object) {
        if (object != null) {
            BigDecimal taxrate = Optional.ofNullable(object.getDynamicObject("hscode")).map(s -> s.getBigDecimal("taxrate")).orElse(BigDecimal.ZERO);
            BigDecimal rdrate = Optional.ofNullable(object.getDynamicObject("hscode")).map(s -> s.getBigDecimal("edrate")).orElse(BigDecimal.ZERO);
            entry.set("taxrateprop", (Object)taxrate);
            entry.set("edrateprop", (Object)rdrate);
            entry.set("backamount", (Object)entry.getBigDecimal("jsje").multiply(rdrate).divide(new BigDecimal("100"), 2, 4));
            entry.set("jhjldw", object.get("unit1"));
        } else {
            entry.set("taxrateprop", (Object)BigDecimal.ZERO);
            entry.set("edrateprop", (Object)BigDecimal.ZERO);
            entry.set("backamount", (Object)BigDecimal.ZERO);
            entry.set("jhjldw", null);
        }
    }

    private BigDecimal getTradeQty(String hxdw, BigDecimal qty, DynamicObject entry) {
        if (!"tradeunit".equals(hxdw)) {
            BigDecimal billqty = entry.getBigDecimal(hxdw + "qty");
            BigDecimal tradeqty = entry.getBigDecimal("tradeqty");
            BigDecimal exportQty = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(billqty) != 0) {
                exportQty = qty.divide(billqty, 10, RoundingMode.HALF_UP).multiply(tradeqty);
                exportQty = this.getUnitQty(exportQty, entry.getDynamicObject("tradeunit"));
            }
            return exportQty;
        }
        return qty;
    }

    private BigDecimal getDollarrate(DynamicObject rowEntity) {
        String number = Optional.ofNullable(rowEntity.getDynamicObject(TRADECURRENCY)).map(s -> s.getString("number")).orElse("");
        if (USD.equals(number)) {
            return rowEntity.getBigDecimal(DEALRATE);
        }
        return BigDecimal.ZERO;
    }

    private Map<Integer, String> getOneGoodsGlh(DynamicObject data, int index) {
        Date sbny = data.getDate("sbny");
        String sbpc = data.getString("sbpc");
        String oneAssociationCode = patchNumberService.getOneAssociationCode(sbny, sbpc, index + 1);
        HashMap<Integer, String> rs = new HashMap<Integer, String>();
        rs.put(index, oneAssociationCode);
        return rs;
    }

    public DynamicObjectCollection queryRunningSchTaskByJobId(String jobId) {
        return QueryServiceHelper.query((String)"sch_task", (String)"id", (QFilter[])new QFilter[]{new QFilter("job", "=", (Object)jobId), new QFilter("status", "=", (Object)"BEGIN")}, (String)"dispatchtime desc", (int)1);
    }

    public JobFormInfo createJobFormInfo(String appId, String jobName, String jobId, String taskClassName, String clickClassName, Map<String, Object> customParam, CloseCallBack closeCallBack) {
        JobInfo jobInfo = this.createJobInfo(appId, jobName, jobId, taskClassName, customParam);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(jobInfo.getName());
        if (null != closeCallBack) {
            jobFormInfo.setCloseCallBack(closeCallBack);
        }
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName(clickClassName);
        return jobFormInfo;
    }

    public JobInfo createJobInfo(String appId, String jobName, String jobId, String taskClassName, Map<String, Object> customParam) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(jobName);
        jobInfo.setId(jobId);
        jobInfo.setTaskClassname(taskClassName);
        jobInfo.setParams(customParam);
        return jobInfo;
    }

    private void updateYtzzsse(DynamicObject mainData) {
        DynamicObjectCollection entryEntity = mainData.getDynamicObjectCollection(ENTRYENTITY);
        BigDecimal ytzzsse = entryEntity.stream().map(entry -> entry.getBigDecimal("backamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        mainData.set("ytzzsse", (Object)ytzzsse);
    }

    public String getTaxRateStr(Object taxrate) {
        String taxrateStr = "0";
        try {
            if (taxrate instanceof String && StringUtil.isNotEmpty((CharSequence)taxrate.toString())) {
                taxrateStr = new BigDecimal(taxrate.toString()).setScale(2).toString();
            }
            if (taxrate instanceof BigDecimal) {
                taxrateStr = ((BigDecimal)taxrate).setScale(2).toString();
            }
            taxrateStr = "0.00".equals(taxrateStr) ? "0" : taxrateStr;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return taxrateStr;
    }

    public BigDecimal getUnitQty(BigDecimal baseQuantity, DynamicObject unit) {
        BigDecimal unitQty;
        if (unit != null) {
            int precisionaccount = unit.getInt("precisionaccount");
            int precision = unit.getInt("precision");
            unitQty = precisionaccount == 2 ? baseQuantity.setScale(precision, 1) : (precisionaccount == 3 ? baseQuantity.setScale(precision, 0) : baseQuantity.setScale(precision, 4));
        } else {
            unitQty = baseQuantity.setScale(10, 4);
        }
        return unitQty;
    }
}

