/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.business.draft;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcetr.business.draft.CktsDraftService;

public class PatchNumberService {
    private static final String DEFAULT_INIT = "001";
    private static final Pattern pattern = Pattern.compile("[^0-9]");

    public String generator(Long orgId, Date sbny) {
        String sbpc = CktsDraftService.querySbpc(orgId, sbny);
        if (StringUtil.isEmpty((CharSequence)sbpc) || "null".equals(sbpc)) {
            return DEFAULT_INIT;
        }
        Matcher matcher = pattern.matcher(sbpc);
        String all = matcher.replaceAll("");
        int s = Integer.parseInt(all) + 1;
        return String.format("%03d", s);
    }

    public String getOneAssociationCode(Date sbny, String sbpc, int index) {
        if (sbny == null || sbpc == null) {
            return "";
        }
        String dateStr = DateUtils.format((Date)sbny, (String)"YYYYMM");
        return dateStr + sbpc + String.format("%08d", index);
    }

    public Map<Integer, String> getAssociationCode(Date sbny, String sbpc, int size) {
        HashMap<Integer, String> result = new HashMap<Integer, String>(16);
        if (sbny == null || sbpc == null) {
            return result;
        }
        String dateStr = DateUtils.format((Date)sbny, (String)"YYYYMM");
        Map<Integer, String> collect = IntStream.range(0, size).boxed().collect(Collectors.toMap(s -> s, s -> dateStr + sbpc + String.format("%08d", s + 1)));
        return collect;
    }
}

