/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.business.draft.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.tcetr.business.draft.CktsDraftService;

public class CktsDraftAutoCalcTask
extends AbstractTask {
    private CktsDraftService service = new CktsDraftService();
    private String message = "";
    private static final Log logger = LogFactory.getLog(CktsDraftAutoCalcTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e", (String)"CktsDraftAutoCalcTask_0", (String)"taxc-tcetr", (Object[])new Object[0]), null);
        String orgName = (String)map.get("orgname");
        String mainDataMap = (String)map.get("mainData");
        Object[] datas = DynamicObjectSerializeUtil.deserialize((String)mainDataMap, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcetr_ckts_dgdj"));
        DynamicObject obj = (DynamicObject)datas[0];
        DynamicObject mainData = BusinessDataServiceHelper.newDynamicObject((String)"tcetr_ckts_dgdj");
        DataEntityPropertyCollection properties = mainData.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            mainData.set(property, obj.get(property));
        }
        List successPkIds = (List)map.get("wfRecordId");
        this.message = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5916\u8d38\u4f01\u4e1a\u9000\u7a0e\u5e95\u7a3f\u751f\u6210\u4efb\u52a1", (String)"CktsDraftAutoCalcTask_1", (String)"taxc-tcetr", (Object[])new Object[0]), orgName);
        try {
            this.feedbackProgress(10, this.message, null);
            this.service.initWfData(this, successPkIds, mainData);
            this.feedbackProgress(90, this.message, null);
            OperateOption option = OperateOption.create();
            option.setVariableValue("wfRecordId", SerializationUtils.toJsonString((Object)successPkIds));
            OperationResult result = SaveServiceHelper.saveOperate((String)mainData.getDynamicObjectType().getName(), (DynamicObject[])new DynamicObject[]{mainData}, (OperateOption)option);
            if (!result.isSuccess()) {
                this.rollbackWfRecordStatus(successPkIds);
                logger.warn("generate drawback draft fail", (Object)result.getAllErrorInfo());
                this.message = result.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getMessage).findFirst().orElseGet(() -> ((OperationResult)result).getMessage());
                this.feedbackResult(map, Boolean.FALSE.toString());
                return;
            }
        }
        catch (Exception e) {
            this.rollbackWfRecordStatus(successPkIds);
            logger.warn("generate drawbakc draft exception", (Throwable)e);
            throw e;
        }
        this.feedbackProgress(100, this.message, null);
        this.feedbackResult(map, Boolean.TRUE.toString());
    }

    private void feedbackResult(Map<String, Object> map, String isSuccess) {
        map.put("success", isSuccess);
        map.put("message", this.message);
        this.feedbackCustomdata(map);
    }

    public void feedbackProgress(int progress, Map<String, Object> customData) {
        this.feedbackProgress(progress, this.message, customData);
    }

    private void rollbackWfRecordStatus(List<Object> successPkIds) {
        ArrayList<DynamicObject> wfRecordUpdList = new ArrayList<DynamicObject>(successPkIds.size());
        for (Object successPkId : successPkIds) {
            DynamicObject wfRecord = BusinessDataServiceHelper.newDynamicObject((String)"tcetr_updownwfrecord");
            wfRecord.set("id", successPkId);
            wfRecord.set("iscreatedraft", (Object)"0");
            wfRecordUpdList.add(wfRecord);
        }
        SaveServiceHelper.update((DynamicObject[])wfRecordUpdList.toArray(new DynamicObject[0]));
    }
}

