/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.business.model;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class DrawBackDeclareHeader {
    public static final Date DEFAULT_DATE = Date.from(LocalDate.of(9999, 1, 1).atStartOfDay(ZoneId.systemDefault()).toInstant());
    private Long org;
    private String orgName;
    private Date skssqq;
    private Date skssqz;
    private Date month;
    private String batchNo;
    private String type;

    public DrawBackDeclareHeader(Long org, String orgName, Date month, String batchNo) {
        this.org = org;
        this.orgName = orgName;
        this.month = month;
        this.batchNo = batchNo;
        this.skssqq = month != null ? DateUtils.getFirstDateOfMonth((Date)month) : null;
        this.skssqz = month != null ? DateUtils.getLastDateOfMonth1((Date)month) : null;
    }

    public boolean canLoad() {
        return this.org != null && this.org != 0L && this.month != null && this.month != DEFAULT_DATE;
    }

    public Long getOrg() {
        return this.org;
    }

    public void setOrg(Long org) {
        this.org = org;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Date getSkssqq() {
        return this.skssqq;
    }

    public void setSkssqq(Date skssqq) {
        this.skssqq = skssqq;
    }

    public Date getSkssqz() {
        return this.skssqz;
    }

    public void setSkssqz(Date skssqz) {
        this.skssqz = skssqz;
    }

    public Date getMonth() {
        return this.month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public String getBatchNo() {
        return this.batchNo;
    }

    public void setBatchNo(String batchNo) {
        this.batchNo = batchNo;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

