/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.business.sbb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.tcetr.business.sbb.DeclareService;

public class DeclareQueryListService {
    public static final String AUDIT = "audit";
    public static final String SUBMIT = "submit";
    public static final String UNAUDIT = "unaudit";
    public static final String UNSUBMIT = "unsubmit";

    private DeclareQueryListService() {
    }

    public static ValidDataResultVo submit(List<Object> pklist, String operationKey, String entryName, boolean isQueryList) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryName);
        DynamicObject[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
        ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
        String msg = "";
        if (loadResult == null || loadResult.length < 1) {
            msg = isQueryList ? ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e", (String)"DeclareQueryListService_0", (String)"taxc-tcetr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u62a5\u8868\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u91cd\u7f6e,\u8bf7\u5237\u65b0\u540e\u518d\u64cd\u4f5c", (String)"DeclareQueryListService_1", (String)"taxc-tcetr", (Object[])new Object[0]);
            return ValidDataResultVo.fail((String)msg);
        }
        for (DynamicObject obj : loadResult) {
            boolean isUnAudit;
            String billstatus = obj.getString("billstatus");
            String declareStatus = obj.getString("declarestatus");
            boolean isSumbit = "A".equals(billstatus) && StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey);
            boolean isUnSumbit = "B".equals(billstatus) && StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey);
            boolean isAudit = "B".equals(billstatus) && StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey);
            boolean bl = isUnAudit = "C".equals(billstatus) && !"declared".equals(declareStatus) && StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey);
            if (isSumbit || isUnSumbit || isAudit || isUnAudit) {
                updateList.add(obj);
                continue;
            }
            String nsrmc = obj.getDynamicObject("org").getString("name");
            Date skssqq = obj.getDate("skssqq");
            msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"DeclareQueryListService_2", (String)"taxc-tcetr", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
            if (StringUtils.equals((CharSequence)SUBMIT, (CharSequence)operationKey) && !"A".equals(billstatus)) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u6682\u5b58\u624d\u80fd\u63d0\u4ea4\u3002", (String)"DeclareQueryListService_3", (String)"taxc-tcetr", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
            }
            if (StringUtils.equals((CharSequence)UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"DeclareQueryListService_4", (String)"taxc-tcetr", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
            }
            if (StringUtils.equals((CharSequence)AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"DeclareQueryListService_5", (String)"taxc-tcetr", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
            }
            if (StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
                msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838", (String)"DeclareQueryListService_6", (String)"taxc-tcetr", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
            }
            if (!StringUtils.equals((CharSequence)UNAUDIT, (CharSequence)operationKey) || !"declared".equals(declareStatus)) continue;
            msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838", (String)"DeclareQueryListService_7", (String)"taxc-tcetr", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return ValidDataResultVo.fail((String)msg);
        }
        DynamicObject workProcess = DeclareService.getWorkProcess(entryName);
        if (workProcess == null) {
            if (!CollectionUtils.isEmpty(updateList)) {
                DeclareService.updateData(updateList, operationKey);
                return ValidDataResultVo.success((String)DeclareQueryListService.getMsg(operationKey));
            }
        } else {
            OperationResult result = OperationServiceHelper.executeOperate((String)operationKey, (String)entryName, (DynamicObject[])updateList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (!result.isSuccess()) {
                String message = "";
                List allErrorOrValidateInfo = result.getAllErrorOrValidateInfo();
                message = allErrorOrValidateInfo != null && allErrorOrValidateInfo.size() > 0 ? allErrorOrValidateInfo.stream().map(s -> s.getMessage()).collect(Collectors.joining(",")) : result.getMessage();
                return ValidDataResultVo.fail((String)message, (Object)result);
            }
            return ValidDataResultVo.success((String)DeclareQueryListService.getMsg(operationKey));
        }
        return ValidDataResultVo.success();
    }

    private static String getMsg(String operationKey) {
        String msg = "";
        switch (operationKey) {
            case "submit": {
                msg = ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"DeclareQueryListService_8", (String)"taxc-tcetr", (Object[])new Object[0]);
                break;
            }
            case "unsubmit": {
                msg = ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"DeclareQueryListService_9", (String)"taxc-tcetr", (Object[])new Object[0]);
                break;
            }
            case "audit": {
                msg = ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f", (String)"DeclareQueryListService_10", (String)"taxc-tcetr", (Object[])new Object[0]);
                break;
            }
            case "unaudit": {
                msg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u6210\u529f", (String)"DeclareQueryListService_11", (String)"taxc-tcetr", (Object[])new Object[0]);
            }
        }
        return msg;
    }
}

