/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.business.sbb;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.BaseRowModel;
import kd.taxc.bdtaxr.common.dto.MultipleSheetPropety;
import kd.taxc.bdtaxr.common.dto.Sheet;
import kd.taxc.bdtaxr.common.util.bean.BeanUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.file.ExportExcelUtils;
import org.apache.commons.collections.CollectionUtils;

public class DeclareService {
    private static final String ENTITY = "tcetr_declare_main";
    private static final String selectFields = "id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,org,type,skssqq,skssqz,month,batchno,sourcetype,declarestatus,sbtse,nsrsbh,nsrmc,zzsamount,xfsamount,declarer,declaredate,templateid,ewblxh,mdtsehj,ytse,mdse,mdtse,creator_id,modifier_id,auditor_id,org_id,declarer_id";
    private static final Log logger = LogFactory.getLog(DeclareService.class);

    public static DynamicObject queryDeclareMain(Long orgId, Date month, String batchno, String type) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("month", "=", (Object)month);
        QFilter q3 = new QFilter("batchno", "=", (Object)batchno);
        QFilter q4 = new QFilter("type", "=", (Object)type);
        DynamicObject object = QueryServiceHelper.queryOne((String)ENTITY, (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3, q4});
        return object;
    }

    public static String queryPatch(Long orgId, Date month, String declarestatus) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("month", "=", (Object)month);
        QFilter q3 = new QFilter("declarestatus", "=", (Object)declarestatus);
        DynamicObjectCollection query = QueryServiceHelper.query((String)ENTITY, (String)"id,batchno", (QFilter[])new QFilter[]{q1, q2, q3}, (String)"batchno desc");
        return CollectionUtils.isEmpty((Collection)query) ? null : ((DynamicObject)query.get(0)).getString("batchno");
    }

    public static DynamicObject getDeclareMain(Long orgId, Date month, String type) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("month", "=", (Object)month);
        QFilter q3 = new QFilter("type", "=", (Object)type);
        DynamicObject object = QueryServiceHelper.queryOne((String)ENTITY, (String)selectFields, (QFilter[])new QFilter[]{q1, q2, q3});
        return object;
    }

    public static DynamicObject queryLastDeclareMain(Long orgId, String declarestatus) {
        QFilter q1 = new QFilter("org", "=", (Object)orgId);
        QFilter q2 = new QFilter("declarestatus", "=", (Object)declarestatus);
        DynamicObjectCollection objects = QueryServiceHelper.query((String)ENTITY, (String)"month,batchno", (QFilter[])new QFilter[]{q1, q2}, (String)"createtime desc");
        if (CollectionUtils.isEmpty((Collection)objects)) {
            return null;
        }
        return (DynamicObject)objects.get(0);
    }

    public static DynamicObject getWorkProcess(String entryName) {
        QFilter qFilter1 = new QFilter("entrabill", "=", (Object)entryName);
        QFilter qFilter2 = new QFilter("enable", "=", (Object)"enable");
        return QueryServiceHelper.queryOne((String)"wf_processdefinition", (String)"id", (QFilter[])new QFilter[]{qFilter1, qFilter2});
    }

    public static void updateData(List<DynamicObject> updateList, String operationKey) {
        String billstatus = "billstatus";
        for (DynamicObject obj : updateList) {
            if (StringUtils.equals((CharSequence)"submit", (CharSequence)operationKey)) {
                obj.set(billstatus, (Object)"B");
            }
            if (StringUtils.equals((CharSequence)"unsubmit", (CharSequence)operationKey)) {
                obj.set(billstatus, (Object)"A");
            }
            if (StringUtils.equals((CharSequence)"audit", (CharSequence)operationKey)) {
                obj.set(billstatus, (Object)"C");
            }
            if (StringUtils.equals((CharSequence)"unaudit", (CharSequence)operationKey)) {
                obj.set(billstatus, (Object)"A");
            }
            obj.set("auditdate", (Object)new Date());
            obj.set("auditor", (Object)RequestContext.get().getUserId());
            obj.set("modifier", (Object)RequestContext.get().getUserId());
            obj.set("modifytime", (Object)new Date());
        }
        SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[0]));
    }

    public static void deleteReportByFilter(String templateTypeId, QFilter filter) {
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tpo_template_type");
        String mainTable = typeObject.getString("maintable");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)mainTable, (String)"id", (QFilter[])new QFilter[]{filter});
        if (collection == null || collection.isEmpty()) {
            return;
        }
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject dObject : collection) {
            String mainId = dObject.getString("id");
            QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)dObject.getString("id"));
            if (entityList == null || entityList.isEmpty()) continue;
            for (DynamicObject dobj : entityList) {
                String entityId = dobj.getString("entityid");
                if (mainTable.equals(entityId)) {
                    DeleteServiceHelper.delete((String)mainTable, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(mainId))});
                    continue;
                }
                DeleteServiceHelper.delete((String)entityId, (QFilter[])new QFilter[]{sbbIdFilter});
            }
        }
    }

    public String exportSheetResult(DynamicObject sbb) {
        String urls;
        File file;
        DynamicObjectCollection inEntry;
        List inData;
        DynamicObjectCollection outEntry;
        List outData;
        if (sbb == null) {
            return null;
        }
        ArrayList<MultipleSheetPropety> multipleData = new ArrayList<MultipleSheetPropety>(8);
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.add((Object)sbb);
        List baseInfo = BeanUtils.dynamicToDto((String)"kd.taxc.tcetr.common.dto.TcetrWmqyDeclareBaseInfoExportDto", null, (DynamicObjectCollection)collection, (String)"", (DynamicObjectType)collection.getDynamicObjectType());
        if (CollectionUtils.isNotEmpty((Collection)baseInfo)) {
            this.addMutipleSheetProperty(multipleData, baseInfo, 1, ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"DeclareService_0", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)(outData = BeanUtils.dynamicToDto((String)"kd.taxc.tcetr.common.dto.TcetrWmqyDeclareOutDetailEntryExportDto", null, (DynamicObjectCollection)(outEntry = sbb.getDynamicObjectCollection("entryentity")), (String)"", (DynamicObjectType)outEntry.getDynamicObjectType())))) {
            this.addMutipleSheetProperty(multipleData, outData, 2, ResManager.loadKDString((String)"\u5916\u8d38\u4f01\u4e1a\u51fa\u53e3\u9000\u7a0e\u51fa\u53e3\u660e\u7ec6\u7533\u62a5\u8868", (String)"DeclareService_1", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        if (CollectionUtils.isNotEmpty((Collection)(inData = BeanUtils.dynamicToDto((String)"kd.taxc.tcetr.common.dto.TcetrWmqyDeclareInDetailEntryExportDto", null, (DynamicObjectCollection)(inEntry = sbb.getDynamicObjectCollection("entryentity1")), (String)"", (DynamicObjectType)inEntry.getDynamicObjectType())))) {
            this.addMutipleSheetProperty(multipleData, inData, 3, ResManager.loadKDString((String)"\u5916\u8d38\u4f01\u4e1a\u51fa\u53e3\u9000\u7a0e\u8fdb\u8d27\u660e\u7ec6\u7533\u62a5\u8868", (String)"DeclareService_2", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        if ((file = ExportExcelUtils.exportExcelWithMultipleSheet(multipleData, null)) == null) {
            return null;
        }
        String string = ResManager.loadKDString((String)"\u5916\u8d38\u4f01\u4e1a\u51fa\u53e3\u9000\u7a0e\u7533\u62a5\u8868", (String)"DeclareService_3", (String)"taxc-tcetr", (Object[])new Object[0]);
        String fileName = string + "_" + sbb.getString("org.name") + DateUtils.format((Date)sbb.getDate("month"), (String)DateUtils.YYYYMM) + "_" + sbb.getString("batchno");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)fis, 5000);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return urls;
    }

    private void addMutipleSheetProperty(List<MultipleSheetPropety> multipleData, List<? extends BaseRowModel> data, int index, String sheetName) {
        MultipleSheetPropety multipleSheet = new MultipleSheetPropety();
        multipleSheet.setData(data);
        Sheet sheet = new Sheet(index, 0);
        sheet.setSheetName(sheetName);
        sheet.setAutoWidth(Boolean.TRUE);
        multipleSheet.setSheet(sheet);
        multipleData.add(multipleSheet);
    }
}

