/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.business.wfmanual;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.mpscmm.mscommon.mservice.common.impl.WriteOffServiceImpl;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class WmAutoWfTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(WmAutoWfTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        HashMap<String, String> result = new HashMap<String, String>();
        String msg = "";
        try {
            this.logParams(map);
            this.callService(map);
            result.put("success", "true");
        }
        catch (Throwable t) {
            LOGGER.error("WmAutoWfTask Error!", t);
            String message = t.getMessage() == null ? t.getMessage() : t.getMessage().replace("kd.bos.exception.KDBizException:", "");
            this.feedbackProgress(90, message, null);
            result.put("success", "false");
            msg = message;
        }
        result.put("message", msg);
        this.feedbackProgress(100, "", null);
        this.feedbackCustomdata(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callService(Map<String, Object> map) throws Exception {
        long org;
        long l = org = map.get("org") instanceof Integer ? ((Integer)map.get("org")).longValue() : ((Long)map.get("org")).longValue();
        if (org > 0L) {
            String lockKey = "wmautowftasklockkey:" + org;
            DLock reentrant = DLock.createReentrant((String)lockKey, (String)"kd.taxc.tcetr.business.wfmanual.WmAutoWfTask.execute");
            reentrant.fastMode();
            boolean b = reentrant.tryLock(1000L);
            if (!b) {
                String orgName = (String)map.getOrDefault("orgName", "");
                String message = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7[%s]\u5df2\u6709\u4efb\u52a1\u5728\u6267\u884c\u3002", (String)"WmAutoWfTask_0", (String)"taxc-tcetr", (Object[])new Object[0]), orgName);
                throw new KDBizException(message);
            }
            try {
                long wfTypeByForm = map.get("wfTypeByForm") instanceof Integer ? ((Integer)map.get("wfTypeByForm")).longValue() : ((Long)map.get("wfTypeByForm")).longValue();
                Map schemaMap = (Map)map.get("schemaMap");
                Date wfDate = DateUtils.stringToDate2((String)((String)map.get("wfDate")), (String)"yyyy-MM-dd HH:mm:ss");
                Map conditionsMap = (Map)map.get("conditionsMap");
                Map extParam = (Map)map.get("extParam");
                WriteOffServiceImpl writeOffService = new WriteOffServiceImpl();
                writeOffService.startAutoManualWriteOff(Long.valueOf(wfTypeByForm), schemaMap, wfDate, conditionsMap, extParam);
            }
            finally {
                reentrant.unlock();
            }
        }
    }

    private void logParams(Map<String, Object> map) {
        try {
            LOGGER.info("WmAutoWfTask params: {}", (Object)SerializationUtils.toJsonString(map));
        }
        catch (Throwable t) {
            LOGGER.error("WmAutoWfTask logParams Error!", t);
        }
    }
}

