/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.draft;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tcetr.business.draft.CktsDraftService;

public class ChtsDraftInvoiceDetailPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(ChtsDraftInvoiceDetailPlugin.class);
    private static final String RIM_INV_SPECIAL = "rim_inv_special";
    private static final String RIM_INV_ELECTRIC = "rim_inv_electric";
    private static final String OUT_INVOICE = "out_invoice";
    private static final String ZZS_INVOICE = "zzs_invoice";
    private static final String SIM_VATINVOICE = "sim_vatinvoice";
    private static final CktsDraftService cktsDraftService = new CktsDraftService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String type = (String)customParams.get("type");
        String orgid = (String)customParams.get("orgid");
        DynamicObject taxorg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"unifiedsocialcode, taxpayer", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(orgid))});
        String unifiedsocialcode = Optional.ofNullable(taxorg).map(s -> s.getString("unifiedsocialcode")).orElse("");
        List selectedInvoiceDetailIds = (List)customParams.get("selectedInvoiceDetailIds");
        DynamicObjectCollection resultList = new DynamicObjectCollection();
        if (OUT_INVOICE.equals(type)) {
            resultList = this.getOutInvoiceDetail(unifiedsocialcode, selectedInvoiceDetailIds);
        }
        if (ZZS_INVOICE.equals(type)) {
            resultList = this.getZzsInvoiceDetail(unifiedsocialcode, selectedInvoiceDetailIds);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        if (resultList.isEmpty()) {
            return;
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", resultList.size());
        int rowIndex = 0;
        for (DynamicObject object : resultList) {
            model.setValue("invoiceno", object.get("invoiceno"), rowIndex);
            model.setValue("issuetime", (Object)object.getDate("invoicedate"), rowIndex);
            model.setValue("buyername", object.get("buyername"), rowIndex);
            model.setValue("goodsname", (Object)object.getString("goodsname"), rowIndex);
            model.setValue("specification", (Object)object.getString("spec"), rowIndex);
            model.setValue("unit", (Object)object.getString("unit"), rowIndex);
            model.setValue("num", (Object)object.getBigDecimal("num"), rowIndex);
            model.setValue("unitprice", (Object)object.getBigDecimal("unitprice"), rowIndex);
            model.setValue("amount", (Object)object.getBigDecimal("amount"), rowIndex);
            model.setValue("remark", (Object)object.getString("remark"), rowIndex);
            model.setValue("invoiceid", (Object)object.getLong("itemsId"), rowIndex);
            model.setValue("salertaxno", object.get("salertaxno"), rowIndex);
            model.setValue("salername", object.get("salername"), rowIndex);
            String taxrateStr = cktsDraftService.getTaxRateStr(object.get("taxrate"));
            model.setValue("taxrate", (Object)taxrateStr, rowIndex);
            if (object.getDynamicObjectType().getProperties().containsKey((Object)"invoicecode")) {
                model.setValue("invoicecode", (Object)object.getString("invoicecode"), rowIndex);
            }
            if (object.getDynamicObjectType().getProperties().containsKey((Object)"effective_tax_amount")) {
                model.setValue("effective_tax_amount", (Object)object.getBigDecimal("effective_tax_amount"), rowIndex);
            }
            ++rowIndex;
        }
        this.getView().setVisible(Boolean.valueOf(ZZS_INVOICE.equals(type)), new String[]{"effective_tax_amount"});
        model.endInit();
        this.getView().updateView("entryentity");
    }

    private QFilter getInvoiceTypeQfilter(String flag) {
        QFilter filter = null;
        if (RIM_INV_SPECIAL.equals(flag)) {
            filter = new QFilter("invoice_type", "in", cktsDraftService.getInvoiceTypeId("2", "4"));
        } else if (RIM_INV_ELECTRIC.equals(flag)) {
            filter = new QFilter("invoice_type", "in", cktsDraftService.getInvoiceTypeId("27"));
        } else if (SIM_VATINVOICE.equals(flag)) {
            filter = new QFilter("baseinvoicetype", "in", cktsDraftService.getInvoiceTypeId("1", "3", "26"));
        }
        return filter;
    }

    public DynamicObjectCollection getZzsInvoiceDetail(String unifiedsocialcode, List<Long> selectedInvoiceDetailIds) {
        DynamicObjectCollection resultList = new DynamicObjectCollection();
        QFilter notInIdFilter = new QFilter("items.id", "not in", selectedInvoiceDetailIds);
        QFilter filter = new QFilter("buyer_tax_no", "=", (Object)unifiedsocialcode).or(new QFilter("saler_tax_no", "=", (Object)unifiedsocialcode));
        String selectFields = "id,items.id as itemsId,invoice_no as invoiceno,effective_tax_amount ,buyer_name as buyername,saler_tax_no as salertaxno,saler_name as salername,invoice_date as invoicedate,remark,items.goods_name as goodsname,items.unit as unit,items.num as num,items.unit_price as unitprice,items.tax_rate as taxrate,items.detail_amount as amount,items.spec_model as spec";
        DynamicObjectCollection query = QueryServiceHelper.query((String)RIM_INV_SPECIAL, (String)(selectFields + ", invoice_code as invoicecode"), (QFilter[])new QFilter[]{notInIdFilter, filter, this.getInvoiceTypeQfilter(RIM_INV_SPECIAL)});
        resultList.addAll((Collection)query);
        DynamicObjectCollection query2 = QueryServiceHelper.query((String)RIM_INV_ELECTRIC, (String)selectFields, (QFilter[])new QFilter[]{notInIdFilter, filter, this.getInvoiceTypeQfilter(RIM_INV_ELECTRIC)});
        resultList.addAll((Collection)query2);
        return resultList;
    }

    public DynamicObjectCollection getOutInvoiceDetail(String unifiedsocialcode, List<Long> selectedInvoiceDetailIds) {
        QFilter notInIdFilter = new QFilter("items.id", "not in", selectedInvoiceDetailIds);
        QFilter filter = new QFilter("salertaxno", "=", (Object)unifiedsocialcode);
        QFilter zeroFilter = new QFilter("items.taxrate", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "0.0"}));
        String selectFields = "id,items.id as itemsId,invoiceno,invoicecode,buyername,salertaxno,salername,issuetime as invoicedate,remark,items.goodsname as goodsname,items.unit as unit,items.num as num,items.unitprice as unitprice,items.taxrate as taxrate,items.amount as amount,items.specification as spec";
        DynamicObjectCollection resultList = QueryServiceHelper.query((String)SIM_VATINVOICE, (String)selectFields, (QFilter[])new QFilter[]{notInIdFilter, zeroFilter, filter, this.getInvoiceTypeQfilter(SIM_VATINVOICE)});
        return resultList;
    }

    public void click(EventObject evt) {
        Button btn;
        Object source = evt.getSource();
        if (source instanceof Button && (btn = (Button)source).getKey().equals("btnok")) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            if (selectRows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u53d1\u7968", (String)"ChtsDraftInvoiceDetailPlugin_0", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            List entryentity = Arrays.stream(selectRows).boxed().map(index -> entryGrid.getModel().getEntryRowEntity("entryentity", index.intValue())).collect(Collectors.toList());
            HashMap<String, List<Object>> result = new HashMap<String, List<Object>>(16);
            result.put("selectedRows", entryentity);
            result.put("type", (List<Object>)customParams.get("type"));
            this.getView().returnDataToParent(result);
            this.getView().close();
        }
    }
}

