/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.draft;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.taxc.bdtaxr.common.functionalinterfaceext.ThreeConsumer;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcetr.business.draft.CktsDraftService;
import kd.taxc.tcetr.business.draft.PatchNumberService;
import kd.taxc.tcetr.business.draft.task.CktsCalcTaskClick;

public class CktsDraftFormPlugin
extends AbstractBillPlugIn
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String INVOICE_ADD_ROW = "invoiceaddrow";
    private static final String INVOICE_DEL_ROW = "invoicedelrow";
    private static final String GOODS_ADD_ROW = "goodsaddrow";
    private static final String GOODS_DEL_ROW = "goodsdelrow";
    private static final String TCETR_INVOICE_LIST = "tcetr_invoice_list";
    private static final String INVOICEENTRYENTITY = "invoiceentryentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String OUT_INVOICE = "out_invoice";
    private static final String ZZS_INVOICE = "zzs_invoice";
    private static final String OUTENTRYENTITY = "outentryentity";
    private static final String DEALRATE = "dealrate";
    private static final String DOLLARRATE = "dollarrate";
    private static final String USD = "USD";
    private static final String TRADECURRENCY = "tradecurrency";
    private static final String EXPORTSELLAMOUNT = "exportsellamount";
    private static final String FOBPRICE = "fobprice";
    private static final String TRADEAMOUNT = "tradeamount";
    private static final String ZZSGLH = "zzsglh";
    private static final String INVOICEGLH = "invoiceglh";
    private static PatchNumberService patchNumberService = new PatchNumberService();
    private static CktsDraftService cktsDraftService = new CktsDraftService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit exportbasedata = (BasedataEdit)this.getControl("exportbasedata1");
        exportbasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        exportbasedata.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        if (!"createdraft".equals(source)) {
            LicenseCheckServiceHelper.checkOrgAuth((IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("sbny", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
        Date sbny = (Date)this.getModel().getValue("sbny");
        this.getModel().setValue("sbpc", (Object)patchNumberService.generator(orgId, sbny));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int rowIndex;
        String name = e.getProperty().getName();
        if (DEALRATE.equals(name)) {
            rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(OUTENTRYENTITY, rowIndex);
            String number = Optional.ofNullable(entryRowEntity.getDynamicObject(TRADECURRENCY)).map(s -> s.getString("number")).orElse("");
            this.getModel().getEntryEntity(OUTENTRYENTITY).stream().forEach(s -> {
                if (s.getDynamicObject(TRADECURRENCY).getString("number").equals(number)) {
                    s.set(DEALRATE, (Object)newValue);
                    if (USD.equals(number)) {
                        s.set(DOLLARRATE, (Object)newValue);
                    }
                    s.set(EXPORTSELLAMOUNT, (Object)s.getBigDecimal(TRADEAMOUNT).multiply(s.getBigDecimal(DEALRATE)));
                    s.set(FOBPRICE, (Object)(s.getBigDecimal(DOLLARRATE).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : s.getBigDecimal(EXPORTSELLAMOUNT).divide(s.getBigDecimal(DOLLARRATE), 2, 4)));
                }
            });
            this.getView().updateView(OUTENTRYENTITY);
        }
        if (DOLLARRATE.equals(name)) {
            rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(OUTENTRYENTITY, rowIndex);
            entryRowEntity.set(FOBPRICE, (Object)this.getDecimalgetFobPrice(this.getModel(), rowIndex));
            this.getView().updateView(OUTENTRYENTITY);
        }
        if (ZZSGLH.equals(name)) {
            rowIndex = e.getChangeSet()[0].getRowIndex();
            String zzsglh = (String)e.getChangeSet()[0].getNewValue();
            DynamicObject object = this.getModel().getEntryEntity(OUTENTRYENTITY).stream().filter(s -> s.getString("goodsglh").equals(zzsglh)).findFirst().orElse(null);
            this.zzsGlhChangeCalc(rowIndex, object);
            this.updateYtzzsse();
        }
        if (INVOICEGLH.equals(name)) {
            String invoiceglh = (String)e.getChangeSet()[0].getNewValue();
            long count = this.getModel().getEntryEntity(INVOICEENTRYENTITY).stream().filter(s -> StringUtil.isNotEmpty((CharSequence)s.getString(INVOICEGLH))).filter(s -> s.getString(INVOICEGLH).equals(invoiceglh)).count();
            if (count > 1L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e00\u4e2a\u5173\u8054\u53f7\u4e0d\u5f97\u5173\u8054\u4e24\u4e2a\u51fa\u53e3\u53d1\u7968\u53f7\uff0c\u8bf7\u68c0\u67e5", (String)"CktsDraftFormPlugin_0", (String)"taxc-tcetr", (Object[])new Object[0]));
            }
        }
        if ("sbny".equals(name) || "sbpc".equals(name)) {
            if ("sbny".equals(name)) {
                Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
                Date sbny = (Date)this.getModel().getValue("sbny");
                this.getModel().setValue("sbpc", (Object)patchNumberService.generator(orgId, sbny));
            }
            if (this.getModel().getValue("exportbasedata1", 0) == null) {
                return;
            }
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(OUTENTRYENTITY);
            Map<Integer, String> associationCode = this.getGoodsGlh(this.getModel(), entryentity.size());
            ArrayList<String> values = new ArrayList<String>(associationCode.values());
            HashMap glhMap = new HashMap();
            entryentity.stream().peek(s -> {
                String cfr_ignored_0 = (String)glhMap.put(s.getString("goodsglh"), associationCode.get(s.getInt("seq") - 1));
            }).forEach(s -> s.set("goodsglh", associationCode.get(s.getInt("seq") - 1)));
            this.getModel().getEntryEntity(INVOICEENTRYENTITY).forEach(s -> s.set(INVOICEGLH, glhMap.get(s.getString(INVOICEGLH))));
            this.getModel().getEntryEntity(ENTRYENTITY).forEach(s -> s.set(ZZSGLH, glhMap.get(s.getString(ZZSGLH))));
            this.getView().updateView(OUTENTRYENTITY);
            this.getView().updateView(INVOICEENTRYENTITY);
            this.getView().updateView(ENTRYENTITY);
            this.setEntityGlh(this.getModel(), values);
        }
    }

    private BigDecimal getTradeQty(String hxdw, BigDecimal qty, DynamicObject entry) {
        if (!"tradeunit".equals(hxdw)) {
            BigDecimal billqty = entry.getBigDecimal(hxdw + "qty");
            BigDecimal tradeqty = entry.getBigDecimal("tradeqty");
            BigDecimal exportQty = BigDecimal.ZERO;
            if (BigDecimal.ZERO.compareTo(billqty) != 0) {
                exportQty = qty.divide(billqty, 10, RoundingMode.HALF_UP).multiply(tradeqty);
                exportQty = cktsDraftService.getUnitQty(exportQty, entry.getDynamicObject("tradeunit"));
            }
            return exportQty;
        }
        return qty;
    }

    private void zzsGlhChangeCalc(int rowIndex, DynamicObject object) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
        if (object != null) {
            BigDecimal taxrate = Optional.ofNullable(object.getDynamicObject("hscode")).map(s -> s.getBigDecimal("taxrate")).orElse(BigDecimal.ZERO);
            BigDecimal rdrate = Optional.ofNullable(object.getDynamicObject("hscode")).map(s -> s.getBigDecimal("edrate")).orElse(BigDecimal.ZERO);
            entryRowEntity.set("taxrateprop", (Object)taxrate);
            entryRowEntity.set("edrateprop", (Object)rdrate);
            entryRowEntity.set("backamount", (Object)entryRowEntity.getBigDecimal("jsje").multiply(rdrate).divide(new BigDecimal("100"), 2, 4));
            entryRowEntity.set("jhjldw", object.get("unit1"));
        } else {
            entryRowEntity.set("taxrateprop", (Object)BigDecimal.ZERO);
            entryRowEntity.set("edrateprop", (Object)BigDecimal.ZERO);
            entryRowEntity.set("backamount", (Object)BigDecimal.ZERO);
            entryRowEntity.set("jhjldw", null);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List successPkIds = (List)customParams.get("wfRecordId");
        if (successPkIds != null && !successPkIds.isEmpty()) {
            this.getModel().setValue("datasource", (Object)"hxsc");
            DynamicObject wfr = BusinessDataServiceHelper.loadSingle(successPkIds.get(0), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcetr_updownwfrecord"));
            long orgId = wfr.getLong("taxorg.id");
            if (orgId > 0L) {
                this.getModel().setValue("org", (Object)orgId);
            }
            Date sbny = (Date)this.getModel().getValue("sbny");
            customParams.put("orgname", wfr.getString("taxorg.name"));
            DynamicObject dataEntity = this.getModel().getDataEntity();
            dataEntity.set("sbpc", (Object)patchNumberService.generator(orgId, sbny));
            customParams.put("mainData", DynamicObjectSerializeUtil.serialize((Object[])new Object[]{dataEntity}, (DynamicObjectType)dataEntity.getDynamicObjectType()));
            this.dispatch(customParams);
            Object billno = this.getModel().getValue("billno");
            if (Objects.nonNull(billno)) {
                OperatorDialogUtils.operateDialog((String)"etrscsum", (String)"tcetr_ckts_dgdj", (String)ResManager.loadKDString((String)"\u65b0\u589e\u4fdd\u5b58", (String)"CktsDraftFormPlugin_5", (String)"taxc-tcetr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%s\uff0c\u4fdd\u5b58\u6210\u529f", (String)"CktsDraftFormPlugin_6", (String)"taxc-tcetr", (Object[])new Object[0]), billno));
            }
        } else {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INVOICEENTRYENTITY);
            Set sinvoicedetailids = entryEntity.stream().map(object -> object.getLong("sinvoicedetailid")).collect(Collectors.toSet());
            Map<Long, DynamicObject> invoiceMap = cktsDraftService.getInvoiceMap(sinvoicedetailids);
            for (DynamicObject object2 : entryEntity) {
                long sinvoicedetailid = object2.getLong("sinvoicedetailid");
                DynamicObject[] invoiceObj = invoiceMap.get(sinvoicedetailid);
                if (invoiceObj == null) continue;
                object2.set("sissuetime", (Object)invoiceObj.getDate("issuetime"));
                object2.set("sbuyername", (Object)invoiceObj.getString("buyername"));
                object2.set("goodsname", (Object)invoiceObj.getString("goodsname"));
                object2.set("specification", (Object)invoiceObj.getString("specification"));
                object2.set("unit", (Object)invoiceObj.getString("unit"));
                object2.set("num", (Object)invoiceObj.getBigDecimal("num"));
                object2.set("unitprice", (Object)invoiceObj.getBigDecimal("unitprice"));
                object2.set("amount", (Object)invoiceObj.getBigDecimal("amount"));
                object2.set("invoicetaxrate", (Object)invoiceObj.getString("taxrate"));
            }
            this.getView().updateView(INVOICEENTRYENTITY);
            this.getModel().setDataChanged(false);
            DynamicObjectCollection outentryentity = this.getModel().getEntryEntity(OUTENTRYENTITY);
            List<Long> primaryKeyValues = outentryentity.stream().map(o -> o.getLong("exportbasedata1.id")).filter(l -> l != 0L).collect(Collectors.toList());
            if (primaryKeyValues.isEmpty()) {
                return;
            }
            DynamicObject[] exportDeclaration = cktsDraftService.getExportDeclaration(primaryKeyValues);
            HashMap<Object, DynamicObject> entryentity = new HashMap<Object, DynamicObject>();
            for (DynamicObject object3 : exportDeclaration) {
                DynamicObjectCollection ent = object3.getDynamicObjectCollection(ENTRYENTITY);
                for (DynamicObject dyo : ent) {
                    entryentity.put(dyo.get("id"), dyo);
                }
            }
            DynamicObjectCollection outEntryEntity = this.getModel().getEntryEntity(OUTENTRYENTITY);
            for (DynamicObject object4 : outEntryEntity) {
                DynamicObject item = (DynamicObject)entryentity.get(object4.get("goodsid"));
                if (item == null) continue;
                object4.set("goodsitemno", (Object)item.getString("itemno"));
                object4.set("tradeqty", item.get("tradeqty"));
                String hxdw = object4.getString("hxdw");
                if (this.isCreateFromWf()) {
                    BigDecimal qty = object4.getBigDecimal("qty");
                    object4.set("tradeqty", (Object)this.getTradeQty(hxdw, qty, item));
                }
                object4.set("tradeunit", item.get("tradeunit"));
                object4.set("tradeprice", item.get("tradeprice"));
                object4.set(TRADECURRENCY, item.get(TRADECURRENCY));
                object4.set(TRADEAMOUNT, item.get(TRADEAMOUNT));
                object4.set("dcountry", item.get("dcountry"));
            }
            this.getView().updateView(OUTENTRYENTITY);
            this.getModel().setDataChanged(false);
        }
        DynamicObjectCollection outEntryEntity = this.getModel().getEntryEntity(OUTENTRYENTITY);
        this.setEntityGlh(this.getModel(), outEntryEntity.stream().map(s -> s.getString("goodsglh")).collect(Collectors.toList()));
        for (int i = 0; i < outEntryEntity.size(); ++i) {
            this.getView().setEnable(Boolean.valueOf(!this.isCreateFromWf()), i, new String[]{"exportbasedata1", "qty", "tradeqty"});
        }
        this.getView().setEnable(Boolean.valueOf(!this.isCreateFromWf()), new String[]{INVOICE_ADD_ROW, INVOICE_DEL_ROW, GOODS_ADD_ROW, GOODS_DEL_ROW});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List successPkIds = (List)customParams.get("wfRecordId");
        if (successPkIds != null && !successPkIds.isEmpty()) {
            option.setVariableValue("wfRecordId", SerializationUtils.toJsonString((Object)successPkIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Map<String, Object> map;
        List<Long> sinvoicedetailid;
        DynamicObjectCollection invoiceentryentity;
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        String orgid = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("id")).orElse("0");
        if ("0".equals(orgid)) {
            return;
        }
        if (INVOICE_ADD_ROW.equals(itemKey)) {
            invoiceentryentity = this.getModel().getEntryEntity(INVOICEENTRYENTITY);
            sinvoicedetailid = invoiceentryentity.stream().map(s -> s.getLong("sinvoicedetailid")).collect(Collectors.toList());
            map = this.getCustomsObjectMap(OUT_INVOICE, sinvoicedetailid, orgid);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCETR_INVOICE_LIST, (IFormView)this.getView(), map, (IFormPlugin)this);
        }
        if (GOODS_ADD_ROW.equals(itemKey)) {
            invoiceentryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            sinvoicedetailid = invoiceentryentity.stream().map(s -> s.getLong("sinvoicedetailid2")).collect(Collectors.toList());
            map = this.getCustomsObjectMap(ZZS_INVOICE, sinvoicedetailid, orgid);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCETR_INVOICE_LIST, (IFormView)this.getView(), map, (IFormPlugin)this);
        }
    }

    private void dispatch(Map<String, Object> customParams) {
        String appId = this.getView().getFormShowParameter().getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.getOrCreate().getCurrUserId());
        String name = this.getJobName();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String orgName = "";
        if (org != null) {
            orgName = org.getString("name");
        }
        String jobName = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5916\u8d38\u4f01\u4e1a\u9000\u7a0e\u5e95\u7a3f\u751f\u6210\u4efb\u52a1", (String)"CktsDraftAutoCalcTask_1", (String)"taxc-tcetr", (Object[])new Object[0]), orgName);
        jobInfo.setName(jobName);
        jobInfo.setId(this.getJobId());
        jobInfo.setTaskClassname(this.getTaskClassName());
        jobInfo.setParams(customParams);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(name);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setClickClassName(this.getClickClassName());
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private String getJobName() {
        return ResManager.loadKDString((String)"\u51fa\u53e3\u9000\u7a0e\u5916\u8d38\u4f01\u4e1a\u5e95\u7a3f\u751f\u6210\u4efb\u52a1", (String)"CktsDraftFormPlugin_3", (String)"taxc-tcetr", (Object[])new Object[0]);
    }

    private String getJobId() {
        return (String)this.getModel().getValue("billno");
    }

    private String getTaskClassName() {
        return "kd.taxc.tcetr.business.draft.task.CktsDraftAutoCalcTask";
    }

    private String getClickClassName() {
        return CktsCalcTaskClick.class.getName();
    }

    public Map<String, Object> getCustomsObjectMap(String type, List<Long> selectedInvoiceIds, String orgid) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("type", type);
        map.put("orgid", orgid);
        map.put("selectedInvoiceDetailIds", selectedInvoiceIds);
        map.put("customCaption", type.equals(OUT_INVOICE) ? ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u589e\u503c\u7a0e\u53d1\u7968", (String)"CktsDraftFormPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u589e\u503c\u7a0e\u4e13\u7528\u53d1\u7968", (String)"CktsDraftFormPlugin_2", (String)"taxc-tcetr", (Object[])new Object[0]));
        return map;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals(TCETR_INVOICE_LIST) && closedCallBackEvent.getReturnData() != null) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            List selectedRows = (List)result.get("selectedRows");
            String type = (String)result.get("type");
            if (OUT_INVOICE.equals(type)) {
                this.setEntityDetail(selectedRows, INVOICEENTRYENTITY, (ThreeConsumer<IDataModel, Integer, DynamicObject>)((ThreeConsumer)(model, index, object) -> this.setOutInvoiceModelValue((IDataModel)model, (int)index, (DynamicObject)object, null)));
            }
            if (ZZS_INVOICE.equals(type)) {
                this.setEntityDetail(selectedRows, ENTRYENTITY, (ThreeConsumer<IDataModel, Integer, DynamicObject>)((ThreeConsumer)(model, index, object) -> this.setZzsInvoiceModelValue((IDataModel)model, (int)index, (DynamicObject)object, null)));
            }
        } else if (StringUtil.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"taskcloseback")) {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && StringUtil.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String jobId = taskInfo.getJobId();
                String data = taskInfo.getData();
                Map customs = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                String message = (String)customs.get("message");
                String success = (String)customs.get("success");
                if (Boolean.TRUE.toString().equals(success)) {
                    DynamicObject one = cktsDraftService.queryOneByBillno(jobId);
                    BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
                    billShowParameter.setCustomParam("wfRecordId", null);
                    billShowParameter.setPkId((Object)one.getLong("id"));
                    this.getModel().setValue("id", (Object)one.getLong("id"));
                    billShowParameter.setBillStatus(BillOperationStatus.EDIT);
                    billShowParameter.setStatus(OperationStatus.EDIT);
                    this.getView().invokeOperation("refresh");
                    this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u53d6\u6570\u5b8c\u6210", (String)"CktsDraftFormPlugin_4", (String)"taxc-tcetr", (Object[])new Object[0]), message));
                } else {
                    this.getView().showErrorNotification(message);
                }
                this.getPageCache().put("releaseTask", "true");
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        customQFilters.add(new QFilter("org", "=", (Object)orgId));
        customQFilters.add(new QFilter("billstatus", "=", (Object)"C"));
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        Long primaryKeyValue = this.getExportBaseDataF7Id(afterF7SelectEvent);
        if (primaryKeyValue == 0L) {
            this.getModel().deleteEntryData(OUTENTRYENTITY);
            return;
        }
        DynamicObject exportDeclaration = cktsDraftService.getExportDeclaration(primaryKeyValue);
        if (exportDeclaration == null) {
            return;
        }
        DynamicObjectCollection entryentity = exportDeclaration.getDynamicObjectCollection(ENTRYENTITY);
        Map<Integer, String> associationCode = this.getGoodsGlh(this.getModel(), entryentity.size());
        IDataModel model = this.getModel();
        model.beginInit();
        model.deleteEntryData(OUTENTRYENTITY);
        model.batchCreateNewEntryRow(OUTENTRYENTITY, entryentity.size());
        for (int index = 0; index < entryentity.size(); ++index) {
            this.setOutGoodsInfo(exportDeclaration, model, index, (DynamicObject)entryentity.get(index), associationCode, null);
        }
        model.endInit();
        this.getView().getModel().updateCache();
        this.getView().updateView(OUTENTRYENTITY);
        List<String> values = associationCode.entrySet().stream().map(s -> (String)s.getValue()).collect(Collectors.toList());
        this.setEntityGlh(this.getModel(), values);
        this.clearGlhData();
    }

    public void clearGlhData() {
        DynamicObjectCollection entity;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INVOICEENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            entryEntity.stream().forEach(s -> s.set(INVOICEGLH, (Object)""));
            this.getView().updateView(INVOICEENTRYENTITY);
        }
        if ((entity = this.getModel().getEntryEntity(ENTRYENTITY)) != null && entity.size() > 0) {
            entity.stream().forEach(s -> {
                s.set(ZZSGLH, (Object)"");
                s.set("taxrateprop", (Object)BigDecimal.ZERO);
                s.set("edrateprop", (Object)BigDecimal.ZERO);
                s.set("backamount", (Object)BigDecimal.ZERO);
            });
            this.getView().updateView(ENTRYENTITY);
            this.updateYtzzsse();
        }
    }

    private void updateYtzzsse() {
        this.getModel().updateCache();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        BigDecimal ytzzsse = entryEntity.stream().map(entry -> entry.getBigDecimal("backamount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        this.getModel().setValue("ytzzsse", (Object)ytzzsse);
        this.getView().updateView("ytzzsse");
    }

    private Long getExportBaseDataF7Id(AfterF7SelectEvent afterF7SelectEvent) {
        ListSelectedRow listSelectedRow = afterF7SelectEvent.getListSelectedRow();
        String inputValue = (String)afterF7SelectEvent.getInputValue();
        if (listSelectedRow != null) {
            return (Long)listSelectedRow.getPrimaryKeyValue();
        }
        if (StringUtil.isNotEmpty((CharSequence)inputValue)) {
            return Long.parseLong(inputValue);
        }
        return 0L;
    }

    private void setEntityDetail(List<DynamicObject> selectedRows, String entryentity, ThreeConsumer<IDataModel, Integer, DynamicObject> threeConsumer) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entity = model.getEntryEntity(entryentity);
        model.beginInit();
        if (entity == null || entity.size() == 0) {
            model.batchCreateNewEntryRow(entryentity, selectedRows.size());
            for (int index = 0; index < selectedRows.size(); ++index) {
                DynamicObject object = selectedRows.get(index);
                threeConsumer.accept((Object)model, (Object)index, (Object)object);
            }
        } else {
            for (int index = 0; index < selectedRows.size(); ++index) {
                int newEntryRow = model.createNewEntryRow(entryentity);
                DynamicObject object = selectedRows.get(index);
                threeConsumer.accept((Object)model, (Object)newEntryRow, (Object)object);
            }
        }
        model.endInit();
        this.getView().getModel().updateCache();
        this.getView().updateView(entryentity);
    }

    private void setZzsInvoiceModelValue(IDataModel model, int index, DynamicObject object, List<DynamicObject> wfRecords) {
        String taxrateStr = object.getString("taxrate");
        if (wfRecords != null && !wfRecords.isEmpty()) {
            DynamicObject wfRecord = wfRecords.get(0);
            taxrateStr = cktsDraftService.getTaxRateStr(object.get("taxrate"));
            model.setValue("invoiceqty", (Object)wfRecords.stream().map(o -> o.getBigDecimal("qty")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO), index);
            model.setValue("jsje", (Object)wfRecords.stream().map(o -> o.getBigDecimal("ftje")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO), index);
        } else {
            model.setValue("jhsl", (Object)object.getBigDecimal("num"), index);
            model.setValue("jsje", (Object)object.getBigDecimal("amount"), index);
        }
        model.setValue("jhpzh", (Object)(object.getString("invoicecode") + object.getString("invoiceno")), index);
        model.setValue("sinvoicedetailid2", (Object)object.getLong("invoiceid"), index);
        model.setValue("ghfnsrsbh", (Object)object.getString("salertaxno"), index);
        model.setValue("ghfmc", (Object)object.getString("salername"), index);
        model.setValue("kprq", (Object)object.getDate("issuetime"), index);
        model.setValue("spmc", (Object)object.getString("goodsname"), index);
        model.setValue("invoiceunit", (Object)object.getString("unit"), index);
        model.setValue("zzsunit", (Object)object.getString("unit"), index);
        model.setValue("zzstaxrate", (Object)taxrateStr, index);
    }

    private void setOutInvoiceModelValue(IDataModel model, int index, DynamicObject object, List<DynamicObject> wfRecords) {
        String taxrateStr = object.getString("taxrate");
        if (wfRecords != null && !wfRecords.isEmpty()) {
            DynamicObject wfRecord = wfRecords.get(0);
            taxrateStr = cktsDraftService.getTaxRateStr(object.get("taxrate"));
            model.setValue("sissuetime", (Object)wfRecord.getDate("billdate"), index);
            model.setValue("sbuyername", (Object)wfRecord.getString("trade"), index);
            model.setValue("goodsname", (Object)wfRecord.getString("goodsname"), index);
        } else {
            model.setValue("sissuetime", (Object)object.getDate("issuetime"), index);
            model.setValue("sbuyername", (Object)object.getString("buyername"), index);
            model.setValue("goodsname", (Object)object.getString("goodsname"), index);
        }
        model.setValue("sinvoiceno", (Object)object.getString("invoiceno"), index);
        model.setValue("sinvoicedetailid", (Object)object.getLong("invoiceid"), index);
        model.setValue("specification", (Object)object.getString("specification"), index);
        model.setValue("unit", (Object)object.getString("unit"), index);
        model.setValue("num", (Object)object.getBigDecimal("num"), index);
        model.setValue("unitprice", (Object)object.getBigDecimal("unitprice"), index);
        model.setValue("amount", (Object)object.getBigDecimal("amount"), index);
        model.setValue("invoicetaxrate", (Object)taxrateStr, index);
    }

    public void setOutGoodsInfo(DynamicObject exportDeclaration, IDataModel model, int index, DynamicObject object, Map<Integer, String> associationCode, List<DynamicObject> wfRecord) {
        String itemno = object.getString("itemno");
        model.setValue(FOBPRICE, object.get("mylaj"), index);
        model.setValue("tradeqty", object.get("tradeqty"), index);
        if (wfRecord != null && !wfRecord.isEmpty()) {
            itemno = wfRecord.get(0).getString("invoicecode");
            BigDecimal qty = BigDecimal.ZERO;
            BigDecimal ftje = BigDecimal.ZERO;
            for (DynamicObject obj : wfRecord) {
                qty = qty.add(obj.getBigDecimal("qty"));
                ftje = ftje.add(obj.getBigDecimal("ftje"));
            }
            model.setValue("qty", (Object)qty, index);
            model.setValue(FOBPRICE, (Object)ftje, index);
            model.setValue("exportqty", (Object)qty, index);
            model.setValue("tradeqty", (Object)qty, index);
        }
        model.setValue("goodsid", (Object)object.getLong("id"), index);
        model.setValue("goodsitemno", (Object)itemno, index);
        model.setValue("hscode", object.get("hscode"), index);
        model.setValue("tradeunit", object.get("tradeunit"), index);
        model.setValue("tradeprice", object.get("tradeprice"), index);
        model.setValue(TRADECURRENCY, object.get(TRADECURRENCY), index);
        model.setValue(TRADEAMOUNT, object.get(TRADEAMOUNT), index);
        model.setValue("dcountry", object.get("dcountry"), index);
        model.setValue(DOLLARRATE, (Object)this.getDollarrate(model, index), index);
        BigDecimal exportsellamount = this.getExportsellamount(model, index);
        model.setValue(EXPORTSELLAMOUNT, (Object)exportsellamount, index);
        model.setValue("goodsglh", (Object)associationCode.get(index), index);
        model.setValue("exportbasedata1", (Object)exportDeclaration.getLong("id"), index);
        String exportdata = Optional.ofNullable((DynamicObject)model.getValue("exportbasedata1", index)).map(s -> s.getString("billno")).orElse("");
        model.setValue("goodsecdnum", (Object)(exportdata + "0" + itemno), index);
        model.setValue("ckrq1", (Object)exportDeclaration.getDate("exportdate"), index);
        model.setValue("unit1", object.get("firstunit"), index);
        if (this.isCreateFromWf() || index > 0) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"exportbasedata1", "tradeqty"});
        }
    }

    private BigDecimal getDollarrate(IDataModel model, int index) {
        DynamicObject rowEntity = model.getEntryRowEntity(OUTENTRYENTITY, index);
        String number = Optional.ofNullable(rowEntity.getDynamicObject(TRADECURRENCY)).map(s -> s.getString("number")).orElse("");
        if (USD.equals(number)) {
            return rowEntity.getBigDecimal(DEALRATE);
        }
        return BigDecimal.ZERO;
    }

    private Map<Integer, String> getGoodsGlh(IDataModel model, int size) {
        Date sbny = (Date)model.getValue("sbny");
        String sbpc = (String)model.getValue("sbpc");
        return patchNumberService.getAssociationCode(sbny, sbpc, size);
    }

    private void setEntityGlh(IDataModel model, List<String> codes) {
        ComboEdit invoiceglh = (ComboEdit)this.getControl(INVOICEGLH);
        ComboEdit zzsglh = (ComboEdit)this.getControl(ZZSGLH);
        List goodsglh = codes.stream().map(s -> new ComboItem(new LocaleString(s), s)).collect(Collectors.toList());
        invoiceglh.setComboItems(goodsglh);
        zzsglh.setComboItems(goodsglh);
    }

    private BigDecimal getDecimalgetFobPrice(IDataModel model, int index) {
        DynamicObject rowEntity = model.getEntryRowEntity(OUTENTRYENTITY, index);
        BigDecimal dollarrate = rowEntity.getBigDecimal(DOLLARRATE);
        if (dollarrate == null || dollarrate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return rowEntity.getBigDecimal(EXPORTSELLAMOUNT).divide(rowEntity.getBigDecimal(DOLLARRATE), 2, 4);
    }

    private BigDecimal getExportsellamount(IDataModel model, int index) {
        DynamicObject rowEntity = model.getEntryRowEntity(OUTENTRYENTITY, index);
        return rowEntity.getBigDecimal(TRADEAMOUNT).multiply(rowEntity.getBigDecimal(DEALRATE));
    }

    private boolean isCreateFromWf() {
        return "hxsc".equals(this.getModel().getValue("datasource"));
    }
}

