/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.draft;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcetr.business.draft.CktsDraftService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CktsDraftListPlugin
extends AbstractListPlugin {
    private static final String GESBB = "gesbb";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap "});
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isLinkDraft = customParams.getOrDefault("linkDraft", Boolean.FALSE);
        Boolean isViewHistory = customParams.getOrDefault("viewHistory", Boolean.FALSE);
        Object org = customParams.get("orgid");
        String sbny = customParams.get("sbny") != null ? (String)customParams.get("sbny") : "";
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (isLinkDraft.booleanValue() || isViewHistory.booleanValue()) {
            for (FilterColumn filterColumn : filterColumnList) {
                if (org != null && filterColumn.getFieldName().equals("org.name") && filterColumn instanceof CommonFilterColumn) {
                    filterColumn.setDefaultValue(org.toString());
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)sbny)) continue;
                Date startdate = DateUtils.stringToDate((String)sbny);
                Date enddate = DateUtils.getLastDateOfMonth((Date)startdate);
                if (!filterColumn.getFieldName().equals("sbny")) continue;
                filterColumn.setDefaultValues(new Object[]{DateUtils.format((Date)startdate), DateUtils.format((Date)enddate)});
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isLinkDraft = customParams.getOrDefault("linkDraft", Boolean.FALSE);
        Boolean isViewHistory = customParams.getOrDefault("viewHistory", Boolean.FALSE);
        if (isLinkDraft.booleanValue() || isViewHistory.booleanValue()) {
            qFilters.add(new QFilter("sbpc", "=", customParams.get("sbpc")));
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (GESBB.equals(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)list)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"CktsDraftListPlugin_0", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            DynamicObject[] tcetrCktsDgdj = BusinessDataServiceHelper.load((Object[])list.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcetr_ckts_dgdj"));
            boolean hasUnAudit = Arrays.stream(tcetrCktsDgdj).anyMatch(s -> !"C".equals(s.getString("billstatus")));
            if (hasUnAudit) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u53ef\u4ee5\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"CktsDraftListPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            boolean isDeclared = Arrays.stream(tcetrCktsDgdj).anyMatch(s -> StringUtils.isNotEmpty((CharSequence)s.getString("sbbbillno")));
            if (isDeclared) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u751f\u6210\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"CktsDraftListPlugin_2", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            Map<String, List<DynamicObject>> groups = Arrays.stream(tcetrCktsDgdj).collect(Collectors.groupingBy(s -> String.format("%s_%s_%s", s.getString("org.id"), DateUtils.format((Date)s.getDate("sbny"), (String)"yyyyMM"), s.getString("sbpc"))));
            if (groups.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u3010\u7a0e\u52a1\u7ec4\u7ec7\u3011\uff0c\u540c\u3010\u7533\u62a5\u5e74\u6708\u3011\u548c\u3010\u7533\u62a5\u6279\u6b21\u3011\uff0c\u624d\u80fd\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"CktsDraftListPlugin_3", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            long orgId = tcetrCktsDgdj[0].getLong("org.id");
            Date sbny = tcetrCktsDgdj[0].getDate("sbny");
            String sbpc = tcetrCktsDgdj[0].getString("sbpc");
            DynamicObjectCollection hasDeclareds = CktsDraftService.draftFilter(orgId, sbny, sbpc, s -> StringUtil.isNotEmpty((CharSequence)s.getString("sbbbillno")) && s.getLong("sbbid") != 0L);
            if (hasDeclareds != null & hasDeclareds.size() > 0) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u7533\u62a5\u5e74\u6708\u3010%1$s\u3011\uff0c\u6279\u6b21\u3010%2$s\u3011\u7684\u7533\u62a5\u8868\u5df2\u7ecf\u751f\u6210\u3010%3$s\u3011\uff0c\u5982\u9700\u518d\u6b21\u7533\u62a5\u8bf7\u4fee\u6539\u7533\u62a5\u6279\u6b21\u3002", (String)"CktsDraftListPlugin_5", (String)"taxc-tcetr", (Object[])new Object[0]), DateUtils.format((Date)sbny, (String)"yyyy-MM"), sbpc, hasDeclareds.stream().map(s -> s.getString("sbbbillno")).collect(Collectors.joining(","))));
                return;
            }
            DynamicObjectCollection canDeclare = CktsDraftService.draftFilter(orgId, sbny, sbpc, s -> StringUtil.isEmpty((CharSequence)s.getString("sbbbillno")) && s.getLong("sbbid") == 0L);
            if (canDeclare.size() != tcetrCktsDgdj.length) {
                List pkIds = Arrays.stream(tcetrCktsDgdj).map(s -> s.getLong("id")).collect(Collectors.toList());
                String billnos = canDeclare.stream().filter(s -> !pkIds.contains(s.getLong("id"))).map(s -> s.getString("billno")).collect(Collectors.joining(","));
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5e95\u7a3f\u7f16\u53f7\u4e3a%1$s\u4e3a\u3010%2$s\u7533\u62a5\u5e74\u6708\u3011\u3010%3$s\u6279\u6b21\u3011\u7684\u5e95\u7a3f\uff0c\u5982\u65e0\u9700\u672c\u6b21\u7533\u62a5\uff0c\u8bf7\u4fee\u6539\u7533\u62a5\u6279\u6b21\u3002", (String)"CktsDraftListPlugin_4", (String)"taxc-tcetr", (Object[])new Object[0]), billnos, DateUtils.format((Date)sbny, (String)"yyyy-MM"), sbpc));
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("pkids", list.getPrimaryKeyValues());
            param.put("orgid", orgId);
            param.put("sbny", sbny);
            param.put("sbpc", sbpc);
            param.put("createsbb", true);
            param.put("templatetype", "drawback");
            param.put("type", "drawback");
            PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)"tcetr_wmqy_declare_query", null, (IFormView)this.getView(), param, (OperationStatus)OperationStatus.ADDNEW, (IFormPlugin)this);
        }
    }
}

