/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.draft.manufacture;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.functionalinterfaceext.ThreeConsumer;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcetr.business.draft.CktsDraftService;

public class ManufactureDraftFormPlugin
extends AbstractBillPlugIn
implements AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String USD = "USD";
    private static final String DEALRATE = "dealrate";
    private static final String TRADECURRENCY = "tradecurrency";
    private static final String TRADEAMOUNT = "tradeamount";
    private static final String INVOICE_ADD_ROW = "invoiceaddrow";
    private static final String TCETR_INVOICE_LIST = "tcetr_invoice_list";
    private static final String INVOICEENTRYENTITY = "invoiceentryentity";
    private static final String OUT_INVOICE = "out_invoice";
    private static final String OUTENTRYENTITY = "outentryentity";
    private static final String DOLLARRATE = "dollarrate";
    private static final String EXPORTSELLAMOUNT = "exportsellamount";
    private static final String EXPORTDOLLAR = "exportdollar";
    private static CktsDraftService cktsDraftService = new CktsDraftService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit exportbasedata = (BasedataEdit)this.getControl("exportbasedata");
        BasedataEdit exportbasedata1 = (BasedataEdit)this.getControl("exportbasedata1");
        exportbasedata.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        exportbasedata.addAfterF7SelectListener((AfterF7SelectListener)this);
        exportbasedata1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        exportbasedata1.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        if (!"createdraft".equals(source)) {
            LicenseCheckServiceHelper.checkOrgAuth((IDataModel)this.getModel(), (IFormView)this.getView());
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("taxperiod", (Object)DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1)));
        List<Object> successPkIds = this.getWfRecordId();
        if (successPkIds != null && !successPkIds.isEmpty()) {
            this.getModel().setValue("datasource", (Object)"hxsc");
        } else {
            this.getModel().setValue("datasource", (Object)"sdxz");
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List<Object> successPkIds = this.getWfRecordId();
        if (successPkIds != null && !successPkIds.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"org", INVOICE_ADD_ROW, "invoicedelrow"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"exportbasedata", "exportdate", "dlckhwzmmh", "exportinfo"});
            this.initWfData(successPkIds);
        } else {
            this.updateEntityDataByExport();
        }
        String initflag = this.getPageCache().get("alreadyinitflag");
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus() && !"1".equals(initflag)) {
            this.getPageCache().put("alreadyinitflag", "1");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String initflag = this.getPageCache().get("alreadyinitflag");
        if (OperationStatus.ADDNEW != this.getView().getFormShowParameter().getStatus() && "1".equals(initflag)) {
            this.getModel().setDataChanged(false);
        }
    }

    private void updateEntityDataByExport() {
        DynamicObject exportObject = (DynamicObject)this.getModel().getValue("exportbasedata");
        if (null == exportObject) {
            return;
        }
        this.setExportDetail(exportObject);
        this.setExportInvoiceDetail();
        this.setEntityBGDH(this.getModel().getEntryEntity(OUTENTRYENTITY).stream().map(s -> s.getString("goodsecdnum")).collect(Collectors.toList()));
    }

    private List<Object> getWfRecordId() {
        if (OperationStatus.ADDNEW == this.getView().getFormShowParameter().getStatus()) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            return (List)customParams.get("wfRecordId");
        }
        if (this.isCreateFromWf()) {
            Object id = this.getModel().getValue("id");
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tcetr_wfrecord_scqy", (String)"draftid,id", (QFilter[])new QFilter[]{new QFilter("draftid", "=", id).and("iscreatedraft", "=", (Object)"1")});
            return query.stream().map(a -> a.get("id")).collect(Collectors.toList());
        }
        return null;
    }

    private boolean isCreateFromWf() {
        return "hxsc".equals(this.getModel().getValue("datasource"));
    }

    private void initWfData(List<Object> successPkIds) {
        if (successPkIds != null && !successPkIds.isEmpty()) {
            DynamicObject[] wfRecords = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tcetr_wfrecord_scqy"));
            long orgId = wfRecords[0].getLong("taxorg.id");
            if (orgId > 0L) {
                this.getModel().setValue("org", (Object)orgId);
            }
            HashMap<String, List<DynamicObject>> exportGroup = new HashMap<String, List<DynamicObject>>();
            HashMap<String, List<DynamicObject>> invoiceGroup = new HashMap<String, List<DynamicObject>>();
            HashMap<String, String> hxdwMap = new HashMap<String, String>();
            for (DynamicObject dynamicObject : wfRecords) {
                DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("entry");
                DynamicObject export = entry.stream().filter(o -> "tdm_export_declaration".equals(o.getString("billtype.number"))).findFirst().orElse(null);
                if (export == null) continue;
                String unique = export.getString("billno") + "_" + export.getString("invoicecode");
                hxdwMap.put(unique, cktsDraftService.getHxdw(dynamicObject.get("writeofftypeid.id")));
                for (DynamicObject obj : entry) {
                    List list;
                    if ("tdm_export_declaration".equals(obj.getString("billtype.number"))) {
                        list = exportGroup.computeIfAbsent(unique, o -> new ArrayList());
                        list.add(obj);
                        continue;
                    }
                    if (!"sim_vatinvoice".equals(obj.getString("billtype.number"))) continue;
                    list = invoiceGroup.computeIfAbsent(unique, o -> new ArrayList());
                    list.add(obj);
                }
            }
            this.setExportDetail(exportGroup, invoiceGroup, hxdwMap);
            this.setExportInvoiceDetail(invoiceGroup);
        }
    }

    private void setExportInvoiceDetail(Map<String, List<DynamicObject>> invoiceGroup) {
        if (invoiceGroup != null && !invoiceGroup.isEmpty()) {
            List billIds = invoiceGroup.values().stream().map(Collection::stream).reduce(Stream::concat).orElseGet(Stream::empty).map(o -> o.getLong("billentryid")).collect(Collectors.toList());
            String selectFields = "id,items.id as invoiceid,invoiceno,invoicecode,buyername,salertaxno,salername,issuetime as invoicedate,remark,items.goodsname as goodsname,items.unit as unit,items.num as num,items.unitprice as unitprice,items.taxrate as taxrate,items.amount as amount,items.specification as specification";
            DynamicObjectCollection resultList = QueryServiceHelper.query((String)"sim_vatinvoice", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("items.id", "in", billIds)});
            Map<Long, DynamicObject> invoiceMap = resultList.stream().collect(Collectors.toMap(d -> d.getLong("invoiceid"), d -> d));
            this.getModel().beginInit();
            this.getModel().deleteEntryData(INVOICEENTRYENTITY);
            int index = 0;
            for (Map.Entry<String, List<DynamicObject>> gEntry : invoiceGroup.entrySet()) {
                List<DynamicObject> wfRecords = gEntry.getValue();
                for (DynamicObject invoiceDetail : wfRecords) {
                    DynamicObject exportWfDetail = this.getWfRecordExportDetail(invoiceDetail);
                    long billid = invoiceDetail.getLong("billentryid");
                    DynamicObject object = invoiceMap.get(billid);
                    if (object == null) continue;
                    IDataModel model = this.getModel();
                    model.createNewEntryRow(INVOICEENTRYENTITY);
                    model.setValue("sissuetime", (Object)object.getDate("invoicedate"), index);
                    model.setValue("sinvoiceno", (Object)object.getString("invoiceno"), index);
                    model.setValue("sbuyername", (Object)object.getString("buyername"), index);
                    model.setValue("goodsname", (Object)object.getString("goodsname"), index);
                    model.setValue("sinvoicedetailid", (Object)object.getLong("invoiceid"), index);
                    model.setValue("specification", (Object)object.getString("specification"), index);
                    model.setValue("unit", (Object)object.getString("unit"), index);
                    model.setValue("unitprice", (Object)object.getBigDecimal("unitprice"), index);
                    model.setValue("num", (Object)invoiceDetail.getBigDecimal("qty"), index);
                    model.setValue("amount", (Object)invoiceDetail.getBigDecimal("ftje"), index);
                    model.setValue("invoicetaxrate", (Object)invoiceDetail.getString("taxrate"), index);
                    BigDecimal taxrate = invoiceDetail.getBigDecimal("taxrate");
                    model.setValue("taxrateprop", (Object)taxrate, index);
                    BigDecimal tsl = BigDecimal.ZERO;
                    if (exportWfDetail != null) {
                        tsl = exportWfDetail.getBigDecimal("taxrate");
                        model.setValue("edrateprop", (Object)tsl, index);
                        model.setValue("exportgoodsno", (Object)(exportWfDetail.getString("sourcebillno") + "0" + exportWfDetail.getString("invoicecode")), index);
                    }
                    BigDecimal mzhdkse = invoiceDetail.getBigDecimal("ftje").multiply(taxrate.subtract(tsl));
                    model.setValue("mzhdkse", (Object)mzhdkse, index);
                    BigDecimal mdtse = invoiceDetail.getBigDecimal("ftje").multiply(tsl);
                    model.setValue("mdtse", (Object)mdtse, index);
                    ++index;
                }
            }
            this.getModel().endInit();
            this.getView().getModel().updateCache();
            this.getView().updateView(INVOICEENTRYENTITY);
        }
    }

    private void setExportDetail(Map<String, List<DynamicObject>> exportGroup, Map<String, List<DynamicObject>> invoiceGroup, Map<String, String> hxdwMap) {
        if (exportGroup != null && !exportGroup.isEmpty()) {
            this.getModel().beginInit();
            this.getModel().deleteEntryData(OUTENTRYENTITY);
            IDataModel model = this.getModel();
            int index = 0;
            for (Map.Entry<String, List<DynamicObject>> gEntry : exportGroup.entrySet()) {
                List<DynamicObject> wfDetail = gEntry.getValue();
                DynamicObject[] exportDeclarations = cktsDraftService.getExportDeclaration(wfDetail.stream().map(o -> o.getLong("billid")).collect(Collectors.toList()));
                if (exportDeclarations == null || exportDeclarations.length == 0) continue;
                String unique = gEntry.getKey();
                List<DynamicObject> invoiceList = invoiceGroup.get(unique);
                String[] s = unique.split("_");
                for (DynamicObject exportDeclaration : exportDeclarations) {
                    DynamicObjectCollection entryentity = exportDeclaration.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entryentity) {
                        String itemno = entry.getString("itemno");
                        if (!s[1].equals(itemno)) continue;
                        this.getModel().createNewEntryRow(OUTENTRYENTITY);
                        String hxdw = hxdwMap.get(unique);
                        BigDecimal qty = BigDecimal.ZERO;
                        BigDecimal ftje = BigDecimal.ZERO;
                        BigDecimal rmb = BigDecimal.ZERO;
                        if (wfDetail != null && !wfDetail.isEmpty()) {
                            for (DynamicObject obj : wfDetail) {
                                if (!Objects.equals(itemno, obj.getString("invoicecode"))) continue;
                                qty = qty.add(obj.getBigDecimal("qty"));
                                ftje = ftje.add(obj.getBigDecimal("ftje"));
                            }
                            rmb = this.getExportsellAmountByWfDetail(invoiceList);
                        }
                        model.setValue(EXPORTDOLLAR, (Object)ftje, index);
                        model.setValue(EXPORTSELLAMOUNT, (Object)rmb, index);
                        BigDecimal firstunitqty = entry.getBigDecimal("firstunitqty");
                        BigDecimal tradeqty = entry.getBigDecimal("tradeqty");
                        BigDecimal secondunitqty = entry.getBigDecimal("secondunitqty");
                        if ("tradeunit".equals(hxdw)) {
                            qty = qty.multiply(firstunitqty).divide(tradeqty, 10, RoundingMode.HALF_UP);
                        } else if ("secondunit".equals(hxdw)) {
                            qty = qty.multiply(firstunitqty).divide(secondunitqty, 10, RoundingMode.HALF_UP);
                        }
                        if (BigDecimal.ZERO.compareTo(qty) != 0) {
                            qty = cktsDraftService.getUnitQty(qty, (DynamicObject)entry.get("firstunit"));
                        }
                        model.setValue("tradeqty", (Object)qty, index);
                        String exportBillno = exportDeclaration.getString("billno");
                        model.setValue("hxdw", (Object)hxdw, index);
                        model.setValue("exportdetailid", entry.get("id"), index);
                        model.setValue("exportbasedata1", exportDeclaration.get("id"), index);
                        model.setValue("jljgszch", exportDeclaration.get("recordno"), index);
                        model.setValue("goodsecdnum", (Object)(exportBillno + "0" + itemno), index);
                        model.setValue("goodsitemno", (Object)itemno, index);
                        model.setValue("hscode", entry.get("hscode"), index);
                        model.setValue("tradeunit", entry.get("firstunit"), index);
                        model.setValue(TRADECURRENCY, entry.get(TRADECURRENCY), index);
                        model.setValue("tradeprice", entry.get("tradeprice"), index);
                        model.setValue(TRADEAMOUNT, entry.get(TRADEAMOUNT), index);
                        model.setValue("dcountry", entry.get("dcountry"), index);
                        ++index;
                    }
                }
            }
            this.getModel().endInit();
            this.getView().getModel().updateCache();
            this.getView().updateView(OUTENTRYENTITY);
        }
    }

    private BigDecimal getExportsellAmountByWfDetail(List<DynamicObject> invoiceList) {
        BigDecimal fphxjehz = invoiceList.stream().map(a -> a.getBigDecimal("ftje")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return fphxjehz;
    }

    private void setExportDetail(DynamicObject exportObject) {
        DynamicObjectCollection baseExportDetailCollection = this.getModel().getEntryEntity(OUTENTRYENTITY);
        DynamicObjectCollection entryEntityCollection = exportObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject baseObject : baseExportDetailCollection) {
            for (DynamicObject dynamicObject : entryEntityCollection) {
                if (!baseObject.getString("exportdetailid").equals(dynamicObject.getString("id"))) continue;
                baseObject.set("goodsitemno", (Object)dynamicObject.getString("itemno"));
                baseObject.set("exportbasedata1_id", exportObject.get("id"));
                baseObject.set("hscode", dynamicObject.get("hscode"));
                baseObject.set("tradeqty", dynamicObject.get("firstunitqty"));
                baseObject.set("tradeunit", dynamicObject.get("firstunit"));
                baseObject.set(TRADECURRENCY, dynamicObject.get(TRADECURRENCY));
                baseObject.set("tradeprice", dynamicObject.get("tradeprice"));
                baseObject.set(TRADEAMOUNT, dynamicObject.get(TRADEAMOUNT));
                baseObject.set("dcountry", dynamicObject.get("dcountry"));
            }
        }
        this.getView().getModel().updateCache();
        this.getView().updateView(OUTENTRYENTITY);
    }

    private void setExportInvoiceDetail() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INVOICEENTRYENTITY);
        for (DynamicObject object : entryEntity) {
            DynamicObjectCollection invoiceList = cktsDraftService.getInvoiceList(Lists.newArrayList((Object[])new Long[]{object.getLong("sinvoicedetailid")}));
            DynamicObject invoiceObj = (DynamicObject)invoiceList.get(0);
            object.set("sinvoicedetailid", (Object)invoiceObj.getLong("sinvoicedetailid"));
            object.set("sinvoiceno", (Object)invoiceObj.getString("invoiceno"));
            object.set("sissuetime", (Object)invoiceObj.getDate("issuetime"));
            object.set("sbuyername", (Object)invoiceObj.getString("buyername"));
            object.set("goodsname", (Object)invoiceObj.getString("goodsname"));
            object.set("specification", (Object)invoiceObj.getString("specification"));
            object.set("unit", (Object)invoiceObj.getString("unit"));
            object.set("num", (Object)invoiceObj.getBigDecimal("num"));
            object.set("unitprice", (Object)invoiceObj.getBigDecimal("unitprice"));
            object.set("amount", (Object)invoiceObj.getBigDecimal("amount"));
            object.set("invoicetaxrate", (Object)invoiceObj.getString("taxrate"));
        }
        this.getView().getModel().updateCache();
        this.getView().updateView(INVOICEENTRYENTITY);
    }

    private void setEntityBGDH(List<String> codes) {
        ComboEdit exportgoodsno = (ComboEdit)this.getControl("exportgoodsno");
        List goodsBGDH = codes.stream().map(s -> new ComboItem(new LocaleString(s), s)).collect(Collectors.toList());
        exportgoodsno.setComboItems(goodsBGDH);
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String name = e.getProperty().getName();
        this.getPageCache().put("alreadyinitflag", "0");
        if ("exportgoodsno".equals(name)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            String exportgoodsno = (String)e.getChangeSet()[0].getNewValue();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(INVOICEENTRYENTITY, rowIndex);
            DynamicObject object = this.getModel().getEntryEntity(OUTENTRYENTITY).stream().filter(s -> s.getString("goodsecdnum").equals(exportgoodsno)).findFirst().orElse(null);
            if (object != null) {
                BigDecimal taxrate = Optional.ofNullable(object.getDynamicObject("hscode")).map(s -> s.getBigDecimal("taxrate")).orElse(BigDecimal.ZERO);
                BigDecimal rdrate = Optional.ofNullable(object.getDynamicObject("hscode")).map(s -> s.getBigDecimal("edrate")).orElse(BigDecimal.ZERO);
                entryRowEntity.set("taxrateprop", (Object)taxrate.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
                entryRowEntity.set("edrateprop", (Object)rdrate.divide(new BigDecimal("100"), 4, RoundingMode.HALF_UP));
            } else {
                entryRowEntity.set("taxrateprop", (Object)BigDecimal.ZERO);
                entryRowEntity.set("edrateprop", (Object)BigDecimal.ZERO);
            }
            entryRowEntity.set("exportgoodsno", (Object)exportgoodsno);
            this.getView().updateView(INVOICEENTRYENTITY, rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("exportbasedata".equals(name)) {
            this.clearEntry(OUTENTRYENTITY);
            DynamicObject exportObject = (DynamicObject)this.getModel().getValue("exportbasedata");
            if (null == exportObject) {
                return;
            }
            DynamicObjectCollection entryEntityCollection = exportObject.getDynamicObjectCollection("entryentity");
            IDataModel model = this.getModel();
            model.beginInit();
            model.batchCreateNewEntryRow(OUTENTRYENTITY, entryEntityCollection.size());
            for (int index = 0; index < entryEntityCollection.size(); ++index) {
                DynamicObject object = (DynamicObject)entryEntityCollection.get(index);
                model.setValue("exportdetailid", (Object)object.getLong("id"), index);
                model.setValue("exportbasedata1", (Object)exportObject.getLong("id"), index);
                model.setValue("goodsitemno", (Object)object.getString("itemno"), index);
                model.setValue("hscode", object.get("hscode"), index);
                model.setValue("tradeqty", object.get("tradeqty"), index);
                model.setValue("tradeunit", object.get("tradeunit"), index);
                model.setValue(TRADECURRENCY, object.get(TRADECURRENCY), index);
                model.setValue("tradeprice", object.get("tradeprice"), index);
                model.setValue(TRADEAMOUNT, object.get(TRADEAMOUNT), index);
                model.setValue("dcountry", object.get("dcountry"), index);
                model.setValue(DOLLARRATE, (Object)this.getDollarrate(model, index), index);
                model.setValue("jljgszch", exportObject.get("recordno"), index);
                model.setValue(EXPORTDOLLAR, USD.equals(object.getDynamicObject(TRADECURRENCY).getString("number")) ? object.get(TRADEAMOUNT) : BigDecimal.ZERO, index);
                String exportdata = Optional.ofNullable((DynamicObject)model.getValue("exportbasedata")).map(s -> s.getString("billno")).orElse("");
                model.setValue("goodsecdnum", (Object)(exportdata + "0" + object.getString("itemno")), index);
            }
            model.endInit();
            this.getView().getModel().updateCache();
            this.getView().updateView(OUTENTRYENTITY);
        }
        if (DEALRATE.equals(name)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(OUTENTRYENTITY, rowIndex);
            String number = Optional.ofNullable(entryRowEntity.getDynamicObject(TRADECURRENCY)).map(s -> s.getString("number")).orElse("");
            this.getModel().getEntryEntity(OUTENTRYENTITY).stream().forEach(s -> {
                if (s.getDynamicObject(TRADECURRENCY) != null && s.getDynamicObject(TRADECURRENCY).getString("number").equals(number)) {
                    s.set(DEALRATE, (Object)newValue);
                    if (USD.equals(number)) {
                        s.set(DOLLARRATE, (Object)newValue);
                    } else {
                        s.set(EXPORTDOLLAR, (Object)this.getExportSellDollar(entryRowEntity));
                    }
                    s.set(EXPORTSELLAMOUNT, (Object)s.getBigDecimal(TRADEAMOUNT).multiply(s.getBigDecimal(DEALRATE)));
                }
            });
            this.getView().updateView(OUTENTRYENTITY);
        }
        if (DOLLARRATE.equals(name)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(OUTENTRYENTITY, rowIndex);
            if (entryRowEntity.getDynamicObject(TRADECURRENCY) != null && !USD.equals(entryRowEntity.getDynamicObject(TRADECURRENCY).getString("number"))) {
                entryRowEntity.set(EXPORTDOLLAR, (Object)this.getExportSellDollar(entryRowEntity));
                this.getView().updateView(OUTENTRYENTITY);
            }
        }
    }

    private BigDecimal getExportSellDollar(DynamicObject rowEntity) {
        BigDecimal dealrate = rowEntity.getBigDecimal(DEALRATE);
        BigDecimal dollarrate = rowEntity.getBigDecimal(DOLLARRATE);
        if (dealrate == null || dealrate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        if (dollarrate == null || dollarrate.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        return rowEntity.getBigDecimal(TRADEAMOUNT).multiply(dealrate).divide(dollarrate, 2, 4);
    }

    private BigDecimal getDollarrate(IDataModel model, int index) {
        DynamicObject rowEntity = model.getEntryRowEntity(OUTENTRYENTITY, index);
        String number = Optional.ofNullable(rowEntity.getDynamicObject(TRADECURRENCY)).map(s -> s.getString("number")).orElse("");
        if (USD.equals(number)) {
            return rowEntity.getBigDecimal(DEALRATE);
        }
        return BigDecimal.ZERO;
    }

    private void clearEntry(String entryName) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity(entryName);
        entryentity.clear();
        this.getModel().deleteEntryData(entryName);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Long orgId = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getLong("id")).orElse(0L);
        List customQFilters = beforeF7SelectEvent.getCustomQFilters();
        customQFilters.add(new QFilter("org", "=", (Object)orgId));
        customQFilters.add(new QFilter("billstatus", "=", (Object)"C"));
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        this.setEntityBGDH(this.getModel().getEntryEntity(OUTENTRYENTITY).stream().map(s -> s.getString("goodsecdnum")).collect(Collectors.toList()));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(INVOICEENTRYENTITY);
        if (entryEntity != null && entryEntity.size() > 0) {
            entryEntity.stream().forEach(s -> {
                s.set("exportgoodsno", (Object)"");
                s.set("taxrateprop", (Object)BigDecimal.ZERO);
                s.set("edrateprop", (Object)BigDecimal.ZERO);
            });
            this.getView().updateView(INVOICEENTRYENTITY);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        OperateOption option = source.getOption();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List successPkIds = (List)customParams.get("wfRecordId");
        if (successPkIds != null && !successPkIds.isEmpty()) {
            option.setVariableValue("wfRecordId", SerializationUtils.toJsonString((Object)successPkIds));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String itemKey = afterDoOperationEventArgs.getOperateKey();
        String orgid = Optional.ofNullable((DynamicObject)this.getModel().getValue("org")).map(s -> s.getString("id")).orElse("0");
        if (INVOICE_ADD_ROW.equals(itemKey)) {
            DynamicObjectCollection invoiceentryentity = this.getModel().getEntryEntity(INVOICEENTRYENTITY);
            List<Long> sinvoicedetailid = invoiceentryentity.stream().map(s -> s.getLong("sinvoicedetailid")).collect(Collectors.toList());
            Map<String, Object> map = this.getCustomsObjectMap(OUT_INVOICE, sinvoicedetailid, orgid);
            PageShowCommon.showForm((ShowType)ShowType.Modal, (String)TCETR_INVOICE_LIST, (IFormView)this.getView(), map, (IFormPlugin)this);
        }
    }

    public Map<String, Object> getCustomsObjectMap(String type, List<Long> selectedInvoiceIds, String orgid) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("type", type);
        map.put("orgid", orgid);
        map.put("selectedInvoiceDetailIds", selectedInvoiceIds);
        return map;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getActionId().equals(TCETR_INVOICE_LIST) && closedCallBackEvent.getReturnData() != null) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            List selectedRows = (List)result.get("selectedRows");
            String type = (String)result.get("type");
            if (OUT_INVOICE.equals(type)) {
                this.setEntityDetail(selectedRows, INVOICEENTRYENTITY, (ThreeConsumer<IDataModel, Integer, DynamicObject>)((ThreeConsumer)(model, index, object) -> this.setOutInvoiceModelValue((IDataModel)model, (int)index, (DynamicObject)object)));
            }
        }
    }

    private void setEntityDetail(List<DynamicObject> selectedRows, String entryentity, ThreeConsumer<IDataModel, Integer, DynamicObject> threeConsumer) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entity = model.getEntryEntity(entryentity);
        model.beginInit();
        if (entity == null || entity.size() == 0) {
            model.batchCreateNewEntryRow(entryentity, selectedRows.size());
            for (int index = 0; index < selectedRows.size(); ++index) {
                DynamicObject object = selectedRows.get(index);
                threeConsumer.accept((Object)model, (Object)index, (Object)object);
            }
        } else {
            for (int index = 0; index < selectedRows.size(); ++index) {
                int newEntryRow = model.createNewEntryRow(entryentity);
                DynamicObject object = selectedRows.get(index);
                threeConsumer.accept((Object)model, (Object)newEntryRow, (Object)object);
            }
        }
        model.endInit();
        this.getView().getModel().updateCache();
        this.getView().updateView(entryentity);
    }

    private void setOutInvoiceModelValue(IDataModel model, int index, DynamicObject object) {
        model.setValue("sinvoicedetailid", (Object)object.getLong("invoiceid"), index);
        model.setValue("sinvoiceno", (Object)object.getString("invoiceno"), index);
        model.setValue("sissuetime", (Object)object.getDate("issuetime"), index);
        model.setValue("sbuyername", (Object)object.getString("buyername"), index);
        model.setValue("goodsname", (Object)object.getString("goodsname"), index);
        model.setValue("specification", (Object)object.getString("specification"), index);
        model.setValue("unit", (Object)object.getString("unit"), index);
        model.setValue("num", (Object)object.getBigDecimal("num"), index);
        model.setValue("unitprice", (Object)object.getBigDecimal("unitprice"), index);
        model.setValue("amount", (Object)object.getBigDecimal("amount"), index);
        model.setValue("invoicetaxrate", (Object)object.getString("taxrate"), index);
    }

    private DynamicObject getWfRecordExportDetail(DynamicObject invoiceDetail) {
        DynamicObject wfRecord;
        DynamicObjectCollection entry;
        if (invoiceDetail != null && (entry = (wfRecord = (DynamicObject)invoiceDetail.getParent()).getDynamicObjectCollection("entry")) != null) {
            DynamicObject export = entry.stream().filter(o -> "tdm_export_declaration".equals(o.getString("billtype.number"))).findFirst().orElse(null);
            return export;
        }
        return null;
    }
}

