/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.draft.manufacture;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.tcetr.business.sbb.DeclareService;
import org.apache.commons.lang3.StringUtils;

public class ManufactureDraftListPlugin
extends AbstractListPlugin {
    private static final String GESBB = "gesbb";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap "});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isLinkDraft = customParams.getOrDefault("linkDraft", Boolean.FALSE);
        Boolean isViewHistory = customParams.getOrDefault("viewHistory", Boolean.FALSE);
        Object org = customParams.get("orgid");
        String sbny = customParams.get("sbny") != null ? (String)customParams.get("sbny") : "";
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        if (isLinkDraft.booleanValue() || isViewHistory.booleanValue()) {
            for (FilterColumn filterColumn : filterColumnList) {
                if (org != null && filterColumn.getFieldName().equals("org.name") && filterColumn instanceof CommonFilterColumn) {
                    filterColumn.setDefaultValue(org.toString());
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)sbny)) continue;
                Date startdate = DateUtils.stringToDate((String)sbny);
                Date enddate = DateUtils.getLastDateOfMonth((Date)startdate);
                if (!filterColumn.getFieldName().equals("taxperiod")) continue;
                filterColumn.setDefaultValues(new Object[]{DateUtils.format((Date)startdate), DateUtils.format((Date)enddate)});
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean isLinkDraft = customParams.getOrDefault("linkDraft", Boolean.FALSE);
        Boolean isViewHistory = customParams.getOrDefault("viewHistory", Boolean.FALSE);
        if (isLinkDraft.booleanValue() || isViewHistory.booleanValue()) {
            qFilters.add(new QFilter("sbbbillno", "=", customParams.get("declarenumber")));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (GESBB.equals(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            DynamicObject[] manufacturerDrafts = BusinessDataServiceHelper.load((Object[])list.getPrimaryKeyValues(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"tcetr_manufacturer_draft"));
            Map<String, List<DynamicObject>> groups = Arrays.stream(manufacturerDrafts).collect(Collectors.groupingBy(s -> String.format("%s_%s", s.getString("org.id"), DateUtils.format((Date)s.getDate("taxperiod"), (String)"yyyyMM"))));
            if (groups.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u3010\u7a0e\u52a1\u7ec4\u7ec7\u3011\uff0c\u540c\u3010\u6240\u5c5e\u7a0e\u671f\u3011\uff0c\u624d\u80fd\u751f\u6210\u7533\u62a5\u8868", (String)"ManufactureDraftListPlugin_0", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            long orgId = manufacturerDrafts[0].getLong("org.id");
            Date taxperiod = manufacturerDrafts[0].getDate("taxperiod");
            DynamicObject dyo = DeclareService.queryDeclareMain(orgId, taxperiod, "", "etrscsum");
            if (null != dyo) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011\u5df2\u5b58\u5728\u3010%2$s\u3011\u7684\u7533\u62a5\u8868,\u8bf7\u52ff\u91cd\u590d\u751f\u6210", (String)"ManufactureDraftListPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]), manufacturerDrafts[0].getDynamicObject("org").getString("name"), DateUtils.format((Date)taxperiod, (String)"yyyy-MM")));
                return;
            }
            HashMap<String, Object> param = new HashMap<String, Object>(16);
            param.put("pkids", list.getPrimaryKeyValues());
            param.put("orgid", orgId);
            param.put("sbny", taxperiod);
            param.put("createsbb", true);
            param.put("templatetype", "etrscsum");
            param.put("type", "etrscsum");
            String str = ResManager.loadKDString((String)"\u7533\u62a5", (String)"ManufactureDraftListPlugin_2", (String)"taxc-tcetr", (Object[])new Object[0]);
            param.put("customCaption", (String)TemplateTypeConstant.getNsrtypemap().get("etrscsum") + str);
            PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)"tcetr_declare_edit", (IFormView)this.getView(), param, (IFormPlugin)this);
        }
    }
}

