/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.feed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.IListView;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tcetr.formplugin.feed.DistributionRateListPlugin;

public class DistributionRateEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public static final String TCETR_DISTRIBUTION_RATE = "tcetr_distribution_rate";
    public static final String STARTDATE = "startdate";
    public static final String ENDDATE = "enddate";
    public static final String ORG = "org";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgControl = (BasedataEdit)this.getControl(ORG);
        orgControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String isChangingMainOrg = (String)this.getModel().getContextVariable("isChangingMainOrg");
        if (!"true".equals(isChangingMainOrg)) {
            List objects = Optional.ofNullable((IListView)this.getView().getParentView()).map(s -> s.getControlFilters()).map(s -> s.getFilter("org.id")).orElseGet(() -> new ArrayList());
            if (!CollectionUtils.isEmpty((Collection)objects) && objects.size() > 0 && StringUtil.isNotBlank((CharSequence)((CharSequence)objects.get(0)))) {
                String orgId = (String)objects.get(0);
                this.setDefaultOrg(Long.parseLong(orgId));
            } else {
                long defaultOrgId = RequestContext.get().getOrgId();
                this.setDefaultOrg(defaultOrgId);
            }
        }
        Date startdate = DateUtils.getFirstDateOfMonth((Date)new Date());
        this.getModel().setValue(STARTDATE, (Object)startdate);
        this.getModel().setValue(ENDDATE, (Object)this.getEndDate(startdate));
        this.getView().getFormShowParameter().setCloseCallBack(new CloseCallBack(DistributionRateListPlugin.class.getName(), TCETR_DISTRIBUTION_RATE));
    }

    private void setDefaultOrg(long orgId) {
        TaxResult existByOrgId = TaxcOrgDataServiceHelper.isTaxcOrgExistByOrgId((Long)orgId);
        if (((Boolean)existByOrgId.getData()).booleanValue()) {
            this.getModel().setValue(ORG, (Object)orgId);
        } else {
            this.getModel().setValue(ORG, null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Date newValue;
        ChangeData[] changeSet = e.getChangeSet();
        String name = e.getProperty().getName();
        if (STARTDATE.equals(name)) {
            newValue = (Date)changeSet[0].getNewValue();
            this.getModel().setValue(STARTDATE, (Object)this.getStartDate(newValue));
            this.getModel().setValue(ENDDATE, (Object)this.getEndDate(newValue));
        }
        if (ENDDATE.equals(name)) {
            newValue = (Date)changeSet[0].getNewValue();
            this.getModel().setValue(ENDDATE, (Object)(newValue != null ? DateUtils.getLastDateOfMonth((Date)newValue) : null));
        }
    }

    private Date getEndDate(Date startdate) {
        if (startdate == null) {
            return null;
        }
        return DateUtils.getLastDateOfMonth((Date)DateUtils.addMonth((Date)DateUtils.addYear((Date)startdate, (int)1), (int)-1));
    }

    private Date getStartDate(Date startdate) {
        if (startdate == null) {
            return null;
        }
        return DateUtils.getFirstDateOfMonth((Date)startdate);
    }
}

