/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.sbb.declare;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tcetr.business.draft.CktsDraftService;
import kd.taxc.tcetr.business.sbb.DeclareService;

public class DeclareShowPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String ORG = "org";
    private static final String PARA_ORG = "orgid";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String TABPAGEAP2 = "tabpageap2";
    private static final String TABPAGEAP3 = "tabpageap3";
    private static final String TABPAGEAP4 = "tabpageap4";
    private static final String TABPAGEAP5 = "tabpageap5";
    private static final String[] tab_keys = new String[]{"tabpageap1", "tabpageap2", "tabpageap3", "tabpageap4", "tabpageap5"};

    public void registerListener(EventObject e) {
        this.addClickListeners(tab_keys);
    }

    private void setActiveTab(String tabKey) {
        HashMap<String, Object> stylemap = new HashMap<String, Object>(2);
        stylemap.put("bc", "#F3F6FF");
        String linestyle = "2px_solid_#5582F3";
        HashMap style = new HashMap(16);
        HashMap<String, String> border = new HashMap<String, String>(16);
        border.put("b", linestyle);
        style.put("b", border);
        stylemap.put("s", style);
        this.getView().updateControlMetadata(tabKey, stylemap);
        HashMap<String, Object> stylemap1 = new HashMap<String, Object>(2);
        stylemap1.put("bc", "#ffffff");
        String linestyle1 = "0px_solid_#ffffff";
        HashMap style1 = new HashMap(16);
        HashMap<String, String> border1 = new HashMap<String, String>(16);
        border1.put("b", linestyle1);
        style1.put("b", border1);
        stylemap1.put("s", style1);
        Arrays.asList(tab_keys).forEach(key -> {
            if (!key.equals(tabKey)) {
                this.getView().updateControlMetadata(key, stylemap1);
            }
        });
        HashMap map = new HashMap(2);
        HashMap s = new HashMap(16);
        HashMap<String, String> b = new HashMap<String, String>(16);
        b.put("r", TABPAGEAP5.equals(tabKey) ? "0px_solid_#ffffff" : "10px_solid_#e0e5ed");
        b.put("l", TABPAGEAP5.equals(tabKey) ? "0px_solid_#ffffff" : "10px_solid_#e0e5ed");
        b.put("t", TABPAGEAP5.equals(tabKey) ? "0px_solid_#ffffff" : "10px_solid_#e0e5ed");
        b.put("b", TABPAGEAP5.equals(tabKey) ? "0px_solid_#ffffff" : "10px_solid_#e0e5ed");
        s.put("b", b);
        map.put("s", s);
        this.getView().updateControlMetadata("flexcontent", map);
        this.showTab(tabKey);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (TABPAGEAP5.equals(key)) {
            String orgId = this.getParam(PARA_ORG);
            String month = this.getParam("month");
            String batchno = this.getParam("batchno");
            String type = this.getParam("type");
            DynamicObjectCollection draftDyos = "etrscsum".equals(type) ? CktsDraftService.queryManufacture(this.getParam("declarenumber")) : CktsDraftService.query(Long.parseLong(orgId), DateUtils.stringToDate((String)month), batchno);
            DynamicObject dyo = DeclareService.queryDeclareMain(Long.parseLong(orgId), DateUtils.stringToDate((String)month), batchno, type);
            if (CollectionUtils.isEmpty((Collection)draftDyos) || "2".equals(dyo.getString("sourcetype"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u672a\u68c0\u6d4b\u5230\u6709\u5b58\u50a8\u7684\u5e95\u7a3f\u6570\u636e\u3002", (String)"DeclareShowPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
        }
        if (Arrays.asList(tab_keys).contains(key)) {
            this.setActiveTab(key);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String orgId = this.getParam(PARA_ORG);
        String startDate = this.getParam(SKSSQQ);
        String endDate = this.getParam(SKSSQZ);
        this.getModel().setValue(ORG, (Object)orgId);
        this.getModel().setValue("startdate", (Object)DateUtils.stringToDate((String)startDate));
        this.getModel().setValue("enddate", (Object)DateUtils.stringToDate((String)endDate));
        this.setActiveTab(TABPAGEAP1);
    }

    public void tabSelected(TabSelectEvent event) {
        this.showTab(event.getTabKey());
    }

    private void showTab(String tableKey) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (TABPAGEAP1.equals(tableKey)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("bdtaxr_declare");
            parameter.getOpenStyle().setShowType(ShowType.InContainer);
            parameter.getOpenStyle().setTargetKey("flexcontent");
            parameter.setCustomParams(customParams);
            this.getView().showForm(parameter);
        } else if (TABPAGEAP5.equals(tableKey)) {
            String orgId = this.getParam(PARA_ORG);
            String month = this.getParam("month");
            String batchno = this.getParam("batchno");
            String type = this.getParam("type");
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("etrscsum".equals(type) ? "tcetr_manufacturer_dg_his" : "tcetr_ckts_dg_history");
            listShowParameter.setFormId("bos_list");
            customParams.put(ORG, orgId);
            customParams.put("sbny", month);
            customParams.put("sbpc", batchno);
            customParams.put("viewHistory", Boolean.TRUE);
            customParams.put("declarenumber", this.getParam("declarenumber"));
            listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            listShowParameter.getOpenStyle().setTargetKey("flexcontent");
            listShowParameter.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private String getParam(String param) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get(param);
    }
}

