/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.sbb.declare;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.tcetr.business.sbb.DeclareQueryListService;
import kd.taxc.tcetr.formplugin.draft.CktsDraftSbbStatusUtils;

public class TaxDeclareQueryListPlugin
extends AbstractListPlugin {
    private static final String TEMPLATE_TYPE = "drawback";
    private static final String SKSSQQ = "skssqq";
    private static final String SKSSQZ = "skssqz";
    private static Log logger = LogFactory.getLog(TaxDeclareQueryListPlugin.class);
    private static final String IMPORT = "import";
    private static final String EXPORT = "export";
    private static final String SUBMIT = "submit";
    private static final String UNSUBMIT = "unsubmit";
    private static final String AUDIT = "audit";
    private static final String UNAUDIT = "unaudit";
    private static final String APPLY = "apply";
    private static final String CANCELAPPLY = "cancelapply";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    private static final String BILL_LIST = "billlistap";
    private static final String TCETR_DECLARE_MAIN = "tcetr_declare_main";
    private static final String SEPARATOR_KEY = "line.separator";
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void initialize() {
        String templatetype = (String)this.getView().getFormShowParameter().getCustomParam("templatetype");
        BillList billlist = (BillList)this.getControl(BILL_LIST);
        QFilter qFilter = new QFilter("type", "=", (Object)templatetype);
        billlist.setFilter(qFilter);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (customList != null && !customList.isEmpty()) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf(SKSSQQ);
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                this.getPageCache().put(SKSSQQ, SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billlist;
        ListSelectedRowCollection list;
        Set strCollect;
        DynamicObjectCollection mutexCollection;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if (("delete".equals(key) || SUBMIT.equals(key) || UNSUBMIT.equals(key) || AUDIT.equals(key) || UNAUDIT.equals(key)) && !CollectionUtils.isEmpty((Collection)(mutexCollection = QueryServiceHelper.query((String)"bos_datalock", (String)"objectid,user.name", (QFilter[])new QFilter[]{new QFilter("objectid", "in", strCollect = (list = (billlist = (BillList)this.getControl(BILL_LIST)).getSelectedRows()).stream().map(a -> String.valueOf(a.getPrimaryKeyValue())).collect(Collectors.toSet()))})))) {
            Map<Long, String> mutexMap = mutexCollection.stream().collect(Collectors.toMap(e -> Long.valueOf(e.getString("objectid")), e -> e.getString("user.name"), (k, v) -> k));
            DynamicObjectCollection nsrxxCollection = QueryServiceHelper.query((String)TCETR_DECLARE_MAIN, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", mutexMap.keySet())});
            ArrayList errList = new ArrayList();
            StringBuilder stringBuilder = new StringBuilder();
            nsrxxCollection.stream().forEach(e -> {
                String msg = String.format(ResManager.loadKDString((String)"%1$s\u6b63\u5728\u7f16\u8f91%2$s\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002\r\n", (String)"TaxDeclareQueryListPlugin_12", (String)"taxc-tcetr", (Object[])new Object[0]), mutexMap.get(e.getLong("id")), e.getString("billno"));
                errList.add(msg);
                stringBuilder.append(msg);
            });
            if (errList.size() > 0) {
                args.setCancel(true);
                if (errList.size() == 1) {
                    this.getView().showTipNotification((String)errList.get(0));
                } else {
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxDeclareQueryListPlugin_13", (String)"taxc-tcetr", (Object[])new Object[0]));
                    MessageBoxOptions options = MessageBoxOptions.OK;
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25", (String)"TaxDeclareQueryListPlugin_14", (String)"taxc-tcetr", (Object[])new Object[0]), stringBuilder.toString(), options, ConfirmTypes.Save, null, btnNameMaps);
                }
                return;
            }
        }
        if (SUBMIT.equals(key) || UNSUBMIT.equals(key) || AUDIT.equals(key) || UNAUDIT.equals(key)) {
            billlist = (BillList)this.getControl(BILL_LIST);
            list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u63d0\u4ea4\u7684\u8bb0\u5f55", (String)"TaxDeclareQueryListPlugin_4", (String)"taxc-tcetr", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            List<Object> pklist = list.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
            ValidDataResultVo submit = DeclareQueryListService.submit(pklist, key, TCETR_DECLARE_MAIN, true);
            if (!submit.getSuccess()) {
                this.getView().showTipNotification(submit.getMessage());
                args.setCancel(true);
                return;
            }
            this.getView().showSuccessNotification(submit.getMessage());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        block54: {
            BillList billlist;
            String templatetype = (String)this.getView().getFormShowParameter().getCustomParam("templatetype");
            if (IMPORT.equals(evt.getOperateKey())) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setFormId("bdtaxr_import_dialog_new");
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
                parameter.setCustomParam("source", (Object)"declare");
                parameter.setCustomParam("templatetypelist", (Object)Lists.newArrayList((Object[])new String[]{templatetype}));
                this.getView().showForm(parameter);
            }
            if (EXPORT.equals(evt.getOperateKey())) {
                billlist = (BillList)this.getControl(BILL_LIST);
                ListSelectedRowCollection list = billlist.getSelectedRows();
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u8bb0\u5f55", (String)"TaxDeclareQueryListPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u4efd\u7533\u62a5\u8868\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c\u5bfc\u51fa", (String)"TaxDeclareQueryListPlugin_2", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                String pk = list.get(0).getPrimaryKeyValue().toString();
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)TCETR_DECLARE_MAIN);
                DynamicObject org = obj.getDynamicObject("org");
                String string = obj.getString("type");
                String fileName = TemplateTypeConstant.getNsrtypemap().getOrDefault(string, string) + "_";
                if (org != null) {
                    fileName = fileName + org.getString("name");
                }
                Date date = (Date)obj.get(SKSSQQ);
                DynamicObject template = null;
                String templateid = obj.getString("templateid");
                if (StringUtils.isNotEmpty((CharSequence)templateid)) {
                    template = TemplateUtils.getTemplateObjectById((String)string, (String)templateid);
                }
                if (template == null) {
                    template = TemplateUtils.getTemplateObject((String)string, (Date)date, (Date)date);
                }
                if (template == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u6a21\u677f\u4e0d\u5b58\u5728", (String)"TaxDeclareQueryListPlugin_3", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                fileName = fileName + DateUtils.format((Date)date, (String)"yyyy-MM");
                Map valMap = TemplateShowUtils.queryData((Long)template.getLong("id"), (String)pk, (String)"_");
                valMap.put("tcetr_declare_main_1_month", DateUtils.format((Date)DateUtils.stringToDate((String)((String)valMap.get("tcetr_declare_main_1_month"))), (String)DateUtils.YYYYMM));
                try (InputStream in = TemplateShowUtils.getDownResultExcelFile((DynamicObject)template, (Map)valMap);){
                    String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", in, 5000);
                    String serviceAppId = this.getView().getFormShowParameter().getServiceAppId();
                    String entityNum = ((IListView)this.getView()).getBillFormId();
                    PermissionUtils.putTempFilePermissionCache((String)urls, (String)serviceAppId, (String)entityNum, (String)"4730fc9f000004ae");
                    this.getView().openUrl(urls);
                    break block54;
                }
                catch (IOException e2) {
                    logger.error(e2.getMessage());
                    throw new KDBizException((Throwable)e2, new ErrorCode("", e2.toString()), new Object[0]);
                }
            }
            if (SUBMIT.equals(evt.getOperateKey()) || UNSUBMIT.equals(evt.getOperateKey()) || AUDIT.equals(evt.getOperateKey()) || UNAUDIT.equals(evt.getOperateKey())) {
                billlist = (BillList)this.getControl(BILL_LIST);
                billlist.refresh();
            } else if (APPLY.equals(evt.getOperateKey())) {
                billlist = (BillList)this.getControl(BILL_LIST);
                ListSelectedRowCollection list = billlist.getSelectedRows();
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55", (String)"TaxDeclareQueryListPlugin_5", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                StringBuilder message = new StringBuilder();
                Object[] pkIds = list.getPrimaryKeyValues();
                DynamicObject[] declares = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCETR_DECLARE_MAIN));
                if (declares != null && declares.length > 0) {
                    ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                    for (DynamicObject declare : declares) {
                        DynamicObject org = declare.getDynamicObject("org");
                        String type = declare.getString("type");
                        String skssqq = DateUtils.format((Date)declare.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
                        String skssqz = DateUtils.format((Date)declare.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
                        String billStatus = declare.getString("billstatus");
                        if (!"C".equals(billStatus)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"TaxDeclareQueryListPlugin_6", (String)"taxc-tcetr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz)).append(SEPARATOR);
                            continue;
                        }
                        if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u786e\u8ba4\u7533\u62a5: %1$s %2$s \u81f3 %3$s \u4e0d\u7b26\u5408\u6761\u4ef6", (String)"TaxDeclareQueryListPlugin_7", (String)"taxc-tcetr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz)).append(SEPARATOR);
                            continue;
                        }
                        declare.set("declarestatus", (Object)"declared");
                        declare.set("modifytime", (Object)new Date());
                        declare.set("modifier", (Object)RequestContext.get().getUserId());
                        declare.set("declaredate", (Object)new Date());
                        declare.set("declarer", (Object)RequestContext.get().getUserId());
                        modifyDynamicObjects.add(declare);
                    }
                    if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                        String[] stringArray = message.toString().split(System.getProperty(SEPARATOR_KEY));
                        if (stringArray.length == 1) {
                            this.getView().showErrorNotification(message.toString());
                        } else {
                            this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                            OperationResult operationResult = new OperationResult();
                            operationResult.setSuccess(false);
                            operationResult.setMessage(message.toString());
                            this.getView().showOperationResult(operationResult);
                        }
                        return;
                    }
                    if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                        SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                        CktsDraftSbbStatusUtils.updateDeclareStatus(templatetype, modifyDynamicObjects.stream().map(s -> s.getLong("id")).collect(Collectors.toList()), "declared");
                        this.generateDrawbackInfo(modifyDynamicObjects);
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaxDeclareQueryListPlugin_8", (String)"taxc-tcetr", (Object[])new Object[0]));
                        billlist.refresh();
                    }
                }
            } else if (CANCELAPPLY.equals(evt.getOperateKey())) {
                billlist = (BillList)this.getControl(BILL_LIST);
                ListSelectedRowCollection list = billlist.getSelectedRows();
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u8bb0\u5f55", (String)"TaxDeclareQueryListPlugin_5", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                StringBuilder message = new StringBuilder();
                Object[] pkIds = list.getPrimaryKeyValues();
                DynamicObject[] declares = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)TCETR_DECLARE_MAIN));
                if (declares != null && declares.length > 0) {
                    ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                    for (DynamicObject declare : declares) {
                        DynamicObject org = declare.getDynamicObject("org");
                        String type = declare.getString("type");
                        String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                        String skssqq = DateUtils.format((Date)declare.getDate(SKSSQQ), (String)DateUtils.YYYYMMDD_CHINESE);
                        String skssqz = DateUtils.format((Date)declare.getDate(SKSSQZ), (String)DateUtils.YYYYMMDD_CHINESE);
                        String billStatus = declare.getString("billstatus");
                        if (!"C".equals(billStatus)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"TaxDeclareQueryListPlugin_10", (String)"taxc-tcetr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        if (!"declared".equals(declare.getString("declarestatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u6210\u529f\u53ef\u53d6\u6d88\u7533\u62a5: %1$s %2$s \u81f3 %3$s %s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"TaxDeclareQueryListPlugin_11", (String)"taxc-tcetr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                        declare.set("declarestatus", (Object)"editing");
                        declare.set("modifytime", (Object)new Date());
                        declare.set("modifier", (Object)RequestContext.get().getUserId());
                        declare.set("declaredate", null);
                        declare.set("declarer", (Object)0L);
                        modifyDynamicObjects.add(declare);
                    }
                    if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                        List<String> list2 = this.deleteTaxRefundInfo(modifyDynamicObjects);
                        List<DynamicObject> canCancelApplyList = modifyDynamicObjects.stream().filter(e -> !notDeleteNum.contains(e.getString("billno"))).collect(Collectors.toList());
                        SaveServiceHelper.save((DynamicObject[])canCancelApplyList.toArray(new DynamicObject[0]));
                        CktsDraftSbbStatusUtils.updateDeclareStatus(templatetype, canCancelApplyList.stream().map(s -> s.getLong("id")).collect(Collectors.toList()), "editing");
                        if (StringUtils.isBlank((CharSequence)message.toString()) && CollectionUtils.isEmpty(list2)) {
                            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f", (String)"TaxDeclareQueryListPlugin_8", (String)"taxc-tcetr", (Object[])new Object[0]));
                        } else {
                            for (String num : list2) {
                                String msg = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u7f16\u53f7\uff1a%s\u53d6\u6d88\u5931\u8d25\uff0c\u4e0b\u6e38\u7684\u9000\u7a0e\u4fe1\u606f\u4e3a\u672a\u9000\u7a0e\u6216\u672a\u751f\u6210\u51ed\u8bc1\uff0c\u624d\u80fd\u53d6\u6d88\u7533\u62a5", (String)"TaxDeclareQueryListPlugin_15", (String)"taxc-tcetr", (Object[])new Object[0]), num);
                                message.append(msg).append(SEPARATOR);
                            }
                        }
                        billlist.refresh();
                    }
                    if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                        String[] stringArray = message.toString().split(System.getProperty(SEPARATOR_KEY));
                        if (stringArray.length == 1) {
                            this.getView().showErrorNotification(message.toString());
                        } else {
                            this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                            OperationResult operationResult = new OperationResult();
                            operationResult.setSuccess(false);
                            operationResult.setMessage(message.toString());
                            this.getView().showOperationResult(operationResult);
                        }
                    }
                }
            } else if (VIEWFLOWCHART.equals(evt.getOperateKey())) {
                billlist = (BillList)this.getControl(BILL_LIST);
                ListSelectedRowCollection list = billlist.getSelectedRows();
                if (list == null || list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u67e5\u770b\u7684\u8bb0\u5f55", (String)"TaxDeclareQueryListPlugin_16", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                Set collect = Arrays.stream(list.getPrimaryKeyValues()).collect(Collectors.toSet());
                if (collect.size() > 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u67e5\u770b\u591a\u4e2a\u6d41\u7a0b\u8bb0\u5f55\uff0c\u8bf7\u9009\u62e9\u4e00\u6761\u7533\u62a5\u8bb0\u5f55\u518d\u64cd\u4f5c", (String)"TaxDeclareQueryListPlugin_17", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                OpenStyle openStyle = new OpenStyle();
                openStyle.setShowType(ShowType.MainNewTabPage);
                try {
                    WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)list.get(0).getPrimaryKeyValue(), (OpenStyle)openStyle);
                }
                catch (Exception e3) {
                    logger.error(ThrowableHelper.toString((Exception)e3));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe", (String)"TaxDeclareQueryListPlugin_18", (String)"taxc-tcetr", (Object[])new Object[0]));
                }
            }
        }
    }

    private List<String> deleteTaxRefundInfo(List<DynamicObject> modifyDynamicObjects) {
        List<String> failNumLsit = new ArrayList<String>();
        List billnoList = modifyDynamicObjects.stream().map(e -> e.getString("billno")).collect(Collectors.toList());
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"deleteTaxRefundInfo", (Object[])new Object[]{billnoList});
        boolean success = (Boolean)result.get("success");
        if (!success) {
            List data = (List)result.get("data");
            failNumLsit = data.stream().map(e -> e.get("failnum").toString()).collect(Collectors.toList());
        }
        return failNumLsit;
    }

    private void generateDrawbackInfo(List<DynamicObject> modifyDynamicObjects) {
        ArrayList<Map<String, Object>> drawbackInfoList = new ArrayList<Map<String, Object>>();
        for (DynamicObject object : modifyDynamicObjects) {
            BigDecimal xfsamount;
            BigDecimal zzsamount = object.getBigDecimal("zzsamount");
            if (zzsamount.compareTo(BigDecimal.ZERO) > 0) {
                Map<String, Object> drawbackInfoMap = this.createMapData(object);
                drawbackInfoMap.put("refundableamount", object.getBigDecimal("zzsamount"));
                drawbackInfoMap.put("taxcategory", 1L);
                drawbackInfoMap.put("currency", 1L);
                drawbackInfoList.add(drawbackInfoMap);
            }
            if ((xfsamount = object.getBigDecimal("xfsamount")).compareTo(BigDecimal.ZERO) <= 0) continue;
            Map<String, Object> drawbackInfoMap = this.createMapData(object);
            drawbackInfoMap.put("refundableamount", object.getBigDecimal("xfsamount"));
            drawbackInfoMap.put("taxcategory", 2L);
            drawbackInfoMap.put("currency", 1L);
            drawbackInfoList.add(drawbackInfoMap);
        }
        this.sendTaxRefundInfo(drawbackInfoList);
    }

    private void sendTaxRefundInfo(List<Map<String, Object>> drawbackInfoList) {
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tpo", (String)"TaxRefundInfoService", (String)"addTaxRefundInfo", (Object[])new Object[]{drawbackInfoList});
        boolean success = (Boolean)result.get("success");
        if (!success) {
            List data = (List)result.get("data");
            String errormsg = data.stream().map(e -> e.get("errormsg").toString()).collect(Collectors.joining("/n"));
            logger.info("addTaxRefundErrorMag:" + errormsg);
        }
    }

    private Map<String, Object> createMapData(DynamicObject object) {
        HashMap<String, Object> drawbackInfoMap = new HashMap<String, Object>();
        drawbackInfoMap.put("org", object.getDynamicObject("org").getLong("id"));
        drawbackInfoMap.put("startdate", object.getDate(SKSSQQ));
        drawbackInfoMap.put("enddate", object.getDate(SKSSQZ));
        drawbackInfoMap.put("applicationdate", new Date());
        drawbackInfoMap.put("taxoffice", this.getTaxoffice(object.getDynamicObject("org").getLong("id")));
        drawbackInfoMap.put("declaretype", object.getString("type"));
        drawbackInfoMap.put("declarenum", object.getString("billno"));
        drawbackInfoMap.put("creator", RequestContext.get().getCurrUserId());
        return drawbackInfoMap;
    }

    private Long getTaxoffice(long orgid) {
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxOfficeIdByOrgId(Collections.singletonList(orgid));
        if (listTaxResult.isSuccess() && ((List)listTaxResult.getData()).size() > 0) {
            return (Long)((List)listTaxResult.getData()).get(0);
        }
        return 0L;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String templatetype = (String)this.getView().getFormShowParameter().getCustomParam("templatetype");
        if (!TEMPLATE_TYPE.equals(templatetype)) {
            args.setCancel(true);
            BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)TCETR_DECLARE_MAIN);
            String type = object.getString("type");
            HashMap<String, Object> customParams = new HashMap<String, Object>(4);
            customParams.put("sbbid", object.getString("id"));
            customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
            customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
            Date skssqq = object.getDate(SKSSQQ);
            Date skssqz = object.getDate(SKSSQZ);
            customParams.put("type", type);
            customParams.put("templatetype", type);
            String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
            customParams.put(SKSSQQ, startDate);
            customParams.put(SKSSQZ, DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            customParams.put("taxlimit", DateUtils.getTaxLimit((Date)skssqq, (Date)skssqz));
            customParams.put("taxperiod", startDate.substring(0, 7));
            customParams.put("readonly", Boolean.TRUE);
            customParams.put("from", "history");
            customParams.put("modifytime", object.getDate("modifytime"));
            String declarestatus = object.getString("declarestatus");
            String dataType = object.getString("sourcetype");
            customParams.put("sourcetype", dataType);
            customParams.put("month", object.getString("month"));
            customParams.put("batchno", object.getString("batchno"));
            this.showDeclarePage(StringUtils.trimToEmpty((String)type), customParams, declarestatus, object);
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if (SKSSQQ.equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate(SKSSQQ), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            String skssqz = DateUtils.format((Date)data.getDate(SKSSQZ), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (IMPORT.equals(actionId)) {
            BillList billList = (BillList)this.getView().getControl(BILL_LIST);
            billList.refresh();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
    }

    private void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object) {
        FormShowParameter param = new FormShowParameter();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)type);
        if ("declared".equals(declarestatus)) {
            param.setFormId(templateEnum.getDeclareShowPage());
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setOrgId(Long.valueOf(Long.parseLong((String)customParams.get(ORGID_KEY))));
            requestModel.setTemplateType(type);
            requestModel.setId(Long.valueOf(object.getLong("id")));
            requestModel.setSkssqq(DateUtils.format((Date)object.getDate(SKSSQQ)));
            requestModel.setSkssqz(DateUtils.format((Date)object.getDate(SKSSQZ)));
            requestModel.setOperation("read");
            requestModel.setRefresh(Boolean.FALSE);
            customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        } else {
            param.setFormId(templateEnum.getDeclarePage());
        }
        customParams.put("declarenumber", object.getString("billno"));
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }
}

