/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tcetr.formplugin.sbb.declare;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DrawBackDeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.DevprotalBizAppUtil;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import kd.taxc.tcetr.business.draft.CktsDraftService;
import kd.taxc.tcetr.business.model.DrawBackDeclareHeader;
import kd.taxc.tcetr.business.sbb.DeclareQueryListService;
import kd.taxc.tcetr.business.sbb.DeclareService;
import kd.taxc.tcetr.formplugin.draft.CktsDraftSbbStatusUtils;

public class TcetrDeclarationEditPlugin
extends AbstractFormPlugin {
    private static final String CREATESBB = "createsbb";
    private static Log logger = LogFactory.getLog(TcetrDeclarationEditPlugin.class);
    private static final String ORGID_KEY = "orgid";
    private static final String MONTH = "month";
    private static final String BATCHNO = "batchno";
    private static final String PKIDS = "pkids";
    private static final String CONTENT_TAB = "tabcontent";
    private static final String ENTITY_NAME = "tcetr_declare_main";
    private static final String DECLARE_PAGE_ENTITY_NEW = "bdtaxr_declare";
    private static final String SBBID = "cache_sbbid";
    private static final String BILLNO = "cache_billno";
    private static final String BILL_STATUS = "cache_billstatus";
    private static final String EDIT_KEY = "edit";
    private static final String SAVE_KEY = "save";
    private static final String CANCEL_KEY = "cancel";
    private static final String SUBMIT_KEY = "submit";
    private static final String UNSUBMIT_KEY = "unsubmit";
    private static final String AUDIT_KEY = "audit";
    private static final String UNAUDIT_KEY = "unaudit";
    private static final String VIEW_DRAFT_KEY = "viewdraft";
    private static final String CLOSE_KEY = "close";
    private static final String ORG_SEL = "org";
    private static final String CALLBACKID_MOD = "modifyOrDelete";
    private static final String CALLBACKID_MODIFY = "callback_modify";
    private static final String EDIT_STATUS = "edit";
    private static final String VIEW_STATUS = "read";

    public void registerListener(EventObject e) {
        String BAR_KEY = "toolbarap";
        String TOOL_BAR_DECLARE = "toolbarapdeclare";
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        boolean isHyperLinkClick;
        this.getView().setVisible(Boolean.FALSE, new String[]{SAVE_KEY, CANCEL_KEY});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean bl = isHyperLinkClick = customParams.get(ORGID_KEY) != null && customParams.get("skssqq") != null && customParams.get("skssqz") != null;
        if (isHyperLinkClick) {
            this.loadFromHyperLinkClick(customParams);
        } else {
            Boolean createsbb = customParams.getOrDefault(CREATESBB, false);
            this.loadFromDeclareMenu(createsbb);
        }
        this.getView().setVisible(Boolean.valueOf(!"etrscsum".equals(this.getTemplateType())), new String[]{"xfsamount", "labelap13", "flexpanelap34"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String entityname = this.getModel().getDataEntityType().getName();
        String entity = ENTITY_NAME;
        String sbbid = this.getPageCache().get(SBBID);
        HashMap<String, String> customparam = new HashMap<String, String>();
        if ("edit".equals(key)) {
            if (StringUtils.isNotBlank((CharSequence)entity)) {
                try {
                    DynamicObject dynamicObject;
                    MutexServiceImpl mutexService = new MutexServiceImpl();
                    customparam.put("dataObjId", sbbid);
                    customparam.put("entityKey", entity);
                    customparam.put("operationKey", "edit");
                    customparam.put("groupId", "declare_edit");
                    mutexService.setMutexLockInfo(customparam);
                    boolean isSuccessLock = mutexService.setMutexLock();
                    logger.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entityname, entity, isSuccessLock});
                    if (!isSuccessLock && (dynamicObject = MutexServiceImpl.getMutexData((QFilter)new QFilter("objectid", "=", (Object)sbbid))) != null) {
                        String user = dynamicObject.getString("user.name");
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TcetrDeclarationEditPlugin_13", (String)"taxc-tcetr", (Object[])new Object[0]), user));
                        evt.setCancel(true);
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        } else if (Sets.newHashSet((Object[])new String[]{SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY}).contains(key)) {
            DynamicObject dynamicObject = MutexServiceImpl.getMutexData((QFilter)new QFilter("objectid", "=", (Object)sbbid));
            if (dynamicObject != null && !dynamicObject.get("user.id").equals(RequestContext.get().getCurrUserId())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"TcetrDeclarationEditPlugin_13", (String)"taxc-tcetr", (Object[])new Object[0]), dynamicObject.get("user.name")));
                evt.setCancel(true);
            }
        } else if (SAVE_KEY.equals(key) || CANCEL_KEY.equals(key)) {
            MutexServiceImpl.releaseMutexLock((String)sbbid, (String)"edit", (Long)RequestContext.get().getCurrUserId());
        }
    }

    private void loadFromDeclareMenu(Boolean createsbb) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String templateType = (String)customParams.get("type");
        if ("etrscsum".equals(templateType)) {
            FieldEdit control = (FieldEdit)this.getControl(BATCHNO);
            control.setMustInput(Boolean.FALSE.booleanValue());
            this.getView().setVisible(Boolean.FALSE, new String[]{BATCHNO});
        }
        if (createsbb.booleanValue()) {
            DrawBackDeclareHeader header = this.initDeclareHeader(customParams);
            header.setType(this.getTemplateType());
            Boolean check = this.beforeOpenInnerPage(header, customParams);
            if (check.booleanValue()) {
                this.getModel().setValue(ORG_SEL, null);
                JSONArray jsonArrays = (JSONArray)customParams.get(PKIDS);
                CktsDraftSbbStatusUtils.deleteSbbMess(templateType, jsonArrays.stream().collect(Collectors.toList()));
                this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
            }
        } else {
            HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
            Long orgId = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)RequestContext.get().getOrgId(), (DynamicObjectCollection)col);
            if (orgId == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"TcetrDeclarationEditPlugin_0", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            customParams.put(ORGID_KEY, orgId);
            DrawBackDeclareHeader header = this.initDeclareHeader(customParams);
            this.beforeOpenInnerPage(header, customParams);
        }
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String orgid = (String)customParams.get(ORGID_KEY);
        String appid = this.getView().getFormShowParameter().getAppId();
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, null);
        if (!checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            String taxmonth = (String)customParams.get(MONTH);
            String batchno = (String)customParams.get(BATCHNO);
            Date month = DateUtils.stringToDate((String)taxmonth);
            this.getModel().setValue(MONTH, (Object)month);
            String templateType = (String)customParams.get("type");
            if ("etrscsum".equals(templateType)) {
                FieldEdit control = (FieldEdit)this.getControl(BATCHNO);
                control.setMustInput(Boolean.FALSE.booleanValue());
                this.getView().setVisible(Boolean.FALSE, new String[]{BATCHNO});
            }
            this.getModel().setValue(BATCHNO, (Object)batchno);
            this.openDeclarePage(this.getDeclareHeader(), "true".equals(String.valueOf(customParams.get("refresh"))));
        }
    }

    private Boolean beforeOpenInnerPage(DrawBackDeclareHeader header, Map<String, Object> customParams) {
        String appid = this.getView().getFormShowParameter().getAppId();
        Boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)header.getOrg().toString(), (String)appid, null);
        if (!checkResult.booleanValue()) {
            this.openDeclarePage(header, true);
        }
        return checkResult;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object object;
        String appid = this.getView().getFormShowParameter().getAppId();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        if (e.getProperty().getName().equals(ORG_SEL)) {
            object = changeData[0].getNewValue();
            if (object == null) {
                return;
            }
            DynamicObject org = (DynamicObject)object;
            String orgid = org.getString("id");
            boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, null);
            if (checkResult) {
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
            } else {
                customParams.put(ORGID_KEY, Long.parseLong(orgid));
                DrawBackDeclareHeader header = this.initDeclareHeader(customParams);
                this.loadData(header);
            }
        }
        if (e.getProperty().getName().equals(MONTH)) {
            object = changeData[0].getNewValue();
            if (object == null) {
                return;
            }
            this.loadData(this.getDeclareHeader());
        }
    }

    private DrawBackDeclareHeader getDeclareHeader() {
        Object taxMonth;
        Object org = this.getModel().getValue(ORG_SEL);
        Long orgId = 0L;
        Date month = null;
        if (org != null) {
            orgId = ((DynamicObject)org).getLong("id");
        }
        if ((taxMonth = this.getModel().getValue(MONTH)) != null) {
            month = (Date)taxMonth;
        }
        String batchno = (String)this.getModel().getValue(BATCHNO);
        return new DrawBackDeclareHeader(orgId, "", month, batchno);
    }

    public void loadData(DrawBackDeclareHeader header) {
        this.openDeclarePage(header, true);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String showData = this.getView().getPageCache().get("showData");
        this.clientCallBackMethod(showData, e.getName());
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"TcetrDeclarationEditPlugin_1", (String)"taxc-tcetr", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
                DrawBackDeclareHeader declareHeader = this.getDeclareHeader();
                ValidDataResultVo validDataResultVo = this.validDataBeforeOperation(this.getDeclareHeader());
                if (!validDataResultVo.getSuccess()) {
                    this.getView().showErrorNotification(validDataResultVo.getMessage());
                    return;
                }
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                String templateType = (String)customParams.get("type");
                if (!"etrscsum".equals(templateType) && StringUtils.isEmpty((CharSequence)declareHeader.getBatchNo())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a", (String)"TcetrDeclarationEditPlugin_10", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                this.save();
                break;
            }
            case "cancel": {
                LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"TcetrDeclarationEditPlugin_2", (String)"taxc-tcetr", (Object[])new Object[0]));
                this.getView().showLoading(cancelMsg, 3000);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage());
                }
                this.cancel();
                break;
            }
        }
    }

    private ValidDataResultVo validDataBeforeOperation(DrawBackDeclareHeader declareHeader) {
        Date month = declareHeader.getMonth();
        Long org = declareHeader.getOrg();
        if (org == null || org == 0L) {
            return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a", (String)"TcetrDeclarationEditPlugin_12", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        if (month == null) {
            return ValidDataResultVo.fail((String)ResManager.loadKDString((String)"\u7533\u62a5\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (String)"TcetrDeclarationEditPlugin_9", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
        return ValidDataResultVo.success();
    }

    private void cancel() {
        boolean dataChanged;
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        IPageCache childPageCache = childPage.getPageCache();
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        boolean bl = dataChanged = updateMap != null && updateMap.size() > 0;
        if (dataChanged) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCEL_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"TcetrDeclarationEditPlugin_3", (String)"taxc-tcetr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"TcetrDeclarationEditPlugin_4", (String)"taxc-tcetr", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"TcetrDeclarationEditPlugin_14", (String)"taxc-tcetr", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            DrawBackDeclareHeader header = this.getDeclareHeader();
            header.setType(this.getTemplateType());
            DynamicObject dyo = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
            if (dyo == null) {
                this.releaseDraftRef(this.getPageCache());
                this.getView().close();
            } else {
                this.enableSubmitBtn();
                FormulaService.cancel((IPageCache)this.getPageCache());
                this.operationSbb(VIEW_STATUS);
            }
        }
    }

    private void releaseDraftRef(IPageCache pageCache) {
        String sbbid = pageCache.get(SBBID);
        String templateType = this.getTemplateType();
        CktsDraftSbbStatusUtils.deleteSbbMess(templateType, Lists.newArrayList((Object[])new Object[]{Long.parseLong(sbbid)}));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, CLOSE_KEY});
                DrawBackDeclareHeader declareHeader = this.getDeclareHeader();
                ValidDataResultVo validDataResultVo = this.validDataBeforeOperation(declareHeader);
                if (!validDataResultVo.getSuccess()) {
                    this.getView().showErrorNotification(validDataResultVo.getMessage());
                    return;
                }
                this.operationSbb("edit");
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "viewdraft": {
                this.viewDraft();
                break;
            }
        }
    }

    protected void viewDraft() {
        DrawBackDeclareHeader header = this.getDeclareHeader();
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
        String draftPage = templateEnum.getDraftPage();
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(ORGID_KEY, header.getOrg());
        customParams.put("sbny", header.getMonth());
        customParams.put("sbpc", header.getBatchNo());
        customParams.put("linkDraft", Boolean.TRUE);
        customParams.put("declarenumber", this.getPageCache().get(BILLNO));
        PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)draftPage, (IFormView)this.getView(), customParams);
    }

    public void operationSbb(String operationType) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        customParams.put("operation", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put("refresh", "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        DrawBackDeclareHeader header = this.getDeclareHeader();
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setId(Long.valueOf(Long.parseLong(this.getPageCache().get(SBBID))));
        requestModel.setOrgId(header.getOrg());
        requestModel.setTemplateType((String)customParams.get("templatetype"));
        requestModel.setOperation(operationType);
        requestModel.setSkssqq(DateUtils.format((Date)header.getSkssqq()));
        requestModel.setSkssqz(DateUtils.format((Date)header.getSkssqz()));
        requestModel.setRefresh(Boolean.valueOf(false));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(DECLARE_PAGE_ENTITY_NEW);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if ("edit".equals(operationType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, SAVE_KEY, CANCEL_KEY});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE_KEY, AUDIT_KEY, CANCEL_KEY});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
        }
    }

    public void save() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        IFormPlugin taxDeclarePlugin = pluginList.stream().filter(s -> s.getPluginName().endsWith("TaxDeclarePlugin")).findFirst().orElse(null);
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                DeclareRequestModel declareRequestModel = new DeclareRequestModel();
                DrawBackDeclareHeader header = this.getDeclareHeader();
                header.setType(this.getTemplateType());
                DynamicObject declareMain = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
                if (declareMain != null && !"A".equals(declareMain.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838,\u4e0d\u5141\u8bb8\u4fee\u6539\u4fdd\u5b58\uff01", (String)"TcetrDeclarationEditPlugin_11", (String)"taxc-tcetr", (Object[])new Object[0]));
                    return;
                }
                declareRequestModel.setId(Long.valueOf(Long.parseLong(this.getPageCache().get(SBBID))));
                declareRequestModel.setOrgId(header.getOrg());
                declareRequestModel.setTemplateType(this.getTemplateType());
                declareRequestModel.setRefresh(Boolean.valueOf(true));
                declareRequestModel.setOperation("edit");
                declareRequestModel.setSkssqq(DateUtils.format((Date)header.getSkssqq()));
                declareRequestModel.setSkssqz(DateUtils.format((Date)header.getSkssqz()));
                BaseResult baseResult = (BaseResult)saveClick.invoke((Object)taxDeclarePlugin, childPageCache, declareRequestModel);
                if (BaseResult.OK.equals(baseResult.getCode())) {
                    this.writeBackDraft();
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TcetrDeclarationEditPlugin_6", (String)"taxc-tcetr", (Object[])new Object[0]));
                    String billno = this.getPageCache().get(BILLNO);
                    String templatetype = this.getTemplateType();
                    OperatorDialogUtils.operateDialog((String)"etrscsum", (String)TemplateEnum.getEnumByDeclareType((String)templatetype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TcetrDeclarationEditPlugin_15", (String)"taxc-tcetr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f", (String)"TcetrDeclarationEditPlugin_16", (String)"taxc-tcetr", (Object[])new Object[0]), billno));
                }
            }
            catch (Exception e) {
                logger.error("tcetr save error:", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"TcetrDeclarationEditPlugin_7", (String)"taxc-tcetr", (Object[])new Object[0]));
                return;
            }
            this.operationSbb(VIEW_STATUS);
        }
        this.enableSubmitBtn();
    }

    private void writeBackDraft() {
        String sbbid = this.getPageCache().get(SBBID);
        String billno = this.getPageCache().get(BILLNO);
        String pkIds = this.getPageCache().get(PKIDS);
        if (StringUtil.isEmpty((CharSequence)sbbid) || StringUtil.isEmpty((CharSequence)billno) || StringUtil.isEmpty((CharSequence)pkIds)) {
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String templateType = (String)customParams.get("templatetype");
        CktsDraftSbbStatusUtils.updateDraftSbbMess(templateType, Arrays.stream(pkIds.split(",")).map(Long::parseLong).collect(Collectors.toList()), StringUtils.isEmpty((CharSequence)sbbid) ? 0L : Long.parseLong(sbbid), billno);
    }

    public void enableSubmitBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY});
    }

    public void submit(String key) {
        String sbbid = null;
        DrawBackDeclareHeader header = this.getDeclareHeader();
        ValidDataResultVo resultVo = this.validDataBeforeOperation(header);
        if (!resultVo.getSuccess()) {
            this.getView().showErrorNotification(resultVo.getMessage());
            return;
        }
        header.setType(this.getTemplateType());
        DynamicObject declare = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
        if (declare != null) {
            sbbid = declare.getString("id");
        }
        if (!StringUtils.isEmpty(sbbid)) {
            ArrayList<Object> pklist = new ArrayList<Object>();
            pklist.add(sbbid);
            ValidDataResultVo validDataResultVo = DeclareQueryListService.submit(pklist, key, ENTITY_NAME, false);
            if (validDataResultVo.getSuccess()) {
                this.setBtnStatus(header, VIEW_STATUS);
                String billno = this.getPageCache().get(BILLNO);
                String operateName = ResManager.loadKDString((String)String.format(ResManager.loadKDString((String)"%s", (String)"TcetrDeclarationEditPlugin_17", (String)"taxc-tcetr", (Object[])new Object[0]), OperateCodeEnum.getByCode((String)key)), (String)"TcetrDeclarationEditPlugin_17", (String)"taxc-tcetr", (Object[])new Object[0]);
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u7f16\u53f7\uff1a%1$s\uff0c%2$s\u6210\u529f\u3002", (String)"TcetrDeclarationEditPlugin_18", (String)"taxc-tcetr", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode((String)key));
                OperatorDialogUtils.operateDialogByAppid((String)DevprotalBizAppUtil.getTaxcAppByNumber((String)"tcetr"), (String)ENTITY_NAME, (String)operateName, (String)operateDescription);
            } else {
                this.getView().showTipNotification(validDataResultVo.getMessage());
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"TcetrDeclarationEditPlugin_8", (String)"taxc-tcetr", (Object[])new Object[0]));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        DrawBackDeclareHeader header = this.getDeclareHeader();
        header.setType(this.getTemplateType());
        switch (callBackId) {
            case "cancel": {
                DynamicObject dyo = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (dyo == null) {
                    this.releaseDraftRef(this.getPageCache());
                    this.getView().close();
                    break;
                }
                this.enableSubmitBtn();
                FormulaService.cancel((IPageCache)this.getPageCache());
                this.operationSbb(VIEW_STATUS);
            }
        }
    }

    private boolean isDeclared(String rootPageId, DrawBackDeclareHeader header) {
        DynamicObject declare = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, "A");
        this.getPageCache().remove("templateid");
        if (declare != null) {
            if (StringUtils.isNotEmpty((CharSequence)declare.getString("templateid"))) {
                this.getPageCache().put("templateid", declare.getString("templateid"));
            }
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put(BILL_STATUS, billstatus);
            rootCache.put(SBBID, id);
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                return true;
            }
        }
        return false;
    }

    private void openDeclarePage(DrawBackDeclareHeader header, boolean refresh) {
        String operationStatus = refresh ? "edit" : VIEW_STATUS;
        header.setType(this.getTemplateType());
        this.showInnerPage(header, refresh, operationStatus);
    }

    private void showInnerPage(DrawBackDeclareHeader header, boolean refresh, String operationStatus) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("rootPageId", this.getView().getPageId());
        customParams.put("templatetype", this.getTemplateType());
        customParams.put("ParentCache", "true");
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(this.getView().getPageId(), header);
        if (isDeclare) {
            readonly = true;
        }
        customParams.put("readonly", readonly);
        customParams.put("templateid", this.getPageCache().get("templateid"));
        FormShowParameter param = new FormShowParameter();
        DeclareRequestModel requestModel = new DeclareRequestModel();
        Long sbbid = TcetrDeclarationEditPlugin.getSbbid(header);
        requestModel.setId(sbbid);
        requestModel.setOrgId(header.getOrg());
        requestModel.setTemplateType(header.getType());
        requestModel.setOperation(operationStatus);
        requestModel.setSkssqq(header.getSkssqq() != null ? DateUtils.format((Date)header.getSkssqq()) : "");
        requestModel.setSkssqz(header.getSkssqz() != null ? DateUtils.format((Date)header.getSkssqz()) : "");
        String billNo = this.getBillNo(header);
        requestModel.setBillNo(billNo);
        HashMap<String, String> businessMap = new HashMap<String, String>(16);
        businessMap.put(MONTH, DateUtils.format((Date)header.getMonth()));
        businessMap.put(BATCHNO, header.getBatchNo());
        String pKids = this.getPKids(this.getView().getFormShowParameter().getCustomParams());
        businessMap.put(PKIDS, pKids);
        requestModel.setBusinessMap(businessMap);
        HashMap<String, Object> extendParams = new HashMap<String, Object>(16);
        extendParams.put(MONTH, header.getMonth() == null || DrawBackDeclareHeader.DEFAULT_DATE.compareTo(header.getMonth()) == 0 ? null : header.getMonth());
        extendParams.put(BATCHNO, header.getBatchNo());
        requestModel.setExtendParams(extendParams);
        requestModel.setRefresh(Boolean.valueOf(refresh));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(DECLARE_PAGE_ENTITY_NEW);
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        this.getPageCache().put(SBBID, String.valueOf(sbbid));
        this.getPageCache().put(BILLNO, billNo);
        this.getPageCache().put(PKIDS, pKids);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.getView().updateView(CONTENT_TAB);
        this.setBtnStatus(header, operationStatus);
    }

    private String getPKids(Map<String, Object> customParams) {
        Boolean createsbb = (Boolean)customParams.getOrDefault(CREATESBB, false);
        if (createsbb.booleanValue()) {
            JSONArray jsonArrays = (JSONArray)customParams.get(PKIDS);
            return jsonArrays.stream().map(s -> s.toString()).collect(Collectors.joining(","));
        }
        DrawBackDeclareHeader header = this.getDeclareHeader();
        if (header.getMonth() == null || StringUtils.isEmpty((CharSequence)header.getBatchNo())) {
            return "0";
        }
        DynamicObjectCollection query = CktsDraftService.query(header.getOrg(), header.getMonth(), header.getBatchNo());
        return query.stream().map(s -> s.getString("id")).collect(Collectors.joining(","));
    }

    private void setBtnStatus(DrawBackDeclareHeader header, String operationStatus) {
        DynamicObject dyo = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
        if (dyo != null && VIEW_STATUS.equals(operationStatus)) {
            String billstatus = dyo.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{SAVE_KEY, AUDIT_KEY, CANCEL_KEY});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{SUBMIT_KEY});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{AUDIT_KEY});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY, SUBMIT_KEY});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{AUDIT_KEY});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, SAVE_KEY, CANCEL_KEY});
        }
        if (dyo != null) {
            this.getView().setEnable(Boolean.valueOf("1".equals(dyo.getString("sourcetype"))), new String[]{VIEW_DRAFT_KEY});
        }
    }

    public static Long getSbbid(DrawBackDeclareHeader header) {
        if (!header.canLoad()) {
            return 0L;
        }
        DynamicObject object = "drawback".equals(header.getType()) ? DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType()) : DeclareService.getDeclareMain(header.getOrg(), header.getMonth(), header.getType());
        if (object != null) {
            return object.getLong("id");
        }
        return DrawBackDeclareServiceHelper.generateSBBId(null);
    }

    private String getBillNo(DrawBackDeclareHeader header) {
        if (!header.canLoad()) {
            return "";
        }
        DynamicObject object = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
        if (object != null) {
            return object.getString("billno");
        }
        String sbbNo = DeclareServiceHelper.generateSBBNo((String)("etrscsum".equals(header.getType()) ? "tcetr_etrsc_out_detail" : ENTITY_NAME));
        sbbNo = sbbNo.replace("MONTH", DateUtils.format((Date)header.getMonth(), (String)"yyyyMM"));
        return sbbNo;
    }

    public String getTemplateType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        return (String)customParams.get("templatetype");
    }

    public void clientCallBackMethod(String showData, String sheetid) {
        if (StringUtil.isNotEmpty((CharSequence)showData)) {
            Map dataMap = (Map)SerializationUtils.fromJsonString((String)showData, Map.class);
            if (dataMap != null && !dataMap.isEmpty()) {
                String sbtse = dataMap.getOrDefault("tcetr_declare_main#1#sbtse", "0");
                String zzsamount = dataMap.getOrDefault("tcetr_declare_main#1#zzsamount", "0");
                String xfsamount = dataMap.getOrDefault("tcetr_declare_main#1#xfsamount", "0");
                this.getModel().setValue("sbtse", (Object)new BigDecimal(sbtse.replace(",", "")));
                this.getModel().setValue("zzsamount", (Object)new BigDecimal(zzsamount.replace(",", "")));
                this.getModel().setValue("xfsamount", (Object)new BigDecimal(xfsamount.replace(",", "")));
            }
        } else {
            DrawBackDeclareHeader header = this.getDeclareHeader();
            header.setType(this.getTemplateType());
            DynamicObject object = DeclareService.queryDeclareMain(header.getOrg(), header.getMonth(), header.getBatchNo(), header.getType());
            if (object != null) {
                this.getModel().setValue("sbtse", (Object)object.getBigDecimal("sbtse"));
                this.getModel().setValue("zzsamount", (Object)object.getBigDecimal("zzsamount"));
                this.getModel().setValue("xfsamount", (Object)object.getBigDecimal("xfsamount"));
            }
        }
        this.getView().updateView();
    }

    public DrawBackDeclareHeader initDeclareHeader(Map<String, Object> customParams) {
        Boolean createsbb = (Boolean)customParams.getOrDefault(CREATESBB, false);
        if (!createsbb.booleanValue()) {
            Long orgId = (Long)customParams.get(ORGID_KEY);
            DynamicObject object = DeclareService.queryLastDeclareMain(orgId, "editing");
            if (object == null) {
                this.getModel().setValue(ORG_SEL, (Object)orgId);
                this.getModel().setValue(MONTH, null);
                this.getModel().setValue(BATCHNO, null);
                return new DrawBackDeclareHeader(orgId, "", DrawBackDeclareHeader.DEFAULT_DATE, null);
            }
            this.getModel().setValue(ORG_SEL, (Object)orgId);
            this.getModel().setValue(MONTH, (Object)object.getDate(MONTH));
            this.getModel().setValue(BATCHNO, (Object)object.getString(BATCHNO));
            return new DrawBackDeclareHeader(orgId, "", object.getDate(MONTH), object.getString(BATCHNO));
        }
        Object orgid = customParams.get(ORGID_KEY);
        Object month = customParams.get("sbny");
        Object batchno = customParams.get("sbpc");
        this.getModel().setValue(ORG_SEL, orgid);
        this.getModel().setValue(MONTH, month);
        this.getModel().setValue(BATCHNO, batchno);
        return this.getDeclareHeader();
    }
}

